/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JList;
import lombok.Generated;
import se.prediktera.breeze.backend.grabber.CameraStreamGrabber;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.entry.MainViewPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeDescriptionButton;
import se.prediktera.breeze.frontend.common.swing.BreezeExternalLinkPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.BreezeUser;
import se.prediktera.breeze.frontend.common.util.BreezeUserManager;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.frontend.main.settings.BreezeRuntimeSettingsPanel;
import se.prediktera.breeze.frontend.main.settings.SettingsPanel;
import se.prediktera.breeze.frontend.main.settings.focus.FocusPanel;
import se.prediktera.breeze.frontend.main.settings.focus.HardwareSidePanel;
import se.prediktera.breeze.frontend.main.settings.hardware.CameraMainPanel;
import se.prediktera.breeze.frontend.main.settings.hardware.StageSettingsPanel;
import se.prediktera.breeze.frontend.main.settings.integration.IntegrationPanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferencesSettingsPanel;
import se.prediktera.breeze.frontend.main.settings.sensor.SensorPanel;
import se.prediktera.breeze.frontend.main.settings.testscan.TestScanWithRuntimePanel;
import se.prediktera.breeze.frontend.main.settings.user.UserPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.tcp.BreezeRuntime;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class MaintenancePanel
extends EntryMainPanel {
    private HardwareSidePanel hardwareSidePanel = null;
    private Camera connectedCamera = null;
    private final BreezeComboBoxInputField<String> selectedCameraInputField = new BreezeComboBoxInputField("Active camera");
    protected int cameraId;

    public MaintenancePanel(BreezeFrame breezeFrame) {
        super(breezeFrame, BreezeType.Settings, "Hardware and workspace settings", false, false, 320);
        this.verticalLabelPanel.setVisible(false);
        this.hardwareSidePanel = new HardwareSidePanel(this, HardwareSidePanel.HardwareType.Hardware, new CameraStreamGrabber(), hardware -> this.hardwareSidePanel.updateAll());
    }

    public MaintenancePanel(BreezeProgress breezeProgress, BreezeFrame breezeFrame) {
        this(breezeFrame);
        BreezeRuntime breezeRuntime = TcpManager.getInstance().getBreezeRuntimeManager();
        if (breezeRuntime != null && BreezeProperties.getInstance().isBreezeRuntimeLocal()) {
            breezeProgress.setInfoText("Connecting to Breeze Runtime");
            breezeRuntime.startRuntime(breezeProgress);
        }
        ArrayList<ViewClass> arrayList = new ArrayList<ViewClass>();
        arrayList.add(new SettingsViewClass("Cameras", "Select cameras", (AbstractViewPanel)new CameraMainPanel(this), "videocam"));
        arrayList.add(new SettingsIndentationViewClass("Focus", "Set focus and field of view", (AbstractViewPanel)new FocusPanel(this), "Focus"));
        arrayList.add(new SettingsIndentationViewClass("Integration time", "Set integration time", (AbstractViewPanel)new IntegrationPanel(this), "Time"));
        arrayList.add(new SettingsIndentationViewClass("Test scan", "Test scan image", (AbstractViewPanel)new TestScanWithRuntimePanel(this), "scan"));
        arrayList.add(new SettingsIndentationViewClass("References", "Set reference settings", (AbstractViewPanel)new ReferencesSettingsPanel(this), "Measurement"));
        arrayList.add(new SettingsIndentationViewClass("Sensor", "Diagnostics of sensor frame", (AbstractViewPanel)new SensorPanel(this), "Sensor"));
        arrayList.add(new SettingsViewClass("Sample mover", "Select sample mover stage, if any", (AbstractViewPanel)new StageSettingsPanel(this), "flip"));
        arrayList.add(new SettingsViewClass("General", "General settings", (AbstractViewPanel)new SettingsPanel(this), "general.png"));
        BreezeUser breezeUser = BreezeUserManager.getBreezeUser();
        if (breezeUser.isAdmin()) {
            arrayList.add(new SettingsViewClass("Runtime", "Breeze Runtime settings", (AbstractViewPanel)new BreezeRuntimeSettingsPanel(this), "BreezeRuntime"));
        }
        if (breezeUser.isAdmin()) {
            arrayList.add(new SettingsViewClass("Users", "Add, remove and change users", (AbstractViewPanel)new UserPanel(this), "User"));
        }
        this.setLists(arrayList, arrayList, null);
        this.selectedCameraInputField.getComboBox().setMinimumSize(new Dimension(250, 25));
        this.selectedCameraInputField.getComboBox().setPreferredSize(new Dimension(250, 25));
        for (int i = 0; i < BreezeProperties.getInstance().getNumberOfCameras(); ++i) {
            this.selectedCameraInputField.addItem(StringHelper.numberToOrdinal(i));
        }
        this.selectedCameraInputField.setChangedListener(string -> {
            final SettingsViewClass settingsViewClass = (SettingsViewClass)this.getSelectedEntry();
            var var3_3 = new WizardStep.LeaveControlCallback(){
                final /* synthetic */ MaintenancePanel this$0;
                {
                    this.this$0 = maintenancePanel;
                }

                @Override
                public void leaveWithControl() {
                    this.this$0.cameraId = this.this$0.selectedCameraInputField.getSelectedIndex();
                    if (this.this$0.connectedCamera != null) {
                        this.this$0.connectedCamera = this.this$0.getSelectedCamera();
                    }
                    settingsViewClass.getPanel().showEntry(null, null);
                    this.this$0.repaintEntryList();
                    this.this$0.hardwareSidePanel.setActiveCamera(this.this$0.cameraId);
                }
            };
            WizardStep.LeaveResult leaveResult = settingsViewClass.getPanel().leaveEntry(var3_3);
            if (leaveResult.ok()) {
                var3_3.leaveWithControl();
            }
        });
        this.selectedCameraInputField.setFormat(BreezeInputFieldHelper.Format.OneRow);
        this.selectedCameraInputField.setVisible(BreezeProperties.getInstance().getNumberOfCameras() == 1);
        this.selectedCameraInputField.setRenderer(new MultiCameraListCellRenderer());
        Component component = ((BorderLayout)this.rightPanel.getLayout()).getLayoutComponent("Center");
        AbstractViewPanel abstractViewPanel = new AbstractViewPanel(){

            @Override
            public boolean showRightSettingsPanel() {
                return true;
            }

            @Override
            public EntrySettingsPanel.SettingsComponent getRightSettingsPanel(EntrySettingsPanel entrySettingsPanel) {
                return MaintenancePanel.this.hardwareSidePanel;
            }

            @Override
            public String getType() {
                return "MaintenanceMainPanel";
            }

            @Override
            public void showEntry(Object object, Object object2) {
            }
        };
        abstractViewPanel.setMinimumSize(new Dimension(200, 200));
        abstractViewPanel.setLayout(new BorderLayout());
        abstractViewPanel.add(component);
        MainViewPanel mainViewPanel = new MainViewPanel(abstractViewPanel, 0);
        this.rightPanel.add((Component)mainViewPanel, "Center");
    }

    @Override
    protected int getMainHeight() {
        return 70;
    }

    @Override
    public void showSelectedEntry(boolean bl) {
        super.showSelectedEntry(bl);
        if (this.topPanel != null && this.topPanel.getCustomPanel().getComponentCount() == 0) {
            BreezeExternalLinkPanel breezeExternalLinkPanel = new BreezeExternalLinkPanel(this.selectedCameraInputField, "settings");
            this.topPanel.getCustomPanel().add((Component)breezeExternalLinkPanel, "Center");
        }
        this.repaintEntryList();
    }

    @Override
    public void repaintEntryList() {
        super.repaintEntryList();
        if (this.selectedCameraInputField != null) {
            this.selectedCameraInputField.setVisible(HardwareRegistry.getInstance().getSecondCamera() != null);
            if (!this.selectedCameraInputField.isVisible()) {
                this.hardwareSidePanel.clearActiveCamera();
            } else {
                this.hardwareSidePanel.setActiveCamera(this.selectedCameraInputField.getSelectedIndex());
            }
        }
    }

    public void reloadHardwareSidePanel() {
        this.hardwareSidePanel.updateAll();
    }

    public int getCameraId() {
        if (this.selectedCameraInputField.isVisible()) {
            return this.cameraId;
        }
        return 0;
    }

    public Camera getSelectedCamera() {
        return HardwareRegistry.getInstance().getCamera(this.getCameraId());
    }

    @Override
    public void backButtonClicked() {
        this.requestFocusInWindow();
        BreezeProgressDialog.startProgress(this.getFrame(), new ProgressAction(){

            @Override
            public void runAction() {
                this.setInfoText("Exiting");
                SampleMover sampleMover = HardwareRegistry.getInstance().getSampleMover();
                if (sampleMover != null && sampleMover.isConnected()) {
                    sampleMover.stop();
                    sampleMover.exitWhiteRefState();
                    this.setInfoText("Moving to sample position");
                    sampleMover.moveToReturnPosition(null);
                }
                MaintenancePanel.super.backButtonClicked();
            }
        }, "Exit");
    }

    public void enterPanel(BreezeDescriptionButton breezeDescriptionButton, CameraStreamGrabber cameraStreamGrabber, ConnectCallback connectCallback) {
        Camera camera = this.getSelectedCamera();
        if (this.connectedCamera != null && camera == this.connectedCamera) {
            this.toggleCamera(breezeDescriptionButton, cameraStreamGrabber, connectCallback);
        } else {
            breezeDescriptionButton.setToggled(false);
            connectCallback.updateFromCamera(camera, false);
        }
    }

    public void toggleCamera(final BreezeDescriptionButton breezeDescriptionButton, final CameraStreamGrabber cameraStreamGrabber, final ConnectCallback connectCallback) {
        breezeDescriptionButton.setEnabled(false);
        if (!cameraStreamGrabber.isRunning()) {
            breezeDescriptionButton.setToggled(true);
            new ConnectProgressAction.ConnectCamera(this, this.getFrame(), this.getSelectedCamera()){
                final /* synthetic */ MaintenancePanel this$0;
                {
                    this.this$0 = maintenancePanel;
                    super(breezeFrame, camera);
                }

                @Override
                public void onFirstConnection(Camera camera) {
                    connectCallback.updateFromCamera(camera, true);
                }

                @Override
                public void afterConnection(BreezeProgress breezeProgress, Camera camera) {
                    if (ReferenceHelper.shouldTakeNewDark(camera)) {
                        ReferenceHelper.takeDarkReference(breezeProgress, camera);
                    }
                    this.this$0.connectedCamera = camera;
                    connectCallback.updateFromCamera(camera, false);
                    connectCallback.afterConnection(camera);
                    cameraStreamGrabber.startGrab(camera);
                    breezeDescriptionButton.setEnabled(true);
                    this.this$0.repaintEntryList();
                }

                @Override
                public void onFailedConnection(Exception exception) {
                    breezeDescriptionButton.setToggled(false);
                    breezeDescriptionButton.setEnabled(true);
                }
            };
        } else {
            breezeDescriptionButton.setToggled(false);
            cameraStreamGrabber.stop();
            breezeDescriptionButton.setEnabled(true);
            this.connectedCamera = null;
        }
    }

    public void leavePanel(CameraStreamGrabber cameraStreamGrabber) {
        if (cameraStreamGrabber.isRunning()) {
            cameraStreamGrabber.stop();
        }
    }

    @Generated
    public HardwareSidePanel getHardwareSidePanel() {
        return this.hardwareSidePanel;
    }

    @Generated
    public BreezeComboBoxInputField<String> getSelectedCameraInputField() {
        return this.selectedCameraInputField;
    }

    public static class SettingsViewClass
    extends ViewClass {
        public SettingsViewClass(String string, String string2, AbstractViewPanel abstractViewPanel, String string3) {
            super(string, string2, abstractViewPanel, abstractViewPanel);
            this.setIcon(ImageHelper.getResourceIcon("maintenance/" + string3));
        }
    }

    private static class SettingsIndentationViewClass
    extends SettingsViewClass {
        public SettingsIndentationViewClass(String string, String string2, AbstractViewPanel abstractViewPanel, String string3) {
            super(string, string2, abstractViewPanel, string3);
        }

        @Override
        public int getIndentation() {
            return 15;
        }
    }

    public static class MultiCameraListCellRenderer
    extends BreezeComboBox.ComboBoxListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent(jList, this.getCameraName(object), n, bl, bl2);
        }

        private Object getCameraName(Object object) {
            int n;
            if (object instanceof Camera.MultiCameraSetting) {
                Camera.MultiCameraSetting multiCameraSetting = (Camera.MultiCameraSetting)object;
                Camera.MultiCameraMode multiCameraMode = multiCameraSetting.mode();
                switch (multiCameraMode) {
                    case ScaleDown: 
                    case ScaleUp: {
                        return "Merge";
                    }
                    case Single: {
                        return Camera.getCameraTypeName(HardwareRegistry.getInstance().getCamera(multiCameraSetting.index()), "N/A");
                    }
                }
                return multiCameraMode;
            }
            if (object != null && (n = StringHelper.ordinalToNumber(object.toString())) >= 0) {
                return Camera.getCameraTypeName(HardwareRegistry.getInstance().getCamera(n), "N/A");
            }
            return object;
        }
    }

    public static interface ConnectCallback {
        public void updateFromCamera(Camera var1, boolean var2);

        public void afterConnection(Camera var1);
    }
}

