/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.lang3.SystemUtils;
import org.w3c.dom.Node;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.EntryWithSave;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.validator.NumericMinMaxValidator;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlPropertyViewPanel;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.frontend.main.settings.measurement.GeneralSettingsPanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.map.common.NiceDataFormat;

public class SettingsPanel
extends AbstractViewPanel
implements EntryWithSave {
    public final XmlPropertyViewPanel visualizationPanel;
    public final XmlPropertyViewPanel modellingPanel;

    public SettingsPanel(MaintenancePanel maintenancePanel) {
        super(maintenancePanel);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(BreezeTheme.getInstance().getPanelBackground());
        int n = 0;
        CollapsePanel collapsePanel = new CollapsePanel("General settings", false, false);
        collapsePanel.addPanel(new GeneralSettingsPanel(maintenancePanel));
        jPanel.add((Component)collapsePanel, GridBagHelper.createWithWeigthX1(n++, new Insets(12, 0, 0, 0)));
        int n2 = SystemUtils.IS_OS_WINDOWS ? 350 : 380;
        CollapsePanel collapsePanel2 = new CollapsePanel("Settings for new projects", true, false);
        collapsePanel2.labelWidth = n2;
        BreezeComboBoxInputField<RtFramePredictor.ReferenceConvertTo> breezeComboBoxInputField = new BreezeComboBoxInputField<RtFramePredictor.ReferenceConvertTo>("Convert to", Arrays.asList(RtFramePredictor.ReferenceConvertTo.values()), BreezeProperties.getInstance().getReferenceConvertTo(), referenceConvertTo -> BreezeProperties.getInstance().setReferenceConvertTo((RtFramePredictor.ReferenceConvertTo)((Object)referenceConvertTo)), BreezeInputFieldHelper.Format.OneRow);
        breezeComboBoxInputField.setValueWidth(200);
        collapsePanel2.addPanel(breezeComboBoxInputField);
        GeneralSettingsPanel.UnitComoBoxInputField unitComoBoxInputField = new GeneralSettingsPanel.UnitComoBoxInputField(BreezeProperties.getInstance().getDefaultUnit(), siUnit -> BreezeProperties.getInstance().setDefaultUnit((SpatialDescriptor.SiUnit)((Object)siUnit)));
        unitComoBoxInputField.setLabelWidth(n2);
        unitComoBoxInputField.setValueWidth(200);
        collapsePanel2.addPanel(unitComoBoxInputField);
        BreezeComboBoxInputField<String> breezeComboBoxInputField2 = new BreezeComboBoxInputField<String>("Visualization direction", Arrays.asList("vertical", "horizontal"), BreezeProperties.getInstance().getVisualisationDirection(), string -> BreezeProperties.getInstance().setVisualisationDirection((String)string), BreezeInputFieldHelper.Format.OneRow);
        breezeComboBoxInputField2.setRenderer(new BreezeComboBox.FormatStringCellRenderer());
        breezeComboBoxInputField2.setLabelWidth(n2);
        breezeComboBoxInputField2.setValueWidth(200);
        collapsePanel2.addPanel(breezeComboBoxInputField2);
        jPanel.add((Component)collapsePanel2, GridBagHelper.createWithWeigthX1(n++, new Insets(12, 0, 0, 0)));
        CollapsePanel collapsePanel3 = new CollapsePanel("Visualization for new projects", true, false);
        this.visualizationPanel = new XmlPropertyViewPanel(maintenancePanel, this);
        collapsePanel3.addPanel((JComponent)((Object)this.visualizationPanel), GridBagHelper.createWithWeigthX1(n++, new Insets(12, 0, 0, 0)));
        jPanel.add((Component)collapsePanel3, GridBagHelper.createWithWeigthX1(n++, new Insets(12, 0, 0, 0)));
        collapsePanel3 = new CollapsePanel("Modelling settings for new projects", true, false);
        this.modellingPanel = new XmlPropertyViewPanel(maintenancePanel, this);
        collapsePanel3.addPanel((JComponent)((Object)this.modellingPanel), GridBagHelper.createWithWeigthX1(n++, new Insets(12, 0, 0, 0)));
        jPanel.add((Component)collapsePanel3, GridBagHelper.createWithWeigthX1(n++, new Insets(12, 0, 0, 0)));
        jPanel.add((Component)new BreezeLabel(""), GridBagHelper.createLast(n, new Insets(0, 0, 0, 0)));
        this.add(new BreezeScrollPane.VerticalOnly(jPanel));
    }

    @Override
    public String getType() {
        return "Settings";
    }

    public String toString() {
        return "";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(BreezeProperties.getInstance().getPropertyNode("gui/colorScale"));
        this.visualizationPanel.updatePanel(null, arrayList);
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList2.add(BreezeProperties.getInstance().getPropertyNode("modelling/excludeWavelengthsBeginningPercent"));
        arrayList2.add(BreezeProperties.getInstance().getPropertyNode("modelling/excludeWavelengthsEndPercent"));
        arrayList2.add(BreezeProperties.getInstance().getPropertyNode("modelling/defaultNumberOfSamplesToInclude"));
        this.modellingPanel.updatePanel(null, arrayList2);
    }

    @Override
    public void save() {
        BreezeProperties.getInstance().save();
    }

    public static class MeasurementLengthPanel
    extends JPanel {
        private final BreezeComboBoxInputField<String> measurementLengthComboInput;
        private final BreezeComboBox unitComboBox = new BreezeComboBox();
        private NumericMinMaxValidator validator = null;

        public MeasurementLengthPanel() {
            this((EntryMainPanelInterface)null);
        }

        public MeasurementLengthPanel(EntryMainPanelInterface entryMainPanelInterface) {
            super(new GridBagLayout());
            Object object2;
            this.setOpaque(false);
            this.measurementLengthComboInput = new BreezeComboBoxInputField("Measurement length", "", BreezeInputFieldHelper.Format.TwoRows);
            this.measurementLengthComboInput.setEditable(true);
            this.populateMeasureLengthComboWithoutListeners(null);
            SampleMover sampleMover = HardwareRegistry.getInstance().getSampleMover();
            for (Object object2 : MeasurementLength.LengthUnit.values(sampleMover)) {
                this.unitComboBox.addItem(object2);
            }
            this.unitComboBox.setPreferredSize(new Dimension(100, 25));
            this.unitComboBox.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    Camera.SetMeasureLengthCamera setMeasureLengthCamera = (Camera.SetMeasureLengthCamera)HardwareRegistry.getInstance().getFirstCamera();
                    MeasurementLength measurementLength = setMeasureLengthCamera.getMeasurementLength();
                    MeasurementLength measurementLength2 = MeasurementLength.convertTo(measurementLength, (MeasurementLength.LengthUnit)((Object)((Object)this.unitComboBox.getSelectedItem())), setMeasureLengthCamera);
                    this.measurementLengthComboInput.setValue(NiceDataFormat.toString((double)measurementLength2.value));
                    setMeasureLengthCamera.setMeasureLength(measurementLength2);
                    if (entryMainPanelInterface != null) {
                        entryMainPanelInterface.repaintEntryList();
                    }
                }
            });
            GridBagConstraints gridBagConstraints = GridBagHelper.create(0, new Insets(0, 0, 0, 0), false);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            this.add(this.measurementLengthComboInput, gridBagConstraints);
            object2 = GridBagHelper.create(1, new Insets(0, 5, 0, 0), false);
            ((GridBagConstraints)object2).anchor = 16;
            this.add((Component)this.unitComboBox, object2);
            this.measurementLengthComboInput.setChangedListener(string -> {
                if (this.validator != null && this.validator.validate((String)string) != null) {
                    return;
                }
                float f = (float)NiceDataFormat.toNumber((String)string);
                ((Camera.SetMeasureLengthCamera)HardwareRegistry.getInstance().getFirstCamera()).setMeasureLength(new MeasurementLength(f, (MeasurementLength.LengthUnit)((Object)((Object)this.unitComboBox.getSelectedItem()))));
                if (entryMainPanelInterface != null) {
                    entryMainPanelInterface.repaintEntryList();
                }
                this.populateMeasureLengthComboWithoutListeners((String)string);
            });
            this.validator = new NumericMinMaxValidator(0.0, 2.147483647E9, "max length");
            this.measurementLengthComboInput.setName("measurementLength");
            this.updateValueFromCurrentHardware();
        }

        private void populateMeasureLengthComboWithoutListeners(String string) {
            ItemListener[] itemListenerArray = this.measurementLengthComboInput.removeAllItemListeners();
            this.measurementLengthComboInput.removeAllItems();
            BreezeProperties.getInstance().getRecentMeasurementLengths().forEach(f -> this.measurementLengthComboInput.addItem(Float.toString(f.floatValue())));
            if (string != null) {
                this.measurementLengthComboInput.setValue(string);
            }
            this.measurementLengthComboInput.addItemListeners(itemListenerArray);
        }

        public void updateValueFromCurrentHardware() {
            HardwareRegistry hardwareRegistry = HardwareRegistry.getInstance();
            Camera camera = hardwareRegistry.getFirstCamera();
            this.setEnabled(camera instanceof Camera.SetMeasureLengthCamera && ((Camera.SetMeasureLengthCamera)camera).canChangeLength());
            MeasurementLength measurementLength = camera.getMeasurementLength();
            this.measurementLengthComboInput.setSelectedItemWithoutListeners(NiceDataFormat.toString((double)measurementLength.value));
            this.unitComboBox.setSelectedItemWithoutListeners((Object)measurementLength.getUnit());
            this.validator.setMinMax(0.0, SampleMover.getValidatorMaxLength((SampleMover)hardwareRegistry.getSampleMover(), (int)Integer.MAX_VALUE).value);
        }

        @Override
        public void setEnabled(boolean bl) {
            this.measurementLengthComboInput.setEnabled(bl);
            this.unitComboBox.setEnabled(bl);
        }
    }
}

