/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.focus;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;

public class CustomTabPanel
extends JPanel {
    private final JPanel tabPanel;
    private final JPanel contentHolder;
    private final BreezeLabel prefixLabel = new BreezeLabel("Frame ", false, 12);
    private final List<BreezeLabel> tabButtons = new ArrayList<BreezeLabel>();
    private final List<JPanel> tabContents = new ArrayList<JPanel>();
    private int selectedIndex;

    public CustomTabPanel() {
        super(new GridBagLayout());
        this.tabPanel = new JPanel(new GridBagLayout());
        this.tabPanel.setOpaque(false);
        this.contentHolder = new JPanel(new CardLayout());
        this.contentHolder.setOpaque(false);
        this.selectedIndex = -1;
        GridBagConstraints gridBagConstraints = GridBagHelper.create(0, new Insets(0, 0, 0, 0));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.prefixLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.tabPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = GridBagHelper.createLast(1, new Insets(0, 0, 0, 0));
        gridBagConstraints2.gridwidth = 0;
        this.add((Component)this.contentHolder, gridBagConstraints2);
    }

    public void addTab(String string, JPanel jPanel) {
        JComponent jComponent;
        if (this.tabPanel.getComponentCount() > 0) {
            jComponent = new BreezeSeparator(1);
            jComponent.setPreferredSize(new Dimension(5, 15));
            this.tabPanel.add((Component)jComponent, GridBagHelper.create(this.tabPanel.getComponentCount(), new Insets(0, 5, 0, 2), false));
        }
        jComponent = new BreezeLabel(string, false, 12);
        jComponent.setCursor(Cursor.getPredefinedCursor(12));
        jComponent.addMouseListener(new MouseAdapter(this, (BreezeLabel)jComponent){
            final /* synthetic */ BreezeLabel val$tabButton;
            final /* synthetic */ CustomTabPanel this$0;
            {
                this.val$tabButton = breezeLabel;
                this.this$0 = customTabPanel;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.this$0.setSelectedTabIndex(this.this$0.tabButtons.indexOf(this.val$tabButton), true);
            }
        });
        this.tabPanel.add((Component)jComponent, GridBagHelper.create(this.tabPanel.getComponentCount(), new Insets(0, 0, 0, 0), false));
        this.contentHolder.add((Component)jPanel, string);
        this.tabButtons.add((BreezeLabel)jComponent);
        this.tabContents.add(jPanel);
    }

    public void setSelectedTabIndex(int n, boolean bl) {
        if (n >= 0 && n < this.tabButtons.size()) {
            for (BreezeLabel object2 : this.tabButtons) {
                object2.setForeground(BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
            }
            BreezeLabel breezeLabel = this.tabButtons.get(n);
            breezeLabel.setForeground(BreezeTheme.getInstance().getLabelForeground());
            String string = breezeLabel.getText();
            CardLayout cardLayout = (CardLayout)this.contentHolder.getLayout();
            cardLayout.show(this.contentHolder, string);
            this.selectedIndex = n;
        }
    }

    public JPanel getContentAtSelectedTab() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.tabContents.size()) {
            return this.tabContents.get(this.selectedIndex);
        }
        return null;
    }

    @Override
    public void setEnabled(boolean bl) {
        for (JPanel jPanel : this.tabContents) {
            jPanel.setEnabled(bl);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Custom Tab Panel");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(400, 300);
        CustomTabPanel customTabPanel = new CustomTabPanel();
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Content 1"));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Content 2"));
        customTabPanel.addTab("Tab 1", jPanel);
        customTabPanel.addTab("Tab 2", jPanel2);
        customTabPanel.setSelectedTabIndex(0, false);
        jFrame.add(customTabPanel);
        jFrame.setVisible(true);
    }
}

