/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.focus;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import se.prediktera.breeze.backend.grabber.CameraStreamGrabber;
import se.prediktera.breeze.common.frame.DrReMatrix;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.BreezeColor;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeDescriptionButton;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSlider;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.CameraPanelInfoText;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.CameraStreamPanel;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.PushbroomStreamImage;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.frontend.main.settings.focus.HardwareSidePanel;
import se.prediktera.breeze.frontend.main.settings.integration.IntegrationPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.samplemover.umbioinspector.UmbioInspector;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.plot.spectral.DataWrapper;
import se.prediktera.map.plot.spectral.SpectralPlot;

public class FocusPanel
extends AbstractViewPanel
implements MaintenancePanel.ConnectCallback {
    private final FocusLinePlot focusLinePlot = new FocusLinePlot(this);
    private final CameraStreamGrabber grabber = new CameraStreamGrabber();
    private double maxfocusrate = 0.0;
    private final FocusRealTimePanel focusRealTimePanel;
    private final JPanel buttonPanel;
    private final BreezeDescriptionButton captureButton;
    private final BreezeDescriptionButton extendReferenceButton;
    private final JLabel focusRateDescLabel;
    private final JLabel maxFocusRateLabel;
    private final JLabel noLinesValueLabel;
    private final BreezeSlider positionSlider;
    private final JLabel positionValueLabel;
    private final JPanel resultPanel;
    private final BreezeDescriptionButton runBeltButton;
    private final BreezeCheckBox showLineCheckBox;
    private final HardwareSidePanel hardwareSidePanel;
    private static boolean showLinePlot;

    public FocusPanel(MaintenancePanel maintenancePanel) {
        super(maintenancePanel);
        this.hardwareSidePanel = maintenancePanel.getHardwareSidePanel();
        this.hardwareSidePanel.setType(HardwareSidePanel.HardwareType.Focus);
        JPanel jPanel = new JPanel();
        this.resultPanel = new JPanel();
        this.focusRateDescLabel = new JLabel();
        JLabel jLabel = new JLabel();
        this.maxFocusRateLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        this.noLinesValueLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JPanel jPanel3 = new JPanel();
        this.positionSlider = new BreezeSlider();
        JLabel jLabel3 = new JLabel();
        this.positionValueLabel = new JLabel();
        this.showLineCheckBox = new BreezeCheckBox();
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane();
        this.buttonPanel = new JPanel();
        this.runBeltButton = new BreezeDescriptionButton();
        this.extendReferenceButton = new BreezeDescriptionButton();
        this.captureButton = new BreezeDescriptionButton();
        JPanel jPanel4 = new JPanel();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        jPanel.setBackground(new Color(255, 255, 255));
        jPanel.setBorder(BorderFactory.createLineBorder(new Color(51, 51, 51), 2));
        jPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 20);
        this.add(jPanel, gridBagConstraints);
        this.resultPanel.setBackground(new Color(102, 102, 102));
        this.resultPanel.setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForegroundLittleMoreDifuse(), 2));
        this.resultPanel.setMinimumSize(new Dimension(100, 90));
        this.resultPanel.setPreferredSize(new Dimension(100, 90));
        this.resultPanel.setLayout(new GridBagLayout());
        this.resultPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                FocusPanel.this.maxfocusrate = 0.0;
            }
        });
        this.resultPanel.setCursor(Cursor.getPredefinedCursor(12));
        this.resultPanel.setToolTipText("Focus rate, click to reset");
        this.focusRateDescLabel.setBackground(new Color(102, 102, 102));
        this.focusRateDescLabel.setFont(new Font("Tahoma", 0, 20));
        this.focusRateDescLabel.setForeground(new Color(255, 255, 255));
        this.focusRateDescLabel.setHorizontalAlignment(0);
        this.focusRateDescLabel.setText("0");
        this.focusRateDescLabel.setVerticalAlignment(3);
        this.focusRateDescLabel.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.resultPanel.add((Component)this.focusRateDescLabel, gridBagConstraints);
        this.maxFocusRateLabel.setForeground(new Color(255, 255, 255));
        this.maxFocusRateLabel.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.resultPanel.add((Component)this.maxFocusRateLabel, gridBagConstraints);
        jLabel.setForeground(new Color(255, 255, 255));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("i18n/Language_ENG");
        jLabel.setText(resourceBundle.getString("Focus_Rate"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.resultPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.add(this.resultPanel, gridBagConstraints);
        jPanel2.setBackground(new Color(102, 102, 102));
        jPanel2.setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForegroundLittleMoreDifuse(), 2));
        jPanel2.setMinimumSize(new Dimension(100, 80));
        jPanel2.setPreferredSize(new Dimension(100, 80));
        jPanel2.setLayout(new GridBagLayout());
        this.noLinesValueLabel.setBackground(new Color(102, 102, 102));
        this.noLinesValueLabel.setFont(new Font("Tahoma", 0, 20));
        this.noLinesValueLabel.setForeground(new Color(255, 255, 255));
        this.noLinesValueLabel.setHorizontalAlignment(0);
        this.noLinesValueLabel.setText("0");
        this.noLinesValueLabel.setVerticalAlignment(3);
        this.noLinesValueLabel.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)this.noLinesValueLabel, gridBagConstraints);
        jLabel2.setForeground(new Color(255, 255, 255));
        jLabel2.setText(resourceBundle.getString("Number_of_Lines"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 0, 20, 0);
        this.add(jPanel2, gridBagConstraints);
        jPanel3.setBackground(new Color(255, 255, 255));
        jPanel3.setLayout(new GridBagLayout());
        this.positionSlider.setName("focusSlider");
        this.positionSlider.addChangeListener(this::positionSliderStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        jPanel3.add((Component)this.positionSlider, gridBagConstraints);
        jLabel3.setFont(new Font("Tahoma", 0, 14));
        jLabel3.setText("Spectral band:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 20, 0, 0);
        jPanel3.add((Component)jLabel3, gridBagConstraints);
        this.positionValueLabel.setFont(new Font("Tahoma", 0, 14));
        this.positionValueLabel.setText("128 (256)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        jPanel3.add((Component)this.positionValueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add(jPanel3, gridBagConstraints);
        this.showLineCheckBox.setText("Show line plot");
        this.showLineCheckBox.setName("showlineplot");
        this.showLineCheckBox.addCallback(bl -> {
            showLinePlot = bl;
            this.focusLinePlot.setVisible(showLinePlot);
        });
        this.showLineCheckBox.setSelected(showLinePlot);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 15;
        this.add(this.showLineCheckBox, gridBagConstraints);
        breezeScrollPane.setHorizontalScrollBarPolicy(31);
        this.buttonPanel.setBackground(new Color(255, 255, 255));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.runBeltButton.setDescription("Conveyor");
        this.runBeltButton.setName("focusConveyer");
        this.runBeltButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                FocusPanel.this.runBeltButtonMouseClicked();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.buttonPanel.add((Component)this.runBeltButton, gridBagConstraints);
        this.extendReferenceButton.setDescription("Reference");
        this.extendReferenceButton.setName("focusReference");
        this.extendReferenceButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                FocusPanel.this.extendReferenceButtonMouseClicked();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.buttonPanel.add((Component)this.extendReferenceButton, gridBagConstraints);
        this.captureButton.setDescription("Camera");
        this.captureButton.setName("focusCamera");
        this.captureButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                FocusPanel.this.captureButtonMouseClicked();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.buttonPanel.add((Component)this.captureButton, gridBagConstraints);
        jPanel4.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)jPanel4, gridBagConstraints);
        breezeScrollPane.setViewportView(this.buttonPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        this.add(breezeScrollPane, gridBagConstraints);
        this.focusRealTimePanel = new FocusRealTimePanel();
        this.grabber.addOn(this.focusRealTimePanel);
        jPanel.add((Component)((Object)this.focusRealTimePanel), "Center");
        this.captureButton.setToggled(false);
        this.extendReferenceButton.setBackground(this.mainpanel.getPageColor());
        this.runBeltButton.setBackground(this.mainpanel.getPageColor());
        this.captureButton.setBackground(this.mainpanel.getPageColor());
        jPanel3.setOpaque(false);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        jLabel3.setForeground(breezeTheme.getLabelForeground());
        this.positionValueLabel.setForeground(breezeTheme.getLabelForeground());
        this.showLineCheckBox.setForeground(breezeTheme.getLabelForeground());
        this.focusLinePlot.setPreferredSize(new Dimension(0, 300));
        JPanel jPanel5 = new JPanel();
        jPanel5.setPreferredSize(new Dimension(100, 0));
        jPanel5.setMinimumSize(new Dimension(100, 0));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 10;
        this.focusLinePlot.add(jPanel5, gridBagConstraints2);
        jPanel.add((Component)((Object)this.focusLinePlot), "South");
    }

    @Override
    public boolean showRightSettingsPanel() {
        return BreezeProperties.getInstance().isShowHardwareSettings();
    }

    @Override
    public String getType() {
        return "Focus";
    }

    @Override
    public WizardStep.LeaveResult leaveEntry(WizardStep.LeaveControlCallback leaveControlCallback) {
        ((MaintenancePanel)this.mainpanel).leavePanel(this.grabber);
        this.reset();
        return WizardStep.LeaveResult.Ok;
    }

    private void reset() {
        this.focusRealTimePanel.reset();
        this.focusRateDescLabel.setText("0");
        this.maxFocusRateLabel.setText("0");
        this.noLinesValueLabel.setText("0");
    }

    @Override
    public void setBgColor(Color color) {
        super.setBgColor(color);
        this.buttonPanel.setBackground(color);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.maxfocusrate = 0.0;
        this.focusLinePlot.setVisible(this.showLineCheckBox.isSelected());
        ((MaintenancePanel)this.mainpanel).enterPanel(this.captureButton, this.grabber, this);
        this.updateFromSampleMover(HardwareRegistry.getInstance().getSampleMover());
    }

    @Override
    public void updateFromCamera(Camera camera, boolean bl) {
        this.positionSlider.setEnabled(Camera.connected(camera));
        this.positionSlider.setMaximum(Camera.connected(camera) ? camera.getBandCount().value - 1 : 0);
        this.positionSlider.setValue(Camera.connected(camera) ? (int)Math.ceil((double)camera.getBandCount().value / 2.0) - 1 : 0);
        this.positionSliderStateChanged(null);
        this.hardwareSidePanel.setCameras();
    }

    @Override
    public void afterConnection(Camera camera) {
        if (camera instanceof StateCamera) {
            ((StateCamera)camera).changeStateToNormal();
        }
        this.focusLinePlot.setCamera(camera);
    }

    private void updateFromSampleMover(SampleMover sampleMover) {
        if (sampleMover == null) {
            this.extendReferenceButton.setVisible(false);
            this.runBeltButton.setVisible(false);
        } else {
            this.extendReferenceButton.setVisible(true);
            this.extendReferenceButton.setToggled(sampleMover.inFocusState(this.getSelectedCamera()));
            this.extendReferenceButton.setDescription(sampleMover instanceof UmbioInspector ? "Reference" : "Focus grid");
            if (sampleMover.isConveyor()) {
                this.runBeltButton.setVisible(true);
                this.runBeltButton.setToggled(sampleMover.isRunning());
            } else {
                this.runBeltButton.setVisible(false);
            }
        }
        this.hardwareSidePanel.setSampleMover(sampleMover);
    }

    private int getCameraId() {
        return ((MaintenancePanel)this.mainpanel).getCameraId();
    }

    private Camera getSelectedCamera() {
        return ((MaintenancePanel)this.mainpanel).getSelectedCamera();
    }

    public String toString() {
        Camera camera = this.getSelectedCamera();
        if (Camera.connected(camera)) {
            return RtDataFormat.toString(camera.getFieldOfView().value) + " " + HardwareRegistry.getInstance().getSampleMoverUnit();
        }
        return "Camera not connected";
    }

    private void captureButtonMouseClicked() {
        this.captureButton.requestFocus();
        ((MaintenancePanel)this.mainpanel).toggleCamera(this.captureButton, this.grabber, this);
    }

    private void extendReferenceButtonMouseClicked() {
        this.extendReferenceButton.requestFocus();
        new ConnectProgressAction.ConnectMover(this.getFrame(), "Focus"){

            @Override
            public void afterConnectionInProgress(BreezeProgress breezeProgress, SampleMover sampleMover) {
                Camera camera = FocusPanel.this.getSelectedCamera();
                if (sampleMover.inFocusState(camera)) {
                    breezeProgress.setInfoText("Moving out of focus");
                    sampleMover.exitFocusState();
                    sampleMover.moveToReturnPosition(camera);
                } else {
                    breezeProgress.setInfoText("Moving to focus");
                    sampleMover.enterFocusState(camera);
                }
                FocusPanel.this.updateFromSampleMover(sampleMover);
            }
        };
    }

    private void runBeltButtonMouseClicked() {
        this.runBeltButton.requestFocus();
        new ConnectProgressAction.ConnectAll(this.getFrame(), this.getCameraId(), "Run belt"){

            @Override
            public void afterConnection(BreezeProgress breezeProgress, Camera camera, SampleMover sampleMover) {
                if (sampleMover.isRunning()) {
                    sampleMover.stop();
                } else {
                    FocusPanel.this.extendReferenceButton.setToggled(false);
                    sampleMover.runContinuously(new Speed(camera));
                }
                FocusPanel.this.updateFromSampleMover(sampleMover);
            }
        };
    }

    private void positionSliderStateChanged(ChangeEvent changeEvent) {
        if (this.positionSlider.getMaximum() == 0) {
            this.positionValueLabel.setText("N/A");
        } else {
            this.positionValueLabel.setText(this.getCurrentBand() + 1 + " (" + (this.positionSlider.getMaximum() + 1) + ")");
        }
    }

    private int getCurrentBand() {
        return this.positionSlider.getValue();
    }

    public static class FocusLinePlot
    extends SpectralPlot {
        private final AbstractViewPanel panel;
        private final Stroke stroke = new BasicStroke(2.0f, 1, 0, 10.0f);
        public final DataWrapper wrapper = new DataWrapper("Average");
        private int dataWidth;

        public FocusLinePlot(AbstractViewPanel abstractViewPanel) {
            this.panel = abstractViewPanel;
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            this.setBackground(breezeTheme.getPanelBackground());
            this.setForeground(breezeTheme.getLabelForeground());
            this.setGridColor(breezeTheme.getPlotGridColor());
            this.setZeroLine(false);
            this.sx = 60;
            this.sy = 10;
            this.ey = 25;
            this.setXdesc("");
            this.setYdesc("Intensity");
            List list = this.getPointWrapperList();
            this.wrapper.setColor(Color.red);
            this.wrapper.setStroke(this.stroke);
            list.add(this.wrapper);
            this.setNoValueFont(new Font("Dialog", 0, 18));
        }

        public void setData(Frame frame, int n) {
            int n2 = Math.max(0, n);
            for (int i = 0; i < this.dataWidth; ++i) {
                this.wrapper.setYvalueAt(i, frame.getFrameValue(n2, i));
            }
            this.contentPaint();
        }

        public void setCamera(Camera camera) {
            this.dataWidth = camera.getWidth().value;
            this.wrapper.setDataX(new float[this.dataWidth]);
            this.wrapper.setDataY(new float[this.dataWidth]);
            for (int i = 0; i < this.dataWidth; ++i) {
                this.wrapper.setXvalueAt(i, (float)(i + 1));
            }
            this.setYmax((double)camera.getMaxsignal().value * 1.05);
            this.setMinMax();
            this.contentPaint();
        }

        protected String getNoSpectraDesc() {
            return "Turn on the Camera switch to start capturing image data";
        }

        protected void createPopupMenu(MouseEvent mouseEvent) {
            BreezeFrame breezeFrame = this.panel.getFrame();
            BreezeContextMenu breezeContextMenu = new BreezeContextMenu(breezeFrame, Color.red);
            breezeContextMenu.addButtonCloseClick("Copy as image to clipboard", () -> ((FocusLinePlot)this).copyToClipboard());
            breezeContextMenu.addSeparator();
            breezeContextMenu.addButtonCloseClick("Reset zoom", () -> ((FocusLinePlot)this).zoomAll());
            if (breezeContextMenu.resize()) {
                breezeFrame.addPage((JPanel)((Object)breezeContextMenu));
                breezeContextMenu.setPositionLater(mouseEvent);
            }
        }
    }

    private class FocusRealTimePanel
    extends CameraStreamPanel {
        private final int[] focusHistogram;
        private int[] grayArray;
        private long lastUpdateTime;
        private float factor;
        private float[][] darkMatrix;
        private float[][] reMatrixInverted;
        private MaxSignal maxSignal;
        private PixelWidth pixelWidth;
        private BandCount bandCount;

        public FocusRealTimePanel() {
            super(CameraPanelInfoText.PressCameraStart);
            this.focusHistogram = new int[256];
            this.lastUpdateTime = 0L;
        }

        @Override
        protected CameraStreamPanel.RgbFrameRasterer createFrameRasterer() {
            return new Renderer();
        }

        @Override
        public void init(Camera camera, FrameCount frameCount) {
            super.init(camera, frameCount);
            this.pixelWidth = this.camera().getWidth();
            this.bandCount = this.camera().getBandCount();
            this.maxSignal = this.camera().getMaxsignal();
            this.grayArray = new int[this.pixelWidth.value];
            this.factor = this.maxSignal.inverted();
            DrReMatrix drReMatrix = camera.getDrReMatrix();
            this.darkMatrix = drReMatrix.getDarkMatrix();
            this.reMatrixInverted = drReMatrix.getReMatrixInversed();
            TcpManager.getInstance().setListener(runtimeEvent -> {
                if (runtimeEvent.isError()) {
                    ToastHandler.getInstance().showToast(runtimeEvent.getMessageError(), Toast.IconType.Error);
                } else if (runtimeEvent.isWarning()) {
                    ToastHandler.getInstance().showToast(runtimeEvent.getMessageError(), Toast.IconType.Warning);
                }
            });
        }

        private void updateLineMatrix(Frame frame) {
            int n = FocusPanel.this.getCurrentBand();
            FocusPanel.this.focusLinePlot.setData(frame, n);
        }

        private void updateFocusRate(int n, int n2) {
            int n3 = (n /= this.pixelWidth.value) - n2;
            double d = 0.0;
            for (int i = 0; i < this.focusHistogram.length; ++i) {
                for (int j = 0; j < this.focusHistogram[i]; ++j) {
                    double d2 = n3 - i + n2;
                    d += d2 * d2;
                }
            }
            double d3 = Math.sqrt(d / (double)(this.pixelWidth.value - 1));
            double d4 = d3 / (double)n2 * 100.0;
            if (FocusPanel.this.maxfocusrate < d4) {
                FocusPanel.this.maxfocusrate = d4;
            }
            if (FocusPanel.this.maxfocusrate > 0.0) {
                double d5 = d4 / FocusPanel.this.maxfocusrate * 100.0;
                if (d5 > 90.0) {
                    FocusPanel.this.resultPanel.setBackground(IntegrationPanel.green);
                } else if (d5 < 90.0 && d5 > 80.0) {
                    FocusPanel.this.resultPanel.setBackground(IntegrationPanel.yellow);
                } else {
                    FocusPanel.this.resultPanel.setBackground(IntegrationPanel.red);
                }
            }
            FocusPanel.this.focusRateDescLabel.setText(NiceDataFormat.toString((double)d4, (int)5));
            FocusPanel.this.maxFocusRateLabel.setText("Best: " + NiceDataFormat.toString((double)FocusPanel.this.maxfocusrate, (int)5));
            int n4 = 0;
            int n5 = -2;
            boolean bl = true;
            for (int i = 0; i < this.grayArray.length; ++i) {
                if (this.grayArray[i] < n) {
                    if (!bl || i <= n5 + 2) continue;
                    int n6 = 255;
                    for (int j = -1; j <= 1; j += 2) {
                        for (int k = 1; k <= 2; ++k) {
                            int n7 = i + k * j;
                            if (n7 < 0 || n7 >= this.grayArray.length || n6 <= this.grayArray[n7]) continue;
                            n6 = this.grayArray[n7];
                        }
                    }
                    if (this.grayArray[i] > n6) continue;
                    ++n4;
                    n5 = i;
                    bl = false;
                    continue;
                }
                bl = true;
            }
            FocusPanel.this.noLinesValueLabel.setText(String.valueOf(n4));
            this.lastUpdateTime = System.currentTimeMillis();
        }

        private class Renderer
        implements CameraStreamPanel.RgbFrameRasterer {
            private Renderer() {
            }

            @Override
            public void rasterIntoRgbFrame(PushbroomStreamImage.RgbFrame rgbFrame, FrameStack frameStack) {
                int n;
                Arrays.fill(FocusRealTimePanel.this.focusHistogram, 0);
                int n2 = 0;
                int n3 = FocusRealTimePanel.this.bandCount.value / 2;
                int n4 = Math.max(0, FocusPanel.this.getCurrentBand());
                int n5 = FocusRealTimePanel.this.pixelWidth.value;
                RawFrame rawFrame = frameStack.getFrame();
                if (FocusRealTimePanel.this.darkMatrix != null) {
                    if (FocusRealTimePanel.this.reMatrixInverted != null) {
                        for (n = 0; n < n5; ++n) {
                            float f = FocusRealTimePanel.this.darkMatrix[n4][n];
                            var10_13 = (rawFrame.getFrameValue(n4, n) - f) * FocusRealTimePanel.this.reMatrixInverted[n4][n];
                            var11_15 = FocusRealTimePanel.this.maxSignal.value - f;
                            var12_16 = FocusRealTimePanel.this.grayArray[n] = BreezeColor.toRGB(var10_13 / var11_15);
                            n2 += var12_16;
                            int n6 = var12_16;
                            FocusRealTimePanel.this.focusHistogram[n6] = FocusRealTimePanel.this.focusHistogram[n6] + 1;
                        }
                    } else {
                        for (n = 0; n < n5; ++n) {
                            float f = FocusRealTimePanel.this.darkMatrix[n4][n];
                            var10_13 = rawFrame.getFrameValue(n4, n) - f;
                            var11_15 = FocusRealTimePanel.this.maxSignal.value - f;
                            var12_16 = FocusRealTimePanel.this.grayArray[n] = BreezeColor.toRGB(var10_13 / var11_15);
                            n2 += var12_16;
                            int n7 = var12_16;
                            FocusRealTimePanel.this.focusHistogram[n7] = FocusRealTimePanel.this.focusHistogram[n7] + 1;
                        }
                    }
                } else {
                    for (n = 0; n < n5; ++n) {
                        int n8 = FocusRealTimePanel.this.grayArray[n] = BreezeColor.toRGB(rawFrame.getFrameValue(n4, n) * FocusRealTimePanel.this.factor);
                        n2 += n8;
                        int n9 = n8;
                        FocusRealTimePanel.this.focusHistogram[n9] = FocusRealTimePanel.this.focusHistogram[n9] + 1;
                    }
                }
                if (System.currentTimeMillis() > FocusRealTimePanel.this.lastUpdateTime + 500L) {
                    FocusRealTimePanel.this.updateFocusRate(n2, n3);
                    if (FocusPanel.this.showLineCheckBox.isSelected()) {
                        FocusRealTimePanel.this.updateLineMatrix(rawFrame);
                    }
                }
                for (n = 0; n < n5; ++n) {
                    int n10 = FocusRealTimePanel.this.grayArray[n];
                    int n11 = n * 3;
                    if (n10 == 255) {
                        rgbFrame.origframe[n11] = -1;
                        rgbFrame.origframe[n11 + 1] = 0;
                        rgbFrame.origframe[n11 + 2] = 0;
                        continue;
                    }
                    rgbFrame.origframe[n11] = (byte)n10;
                    rgbFrame.origframe[n11 + 1] = (byte)n10;
                    rgbFrame.origframe[n11 + 2] = (byte)n10;
                }
            }
        }
    }
}

