/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.focus;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lombok.Generated;
import se.prediktera.breeze.backend.grabber.CameraStreamGrabber;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.IFramesToAverage;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelField;
import se.prediktera.breeze.frontend.common.swing.BreezeResponsivePanel;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinnerInputPanel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferencesSettingsPanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.CameraMode;
import se.prediktera.breeze.hardware.camera.HySpexCamera;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.samplemover.RemoteMotor;
import se.prediktera.breeze.hardware.samplemover.tray.PositionInputField;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettings;
import se.prediktera.breeze.util.FileFromAbsolutePath;

public class HardwareSidePanel
extends DefaultSettingsPanel {
    private final JPanel additionSettingsPanel = new JPanel(new GridBagLayout());
    private final List<DefaultSettingsPanel.SectionPanel> cameraSections = new ArrayList<DefaultSettingsPanel.SectionPanel>();
    private final DefaultSettingsPanel.SectionPanel sampleMoverSection;
    private final EntryMainPanelInterface mainPanel;
    private final BreezeFrame frame;
    private final HardwareConnectedCallback connectedCallback;
    private final CameraStreamGrabber grabber;
    private HardwareType type;

    public HardwareSidePanel(EntryMainPanelInterface entryMainPanelInterface, HardwareType hardwareType, CameraStreamGrabber cameraStreamGrabber, HardwareConnectedCallback hardwareConnectedCallback) {
        super(300, false);
        this.mainPanel = entryMainPanelInterface;
        this.type = hardwareType;
        this.grabber = cameraStreamGrabber;
        this.connectedCallback = hardwareConnectedCallback;
        this.frame = entryMainPanelInterface.getFrame();
        this.additionSettingsPanel.setOpaque(false);
        this.contentPanel.add((Component)this.additionSettingsPanel, GridBagHelper.createWithWeigthX1(0, new Insets(2, 5, 0, 5)));
        BreezeResponsivePanel breezeResponsivePanel = new BreezeResponsivePanel(this, 210);
        this.contentPanel.add((Component)breezeResponsivePanel, GridBagHelper.createLast(1, new Insets(2, 5, 0, 5)));
        for (int i = 0; i < HardwareRegistry.MaxSupportedCameras; ++i) {
            DefaultSettingsPanel.SectionPanel sectionPanel = new DefaultSettingsPanel.SectionPanel("Camera", this.settingsWidth);
            breezeResponsivePanel.addChildPanel(sectionPanel);
            sectionPanel.hideIfEmpty();
            this.cameraSections.add(sectionPanel);
        }
        this.sampleMoverSection = this.addSection("Sample mover");
    }

    @Override
    public void setEnabled(boolean bl) {
        for (int i = 0; i < this.additionSettingsPanel.getComponentCount(); ++i) {
            this.additionSettingsPanel.getComponent(i).setEnabled(bl);
        }
        for (DefaultSettingsPanel.SectionPanel sectionPanel : this.cameraSections) {
            sectionPanel.setEnabled(bl);
        }
        this.sampleMoverSection.setEnabled(bl);
    }

    public void setActiveCamera(int n) {
        for (int i = 0; i < this.cameraSections.size(); ++i) {
            this.cameraSections.get(i).getRoundedTitledBorder().setActive(n == i);
        }
        this.repaint();
    }

    public void clearActiveCamera() {
        for (DefaultSettingsPanel.SectionPanel sectionPanel : this.cameraSections) {
            sectionPanel.getRoundedTitledBorder().setActive(false);
        }
        this.repaint();
    }

    public void clearCameras() {
        for (DefaultSettingsPanel.SectionPanel sectionPanel : this.cameraSections) {
            sectionPanel.clear();
            sectionPanel.hideIfEmpty();
        }
    }

    public synchronized void setCameras(List<Camera> list) {
        this.clearCameras();
        Camera.ConnectedFields connectedFields = new Camera.ConnectedFields();
        for (Camera camera : list) {
            this.setCameraSection(this.cameraSections.get(camera.getId()), camera, connectedFields, true);
        }
    }

    public void updateAll() {
        this.setCameras();
        this.setSampleMover(HardwareRegistry.getInstance().getSampleMover());
    }

    public void setCameras() {
        this.setCameras(HardwareRegistry.getInstance().getCameras());
    }

    private void setCameraSection(final DefaultSettingsPanel.SectionPanel sectionPanel, final Camera camera, final Camera.ConnectedFields connectedFields, final boolean bl) {
        Object object;
        Object object2;
        sectionPanel.clear();
        sectionPanel.setTitle(camera);
        if (camera == null) {
            return;
        }
        JPanel jPanel = sectionPanel.getPanel();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setOpaque(false);
        jPanel2.add((Component)new BreezeLabelField("Type:", 35, 5, Camera.getCameraTypeName(camera), 0, 20, 12, 14), GridBagHelper.createWithWeigthX1(jPanel2.getComponentCount(), new Insets(5, 0, 0, 0)));
        final Camera.FieldOfViewInputField fieldOfViewInputField = new Camera.FieldOfViewInputField(this.frame, camera, this.mainPanel::repaintEntryList);
        fieldOfViewInputField.setEnabled(!camera.isFieldOfViewFixed() && camera.canChangeView());
        fieldOfViewInputField.setVisible(!camera.isFieldOfViewFixed());
        if (camera instanceof Camera.ICameraMode) {
            object2 = (Camera.ICameraMode)((Object)camera);
            if (camera.isConnected() && (object = object2.getCameraMode()) != null) {
                CameraMode.CameraModeInputField cameraModeInputField = object2.createCameraModeField(new Hardware.SettingsPanelCallbackAdapter(this){

                    @Override
                    public void reloadInformation() {
                        fieldOfViewInputField.setCamera(camera);
                    }
                });
                cameraModeInputField.hideEmptyPanel();
                cameraModeInputField.reload();
                jPanel2.add((Component)cameraModeInputField, GridBagHelper.createWithWeigthX1(jPanel2.getComponentCount(), new Insets(5, 0, 0, 10)));
            }
        }
        if (!camera.isConnected()) {
            object2 = GridBagHelper.createLast(0, new Insets(5, 0, 5, 0));
            ((GridBagConstraints)object2).fill = 0;
            ((GridBagConstraints)object2).anchor = 13;
            object = EntryMainHelper.createSmallTextButton("Connect", () -> new ConnectProgressAction.ConnectCamera(this, this.frame, camera){
                final /* synthetic */ HardwareSidePanel this$0;
                {
                    this.this$0 = hardwareSidePanel;
                    super(breezeFrame, camera);
                }

                @Override
                public void afterConnection(BreezeProgress breezeProgress, Camera camera) {
                    if (this.this$0.type.equals((Object)HardwareType.RecordWizard)) {
                        SwingUtilities.invokeLater(() -> this.this$0.setCameraSection(sectionPanel, camera, connectedFields, bl));
                    } else {
                        SwingUtilities.invokeLater(() -> this.this$0.mainPanel.setDirty(true));
                    }
                    if (this.this$0.connectedCallback != null) {
                        this.this$0.connectedCallback.onConnected(camera);
                    }
                }
            });
            ((Component)object).setName("connectCamera" + camera.getId());
            jPanel2.add((Component)object, object2);
        }
        jPanel.add((Component)jPanel2, GridBagHelper.createWithWeigthX1(jPanel.getComponentCount(), new Insets(5, 0, 0, 0)));
        HardwareSidePanel.addComponentHorizontal(sectionPanel, fieldOfViewInputField);
        if (camera instanceof IFramesToAverage) {
            object2 = new Camera.FramesToAverageInputField(this.frame, camera, this.grabber, this.mainPanel::repaintEntryList, connectedFields);
            HardwareSidePanel.addComponentHorizontal(sectionPanel, (JPanel)object2);
            ((BreezeSpinnerInputPanel)object2).setEnabled(camera.isConnected() && ((Component)object2).isEnabled() && bl);
            ((JComponent)object2).setToolTipText(bl ? null : "Cannot change Frames to average in Record with cached references");
        }
        if (BreezeProperties.getInstance().getFrameRateDisplayUnit().equals((Object)Camera.FpsUnit.framesPerSecond)) {
            object2 = new Camera.FrameRateInputField(this.frame, camera, this.grabber, this.mainPanel::repaintEntryList, connectedFields);
            ((Camera.FrameRateInputField)object2).setEnabled(!camera.isFrameRateFixed());
            ((JComponent)object2).setVisible(!camera.isFrameRateFixed());
            sectionPanel.addComponentHorizontal((JComponent)object2);
        } else {
            object2 = new Camera.FramePeriodInputField(this.frame, camera, this.grabber, this.mainPanel::repaintEntryList, connectedFields);
            ((BreezeSpinnerInputPanel)object2).setEnabled(!camera.isFrameRateFixed());
            ((JComponent)object2).setVisible(!camera.isFrameRateFixed());
            sectionPanel.addComponentHorizontal((JComponent)object2);
        }
        object2 = new Camera.IntegrationTimeInputField(this.frame, camera, this.grabber, () -> {
            if (this.type.equals((Object)HardwareType.Measurement)) {
                this.mainPanel.setDirty(true);
            } else {
                MaintenancePanel maintenancePanel;
                Object object = this.mainPanel;
                if (object instanceof MaintenancePanel && (object = (maintenancePanel = (MaintenancePanel)object).getViewClass().getPanel()) instanceof ReferencesSettingsPanel) {
                    ReferencesSettingsPanel referencesSettingsPanel = (ReferencesSettingsPanel)object;
                    referencesSettingsPanel.showEntry(null, null);
                }
                this.mainPanel.repaintEntryList();
            }
        }, connectedFields);
        ((Camera.IntegrationTimeInputField)object2).setEnabled(!camera.isIntegrationTimeFixed() && camera.isConnected() && ((Component)object2).isEnabled() && bl);
        ((JComponent)object2).setVisible(!camera.isIntegrationTimeFixed());
        ((JComponent)object2).setToolTipText(bl ? null : "Cannot change Integration time in Record with cached references");
        HardwareSidePanel.addComponentHorizontal(sectionPanel, (JPanel)object2);
        if (camera instanceof Camera.WhiteReferenceIntensity) {
            object = (Camera.WhiteReferenceIntensity)camera;
            sectionPanel.addComponentHorizontal(new HySpexCamera.CalibratedReflectanceTargetInputField.CalibratedReflectanceTargetWithFocusInputField((Component)this.frame, object.getWhiteReferenceTargetFile(), arg_0 -> HardwareSidePanel.lambda$setCameraSection$2((Camera.WhiteReferenceIntensity)object, arg_0), BreezeInputFieldHelper.Format.TwoRows));
        }
        if (camera instanceof RemoteCamera) {
            object = (RemoteCamera)camera;
            if ((HardwareRegistry.hasSecondCamera() || camera.getOffset().value > 0.0f) && HardwareRegistry.getInstance().getSampleMover() != null) {
                HardwareSidePanel.addComponentHorizontal(sectionPanel, new Camera.OffsetInputField(this.frame, (RemoteCamera)object, null, BreezeInputFieldHelper.Format.TwoRows));
            }
        }
        sectionPanel.hideIfEmpty();
        this.revalidate();
        this.repaint();
    }

    public void setSampleMover(SampleMover sampleMover) {
        RemoteSampleMover remoteSampleMover;
        Object object;
        this.sampleMoverSection.clear();
        this.sampleMoverSection.setTitle(sampleMover);
        JPanel jPanel = this.sampleMoverSection.getPanel();
        if (sampleMover != null) {
            if (sampleMover.isConnected()) {
                jPanel.add((Component)new BreezeLabelField("Type:", 35, 5, sampleMover.getType().toString(), 0, 20, 12, 14), GridBagHelper.createWithWeigthX1(jPanel.getComponentCount(), new Insets(5, 0, 0, 0)));
            } else {
                object = GridBagHelper.create(0, jPanel.getComponentCount(), new Insets(5, 0, 0, 0), true);
                ((GridBagConstraints)object).anchor = 13;
                jPanel.add((Component)EntryMainHelper.createSmallTextButton("Connect", () -> new ConnectProgressAction.ConnectMover(this.frame, "Connecting"){

                    @Override
                    public void afterConnection(SampleMover sampleMover) {
                        if (HardwareSidePanel.this.type.equals((Object)HardwareType.RecordWizard)) {
                            SwingUtilities.invokeLater(() -> HardwareSidePanel.this.setSampleMover(sampleMover));
                        } else {
                            SwingUtilities.invokeLater(() -> HardwareSidePanel.this.mainPanel.setDirty(true));
                        }
                        if (HardwareSidePanel.this.connectedCallback != null) {
                            HardwareSidePanel.this.connectedCallback.onConnected(sampleMover);
                        }
                    }
                }), object);
            }
        }
        if (sampleMover instanceof RemoteSampleMover && !(object = (RemoteSampleMover)sampleMover).isConveyor()) {
            Object t = ((RemoteSampleMover)object).getSettings();
            PositionInputField.TrayCallback trayCallback = new PositionInputField.TrayCallback(){
                final /* synthetic */ RemoteSampleMover val$rsm;
                {
                    this.val$rsm = remoteSampleMover;
                }

                @Override
                public void moveToPosition(float f) {
                    this.val$rsm.getRemoteMotor().move(((RemoteSampleMoverSettings)this.val$rsm.getSettings()).movementSpeed(), f, RemoteMotor.MotorDirection.Forward, RemoteMotor.MotorDriveMode.Absolute);
                }

                @Override
                public void stop() {
                    this.val$rsm.getRemoteMotor().stopMotor();
                }
            };
            if (((RemoteSampleMover)object).supportVerticalMovement()) {
                HardwareSidePanel.addComponentHorizontal(this.sampleMoverSection, new PositionInputField("Height", (double)((RemoteSampleMoverSettings)t).verticalLocation(), new PositionInputField.TrayCallback(){
                    final /* synthetic */ RemoteSampleMover val$rsm;
                    final /* synthetic */ RemoteSampleMoverSettings val$settings;
                    {
                        this.val$rsm = remoteSampleMover;
                        this.val$settings = remoteSampleMoverSettings;
                    }

                    @Override
                    public void moveToPosition(float f) {
                        this.val$rsm.getRemoteMotor().move(this.val$settings.verticalMovementSpeed(), f, RemoteMotor.MotorDirection.Up, RemoteMotor.MotorDriveMode.Absolute);
                    }

                    @Override
                    public void stop() {
                        this.val$rsm.getRemoteMotor().stopMotor();
                    }
                }, (RemoteSampleMover)object));
            }
            if (!this.type.equals((Object)HardwareType.RecordWizard)) {
                HardwareSidePanel.addComponentHorizontal(this.sampleMoverSection, new PositionInputField("Focus location", (double)((RemoteSampleMoverSettings)t).focusLocation(), trayCallback, (RemoteSampleMover)object, textActionEvent -> t.changeFocusLocation(textActionEvent.getValueFloat())));
            }
            HardwareSidePanel.addComponentHorizontal(this.sampleMoverSection, new PositionInputField("White reference location", (double)((RemoteSampleMoverSettings)t).whiteRefLocation(), trayCallback, (RemoteSampleMover)object, textActionEvent -> t.changeWhiteRefLocation(textActionEvent.getValueFloat())));
            HardwareSidePanel.addComponentHorizontal(this.sampleMoverSection, new BreezeInputField.Number("White reference scan length", (double)((RemoteSampleMoverSettings)t).whiteRefScanLength(), sampleMover.getType().getUnit(), textActionEvent -> t.changeWhiteRefScanLength(textActionEvent.getValueFloat())));
            HardwareSidePanel.addComponentHorizontal(this.sampleMoverSection, new PositionInputField("Scan start location", (double)((RemoteSampleMoverSettings)t).scanStartLocation(), trayCallback, (RemoteSampleMover)object, textActionEvent -> t.changeScanStartLocation(textActionEvent.getValueFloat())));
            HardwareSidePanel.addComponentHorizontal(this.sampleMoverSection, new PositionInputField("Return location", (double)((RemoteSampleMoverSettings)t).returnLocation(), trayCallback, (RemoteSampleMover)object, textActionEvent -> t.changeReturnLocation(textActionEvent.getValueFloat())));
        } else if (sampleMover instanceof RemoteSampleMover && (remoteSampleMover = (RemoteSampleMover)sampleMover).isConveyor() && remoteSampleMover.isConnected()) {
            BreezeLabelField breezeLabelField = new BreezeLabelField("", 0, "Conveyor connected", 20);
            breezeLabelField.setFontStyle(2);
            this.sampleMoverSection.addComponentHorizontal(breezeLabelField);
        }
        this.sampleMoverSection.hideIfEmpty();
        this.revalidate();
        this.repaint();
    }

    private static void addComponentHorizontal(DefaultSettingsPanel.SectionPanel sectionPanel, JPanel jPanel) {
        sectionPanel.addComponentHorizontal(jPanel);
    }

    @Override
    public void showEntry(Object object, Object object2, boolean bl) {
        boolean bl2 = BreezeProperties.getInstance().isShowHardwareSettings();
        if (bl2 != bl) {
            EntrySettingsPanel entrySettingsPanel = (EntrySettingsPanel)this.getParent();
            entrySettingsPanel.toggleVisible(bl2);
        }
    }

    @Override
    public void toggled(boolean bl) {
        super.toggled(bl);
        BreezeProperties.getInstance().setShowHardwareSettings(bl);
    }

    public BreezeSpinnerInputPanel getFrameRateSecondCamera() {
        JPanel jPanel = this.cameraSections.get(1).getPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (component instanceof Camera.FrameRateInputField) {
                Camera.FrameRateInputField frameRateInputField = (Camera.FrameRateInputField)component;
                return frameRateInputField;
            }
            component = jPanel.getComponent(i);
            if (!(component instanceof Camera.FramePeriodInputField)) continue;
            Camera.FramePeriodInputField framePeriodInputField = (Camera.FramePeriodInputField)component;
            return framePeriodInputField;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Generated
    public JPanel getAdditionSettingsPanel() {
        return this.additionSettingsPanel;
    }

    @Generated
    public void setType(HardwareType hardwareType) {
        this.type = hardwareType;
    }

    private static /* synthetic */ void lambda$setCameraSection$2(Camera.WhiteReferenceIntensity whiteReferenceIntensity, TextActionEvent textActionEvent) {
        whiteReferenceIntensity.setWhiteReferenceTargetFile(new FileFromAbsolutePath(textActionEvent.getText()).fileOrNull());
    }

    public static enum HardwareType {
        Focus,
        IntegrationTime,
        TestScan,
        Hardware,
        Measurement,
        RecordWizard;

    }

    public static interface HardwareConnectedCallback {
        public void onConnected(Hardware var1);
    }
}

