/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.hardware;

import java.awt.BorderLayout;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.frontend.main.settings.hardware.MultiCameraSettingsPanel;
import se.prediktera.breeze.frontend.main.settings.hardware.TabbedCameraPanel;
import se.prediktera.breeze.hardware.Camera;

public class CameraMainPanel
extends AbstractViewPanel {
    private final TabbedCameraPanel cameraTabPanel;
    private final MultiCameraSettingsPanel multiCameraSettingsPanel;
    public boolean initiating = true;

    public CameraMainPanel(MaintenancePanel maintenancePanel) {
        super(maintenancePanel);
        this.setLayout(new BorderLayout());
        this.cameraTabPanel = new TabbedCameraPanel(maintenancePanel, this, maintenancePanel.getHardwareSidePanel());
        this.add(this.cameraTabPanel, "Center");
        this.multiCameraSettingsPanel = new MultiCameraSettingsPanel(this.getFrame(), (Boolean)true);
        this.add(this.multiCameraSettingsPanel, "Last");
        this.initiating = false;
    }

    @Override
    public String getType() {
        return "Cameras";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.setVisible(false);
        this.multiCameraSettingsPanel.setVisible(BreezeProperties.getInstance().getNumberOfCameras() > 1);
        BreezeProgressDialog.startProgress(this.getFrame(), new ProgressAction(){

            @Override
            public void runAction() {
                this.setInfoText("Detecting hardware... Please wait");
                CameraMainPanel.this.cameraTabPanel.showEntry();
                CameraMainPanel.this.setVisible(true);
            }
        }, "Loading available cameras");
    }

    @Override
    public boolean showRightSettingsPanel() {
        return BreezeProperties.getInstance().isShowHardwareSettings();
    }

    public void reloadHardwareInformation() {
        if (this.cameraTabPanel != null) {
            this.cameraTabPanel.reloadInformation();
        }
    }

    private Camera getSelectedCamera() {
        return ((MaintenancePanel)this.mainpanel).getSelectedCamera();
    }

    public String toString() {
        Camera camera;
        if (BreezeProperties.getInstance().isBreezeRuntimeLocalHost() && (camera = this.getSelectedCamera()) != null) {
            return camera.toString();
        }
        return "Remote Camera";
    }
}

