/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.hardware;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.frontend.main.settings.focus.HardwareSidePanel;
import se.prediktera.breeze.frontend.main.settings.hardware.CameraMainPanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.camera.RemoteCamera;

public class CameraPanel
extends JPanel {
    private static final String NoneItem = "None";
    private final HardwareComboBox cameraComboBox;
    private final InformationPanel cameraInformationPanel;
    private final JPanel cameraSettingsPanel;
    private final BreezeButton connectCameraButton;
    private final BreezeButton disconnectCameraButton;
    private final MaintenancePanel mainPanel;
    private final CameraMainPanel hardwarePanel;
    private final int cameraId;
    private final HardwareSidePanel hardwareRightPanel;
    private final CameraTypeCallback callback;

    public CameraPanel(MaintenancePanel maintenancePanel, final CameraMainPanel cameraMainPanel, int n, HardwareSidePanel hardwareSidePanel, CameraTypeCallback cameraTypeCallback) {
        super(new GridBagLayout());
        this.mainPanel = maintenancePanel;
        this.hardwarePanel = cameraMainPanel;
        this.cameraId = n;
        this.hardwareRightPanel = hardwareSidePanel;
        this.callback = cameraTypeCallback;
        this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        JPanel jPanel = new JPanel();
        this.cameraComboBox = new HardwareComboBox();
        this.cameraInformationPanel = new InformationPanel();
        this.cameraSettingsPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new GridBagLayout());
        this.cameraComboBox.addItemListener(this::cameraComboBoxItemStateChanged);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)this.cameraComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        this.cameraSettingsPanel.setOpaque(false);
        this.cameraSettingsPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        this.add((Component)this.cameraSettingsPanel, gridBagConstraints);
        this.connectCameraButton = EntryMainHelper.createTextButton("Connect", "connectCamera", null);
        this.connectCameraButton.addClickCallBack(() -> {
            this.connectCameraButton.requestFocus();
            new ConnectProgressAction.ConnectCamera(this, maintenancePanel.getFrame(), this.cameraComboBox.getSelectedCamera()){
                final /* synthetic */ CameraPanel this$0;
                {
                    this.this$0 = cameraPanel;
                    super(breezeFrame, camera);
                }

                @Override
                public void afterConnection(BreezeProgress breezeProgress, Camera camera) {
                    this.this$0.updateCameraPanel(camera);
                    cameraMainPanel.reloadHardwareInformation();
                }
            };
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        this.add((Component)this.connectCameraButton, gridBagConstraints);
        this.disconnectCameraButton = EntryMainHelper.createTextButton("Disconnect", "disconnectCamera", () -> BreezeProgressDialog.startProgress(maintenancePanel.getFrame(), breezeProgressManager -> {
            Camera camera = this.cameraComboBox.getSelectedCamera();
            camera.disconnect(breezeProgressManager);
            this.updateCameraPanel(camera);
            cameraMainPanel.reloadHardwareInformation();
        }, "Disconnecting"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        this.add((Component)this.disconnectCameraButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(20, 20, 0, 0);
        this.add((Component)this.cameraInformationPanel, gridBagConstraints);
        this.cameraComboBox.setName("cameras");
        if (n >= 1) {
            this.cameraComboBox.addItem(NoneItem);
            this.cameraComboBox.addSeparator();
        }
        for (Camera camera : HardwareRegistry.getInstance().getAvailableCameras(n)) {
            this.cameraComboBox.addItem(camera);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 100;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JLabel(""), gridBagConstraints);
    }

    private void cameraComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (!this.hardwarePanel.initiating && itemEvent.getStateChange() == 1) {
            Camera camera = this.cameraComboBox.getSelectedCamera();
            HardwareRegistry.getInstance().switchToCamera(camera, this.cameraId);
            this.updateCameraPanel(camera);
            this.callback.onChanged();
        }
    }

    public void reloadInformation() {
        this.reloadInformation(HardwareRegistry.getInstance().getCamera(this.cameraId));
    }

    public void reloadInformation(Camera camera) {
        InformationPanel.InformationList informationList = new InformationPanel.InformationList(camera);
        if (camera != null && camera.isConnected()) {
            Object object;
            if (camera instanceof RemoteCamera) {
                object = (RemoteCamera)camera;
                ((RemoteCamera)object).add(informationList);
            }
            informationList.add("PixelsPerLine", camera.getWidth().value + (camera.isFlipped() ? " (Mirrored)" : ""));
            informationList.add("Wavelength", camera.getBandCount().value);
            informationList.add("RgbBands", camera.getRgbBands().toCommaSeparatedString());
            informationList.add("MaxSignal", camera.getMaxsignal().value);
            object = camera.getOffset();
            if (((LengthValue)object).value > 0.0f) {
                informationList.add("Offset", ((LengthValue)object).toString());
            }
        }
        this.cameraInformationPanel.setInformation(informationList);
        this.mainPanel.repaintEntryList();
        this.hardwareRightPanel.updateAll();
    }

    public void updateCameraPanel() {
        this.updateCameraPanel(this.cameraComboBox.getSelectedCamera());
    }

    private void updateCameraPanel(final Camera camera) {
        this.cameraSettingsPanel.removeAll();
        if (camera instanceof RemoteCamera) {
            this.cameraSettingsPanel.add((Component)((RemoteCamera)camera).getCameraSettingsPanel(this.mainPanel.getFrame(), new Hardware.SettingsPanelCallback(){
                final /* synthetic */ CameraPanel this$0;
                {
                    this.this$0 = cameraPanel;
                }

                @Override
                public void reloadInformation() {
                    this.this$0.hardwarePanel.reloadHardwareInformation();
                }

                @Override
                public void clearReferenceCache() {
                    ReferenceHelper.clearReferenceCache(camera);
                }

                @Override
                public void setEnabled(boolean bl) {
                    this.this$0.connectCameraButton.setEnabled(bl);
                }

                @Override
                public void reloadSubsequentTabs() {
                    this.this$0.callback.onChanged();
                }
            }), "Center");
        }
        this.reloadInformation(camera);
        this.mainPanel.repaintEntryList();
        this.cameraSettingsPanel.revalidate();
        if (camera == null) {
            this.connectCameraButton.setVisible(false);
            this.disconnectCameraButton.setVisible(false);
            this.cameraInformationPanel.setVisible(false);
        } else if (camera.isConnected()) {
            this.connectCameraButton.setVisible(false);
            this.disconnectCameraButton.setVisible(true);
            this.cameraInformationPanel.setVisible(true);
        } else {
            this.connectCameraButton.setVisible(true);
            this.disconnectCameraButton.setVisible(false);
            this.cameraInformationPanel.setVisible(false);
        }
        this.repaint();
    }

    public void showEntry() {
        Camera camera = HardwareRegistry.getInstance().getCamera(this.cameraId);
        this.cameraComboBox.setSelectedItemAndTrigger(Objects.requireNonNullElse(camera, NoneItem));
    }

    public static interface CameraTypeCallback {
        public void onChanged();
    }

    public static class HardwareComboBox
    extends BreezeComboBox {
        public HardwareComboBox() {
            this.setFont(new Font("Tahoma", 0, 16));
            this.setPreferredSize(new Dimension(34, 30));
            BreezeComboBox.ComboBoxListCellRenderer comboBoxListCellRenderer = new BreezeComboBox.ComboBoxListCellRenderer(5){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                    if (component instanceof JLabel) {
                        JLabel jLabel = (JLabel)component;
                        if (object instanceof Hardware) {
                            Hardware hardware = (Hardware)object;
                            jLabel.setIcon(hardware.getIcon());
                            this.setText(hardware.getDisplayName());
                        }
                    }
                    return component;
                }
            };
            this.setMaximumRowCount(20);
            comboBoxListCellRenderer.setIconTextGap(8);
            this.setRenderer(comboBoxListCellRenderer);
        }

        public Camera getSelectedCamera() {
            Object object = this.getSelectedItem();
            if (object instanceof Camera) {
                Camera camera = (Camera)object;
                return camera;
            }
            return null;
        }
    }
}

