/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.hardware;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import lombok.Generated;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeExternalLinkPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTextArea;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class MultiCameraSettingsPanel
extends JPanel {
    private final MultiModeInputField multiModeComboBox;
    private final BreezeTextArea multiModeInfo = new BreezeTextArea(5, false);
    private final BreezeComboBoxInputField<Camera.TransformAlgorithm> multiRealignAlgorithmComboBox = new BreezeComboBoxInputField("Realignment algorithm", "", BreezeInputFieldHelper.Format.TwoRows);
    private final BreezeInputField featureDetectionOptions = new BreezeInputField("Alignment parameters", "", "", BreezeInputFieldHelper.Format.TwoRows);
    private final BreezeCheckBox backupBeforeRealigning = new BreezeCheckBox("Backup the merged image before re-alignment to the measurement's 'backup' sub folder", true);
    private final BreezeCheckBox rotateLeftAfterRealigning = new BreezeCheckBox("Rotate the merged image left (counter clockwise) after merging", false);
    private final Boolean usedFromSettings;
    private Camera.MultiCameraMode multiCameraMode = null;

    public MultiCameraSettingsPanel(BreezeFrame breezeFrame, Boolean bl) {
        super(new GridBagLayout());
        Serializable serializable;
        Object object;
        this.usedFromSettings = bl;
        this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        int n = 1;
        if (this.usedFromSettings.booleanValue()) {
            this.add((Component)new BreezeLabel("Multi-camera settings", false, 14), this.getGridBagConstraints(n++));
            this.add((Component)new BreezeSeparator(), this.getGridBagConstraints(n++));
            object = new BreezeLabel("With more than one camera, you control how data is recorded, and optionally merged.");
            serializable = ((Component)object).getFont();
            ((JComponent)object).setFont(new Font(((Font)serializable).getFontName(), ((Font)serializable).getStyle(), 12));
            this.add((Component)object, this.getGridBagConstraints(n++));
            this.add((Component)new BreezeCheckBox("Disable automatic alignment of camera settings between cameras", BreezeProperties.getInstance().isExpertMode(), BreezeProperties.getInstance()::setExpertMode), this.getGridBagConstraints(n++));
        }
        object = BreezeProperties.getInstance().getMultiCameraSetting();
        this.multiModeComboBox = new MultiModeInputField(breezeFrame, this.usedFromSettings);
        this.multiModeComboBox.getComboBox().setPreferredSize(new Dimension(200, 26));
        this.multiModeComboBox.setSelectedItem(object);
        this.multiModeComboBox.setListener(multiCameraSetting -> {
            Camera.MultiCameraMode multiCameraMode = multiCameraSetting.mode();
            this.updateControls(multiCameraMode);
        });
        serializable = new BreezeExternalLinkPanel(this.multiModeComboBox, "using-multiple-cameras");
        ((JComponent)serializable).setVisible(this.usedFromSettings);
        this.add((Component)serializable, this.getGridBagConstraints(n++));
        this.multiModeInfo.setFontSize(12);
        this.multiModeInfo.setEditable(false);
        this.multiModeInfo.setBorder(BorderFactory.createEmptyBorder());
        this.multiModeInfo.setTextBackground(BreezeTheme.getInstance().getPanelBackground());
        this.add((Component)this.multiModeInfo, this.getGridBagConstraints(n++));
        for (Camera.TransformAlgorithm transformAlgorithm2 : Camera.TransformAlgorithm.getMergeRealignmentAlgorithms()) {
            this.multiRealignAlgorithmComboBox.addItem(transformAlgorithm2);
        }
        Camera.TransformAlgorithm transformAlgorithm3 = BreezeProperties.getInstance().getMultiCameraRealignAlgorithm();
        this.multiRealignAlgorithmComboBox.setSelectedItem(transformAlgorithm3);
        this.multiRealignAlgorithmComboBox.setChangedListener(transformAlgorithm -> {
            Camera.TransformAlgorithm transformAlgorithm2 = this.multiRealignAlgorithmComboBox.getSelectedItem();
            if (this.usedFromSettings.booleanValue()) {
                BreezeProperties.getInstance().setMultiCameraRealignAlgorithm(transformAlgorithm2);
            }
            this.featureDetectionOptions.setVisible(transformAlgorithm2.hasOptions());
            this.updateControls(((Camera.MultiCameraSetting)this.multiModeComboBox.getValue()).mode());
            MultiCameraSettingsPanel.updateAlgorithmOptions(this.featureDetectionOptions, transformAlgorithm2);
        });
        this.add(this.multiRealignAlgorithmComboBox, this.getGridBagConstraints(n++));
        MultiCameraSettingsPanel.updateAlgorithmOptions(this.featureDetectionOptions, transformAlgorithm3);
        this.featureDetectionOptions.addChangeListener(textActionEvent -> {
            if (this.usedFromSettings.booleanValue()) {
                Camera.TransformAlgorithm.setAlgorithmOptions(this.multiRealignAlgorithmComboBox.getSelectedItem(), textActionEvent.getText());
            }
        });
        this.add((Component)this.featureDetectionOptions, this.getGridBagConstraints(n++));
        this.add((Component)this.backupBeforeRealigning, this.getGridBagConstraints(n++));
        this.add((Component)this.rotateLeftAfterRealigning, this.getGridBagConstraints(n++));
        this.backupBeforeRealigning.setSelected(BreezeProperties.getInstance().isMultiCameraBackup());
        if (this.usedFromSettings.booleanValue()) {
            this.backupBeforeRealigning.addActionListener(actionEvent -> BreezeProperties.getInstance().setMultiCameraBackup(this.backupBeforeRealigning.isSelected()));
        }
        this.rotateLeftAfterRealigning.setSelected(!BreezeProperties.getInstance().getMultiCameraRotate().isEmpty());
        if (this.usedFromSettings.booleanValue()) {
            this.rotateLeftAfterRealigning.addActionListener(actionEvent -> BreezeProperties.getInstance().setMultiCameraRotate(this.rotateLeftAfterRealigning.isSelected() ? "Left" : ""));
        }
        this.updateControls(((Camera.MultiCameraSetting)object).mode());
    }

    private GridBagConstraints getGridBagConstraints(int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        return gridBagConstraints;
    }

    private void updateControls(Camera.MultiCameraMode multiCameraMode) {
        Object object = Camera.MultiCameraMode.getDescription(this.multiCameraMode != null ? this.multiCameraMode : multiCameraMode);
        if (multiCameraMode.isScale()) {
            if (this.usedFromSettings.booleanValue()) {
                object = (String)object + " Data is merged in the order the cameras are listed in Settings.";
                object = (String)object + "\n\nAfter Recorder saves a measurement, realignment can be used to attempt to adjust the sub images to co-align. In continuous (Play) mode, data is never aligned, corresponding to the realignment algorithm None.";
            } else {
                object = (String)object + " Data is merged in the order of the first wavelength bands in the images.";
            }
        }
        this.multiModeInfo.setText((String)object);
        this.multiRealignAlgorithmComboBox.setVisible(multiCameraMode.isScale());
        Camera.TransformAlgorithm transformAlgorithm = this.multiRealignAlgorithmComboBox.getSelectedItem();
        this.featureDetectionOptions.setVisible(multiCameraMode.isScale() && transformAlgorithm.hasOptions());
        boolean bl = multiCameraMode.isScale() && transformAlgorithm != Camera.TransformAlgorithm.None;
        this.backupBeforeRealigning.setVisible(bl);
        this.rotateLeftAfterRealigning.setVisible(bl);
    }

    private static void updateAlgorithmOptions(BreezeInputField breezeInputField, Camera.TransformAlgorithm transformAlgorithm) {
        breezeInputField.setText(Camera.TransformAlgorithm.getAlgorithmOptions(transformAlgorithm));
        breezeInputField.setUsage("<html>" + Camera.TransformAlgorithm.getAlgorithmOptionsHelpString(transformAlgorithm) + "</html>");
        breezeInputField.reFormat();
    }

    public void setMultiCameraMode(Camera.MultiCameraMode multiCameraMode) {
        this.multiCameraMode = multiCameraMode;
        Camera.MultiCameraSetting multiCameraSetting = this.multiCameraMode == Camera.MultiCameraMode.ScaleUp ? new Camera.MultiCameraSetting(Camera.MultiCameraMode.ScaleDown, 0) : this.multiCameraMode.toSetting();
        this.multiModeComboBox.setValue(multiCameraSetting);
        this.updateControls(this.multiCameraMode);
    }

    public TcpManager.CommandErrorException realignMergedData(BreezeProgressManager breezeProgressManager, Measurement measurement) {
        try {
            Camera.TransformAlgorithm transformAlgorithm = this.multiRealignAlgorithmComboBox.getValue();
            if (!transformAlgorithm.equals((Object)Camera.TransformAlgorithm.None)) {
                TcpManager.getInstance().transformData(breezeProgressManager, List.of(measurement), transformAlgorithm, this.backupBeforeRealigning.isSelected(), this.featureDetectionOptions.getValue(), this.rotateLeftAfterRealigning.isSelected() ? "Left" : "");
                ThumbnailManager.deleteAndRemoveMeasurementImagesFromCache(List.of(measurement));
            }
        }
        catch (TcpManager.CommandErrorException commandErrorException) {
            return commandErrorException;
        }
        return null;
    }

    public static class MultiModeInputField
    extends BreezeComboBoxInputField<Camera.MultiCameraSetting> {
        private ModeListener listener;

        public MultiModeInputField(BreezeFrame breezeFrame, Boolean bl) {
            super("Multi-camera");
            this.setFormat(BreezeInputFieldHelper.Format.OneRow);
            this.setLabelFontSize(12);
            this.addItem(new Camera.MultiCameraSetting(Camera.MultiCameraMode.ScaleDown, 0));
            this.addItem(new Camera.MultiCameraSetting(Camera.MultiCameraMode.Parallel, 0));
            this.addSeparator();
            for (int i = 0; i < BreezeProperties.getInstance().getNumberOfCameras(); ++i) {
                this.addItem(new Camera.MultiCameraSetting(Camera.MultiCameraMode.Single, i));
            }
            this.addSeparator();
            this.addItem(new Camera.MultiCameraSetting(Camera.MultiCameraMode.SeparateFiles, 0));
            this.setRenderer(new MaintenancePanel.MultiCameraListCellRenderer());
            BreezeComboBox breezeComboBox = this.getComboBox();
            breezeComboBox.setName("recordMode");
            breezeComboBox.setMinimumSize(new Dimension(160, 26));
            breezeComboBox.setPreferredSize(new Dimension(160, 26));
            this.setChangedListener(multiCameraSetting -> {
                if (multiCameraSetting instanceof Camera.MultiCameraSetting) {
                    Camera.MultiCameraSetting multiCameraSetting2 = multiCameraSetting;
                    Camera.MultiCameraMode multiCameraMode = multiCameraSetting2.mode();
                    Camera camera = HardwareRegistry.getInstance().getSecondCamera();
                    if (camera != null && camera.isConnected()) {
                        TcpManager.getInstance().setProperty("MultiCameraMode", multiCameraMode.name());
                    }
                    if (bl.booleanValue()) {
                        BreezeProperties.getInstance().setMultiCameraSetting(multiCameraSetting2);
                    }
                    if (!WorkspaceManager.GUITEST && multiCameraMode.isScale() && Camera.isHySpexOrTest(camera)) {
                        BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.WARNING_OPTION, "Warning - Merge", "While image alignment techniques can merge spectral data cubes, this approach sacrifices spectral fidelity in each pixel.\n\nThese methods rely on automatic timepoint detection for image coregistration, which can especially struggle with non-flat scenes.\n\nTo compensate for misalignment, the process adjusts the spectra, potentially distorting the very data you are trying to capture.\n\nFor high-fidelity spectral information, separate, unmerged cubes are recommended.", null, null);
                    }
                    if (this.listener != null) {
                        this.listener.onChange(multiCameraSetting2);
                    }
                }
            });
        }

        public void selectDefault() {
            this.setSelectedItem(BreezeProperties.getInstance().getMultiCameraSetting());
        }

        @Generated
        public void setListener(ModeListener modeListener) {
            this.listener = modeListener;
        }

        public static interface ModeListener {
            public void onChange(Camera.MultiCameraSetting var1);
        }
    }
}

