/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.hardware;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.hardware.ComPort;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.frontend.main.settings.hardware.CameraPanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.RemoteCamera;

public class StageSettingsPanel
extends AbstractViewPanel {
    private static final String noSampleMover = "No sample mover";
    private final CameraPanel.HardwareComboBox sampleMoverComboBox;
    private final InformationPanel sampleMoverInformationPanel;
    private final JPanel sampleMoverSettingsPanel;
    private final BreezeButton connectMoverButton;
    private final BreezeButton disconnectMoverButton;
    private final BreezeButton refreshMoverButton;
    public boolean initiating;

    public StageSettingsPanel(MaintenancePanel maintenancePanel) {
        super(maintenancePanel);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(BreezeTheme.getInstance().getPanelBackground());
        this.add(new BreezeScrollPane.VerticalOnly(jPanel), "Center");
        this.sampleMoverSettingsPanel = new JPanel();
        this.sampleMoverInformationPanel = new InformationPanel();
        this.sampleMoverComboBox = new CameraPanel.HardwareComboBox();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        jPanel2.add((Component)this.sampleMoverComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.sampleMoverSettingsPanel.setOpaque(false);
        this.sampleMoverSettingsPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 20, 0, 10);
        jPanel.add((Component)this.sampleMoverSettingsPanel, gridBagConstraints);
        this.connectMoverButton = EntryMainHelper.createTextButton("Connect", "connectSampleMover", () -> new ConnectProgressAction.ConnectMover(this.getFrame(), "Connect"){

            @Override
            public void afterConnectionInProgress(BreezeProgress breezeProgress, SampleMover sampleMover) {
                StageSettingsPanel.this.updateSampleMoverPanel(sampleMover);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 20, 0, 0);
        jPanel.add((Component)this.connectMoverButton, gridBagConstraints);
        this.disconnectMoverButton = EntryMainHelper.createTextButton("Disconnect", "disconnectSampleMover", () -> {
            SampleMover sampleMover = (SampleMover)this.sampleMoverComboBox.getSelectedItem();
            sampleMover.disconnect(BreezeProgressManager.createEmpty());
            this.updateSampleMoverPanel(sampleMover);
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        jPanel.add((Component)this.disconnectMoverButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(20, 20, 0, 0);
        jPanel.add((Component)this.sampleMoverInformationPanel, gridBagConstraints);
        this.refreshMoverButton = EntryMainHelper.createTextButton("Refresh", "refreshSampleMover", () -> {
            SampleMover sampleMover = (SampleMover)this.sampleMoverComboBox.getSelectedItem();
            this.reloadHardwareInformation(sampleMover);
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 35, 0, 0);
        jPanel.add((Component)this.refreshMoverButton, gridBagConstraints);
        this.sampleMoverComboBox.addItem(noSampleMover);
        this.sampleMoverComboBox.addSeparator();
        for (SampleMover sampleMover : HardwareRegistry.getInstance().getSampleMoverList()) {
            this.sampleMoverComboBox.addItem(sampleMover);
        }
        this.sampleMoverComboBox.addItemListener(this::sampleMoverComboBoxItemStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 100;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        this.initiating = false;
    }

    private void sampleMoverComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (!this.initiating && itemEvent.getStateChange() == 1) {
            Object object = this.sampleMoverComboBox.getSelectedItem();
            if (object instanceof SampleMover) {
                SampleMover sampleMover = (SampleMover)object;
                HardwareRegistry.getInstance().switchToSampleMover(sampleMover);
                this.updateSampleMoverPanel(sampleMover);
            } else {
                HardwareRegistry.getInstance().switchToSampleMover(null);
                this.updateSampleMoverPanel(null);
            }
        }
    }

    @Override
    public String getType() {
        return "Stage";
    }

    public String toString() {
        if (BreezeProperties.getInstance().isBreezeRuntimeLocalHost()) {
            SampleMover sampleMover = HardwareRegistry.getInstance().getSampleMover();
            return sampleMover != null ? sampleMover.toString() : noSampleMover;
        }
        return "Remote sample mover";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        SampleMover sampleMover = HardwareRegistry.getInstance().getSampleMover();
        if (sampleMover != null) {
            this.sampleMoverComboBox.setSelectedItemAndTrigger(sampleMover);
        } else {
            this.sampleMoverComboBox.setSelectedItemAndTrigger(this.sampleMoverComboBox.getItemAt(0));
        }
        this.setVisible(true);
    }

    private void updateSampleMoverPanel(final SampleMover sampleMover) {
        this.sampleMoverSettingsPanel.removeAll();
        if (this.sampleMoverComboBox.getSelectedItem() instanceof SampleMover && sampleMover instanceof SampleMover.SettingsPanelSampleMover) {
            this.sampleMoverSettingsPanel.add((Component)((SampleMover.SettingsPanelSampleMover)((Object)sampleMover)).getSettingsPanel(this.getFrame(), new Hardware.SettingsPanelCallback(){
                final /* synthetic */ StageSettingsPanel this$0;
                {
                    this.this$0 = stageSettingsPanel;
                }

                @Override
                public void reloadInformation() {
                    this.this$0.reloadHardwareInformation(sampleMover);
                }

                @Override
                public void clearReferenceCache() {
                }

                @Override
                public void setEnabled(boolean bl) {
                    this.this$0.connectMoverButton.setEnabled(bl);
                }

                @Override
                public void reloadSubsequentTabs() {
                }
            }), "Center");
        }
        this.reloadHardwareInformation(sampleMover);
        this.mainpanel.repaintEntryList();
        this.sampleMoverSettingsPanel.revalidate();
        if (sampleMover != null && sampleMover.isConnected()) {
            this.connectMoverButton.setVisible(false);
            this.disconnectMoverButton.setVisible(true);
            this.refreshMoverButton.setVisible(true);
            this.sampleMoverInformationPanel.setVisible(true);
        } else {
            this.connectMoverButton.setVisible(sampleMover != null);
            this.disconnectMoverButton.setVisible(false);
            this.refreshMoverButton.setVisible(false);
            this.sampleMoverInformationPanel.setVisible(false);
        }
        this.repaint();
    }

    private Camera getSelectedCamera() {
        return ((MaintenancePanel)this.mainpanel).getSelectedCamera();
    }

    private void reloadHardwareInformation(SampleMover sampleMover) {
        InformationPanel.InformationList informationList = new InformationPanel.InformationList();
        if (sampleMover != null && sampleMover.isConnected()) {
            ComPort comPort;
            Object object;
            if (sampleMover instanceof RemoteCamera) {
                object = (RemoteCamera)((Object)sampleMover);
                ((RemoteCamera)object).add(informationList);
            }
            if (SampleMover.isTray(sampleMover)) {
                informationList.add("Type", (Object)sampleMover.getType());
            }
            object = sampleMover.minLength();
            if (((LengthValue)object).value != 0.0f) {
                informationList.add("Min length", ((LengthValue)object).toString());
            }
            LengthValue lengthValue = sampleMover.maxLength();
            if (lengthValue.value > 0.0f) {
                informationList.add("Max length", lengthValue.toString());
            }
            informationList.add("Max speed", sampleMover.maxSpeed().toString());
            informationList.add("Travel speed", sampleMover.movementSpeed().toString());
            Camera camera = this.getSelectedCamera();
            String string = sampleMover.getUnit();
            informationList.add("Calculated recording speed", (camera.isConnected() ? Speed.withUnit(camera, string).toString() : "Camera not connected") + " (using the active camera's Frame rate and Field of view)");
            if (SampleMover.isTray(sampleMover)) {
                informationList.add("Current position", RtDataFormat.toString(sampleMover.getPosition()));
            }
            if ((comPort = sampleMover.getComPort()) != null && !comPort.name.isEmpty()) {
                informationList.add("COM port", comPort.name);
            }
            sampleMover.addAddtionalInformation(informationList);
        }
        this.sampleMoverInformationPanel.setInformation(informationList);
        ((MaintenancePanel)this.mainpanel).reloadHardwareSidePanel();
        this.mainpanel.repaintEntryList();
    }
}

