/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.hardware;

import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTabbedPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.frontend.main.settings.focus.HardwareSidePanel;
import se.prediktera.breeze.frontend.main.settings.hardware.CameraMainPanel;
import se.prediktera.breeze.frontend.main.settings.hardware.CameraPanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;

public class TabbedCameraPanel
extends BreezeTabbedPanel {
    private final MaintenancePanel parent;
    private final CameraMainPanel hardwarePanel;
    private final HardwareSidePanel hardwareSidePanel;
    private final ArrayList<CameraPanel> cameraPanels = new ArrayList();
    private boolean initiatingTabs;

    public TabbedCameraPanel(MaintenancePanel maintenancePanel, CameraMainPanel cameraMainPanel, HardwareSidePanel hardwareSidePanel) {
        this.parent = maintenancePanel;
        this.hardwarePanel = cameraMainPanel;
        this.hardwareSidePanel = hardwareSidePanel;
        this.setName("cameraTabs");
        this.setTabPlacement(1);
        this.rebuildTabs(false);
    }

    private Component createTabHeader(String string, Component component, boolean bl) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 3, 0));
        jPanel.setOpaque(false);
        BreezeLabel breezeLabel = new BreezeLabel(string, false, 14);
        BreezeButton breezeButton = EntryMainHelper.createButton("", "close", () -> {
            int n = this.indexOfComponent(component);
            if (n != -1) {
                BreezeProperties.getInstance().setNumberOfCameras(BreezeProperties.getInstance().getNumberOfCameras() - 1);
                HardwareRegistry.getInstance().updateCamerasAvailable();
                this.rebuildTabs(true);
            }
        });
        breezeButton.setVisible(bl);
        jPanel.add(breezeLabel);
        jPanel.add(breezeButton);
        return jPanel;
    }

    private void rebuildTabs(boolean bl) {
        int n;
        this.initiatingTabs = true;
        this.hardwarePanel.initiating = true;
        this.removeAll();
        this.cameraPanels.clear();
        this.hardwareSidePanel.updateAll();
        int n2 = BreezeProperties.getInstance().getNumberOfCameras();
        for (n = 0; n < n2; ++n) {
            int n3 = n;
            CameraPanel cameraPanel = new CameraPanel(this.parent, this.hardwarePanel, n, this.hardwareSidePanel, () -> {
                if (!this.initiatingTabs) {
                    for (int i = n3 + 1; i < n2; ++i) {
                        this.cameraPanels.get(i).updateCameraPanel();
                    }
                }
            });
            cameraPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            String string = StringHelper.formatLabel(StringHelper.numberToOrdinal(n)) + " camera";
            this.addTabToEnd(string, new BreezeScrollPane.VerticalOnly(cameraPanel), n2);
            this.cameraPanels.add(cameraPanel);
        }
        if (bl) {
            this.parent.getSelectedCameraInputField().removeAllItems();
            for (n = 0; n < n2; ++n) {
                this.parent.getSelectedCameraInputField().addItem(StringHelper.formatLabel(StringHelper.numberToOrdinal(n)));
            }
        }
        if (n2 < HardwareRegistry.MaxSupportedCameras) {
            this.initAddMoreTab();
        }
        this.hardwarePanel.initiating = false;
        this.showEntry();
        this.initiatingTabs = false;
    }

    private void initAddMoreTab() {
        if (this.getTabCount() > 0 && this.getTitleAt(this.getLastTabIndex()).isEmpty()) {
            this.removeTabAt(this.getLastTabIndex());
        }
        this.addTab("", null);
        this.setToolTipTextAt(this.getLastTabIndex(), "Add additional camera");
        this.setEnabledAt(this.getLastTabIndex(), false);
        BreezeButton breezeButton = EntryMainHelper.createButton("addTab", "", "add", () -> {
            BreezeProperties.getInstance().setNumberOfCameras(BreezeProperties.getInstance().getNumberOfCameras() + 1);
            HardwareRegistry.getInstance().updateCamerasAvailable();
            this.rebuildTabs(true);
            boolean bl = BreezeProperties.getInstance().getNumberOfCameras() == HardwareRegistry.MaxSupportedCameras;
            this.setSelectedIndex(this.getTabCount() - (bl ? 1 : 2));
        });
        breezeButton.setToolTipText("Add additional camera");
        this.setTabComponentAt(this.getLastTabIndex(), breezeButton);
    }

    public void addTabToEnd(String string, Component component, int n) {
        super.addTab(string, component);
        int n2 = this.getTabCount();
        int n3 = this.getLastTabIndex();
        this.setTabComponentAt(n3, this.createTabHeader(string, component, n2 > 1 && n2 == n));
        Camera camera = HardwareRegistry.getInstance().getCamera(n3);
        if (camera instanceof Camera) {
            Camera camera2 = camera;
            this.setToolTipTextAt(n3, camera2.getDisplayName());
        }
    }

    public void showEntry() {
        for (CameraPanel cameraPanel : this.cameraPanels) {
            cameraPanel.showEntry();
        }
    }

    public void reloadInformation() {
        for (CameraPanel cameraPanel : this.cameraPanels) {
            cameraPanel.reloadInformation();
        }
    }
}

