/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.help;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.LinkLabel;

public class HelpPanel
extends AbstractViewPanel {
    public static LinkLabel createLink(String string, String string2, String string3) {
        LinkLabel linkLabel = new LinkLabel(string);
        linkLabel.setForeground(BreezeTheme.getInstance().getLinkForeground());
        linkLabel.setIcon((Icon)HelpPanel.getResource("/images/material/" + string2 + ".png"));
        linkLabel.setFont(new Font("Tahoma", 0, 16));
        linkLabel.setLinkLocation(string3);
        return linkLabel;
    }

    public static void openMailClient(String string, String string2, String string3) {
        if (Desktop.isDesktopSupported()) {
            try {
                String string4 = String.format("mailto:%s?subject=%s&body=%s", URLEncoder.encode(string, StandardCharsets.UTF_8), URLEncoder.encode(string2, StandardCharsets.UTF_8).replace("+", "%20"), URLEncoder.encode(string3, StandardCharsets.UTF_8).replace("+", "%20"));
                Desktop.getDesktop().mail(new URI(string4));
            }
            catch (Exception exception) {
                Logg.debug((String)"Cannot open mail client", (Object[])new Object[]{exception});
                throw new ErrorHandler.MessageException("Cannot open mail client", "Error opening mail client");
            }
        } else {
            Logg.info((String)"Desktop is not supported", (Object[])new Object[0]);
        }
    }

    private static ImageIcon getResource(String string) {
        ImageIcon imageIcon = new ImageIcon(HelpPanel.class.getResource(string));
        if (BreezeTheme.getInstance().isDarkMode()) {
            imageIcon = ImageHelper.changeGrayBrightnessDarkTheme(imageIcon);
        }
        return imageIcon;
    }

    @Override
    protected void setComponentChild(JComponent jComponent, Color color, boolean bl) {
    }

    @Override
    public String getType() {
        return "Help";
    }

    @Override
    public void showEntry(Object object, Object object2) {
    }

    public String toString() {
        return "";
    }
}

