/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.integration;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import se.prediktera.breeze.backend.grabber.CameraStreamAddOn;
import se.prediktera.breeze.backend.grabber.CameraStreamGrabber;
import se.prediktera.breeze.common.frame.DrReMatrix;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeDescriptionButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeSlider;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.frontend.main.settings.focus.HardwareSidePanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.samplemover.umbioinspector.UmbioInspector;
import se.prediktera.map.plot.spectral.DataWrapper;
import se.prediktera.map.plot.spectral.SpectralPlot;

public class IntegrationPanel
extends AbstractViewPanel
implements MaintenancePanel.ConnectCallback {
    private IntegrationTimePlot integrationLinePlot = new IntegrationTimePlot(this);
    private final CameraStreamGrabber grabber = new CameraStreamGrabber();
    public static final Color green = Color.green.darker();
    public static final Color yellow = Color.yellow.darker();
    public static final Color red = Color.red.darker();
    private final BreezeDescriptionButton captureButton;
    private final BreezeDescriptionButton extendReferenceButton;
    private final JLabel integrationRateValueLabel;
    private final BreezeSlider positionSlider;
    private final JLabel positionValueLabel;
    private final PreProcessingComboBoxInputField preProcessingComboBoxInputField;
    private final JPanel resultPanel;
    private final BreezeCheckBox showMinMaxCheckBox;
    private final HardwareSidePanel hardwareSidePanel;
    private static boolean minMaxSelected = true;

    public IntegrationPanel(MaintenancePanel maintenancePanel) {
        super(maintenancePanel);
        this.hardwareSidePanel = maintenancePanel.getHardwareSidePanel();
        this.hardwareSidePanel.setType(HardwareSidePanel.HardwareType.IntegrationTime);
        JPanel jPanel = new JPanel();
        this.extendReferenceButton = new BreezeDescriptionButton();
        this.resultPanel = new JPanel();
        this.integrationRateValueLabel = new JLabel();
        JLabel jLabel = new JLabel();
        this.captureButton = new BreezeDescriptionButton();
        JPanel jPanel2 = new JPanel();
        this.showMinMaxCheckBox = new BreezeCheckBox();
        this.preProcessingComboBoxInputField = new PreProcessingComboBoxInputField();
        JPanel jPanel3 = new JPanel();
        this.positionSlider = new BreezeSlider();
        JLabel jLabel2 = new JLabel();
        this.positionValueLabel = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        jPanel.setBackground(new Color(255, 255, 255));
        jPanel.setLayout(new GridBagLayout());
        this.extendReferenceButton.setDescForeground(new Color(51, 51, 51));
        this.extendReferenceButton.setDescription("Reference");
        this.extendReferenceButton.setName("integrationReference");
        this.extendReferenceButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                IntegrationPanel.this.extendReferenceButtonMouseClicked();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        jPanel.add((Component)this.extendReferenceButton, gridBagConstraints);
        this.resultPanel.setBackground(new Color(102, 102, 102));
        this.resultPanel.setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForegroundLittleMoreDifuse(), 2));
        this.resultPanel.setMinimumSize(new Dimension(100, 80));
        this.resultPanel.setPreferredSize(new Dimension(100, 80));
        this.resultPanel.setLayout(new GridBagLayout());
        this.integrationRateValueLabel.setBackground(new Color(102, 102, 102));
        this.integrationRateValueLabel.setFont(new Font("Tahoma", 0, 20));
        this.integrationRateValueLabel.setForeground(new Color(255, 255, 255));
        this.integrationRateValueLabel.setHorizontalAlignment(0);
        this.integrationRateValueLabel.setText("0%");
        this.integrationRateValueLabel.setVerticalAlignment(3);
        this.integrationRateValueLabel.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.resultPanel.add((Component)this.integrationRateValueLabel, gridBagConstraints);
        jLabel.setForeground(new Color(255, 255, 255));
        jLabel.setText("Intensity");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.resultPanel.add((Component)jLabel, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("i18n/Language_ENG");
        jLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("Integration Rate"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.resultPanel, gridBagConstraints);
        this.captureButton.setDescription("Camera");
        this.captureButton.setName("integrationCamera");
        this.captureButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                IntegrationPanel.this.captureButtonMouseClicked();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        jPanel.add((Component)this.captureButton, gridBagConstraints);
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        jPanel.add((Component)this.preProcessingComboBoxInputField, gridBagConstraints);
        this.showMinMaxCheckBox.setText("Min and max pixels");
        this.showMinMaxCheckBox.setName("showlineplot");
        this.showMinMaxCheckBox.setToolTipText("Display the pixels with the smallest and largest intensities");
        this.showMinMaxCheckBox.addCallback(bl -> {
            minMaxSelected = bl;
            this.integrationLinePlot.showMinMax(minMaxSelected);
        });
        this.showMinMaxCheckBox.setSelected(minMaxSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 0, 40, 0);
        jPanel.add((Component)this.showMinMaxCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.add(jPanel, gridBagConstraints);
        jPanel3.setBackground(new Color(255, 255, 255));
        jPanel3.setLayout(new GridBagLayout());
        this.positionSlider.setName("integrationSlider");
        this.positionSlider.addChangeListener(this::positionSliderStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        jPanel3.add((Component)this.positionSlider, gridBagConstraints);
        jLabel2.setFont(new Font("Tahoma", 0, 14));
        jLabel2.setText("Spatial pixel position:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 20, 0, 0);
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        jLabel2.getAccessibleContext().setAccessibleName(resourceBundle.getString("Position:"));
        this.positionValueLabel.setFont(new Font("Tahoma", 0, 14));
        this.positionValueLabel.setText("100 (320)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        jPanel3.add((Component)this.positionValueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add(jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 20);
        this.add((Component)((Object)this.integrationLinePlot), gridBagConstraints);
        this.grabber.addOn(new IntegrationRealTimeClass());
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        jPanel.setBackground(breezeTheme.getPanelBackground());
        jLabel2.setForeground(breezeTheme.getLabelForeground());
        this.positionValueLabel.setForeground(breezeTheme.getLabelForeground());
        jPanel3.setOpaque(false);
        this.showMinMaxCheckBox.setForeground(breezeTheme.getLabelForeground());
        this.extendReferenceButton.setBackground(this.mainpanel.getPageColor());
        this.captureButton.setBackground(this.mainpanel.getPageColor());
        this.resultPanel.setBackground(new Color(102, 102, 102));
    }

    @Override
    public boolean showRightSettingsPanel() {
        return BreezeProperties.getInstance().isShowHardwareSettings();
    }

    @Override
    public String getType() {
        return "IntegrationTime";
    }

    @Override
    public WizardStep.LeaveResult leaveEntry(WizardStep.LeaveControlCallback leaveControlCallback) {
        ((MaintenancePanel)this.mainpanel).leavePanel(this.grabber);
        this.reset();
        return WizardStep.LeaveResult.Ok;
    }

    private void reset() {
        this.integrationRateValueLabel.setText("0%");
        this.resultPanel.setBackground(new Color(102, 102, 102));
    }

    @Override
    public void showEntry(Object object, Object object2) {
        ((MaintenancePanel)this.mainpanel).enterPanel(this.captureButton, this.grabber, this);
        this.updateReferencePlot();
        this.updateFromSampleMover(HardwareRegistry.getInstance().getSampleMover());
        this.reset();
    }

    @Override
    public void updateFromCamera(Camera camera, boolean bl) {
        boolean bl2 = Camera.connected(camera);
        this.positionSlider.setEnabled(bl2);
        this.positionSlider.setMaximum(bl2 ? camera.getWidth().value - 1 : 0);
        this.positionSlider.setValue(bl2 ? (int)Math.ceil((double)camera.getWidth().value / 2.0) - 1 : 0);
        this.positionSliderStateChanged(null);
        this.preProcessingComboBoxInputField.init(camera);
        this.showMinMaxCheckBox.setEnabled(bl2);
        this.hardwareSidePanel.setCameras();
    }

    @Override
    public void afterConnection(Camera camera) {
        if (camera instanceof StateCamera && ((StateCamera)camera).hasWhiteReference()) {
            ((StateCamera)camera).changeStateToWhiteReference();
        }
        this.integrationLinePlot.setCamera(camera);
    }

    private void updateFromSampleMover(SampleMover sampleMover) {
        if (sampleMover == null) {
            this.extendReferenceButton.setVisible(false);
        } else {
            this.extendReferenceButton.setVisible(true);
            this.extendReferenceButton.setToggled(sampleMover.inWhiteRefState(this.getSelectedCamera()));
            this.extendReferenceButton.setDescription(sampleMover instanceof UmbioInspector ? "Reference" : "Move to white reference");
        }
        this.hardwareSidePanel.setSampleMover(sampleMover);
    }

    private Camera getSelectedCamera() {
        return ((MaintenancePanel)this.mainpanel).getSelectedCamera();
    }

    public String toString() {
        Camera camera = this.getSelectedCamera();
        if (Camera.connected(camera)) {
            return camera.getIntegrationTime().toString();
        }
        return "Camera not connected";
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.integrationLinePlot != null) {
            this.integrationLinePlot.cleanUp();
            this.integrationLinePlot = null;
        }
        if (this.grabber.isRunning()) {
            this.grabber.stop();
        }
    }

    private void captureButtonMouseClicked() {
        this.captureButton.requestFocus();
        ((MaintenancePanel)this.mainpanel).toggleCamera(this.captureButton, this.grabber, this);
    }

    private void extendReferenceButtonMouseClicked() {
        this.extendReferenceButton.requestFocus();
        new ConnectProgressAction.ConnectMover(this.getFrame(), "White reference"){

            @Override
            public void afterConnectionInProgress(BreezeProgress breezeProgress, SampleMover sampleMover) {
                Camera camera = IntegrationPanel.this.getSelectedCamera();
                if (sampleMover.inWhiteRefState(camera)) {
                    breezeProgress.setInfoText("Moving out of white reference");
                    sampleMover.exitWhiteRefState();
                    sampleMover.moveToReturnPosition(camera);
                } else {
                    breezeProgress.setInfoText("Moving to white reference");
                    sampleMover.enterWhiteRefState(((MaintenancePanel)IntegrationPanel.this.mainpanel).getSelectedCamera());
                }
                IntegrationPanel.this.updateFromSampleMover(sampleMover);
            }
        };
    }

    private void positionSliderStateChanged(ChangeEvent changeEvent) {
        if (this.positionSlider.getMaximum() == 0) {
            this.positionValueLabel.setText("N/A");
        } else {
            this.positionValueLabel.setText(this.getCurrentLine() + 1 + " (" + (this.positionSlider.getMaximum() + 1) + ")");
        }
    }

    private int getCurrentLine() {
        return this.positionSlider.getValue();
    }

    public void updateReferencePlot() {
        Camera camera = this.getSelectedCamera();
        if (this.integrationLinePlot != null && camera.isConnected()) {
            float f = this.integrationLinePlot.getMaxValue();
            float f2 = f / camera.getMaxsignal().value * 100.0f;
            this.integrationRateValueLabel.setText((int)f2 + "%");
            if (f2 < 91.0f && f2 > 80.0f) {
                this.resultPanel.setBackground(green);
            } else if (f2 < 95.0f && f2 > 70.0f) {
                this.resultPanel.setBackground(yellow);
            } else {
                this.resultPanel.setBackground(red);
            }
        }
    }

    public static class IntegrationTimePlot
    extends SpectralPlot {
        private final AbstractViewPanel panel;
        private final Stroke stroke = new BasicStroke(2.0f, 1, 0, 10.0f);
        public final DataWrapper averageWrapper = new DataWrapper("Average");
        public final DataWrapper minWrapper = new DataWrapper("Min");
        public final DataWrapper maxWrapper = new DataWrapper("Max");
        private boolean showPixels;
        private int dataWidth;
        private float maxSignal;
        private float maxSignal99;
        private float[][] darkMatrix;
        private float[][] reMatrixInversed;

        public IntegrationTimePlot(AbstractViewPanel abstractViewPanel) {
            this.panel = abstractViewPanel;
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            this.setBackground(breezeTheme.getPanelBackground());
            this.setForeground(breezeTheme.getLabelForeground());
            this.setGridColor(breezeTheme.getPlotGridColor());
            this.setZeroLine(false);
            this.sx = 60;
            this.sy = 0;
            this.setXdesc("Wavelength");
            List list = this.getPointWrapperList();
            this.averageWrapper.setColor(Color.red);
            this.averageWrapper.setStroke(this.stroke);
            list.add(this.averageWrapper);
            this.minWrapper.setColor(BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
            this.minWrapper.setStroke(this.stroke);
            list.add(this.minWrapper);
            this.maxWrapper.setColor(BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
            this.maxWrapper.setStroke(this.stroke);
            list.add(this.maxWrapper);
            this.showMinMax(false);
            this.setNoValueFont(new Font("Dialog", 0, 18));
        }

        public void showMinMax(boolean bl) {
            this.minWrapper.setShowLine(bl);
            this.maxWrapper.setShowLine(bl);
            if (bl) {
                this.setYdesc("Intensity at Min pixel, selected position, Max pixel");
            } else {
                this.setYdesc("Intensity at selected position");
            }
            this.contentPaint();
        }

        public void setData(Frame frame, int n, int n2) {
            int n3 = Math.max(0, n);
            for (int i = 0; i < this.dataWidth; ++i) {
                float f = this.getCorrectedValue(frame, i, n3, n2, this.showPixels);
                this.averageWrapper.setYvalueAt(i, f);
                float f2 = 0.0f;
                float f3 = 0.0f;
                for (int j = 0; j < frame.getColumns().value; ++j) {
                    float f4 = this.getCorrectedValue(frame, i, j, n2, this.showPixels);
                    if (j == 0) {
                        f2 = f3 = f4;
                        continue;
                    }
                    f2 = Math.min(f2, f4);
                    f3 = Math.max(f3, f4);
                }
                this.minWrapper.setYvalueAt(i, f2);
                this.maxWrapper.setYvalueAt(i, f3);
            }
            this.contentPaint();
        }

        private float getCorrectedValue(Frame frame, int n, int n2, int n3, boolean bl) {
            float f;
            if (bl) {
                int n4 = n / this.dataWidth;
                int n5 = n % this.dataWidth;
                try {
                    f = frame.getFrameValue(n4, n5);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            } else {
                f = frame.getFrameValue(n, n2);
            }
            if (f >= this.maxSignal99) {
                return this.maxSignal;
            }
            if (n3 > 0) {
                f -= this.darkMatrix[n][n2];
                if (n3 > 1) {
                    f *= this.reMatrixInversed[n][n2];
                }
            }
            return f;
        }

        public void cleanUp() {
        }

        public float getMaxValue() {
            float f = 0.0f;
            for (int i = 0; i < this.maxWrapper.getSize(); ++i) {
                float f2 = this.maxWrapper.getYvalueAt(i);
                if (!(f2 > f)) continue;
                f = f2;
            }
            return f;
        }

        public void setCamera(Camera camera) {
            DrReMatrix drReMatrix = camera.getDrReMatrix();
            this.darkMatrix = drReMatrix.getDarkMatrix();
            this.reMatrixInversed = drReMatrix.getReMatrixInversed();
            this.showPixels = Camera.isXray(camera);
            BandNames bandNames = camera.getBandNames();
            for (DataWrapper dataWrapper : this.getPointWrapperList()) {
                dataWrapper.clearData();
            }
            this.maxSignal = camera.getMaxsignal().value;
            this.maxSignal99 = this.maxSignal * 0.99f;
            if (this.showPixels) {
                this.dataWidth = camera.getWidth().value;
                String[] stringArray = new String[this.dataWidth];
                for (int i = 0; i < this.dataWidth; ++i) {
                    int n = i / this.dataWidth;
                    int n2 = i % this.dataWidth;
                    stringArray[i] = bandNames.get(n) + ":" + n2;
                }
                this.setValues(stringArray);
            } else {
                this.dataWidth = bandNames.size();
                if (bandNames.isNumber()) {
                    for (DataWrapper dataWrapper : this.getPointWrapperList()) {
                        dataWrapper.setDataX(bandNames.toFloatArray());
                    }
                    this.setValues(null);
                } else {
                    this.setValues(bandNames.toArray());
                }
            }
            for (DataWrapper dataWrapper : this.getPointWrapperList()) {
                dataWrapper.setDataY(new float[this.dataWidth]);
            }
            this.setYmax((double)this.maxSignal * 1.05);
            this.setMinMax();
            this.contentPaint();
        }

        protected String getNoSpectraDesc() {
            return "Turn on the Camera switch to start capturing image data";
        }

        protected void createPopupMenu(MouseEvent mouseEvent) {
            BreezeFrame breezeFrame = this.panel.getFrame();
            BreezeContextMenu breezeContextMenu = new BreezeContextMenu(breezeFrame, Color.red);
            breezeContextMenu.addButtonCloseClick("Copy as image to clipboard", () -> ((IntegrationTimePlot)this).copyToClipboard());
            breezeContextMenu.addSeparator();
            breezeContextMenu.addButtonCloseClick("Reset zoom", () -> ((IntegrationTimePlot)this).zoomAll());
            if (breezeContextMenu.resize()) {
                breezeFrame.addPage((JPanel)((Object)breezeContextMenu));
                breezeContextMenu.setPositionLater(mouseEvent);
            }
        }
    }

    public static class PreProcessingComboBoxInputField
    extends BreezeComboBoxInputField<String> {
        public PreProcessingComboBoxInputField() {
            this.setDescription("Pre-processing");
            this.setFormat(BreezeInputFieldHelper.Format.TwoRows);
        }

        public void init(Camera camera) {
            if (camera.isConnected()) {
                if (this.getItemCount() == 0) {
                    this.addItem("Raw");
                    if (camera.useReferencesWhenRecordingWithThisCamera()) {
                        this.addItem("Raw - DR");
                        if (camera.getDrReMatrix() != null) {
                            this.addItem("(Raw - DR) / RE");
                        }
                    }
                }
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
                this.removeAllItems();
            }
        }
    }

    private class IntegrationRealTimeClass
    implements CameraStreamAddOn {
        private long lastupdatetime = 0L;

        private IntegrationRealTimeClass() {
        }

        @Override
        public void apply(FrameStack frameStack) {
            if (System.currentTimeMillis() > this.lastupdatetime + 200L) {
                int n = IntegrationPanel.this.preProcessingComboBoxInputField.getSelectedIndex();
                IntegrationPanel.this.integrationLinePlot.setData(frameStack.getFrame(), IntegrationPanel.this.getCurrentLine(), n);
                IntegrationPanel.this.updateReferencePlot();
                this.lastupdatetime = System.currentTimeMillis();
            }
        }

        @Override
        public void stop() {
        }

        @Override
        public void init(Camera camera, FrameCount frameCount) {
        }
    }
}

