/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.measurement;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinner;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;

public class BreezeTimeSpinner
extends JPanel {
    private final LabelTimeSpinner hourSpinner;
    private final LabelTimeSpinner minSpinner;
    private final LabelTimeSpinner secSpinner;
    private boolean settingValue = false;
    private final TimeChangedCallback callback;

    public BreezeTimeSpinner(TimeChangedCallback timeChangedCallback) {
        super(new GridBagLayout());
        this.callback = timeChangedCallback;
        this.setOpaque(false);
        ChangeListener changeListener = changeEvent -> {
            if (!this.settingValue) {
                timeChangedCallback.changed(this.getValue());
            }
        };
        this.hourSpinner = new LabelTimeSpinner("Hour", 100000, changeListener);
        this.add((Component)this.hourSpinner, GridBagHelper.create(0, 0, new Insets(0, 0, 0, 0)));
        this.minSpinner = new LabelTimeSpinner("Min", 60, changeListener);
        this.add((Component)this.minSpinner, GridBagHelper.create(1, 0, new Insets(0, 12, 0, 0)));
        this.secSpinner = new LabelTimeSpinner("Sec", 60, changeListener);
        this.add((Component)this.secSpinner, GridBagHelper.create(2, 0, new Insets(0, 12, 0, 0)));
    }

    public void setValueAndTrigger(Time time) {
        this.setValue(time);
        this.callback.changed(this.getValue());
    }

    public void setHourLabelWidth(int n) {
        this.hourSpinner.setLabelWidth(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Time time) {
        this.settingValue = true;
        try {
            this.secSpinner.setValue(0.0);
            this.minSpinner.setValue(0.0);
            this.hourSpinner.setValue(0.0);
            int n = (int)(time.ms / 1000L);
            if (n < 60) {
                this.secSpinner.setValue(n);
            } else {
                int n2 = n / 60;
                if (n2 < 60) {
                    this.secSpinner.setValue(n % 60);
                    this.minSpinner.setValue(n2);
                } else {
                    int n3 = n2 / 60;
                    this.hourSpinner.setValue(n3);
                    int n4 = n - n3 * 3600;
                    int n5 = n4 / 60;
                    this.secSpinner.setValue(n4 % 60);
                    this.minSpinner.setValue(n5);
                }
            }
        }
        finally {
            this.settingValue = false;
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.hourSpinner.setEnabled(bl);
        this.minSpinner.setEnabled(bl);
        this.secSpinner.setEnabled(bl);
    }

    public Time getValue() {
        return new Time.Seconds((double)(this.hourSpinner.getValue() * 3600 + this.minSpinner.getValue() * 60 + this.secSpinner.getValue()));
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setTitle("Breeze Time Spinner");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(400, 100);
        BreezeTimeSpinner breezeTimeSpinner = new BreezeTimeSpinner(System.out::println);
        breezeTimeSpinner.setValue(new Time.Seconds(3661.0));
        breezeTimeSpinner.setEnabled(true);
        jFrame.getContentPane().add((Component)breezeTimeSpinner, "Center");
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public static interface TimeChangedCallback {
        public void changed(Time var1);
    }

    private static class LabelTimeSpinner
    extends JPanel {
        private final SpinnerNumberModel spinnerNumberModel;
        private final BreezeSpinner spinner;
        private final BreezeLabel label;

        public LabelTimeSpinner(String string, int n, ChangeListener changeListener) {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.label = new BreezeLabel(string, false, 14);
            this.add((Component)this.label, GridBagHelper.create(0, 0, new Insets(0, 0, 0, 0)));
            this.spinnerNumberModel = new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), Double.valueOf(n), (Number)1.0);
            this.spinner = new BreezeSpinner(this.spinnerNumberModel);
            this.add((Component)this.spinner, GridBagHelper.create(1, 0, new Insets(0, 10, 0, 0)));
            this.spinner.addChangeListener(changeListener);
        }

        public void setValue(double d) {
            this.spinnerNumberModel.setValue(d);
        }

        public int getValue() {
            return ((Number)this.spinnerNumberModel.getValue()).intValue();
        }

        public void setLabelWidth(int n) {
            this.label.setPreferredSize(new Dimension(n, this.label.getPreferredSize().height));
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.label.setEnabled(bl);
            this.spinner.setEnabled(bl);
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            if (!bl) {
                this.spinner.setBackground(breezeTheme.getLabelForegroundMoreDifuse());
            } else {
                this.spinner.setBackground(breezeTheme.getLabelForeground());
            }
        }
    }
}

