/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.measurement;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeRadioButton;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.hardware.Camera;

public class ClearReferenceCustomPanel
extends AbstractBreezeCustomPanel {
    private ClearType clearType = ClearType.Both;

    public ClearReferenceCustomPanel(Camera camera) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        BreezeLabel breezeLabel = new BreezeLabel("Select references to clear");
        this.add((Component)breezeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        ButtonGroup buttonGroup = new ButtonGroup();
        BreezeRadioButton breezeRadioButton2 = new BreezeRadioButton("Clear dark references", buttonGroup, false, (breezeRadioButton, bl) -> {
            this.clearType = ClearType.Dark;
        });
        this.add((Component)breezeRadioButton2, gridBagConstraints);
        BreezeRadioButton breezeRadioButton3 = new BreezeRadioButton("Clear white references", buttonGroup, false, (breezeRadioButton, bl) -> {
            this.clearType = ClearType.White;
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)breezeRadioButton3, gridBagConstraints);
        BreezeRadioButton breezeRadioButton4 = new BreezeRadioButton("Clear both dark and white references", buttonGroup, true, (breezeRadioButton, bl) -> {
            this.clearType = ClearType.Both;
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.add((Component)breezeRadioButton4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)new BreezeInfoPanel(BreezeInfoPanel.InfoType.Warning, "This will remove stored references for all integration times for the active camera.", false), "Center");
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        BreezeLabel breezeLabel2 = new BreezeLabel(" " + Camera.getCameraTypeName(camera), true, 16);
        breezeLabel2.setResourceIcon("material/videocam");
        this.add((Component)breezeLabel2, gridBagConstraints);
    }

    @Override
    public Object getResult() {
        return this.clearType;
    }

    @Override
    public void customButton(BreezeButton breezeButton, BreezeButton breezeButton2, BreezeButton breezeButton3) {
        breezeButton2.setText("Clear");
    }

    public static enum ClearType {
        Dark,
        White,
        Both;

    }
}

