/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.measurement;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.apache.commons.lang3.SystemUtils;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeExternalLinkPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinnerInputPanel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.hardware.Camera;

public class GeneralSettingsPanel
extends JPanel {
    public GeneralSettingsPanel(MaintenancePanel maintenancePanel) {
        super(new GridBagLayout());
        this.setOpaque(false);
        BreezeComboBoxInputField<Camera.FpsUnit> breezeComboBoxInputField = new BreezeComboBoxInputField<Camera.FpsUnit>("Camera frame rate unit", Arrays.asList(Camera.FpsUnit.values()), BreezeProperties.getInstance().getFrameRateDisplayUnit(), fpsUnit -> BreezeProperties.getInstance().setFrameRateDisplayMode((Camera.FpsUnit)((Object)fpsUnit)), BreezeInputFieldHelper.Format.OneRow);
        breezeComboBoxInputField.setRenderer(new BreezeComboBox.FormatStringCellRenderer());
        int n = SystemUtils.IS_OS_WINDOWS ? 350 : 380;
        breezeComboBoxInputField.setLabelWidth(n);
        breezeComboBoxInputField.setValueWidth(200);
        breezeComboBoxInputField.setUsage("Used in camera control panels");
        breezeComboBoxInputField.reformat();
        this.add(breezeComboBoxInputField, this.create(this.getComponentCount()));
        BreezeInputField breezeInputField = new BreezeInputField("Core box measurement name template", BreezeProperties.getInstance().getNameTemplate(), "", textActionEvent -> BreezeProperties.getInstance().setNameTemplate(textActionEvent.getText()), BreezeInputFieldHelper.Format.OneRow);
        breezeInputField.setLabelWidth(n);
        breezeInputField.setValueWidth(200);
        this.add((Component)new BreezeExternalLinkPanel(breezeInputField, "measurement-name-template"), this.create(this.getComponentCount()));
        BreezeSpinnerInputPanel breezeSpinnerInputPanel = new BreezeSpinnerInputPanel("Minimum number of bands for histogram smoothing", "", 0.0f, 25000.0f, 1.0f, BreezeProperties.getInstance().getMinBandsCountForHistogram(), "", d -> BreezeProperties.getInstance().setMinBandsCountForHistogram(d.intValue()));
        breezeSpinnerInputPanel.setFormat(BreezeInputFieldHelper.Format.OneRow);
        breezeSpinnerInputPanel.setLabelWidth(n);
        breezeSpinnerInputPanel.setValueWidth(200);
        this.add((Component)new BreezeExternalLinkPanel(breezeSpinnerInputPanel, "histogram-smoothing"), this.create(this.getComponentCount()));
        BreezeSpinnerInputPanel breezeSpinnerInputPanel2 = new BreezeSpinnerInputPanel("Spectral wavelength matching tolerance (nm)", "", 0.0f, 1.0E9f, 1.0f, (float)BreezeProperties.getInstance().getWavelengthMatchingTolerance(), "", d -> BreezeProperties.getInstance().setWavelengthMatchingTolerance((double)d));
        breezeSpinnerInputPanel2.setFormat(BreezeInputFieldHelper.Format.OneRow);
        breezeSpinnerInputPanel2.setLabelWidth(n);
        breezeSpinnerInputPanel2.setValueWidth(200);
        this.add((Component)new BreezeExternalLinkPanel(breezeSpinnerInputPanel2, "wavelength-matching"), this.create(this.getComponentCount()));
        BreezeInputField breezeInputField2 = new BreezeInputField("Default display name for unclassified data", BreezeProperties.getInstance().getDefaultNonClassifiedValue(), "", textActionEvent -> BreezeProperties.getInstance().setDefaultNonClassifiedValue(textActionEvent.getText()), BreezeInputFieldHelper.Format.OneRow);
        breezeInputField2.setMinlength(1);
        breezeInputField2.setDefaultValue("-");
        breezeInputField2.setLabelWidth(n);
        breezeInputField2.setValueWidth(200);
        this.add((Component)breezeInputField2, this.create(this.getComponentCount()));
        this.add((Component)new JLabel(""), GridBagHelper.createLast(this.getComponentCount(), new Insets(0, 0, 0, 0)));
    }

    private GridBagConstraints create(int n) {
        GridBagConstraints gridBagConstraints = GridBagHelper.create(n, new Insets(n > 0 ? 12 : 0, 0, 0, 0));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        return gridBagConstraints;
    }

    public static class UnitCellRenderer
    extends BreezeComboBox.ComboBoxListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent(jList, (Object)((SpatialDescriptor.SiUnit)((Object)object)).getDescription(), n, bl, bl2);
        }
    }

    public static class UnitComoBoxInputField
    extends BreezeComboBoxInputField<SpatialDescriptor.SiUnit> {
        public UnitComoBoxInputField(SpatialDescriptor.SiUnit siUnit, BreezeComboBoxInputField.SelectionChangedListener<SpatialDescriptor.SiUnit> selectionChangedListener) {
            super("Depth registration unit", Arrays.asList(SpatialDescriptor.SiUnit.values()), siUnit, selectionChangedListener, BreezeInputFieldHelper.Format.OneRow);
            this.setRenderer(new UnitCellRenderer());
        }
    }
}

