/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.measurement;

import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.List;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.measure.ReferenceStatus;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.measure.WhiteIntensityHelper;
import se.prediktera.breeze.common.util.raw.RawFileWriter;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.evince.data.PixelDataHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.CustomReferenceInterface;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportDataCustomReferencePanel;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.FileInputField;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.frontend.wizard.measure.step.ReferenceStatusCustomPanel;
import se.prediktera.breeze.hardware.CalibratedReflectanceTargetList;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.FakeCamera;
import se.prediktera.breeze.hardware.camera.HySpexCamera;
import se.prediktera.breeze.util.raw.HySpexHeader;
import se.prediktera.breeze.util.raw.HySpexHelper;
import se.prediktera.breeze.util.raw.RawHelper;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class ImportReferencePanel
extends AbstractBreezeCustomPanel.DefaultBreezeCustomPanel
implements CustomReferenceInterface {
    private static File lastDirectory = null;
    private ReferenceInputField darkReferenceToImport;
    private ReferenceInputField whiteReferenceToImport;
    private PPImportDataCustomReferencePanel.ReferenceInMeasurement referenceInMeasurement;
    private HySpexCamera.CalibratedReflectanceTargetInputField calibratedReflectanceTarget;
    private final BreezeInputField integrationTimeInputField = new BreezeInputField("Integration time", "", "\u00b5s");
    private final BreezeCheckBox extractDarkReferenceCheckBox = new BreezeCheckBox("Extract dark reference from HySpex header", true);
    private final BreezeMainPanel mainPanel;

    public ImportReferencePanel(BreezeMainPanel breezeMainPanel, Camera camera) {
        this(breezeMainPanel, camera, WorkspaceManager.getWorkspaceFolder());
    }

    public ImportReferencePanel(BreezeMainPanel breezeMainPanel, Camera camera, File file) {
        this.mainPanel = breezeMainPanel;
        if (lastDirectory == null) {
            lastDirectory = file;
        }
        this.setOpaque(false);
        this.darkReferenceToImport = new ReferenceInputField(breezeMainPanel, "Dark reference", false);
        this.add((Component)this.darkReferenceToImport, GridBagHelper.create(this.getComponentCount(), new Insets(24, 24, 0, 24)));
        this.whiteReferenceToImport = new ReferenceInputField(breezeMainPanel, "White reference", true);
        this.add((Component)this.whiteReferenceToImport, GridBagHelper.create(this.getComponentCount(), new Insets(24, 24, 0, 24)));
        this.extractDarkReferenceCheckBox.setVisible(false);
        this.add((Component)this.extractDarkReferenceCheckBox, GridBagHelper.create(this.getComponentCount(), new Insets(24, 24, 0, 24)));
        this.referenceInMeasurement = new PPImportDataCustomReferencePanel.ReferenceInMeasurement(breezeMainPanel.getFrame(), this);
        this.add((Component)this.referenceInMeasurement, GridBagHelper.create(this.getComponentCount(), new Insets(24, 24, 0, 24)));
        this.calibratedReflectanceTarget = new HySpexCamera.CalibratedReflectanceTargetInputField(breezeMainPanel);
        this.add((Component)this.calibratedReflectanceTarget, GridBagHelper.create(this.getComponentCount(), new Insets(24, 24, 0, 24)));
        IntegrationTime integrationTime = camera.getIntegrationTime();
        if (integrationTime != null) {
            this.integrationTimeInputField.setValue(integrationTime.value);
            this.add((Component)this.integrationTimeInputField, GridBagHelper.create(this.getComponentCount(), new Insets(24, 24, 0, 24)));
        }
        this.add((Component)new BreezeLabel(""), GridBagHelper.createLast(this.getComponentCount(), new Insets(24, 24, 0, 24)));
        BreezeFrame.setRelativeSize(this, 0.8);
    }

    private IntegrationTime getIntegrationTime() {
        if (this.integrationTimeInputField.isVisible() && this.integrationTimeInputField.getParent() != null) {
            return new IntegrationTime(this.integrationTimeInputField.getNumberFloat());
        }
        return null;
    }

    public void doImportIntoMeasurements(final BreezeProgressManager breezeProgressManager, List<Measurement> list) {
        breezeProgressManager.setInfoText("Importing references");
        breezeProgressManager.setMaximumAndReset(list.size());
        IntegrationTime integrationTime = this.getIntegrationTime();
        for (Measurement measurement : list) {
            Object object;
            File file = new MeasurementFileLocation.DarkRef().file(measurement);
            File file2 = new MeasurementFileLocation.WhiteRef().file(measurement);
            FakeCamera.FakeCameraFromMeasurement fakeCameraFromMeasurement = new FakeCamera.FakeCameraFromMeasurement(measurement);
            if (this.darkReferenceToImport.hasValue()) {
                object = ImportReferencePanel.importReferenceToTmpFile(breezeProgressManager, this.darkReferenceToImport.getFile());
                fakeCameraFromMeasurement.setDarkReference(new SpectralReference.DarkReference((File)object));
                ReferenceHelper.takeReferenceWithQualityDialog(this.mainPanel, fakeCameraFromMeasurement, new ReferenceHelper.TakeReferenceAction(){
                    final /* synthetic */ File val$tmpDarkRefFile;
                    final /* synthetic */ IntegrationTime val$integrationTime;
                    final /* synthetic */ FakeCamera.FakeCameraFromMeasurement val$camera;
                    final /* synthetic */ File val$darkRefFile;
                    {
                        this.val$tmpDarkRefFile = file;
                        this.val$integrationTime = integrationTime;
                        this.val$camera = fakeCameraFromMeasurement;
                        this.val$darkRefFile = file2;
                    }

                    @Override
                    public ReferenceStatus take() {
                        return ReferenceHelper.qualityCheckDarkReference(breezeProgressManager, this.val$tmpDarkRefFile, this.val$integrationTime, this.val$camera.getMaxsignal());
                    }

                    @Override
                    public void complete() {
                        FileHelper.moveReference(this.val$tmpDarkRefFile, this.val$darkRefFile);
                    }
                }, ReferenceStatusCustomPanel.ReferenceStatusDialogType.Import);
            }
            if (this.whiteReferenceToImport.hasValue()) {
                object = this.importWhiteToTmp(breezeProgressManager, file);
                fakeCameraFromMeasurement.setWhiteReference(new SpectralReference.WhiteReference(((WhiteImportResult)object).tmpWhiteRefFile));
                fakeCameraFromMeasurement.setDarkReference(new SpectralReference.DarkReference(((WhiteImportResult)object).darkRefForWhite));
                ReferenceHelper.takeReferenceWithQualityDialog(this.mainPanel, fakeCameraFromMeasurement, new ReferenceHelper.TakeReferenceAction(){
                    final /* synthetic */ WhiteImportResult val$importWhiteResult;
                    final /* synthetic */ IntegrationTime val$integrationTime;
                    final /* synthetic */ FakeCamera.FakeCameraFromMeasurement val$camera;
                    final /* synthetic */ File val$whiteRefFile;
                    {
                        this.val$importWhiteResult = whiteImportResult;
                        this.val$integrationTime = integrationTime;
                        this.val$camera = fakeCameraFromMeasurement;
                        this.val$whiteRefFile = file;
                    }

                    @Override
                    public ReferenceStatus take() {
                        return ReferenceHelper.qualityCheckWhiteReference(breezeProgressManager, this.val$importWhiteResult.tmpWhiteRefFile, this.val$integrationTime, this.val$camera.getMaxsignal());
                    }

                    @Override
                    public void complete() {
                        FileHelper.moveReference(this.val$importWhiteResult.tmpWhiteRefFile, this.val$whiteRefFile);
                    }
                }, ReferenceStatusCustomPanel.ReferenceStatusDialogType.Import);
                if (((WhiteImportResult)object).darkRefExtracted) {
                    FileHelper.moveReference(((WhiteImportResult)object).darkRefForWhite, file);
                }
            }
            measurement.clearCache();
            breezeProgressManager.incStep();
        }
        PixelDataHelper.clearSpectralMatrixCache();
        ApplyChanges.applyChanges(breezeProgressManager, list, true);
    }

    public void doImportIntoRuntime(BreezeProgress breezeProgress, final Camera camera) {
        Object object;
        breezeProgress.setInfoText("Importing references");
        IntegrationTime integrationTime = this.getIntegrationTime();
        File file = ReferenceHelper.getDarkReferenceFile(camera);
        if (this.darkReferenceToImport.hasValue()) {
            object = ImportReferencePanel.importReferenceToTmpFile(breezeProgress, this.darkReferenceToImport.getFile());
            ReferenceHelper.takeReferenceWithQualityDialog(this.mainPanel, camera, new ReferenceHelper.TakeReferenceAction(){
                final /* synthetic */ File val$tmpDarkRefFile;
                final /* synthetic */ IntegrationTime val$integrationTime;
                {
                    this.val$tmpDarkRefFile = file;
                    this.val$integrationTime = integrationTime;
                }

                @Override
                public ReferenceStatus take() {
                    return ReferenceHelper.setDarkReference(camera, this.val$tmpDarkRefFile, this.val$integrationTime);
                }

                @Override
                public void clear() {
                    ReferenceHelper.clearCurrentDarkReference(camera);
                }
            }, ReferenceStatusCustomPanel.ReferenceStatusDialogType.Import);
        }
        if (this.whiteReferenceToImport.hasValue()) {
            object = this.importWhiteToTmp(breezeProgress, file);
            ReferenceHelper.takeReferenceWithQualityDialog(this.mainPanel, camera, new ReferenceHelper.TakeReferenceAction(){
                final /* synthetic */ WhiteImportResult val$whiteResult;
                final /* synthetic */ IntegrationTime val$integrationTime;
                {
                    this.val$whiteResult = whiteImportResult;
                    this.val$integrationTime = integrationTime;
                }

                @Override
                public ReferenceStatus take() {
                    return ReferenceHelper.setWhiteReference(camera, this.val$whiteResult.tmpWhiteRefFile, this.val$integrationTime);
                }

                @Override
                public void clear() {
                    ReferenceHelper.clearCurrentWhiteReference(camera);
                }
            }, ReferenceStatusCustomPanel.ReferenceStatusDialogType.Import);
            if (((WhiteImportResult)object).darkRefExtracted) {
                ReferenceHelper.setDarkReference(camera, ((WhiteImportResult)object).darkRefForWhite, integrationTime);
            }
            if (BreezeProperties.getInstance().useWhiteIntensity() && file.exists()) {
                List<Frame> list = WhiteIntensityHelper.createWhiteIntensity(((WhiteImportResult)object).darkRefForWhite, ((WhiteImportResult)object).tmpWhiteRefFile);
                File file2 = FileHelper.createTempFileInWorkspace("raw");
                File file3 = RawFileWriter.writeFramesAndHeader(file2.getParentFile(), FileHelper.getFileName(file2), list, camera.getBandNames(), null, null);
                this.applyReflectanceTarget(RawHeader.findByRaw(file3));
                ReferenceHelper.setWhiteIntensityReference(camera, file3, integrationTime);
            }
        }
    }

    private WhiteImportResult importWhiteToTmp(BreezeProgress breezeProgress, File file) {
        File file2 = ImportReferencePanel.importReferenceToTmpFile(breezeProgress, this.whiteReferenceToImport.getFile());
        RawHeader rawHeader = RawHeader.findByRaw(file2);
        File file3 = file;
        boolean bl = false;
        if (HySpexHelper.isHySpexFile(file2) && !this.darkReferenceToImport.hasValue() && this.extractDarkReferenceCheckBox.isVisibleAndSelected()) {
            HySpexHeader hySpexHeader = new HySpexHeader(file2);
            double[][] dArray = hySpexHeader.getBackgrounds();
            if (dArray != null && dArray.length > 0) {
                file3 = FileHelper.createTempFileInWorkspace("raw");
                bl = true;
                hySpexHeader.saveInEnvi(breezeProgress, file3, dArray, rawHeader.bandNames());
            }
            if (hySpexHeader.nobp > 0) {
                List<HySpexHelper.BadPixel> list = hySpexHeader.getBadPixelMap();
                HySpexHelper.applyBadPixels(breezeProgress, file2, list);
            }
        }
        if (this.referenceInMeasurement.useSplit()) {
            RawHelper.extractWhite(file2, file2, file3, this.referenceInMeasurement.getValues());
        }
        this.applyReflectanceTarget(rawHeader);
        return new WhiteImportResult(file2, file3, bl);
    }

    private void applyReflectanceTarget(RawHeader rawHeader) {
        File file = this.calibratedReflectanceTarget.getFile();
        if (file != null && FileHelper.exists(rawHeader.file())) {
            this.addReflectanceTarget(rawHeader, file);
        }
    }

    private static File importReferenceToTmpFile(BreezeProgress breezeProgress, File file) {
        try {
            File file2 = FileHelper.createTempFileInWorkspace("raw");
            PPImportDataCustomReferencePanel.importReference(breezeProgress, file, file2);
            return file2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void addReflectanceTarget(RawHeader rawHeader, File file) {
        CalibratedReflectanceTargetList calibratedReflectanceTargetList = CalibratedReflectanceTargetList.fromTargetFile(file);
        rawHeader.setReferenceTarget(calibratedReflectanceTargetList.getReferenceTarget(rawHeader.bandNames()));
        rawHeader.save();
    }

    @Override
    public boolean usePreferredSize() {
        return true;
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public File getWhiteRefOrSelectedFile() {
        return this.whiteReferenceToImport.getFile();
    }

    @Override
    public boolean useOneReference() {
        return true;
    }

    @Override
    public String getExtractText() {
        return "Use interval within white reference";
    }

    private class ReferenceInputField
    extends FileInputField {
        private final boolean isWhite;

        public ReferenceInputField(Component component, String string, boolean bl) {
            super(component, string, (String)null, null, true);
            this.isWhite = bl;
            this.setName(StringHelper.removeSpace(string).toLowerCase());
        }

        @Override
        protected void customizeDialog(jopensaveDialog jopensaveDialog2) {
            FileChooserPanel.addDataFileFilters(jopensaveDialog2, FileChooserPanel.FilterType.IMAGE);
            jopensaveDialog2.setCurrentDirectory(lastDirectory);
            jopensaveDialog2.addAllSupported();
        }

        @Override
        protected void fileSelected(File file) {
            super.fileSelected(file);
            lastDirectory = file.getParentFile();
            if (this.isWhite) {
                ImportReferencePanel.this.extractDarkReferenceCheckBox.setVisible(HySpexHelper.isHySpexFile(file));
            }
        }
    }

    public record WhiteImportResult(File tmpWhiteRefFile, File darkRefForWhite, boolean darkRefExtracted) {
    }
}

