/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.measurement;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.text.SimpleDateFormat;
import javax.swing.JPanel;
import javax.swing.Timer;
import lombok.Generated;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.measure.ReferenceStatus;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.RawFileImpl;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.client.select.active.RuntimeSpectralPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.ViewPanelCustomPanel;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.frontend.main.settings.measurement.BreezeTimeSpinner;
import se.prediktera.breeze.frontend.main.settings.measurement.ClearReferenceCustomPanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ImportReferencePanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.frontend.main.settings.measurement.SpectralReferences;
import se.prediktera.breeze.frontend.wizard.measure.step.ReferenceStatusCustomPanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class ReferenceCachePanel
extends JPanel {
    private final ReferenceDelayInputField whiteRefDelayInputField;
    private final ReferenceDelayInputField darkRefDelayInputField;
    private final Timer timer = new Timer(500, actionEvent -> this.updateStatus());

    public ReferenceCachePanel(final MaintenancePanel maintenancePanel, ReferenceDelayInputField referenceDelayInputField, ReferenceDelayInputField referenceDelayInputField2) {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.whiteRefDelayInputField = referenceDelayInputField;
        this.darkRefDelayInputField = referenceDelayInputField2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)EntryMainHelper.createTextButton("View", () -> {
            final BreezeFrame breezeFrame = maintenancePanel.getFrame();
            Camera camera = maintenancePanel.getSelectedCamera();
            new ConnectProgressAction.ConnectCamera(this, breezeFrame, camera){
                final /* synthetic */ ReferenceCachePanel this$0;
                {
                    this.this$0 = referenceCachePanel;
                    super(breezeFrame3, camera);
                }

                @Override
                public void afterConnection(BreezeProgress breezeProgress, final Camera camera) {
                    maintenancePanel.reloadHardwareSidePanel();
                    this.this$0.updateFiles();
                    BreezeProgressDialog.startProgress(breezeFrame, new ProgressAction(this){

                        @Override
                        public void runAction() {
                            SpectralReferences spectralReferences = new SpectralReferences(camera);
                            BreezeOptionDialog.showDialog(breezeFrame, maintenancePanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION.setOkText("Close"), ReferenceHelper.getReferenceTitle(camera), "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(new CachedSpectralPanel((BreezeMainPanel)maintenancePanel, spectralReferences), spectralReferences, 0.8), null, null);
                        }
                    }, "Loading references");
                }
            };
        }), GridBagHelper.create(jPanel.getComponentCount(), new Insets(0, 12, 0, 0), false));
        jPanel.add((Component)EntryMainHelper.createTextButton("Import", "import", () -> {
            final BreezeFrame breezeFrame = maintenancePanel.getFrame();
            Camera camera = maintenancePanel.getSelectedCamera();
            new ConnectProgressAction.ConnectCamera(this, breezeFrame, camera){
                final /* synthetic */ ReferenceCachePanel this$0;
                {
                    this.this$0 = referenceCachePanel;
                    super(breezeFrame3, camera);
                }

                @Override
                public void afterConnection(BreezeProgress breezeProgress, final Camera camera) {
                    this.this$0.updateFiles();
                    BreezeOptionDialog.showDialog(breezeFrame, maintenancePanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Import references to " + Camera.getCameraTypeName(camera), "", (AbstractBreezeCustomPanel)new ImportReferencePanel(maintenancePanel, camera), null, breezeActionEvent -> BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){

                        @Override
                        public void runAction() {
                            ((ImportReferencePanel)breezeActionEvent.getBreezeCustomPanel()).doImportIntoRuntime(this.getProgressManager(), camera);
                            maintenancePanel.setDirty(true);
                            BreezeProperties.getInstance().increaseSaveIndex();
                        }
                    }, "Importing reference(s)"));
                }
            };
        }), GridBagHelper.create(jPanel.getComponentCount(), new Insets(0, 12, 0, 0), false));
        BreezeButton breezeButton = EntryMainHelper.createTextButton("Clear", "clear", () -> new ConnectProgressAction.ConnectCamera(this, maintenancePanel.getFrame(), maintenancePanel.getSelectedCamera()){
            final /* synthetic */ ReferenceCachePanel this$0;
            {
                this.this$0 = referenceCachePanel;
                super(breezeFrame, camera);
            }

            @Override
            public void afterConnection(BreezeProgress breezeProgress, Camera camera) {
                BreezeOptionDialog.showDialog(maintenancePanel.getFrame(), BreezeType.Workflow.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Clear all references for " + Camera.getCameraTypeName(camera), "", (AbstractBreezeCustomPanel)new ClearReferenceCustomPanel(camera), null, breezeActionEvent -> {
                    ClearReferenceCustomPanel.ClearType clearType = (ClearReferenceCustomPanel.ClearType)((Object)((Object)breezeActionEvent.result()));
                    switch (clearType) {
                        case Dark: {
                            ReferenceHelper.clearAllDarkReferences(camera);
                            break;
                        }
                        case White: {
                            ReferenceHelper.clearAllWhiteReferences(camera);
                            break;
                        }
                        case Both: {
                            ReferenceHelper.clearAllDarkReferences(camera);
                            ReferenceHelper.clearAllWhiteReferences(camera);
                        }
                    }
                    this.this$0.updateFiles();
                    BreezeProperties.getInstance().increaseSaveIndex();
                });
            }
        });
        breezeButton.setResourceIcon("material/open_in_new");
        breezeButton.scaleIcon(0.75f);
        breezeButton.setIconLocation(BreezeButton.IconLocation.RIGHT);
        jPanel.add((Component)breezeButton, GridBagHelper.create(jPanel.getComponentCount(), new Insets(0, 12, 0, 0), true));
        InputFieldHelper.addPanel(this, jPanel, true, new Insets(12, 0, 0, 0));
    }

    public void showEntry() {
        this.updateFiles();
        this.timer.start();
    }

    private void updateFiles() {
        this.darkRefDelayInputField.showEntry();
        this.whiteRefDelayInputField.showEntry();
    }

    private void updateStatus() {
        this.darkRefDelayInputField.updateStatus();
        this.whiteRefDelayInputField.updateStatus();
    }

    public void leaveEntry() {
        this.timer.stop();
    }

    public static abstract class ReferenceDelayInputField
    extends JPanel {
        private final BreezeTimeSpinner timeSpinner;
        private final BreezeLabelField statusLabelField = new BreezeLabelField("", 0, "Value", 100);
        private final ReferenceInfoPanel infoPanel;
        private final MaintenancePanel mainPanel;
        private final BreezeLabel label;

        private ReferenceDelayInputField(MaintenancePanel maintenancePanel, BreezeTimeSpinner.TimeChangedCallback timeChangedCallback) {
            super(new GridBagLayout());
            this.mainPanel = maintenancePanel;
            this.timeSpinner = new BreezeTimeSpinner(timeChangedCallback);
            this.timeSpinner.setHourLabelWidth(55);
            this.label = new BreezeLabel("Cache time", false, 14);
            this.label.setPreferredSize(new Dimension(260, 30));
            this.add((Component)this.label, GridBagHelper.create(0, 0, new Insets(0, 0, 0, 0), false));
            this.add((Component)this.timeSpinner, GridBagHelper.create(0, 1, new Insets(0, 12, 0, 0), false));
            GridBagConstraints gridBagConstraints = GridBagHelper.create(0, 2, new Insets(12, 12, 0, 0), true);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            this.infoPanel = new ReferenceInfoPanel();
            this.add((Component)this.infoPanel, gridBagConstraints);
            BreezeLabel breezeLabel = this.statusLabelField.getValueLabel();
            this.statusLabelField.setToolTipText("Remaining");
            breezeLabel.setOpaque(true);
            breezeLabel.setBackground(BreezeTheme.getInstance().getSettingPanelBackground());
            breezeLabel.setPreferredSize(new Dimension(110, 30));
            breezeLabel.setHorizontalAlignment(0);
            GridBagConstraints gridBagConstraints2 = GridBagHelper.create(1, 1, new Insets(0, 20, 0, 0), false);
            gridBagConstraints2.anchor = 17;
            this.add((Component)this.statusLabelField, gridBagConstraints2);
            this.add((Component)EntryMainHelper.createTextButton("Take", () -> {
                this.takeNewReference(maintenancePanel);
                BreezeProperties.getInstance().increaseSaveIndex();
            }), GridBagHelper.create(2, 1, new Insets(0, 20, 0, 0), false));
        }

        protected Camera getCamera() {
            return this.mainPanel.getSelectedCamera();
        }

        protected abstract Time getTime();

        public abstract File getReferenceFile();

        public abstract int getReferenceValidTime();

        public abstract void takeNewReference(EntryMainPanel var1);

        public void showEntry() {
            this.timeSpinner.setValue(this.getTime());
            Camera camera = this.getCamera();
            if (Camera.connected(camera)) {
                this.infoPanel.setFile(this.getReferenceFile());
            } else {
                this.infoPanel.noConnected();
            }
            this.updateStatus();
        }

        public void updateStatus() {
            Time time = this.getTime();
            Camera camera = this.getCamera();
            if (camera != null && time.ms > 0L) {
                if (!TcpManager.getInstance().hasProgress()) {
                    int n = this.getReferenceValidTime();
                    this.statusLabelField.setValue(new Time.Seconds((double)n).toCompactNiceString());
                }
            } else {
                this.statusLabelField.setValue("N/A");
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            this.timeSpinner.setEnabled(bl);
            this.label.setEnabled(bl);
            this.statusLabelField.setEnabled(bl);
            this.infoPanel.setEnabled(bl);
        }

        @Generated
        public BreezeTimeSpinner getTimeSpinner() {
            return this.timeSpinner;
        }

        private static class ReferenceInfoPanel
        extends JPanel {
            private final BreezeInputField dateTextField;
            private final BreezeInputField integrationTimeTextField;
            private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss");

            public ReferenceInfoPanel() {
                super(new GridBagLayout());
                this.setOpaque(false);
                this.dateTextField = new BreezeInputField("Date", "", "", BreezeInputFieldHelper.Format.OneRow);
                this.dateTextField.setEnabled(false);
                this.dateTextField.setLabelWidth(55);
                this.add((Component)this.dateTextField, GridBagHelper.create(0, 0, 1.0, 0.0, 2, new Insets(0, 0, 0, 0)));
                this.integrationTimeTextField = new BreezeInputField("Int. Time", "", "\u00b5s", BreezeInputFieldHelper.Format.OneRow);
                this.integrationTimeTextField.setEnabled(false);
                this.integrationTimeTextField.setLabelWidth(80);
                this.integrationTimeTextField.setUnitLabelWidth(60);
                this.integrationTimeTextField.getTextField().setPreferredSize(new Dimension(100, 25));
                this.add((Component)this.integrationTimeTextField, GridBagHelper.create(1, 0, 0.0, 0.0, 2, new Insets(0, 20, 0, 0)));
            }

            public void setFile(File file) {
                if (file != null && file.exists()) {
                    this.dateTextField.setValue(sdf.format(SpectralReference.getReferenceDate(new RawFileImpl(file))));
                    RawHeader rawHeader = RawHeader.findByRaw(file);
                    RawHeader.DescriptionData descriptionData = rawHeader.getDescriptionData();
                    if (descriptionData != null && descriptionData.integrationTime != null) {
                        this.integrationTimeTextField.setValue(descriptionData.integrationTime.value);
                    } else {
                        this.integrationTimeTextField.setValue("N/A");
                    }
                } else {
                    this.dateTextField.setValue("");
                    this.integrationTimeTextField.setValue("");
                }
            }

            @Override
            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                this.dateTextField.getLabel().setEnabled(bl);
                this.integrationTimeTextField.getLabel().setEnabled(bl);
            }

            public void noConnected() {
                this.dateTextField.setValue("Camera not connected");
                this.integrationTimeTextField.setValue("");
            }
        }

        public static class Dark
        extends ReferenceDelayInputField {
            public Dark(MaintenancePanel maintenancePanel) {
                super(maintenancePanel, time -> {
                    BreezeProperties.getInstance().setDarkReferenceDelay(time);
                    ReferenceHelper.setDarkReferenceValidTime(time);
                    TcpManager.getInstance().measurementSettingsChanged();
                    maintenancePanel.repaintEntryList();
                });
            }

            @Override
            protected Time getTime() {
                return BreezeProperties.getInstance().getDarkReferenceDelay();
            }

            @Override
            public File getReferenceFile() {
                return ReferenceHelper.getDarkReferenceFile(this.getCamera());
            }

            @Override
            public int getReferenceValidTime() {
                return ReferenceHelper.getDarkReferenceValidTime(this.getCamera());
            }

            @Override
            public void takeNewReference(final EntryMainPanel entryMainPanel) {
                final BreezeFrame breezeFrame = entryMainPanel.getFrame();
                new ConnectProgressAction.ConnectCamera(this, breezeFrame, this.getCamera()){

                    @Override
                    public void afterConnection(BreezeProgress breezeProgress, final Camera camera) {
                        BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){

                            @Override
                            public void runAction() {
                                ReferenceHelper.takeDarkReference(this.getProgressManager(), camera);
                                entryMainPanel.setDirty(true);
                            }
                        }, "Taking dark reference");
                    }
                };
            }
        }

        public static class White
        extends ReferenceDelayInputField {
            public White(MaintenancePanel maintenancePanel) {
                super(maintenancePanel, time -> {
                    BreezeProperties.getInstance().setWhiteReferenceDelay(time);
                    ReferenceHelper.setWhiteReferenceValidTime(time);
                    TcpManager.getInstance().measurementSettingsChanged();
                    maintenancePanel.repaintEntryList();
                });
            }

            @Override
            protected Time getTime() {
                return BreezeProperties.getInstance().getWhiteReferenceDelay();
            }

            @Override
            public File getReferenceFile() {
                return ReferenceHelper.getWhiteReferenceFile(this.getCamera());
            }

            @Override
            public int getReferenceValidTime() {
                return ReferenceHelper.getWhiteReferenceValidTime(this.getCamera());
            }

            @Override
            public void takeNewReference(final EntryMainPanel entryMainPanel) {
                final BreezeFrame breezeFrame = entryMainPanel.getFrame();
                new ConnectProgressAction.ConnectAll(this, breezeFrame, this.getCamera().getId(), "Connecting to hardware"){

                    @Override
                    public void afterConnection(BreezeProgress breezeProgress, final Camera camera, final SampleMover sampleMover) {
                        BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){

                            @Override
                            public void runAction() {
                                ReferenceHelper.takeReferenceWithQualityDialog(entryMainPanel, camera, new ReferenceHelper.TakeReferenceAction(){
                                    final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = var1_1;
                                    }

                                    @Override
                                    public ReferenceStatus take() {
                                        return ReferenceHelper.takeWhiteReference(this.this$2.getProgressManager(), camera, sampleMover, true);
                                    }

                                    @Override
                                    public void clear() {
                                        ReferenceHelper.clearCurrentWhiteReference(camera);
                                    }

                                    @Override
                                    public void complete() {
                                        if (sampleMover != null) {
                                            sampleMover.moveToReturnPosition(camera);
                                        }
                                    }
                                }, ReferenceStatusCustomPanel.ReferenceStatusDialogType.Record);
                                entryMainPanel.setDirty(true);
                            }
                        }, "Taking white reference");
                    }
                };
            }
        }
    }

    public static class CachedSpectralPanel
    extends RuntimeSpectralPanel {
        private final SpectralReferences spectralReferences;

        public CachedSpectralPanel(BreezeMainPanel breezeMainPanel, SpectralReferences spectralReferences) {
            super(breezeMainPanel);
            this.spectralReferences = spectralReferences;
        }

        @Override
        protected MaxSignal getMaxSignal(Measurement measurement) {
            return this.spectralReferences.getMaxSignal();
        }

        @Override
        protected SpectralReference.DarkReference getDarkReference(Camera camera) {
            return this.spectralReferences.darkReference;
        }

        @Override
        protected SpectralReference.WhiteReference getWhiteReference(Camera camera) {
            return this.spectralReferences.whiteReference;
        }
    }
}

