/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.measurement;

import java.io.File;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.measure.ReferenceStatus;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.entry.application.status.StatusList;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.ViewPanelCustomPanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceCachePanel;
import se.prediktera.breeze.frontend.main.settings.measurement.SpectralReferences;
import se.prediktera.breeze.frontend.wizard.measure.step.ReferenceStatusCustomPanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.error.Logg;

public class ReferenceHelper {
    public static void clearReferenceCache(Camera camera) {
        ReferenceHelper.clearCurrentDarkReference(camera);
        ReferenceHelper.clearCurrentWhiteReference(camera);
    }

    public static ReferenceStatus setDarkReference(Camera camera, File file, IntegrationTime integrationTime) {
        return TcpManager.getInstance().takeDarkReference(BreezeProgressImpl.createEmpty(), false, TcpManager.ReferenceAction.Load, file.getAbsolutePath(), camera.getId(), integrationTime, null);
    }

    public static File getDarkReferenceFile(Camera camera) {
        String string = TcpManager.getInstance().getProperty(camera, "DarkReferenceFile", false);
        if (string.isEmpty()) {
            return null;
        }
        return new File(string);
    }

    public static ReferenceStatus setWhiteReference(Camera camera, File file, IntegrationTime integrationTime) {
        return TcpManager.getInstance().takeWhiteReference(BreezeProgressImpl.createEmpty(), TcpManager.ReferenceAction.Load, file.getAbsolutePath(), camera.getId(), integrationTime, null);
    }

    public static ReferenceStatus setWhiteIntensityReference(Camera camera, File file, IntegrationTime integrationTime) {
        return TcpManager.getInstance().takeWhiteReference(BreezeProgressImpl.createEmpty(), TcpManager.ReferenceAction.LoadIntensity, file.getAbsolutePath(), camera.getId(), integrationTime, null);
    }

    public static File getWhiteReferenceFile(Camera camera) {
        String string = TcpManager.getInstance().getProperty(camera, "WhiteReferenceFile", false);
        if (string.isEmpty()) {
            return null;
        }
        return new File(string);
    }

    public static boolean HasDarkReference(Camera camera) {
        return Boolean.parseBoolean(TcpManager.getInstance().getProperty(camera, "HasDarkReference", false));
    }

    public static SpectralReference.DarkReference getDarkReference(Camera camera) {
        File file = ReferenceHelper.getDarkReferenceFile(camera);
        if (file != null && file.exists()) {
            return new SpectralReference.DarkReference(file);
        }
        return null;
    }

    public static int getDarkReferenceValidTime(Camera camera) {
        return RtDataFormat.toNumberInt(TcpManager.getInstance().getProperty(camera, "DarkReferenceValidTime", false));
    }

    public static boolean isDarkReferenceValid(Camera camera) {
        return ReferenceHelper.getDarkReferenceValidTime(camera) > 0;
    }

    public static void setDarkReferenceValidTime(Time time) {
        TcpManager.getInstance().setProperty("DarkReferenceValidTime", (int)time.toSeconds());
    }

    public static boolean HasWhiteReference(Camera camera) {
        return Boolean.parseBoolean(TcpManager.getInstance().getProperty(camera, "HasWhiteReference", false));
    }

    public static SpectralReference.WhiteReference getWhiteReference(Camera camera) {
        File file = ReferenceHelper.getWhiteReferenceFile(camera);
        if (file != null && file.exists()) {
            return new SpectralReference.WhiteReference(file);
        }
        return null;
    }

    public static int getWhiteReferenceValidTime(Camera camera) {
        return RtDataFormat.toNumberInt(TcpManager.getInstance().getProperty(camera, "WhiteReferenceValidTime", false));
    }

    public static boolean isWhiteReferenceValid(Camera camera) {
        return ReferenceHelper.getWhiteReferenceValidTime(camera) > 0;
    }

    public static void setWhiteReferenceValidTime(Time time) {
        TcpManager.getInstance().setProperty("WhiteReferenceValidTime", (int)time.toSeconds());
    }

    public static ReferenceStatus takeDarkReference(BreezeProgress breezeProgress, Camera camera) {
        breezeProgress.setInfoText("Taking dark reference" + ReferenceHelper.getAdditionalInfoText(camera));
        return TcpManager.getInstance().takeDarkReference(breezeProgress, camera.getId());
    }

    public static ReferenceStatus takeWhiteReference(BreezeProgress breezeProgress, Camera camera) {
        return ReferenceHelper.takeWhiteReference(breezeProgress, camera, null, false);
    }

    public static ReferenceStatus takeReferenceWithQualityDialog(BreezeMainPanel breezeMainPanel, Camera camera, TakeReferenceAction takeReferenceAction, ReferenceStatusCustomPanel.ReferenceStatusDialogType referenceStatusDialogType) {
        ReferenceStatus referenceStatus = takeReferenceAction.take();
        ReferenceStatusCustomPanel.SelectedAction selectedAction = ReferenceHelper.checkReferenceStatus(breezeMainPanel, camera, referenceStatus, referenceStatusDialogType);
        while (selectedAction == ReferenceStatusCustomPanel.SelectedAction.RETAKE) {
            referenceStatus = takeReferenceAction.take();
            selectedAction = ReferenceHelper.checkReferenceStatus(breezeMainPanel, camera, referenceStatus, referenceStatusDialogType);
        }
        if (selectedAction == ReferenceStatusCustomPanel.SelectedAction.CANCEL) {
            Logg.debug((String)"Clearing reference", (Object[])new Object[0]);
            takeReferenceAction.clear();
            SampleMover sampleMover = HardwareRegistry.getInstance().getSampleMover();
            if (sampleMover != null && sampleMover.isConnected() && sampleMover.isTray()) {
                sampleMover.moveToReturnPosition(camera);
            }
            throw new ToastHandler.ToasterMessageException("Reference cancelled: Quality not met", Toast.IconType.Warning);
        }
        takeReferenceAction.complete();
        return referenceStatus;
    }

    private static ReferenceStatusCustomPanel.SelectedAction checkReferenceStatus(BreezeMainPanel breezeMainPanel, Camera camera, ReferenceStatus referenceStatus, ReferenceStatusCustomPanel.ReferenceStatusDialogType referenceStatusDialogType) {
        if (referenceStatus != null && referenceStatus.showErrorDialog() && camera.useReferencesWhenRecordingWithThisCamera()) {
            return ReferenceStatusCustomPanel.showDialog(breezeMainPanel, camera, referenceStatus, referenceStatusDialogType);
        }
        return ReferenceStatusCustomPanel.SelectedAction.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferenceStatus takeWhiteReference(BreezeProgress breezeProgress, Camera camera, SampleMover sampleMover, boolean bl) {
        Object object;
        StateCamera stateCamera;
        if (camera instanceof StateCamera && (stateCamera = (StateCamera)camera).useReferencesWhenRecordingWithThisCamera()) {
            stateCamera.changeStateToWhiteReference();
        }
        boolean bl2 = false;
        if (bl && sampleMover != null) {
            if (sampleMover instanceof RemoteSampleMover && (bl2 = ((RemoteSampleMover)(object = (RemoteSampleMover)sampleMover)).isScanWhiteReference())) {
                breezeProgress.setInfoText("Scanning white reference" + ReferenceHelper.getAdditionalInfoText(camera));
                ((RemoteSampleMover)object).scanWhiteReference(breezeProgress, camera, SampleMover.ScanMode.WhiteReference);
            }
            if (!bl2) {
                breezeProgress.setInfoText("Moving to white reference" + ReferenceHelper.getAdditionalInfoText(camera));
                sampleMover.enterWhiteRefState(camera);
            }
        }
        breezeProgress.setInfoText("Taking white reference" + ReferenceHelper.getAdditionalInfoText(camera));
        try {
            if (!bl2) {
                object = TcpManager.getInstance().takeWhiteReference(breezeProgress, camera.getId());
                return object;
            }
            object = ReferenceHelper.getReferenceStatus(ReferenceHelper.getWhiteReference(camera));
            return object;
        }
        finally {
            if (camera instanceof StateCamera) {
                ((StateCamera)camera).changeStateToNormal();
            }
            if (bl && sampleMover != null) {
                sampleMover.exitWhiteRefState();
            }
        }
    }

    public static ReferenceStatus getReferenceStatus(SpectralReference spectralReference) {
        if (spectralReference != null) {
            return spectralReference.getStatus();
        }
        return null;
    }

    private static String getAdditionalInfoText(Camera camera) {
        if (HardwareRegistry.hasMultiModeCameras()) {
            return " (" + Camera.getCameraTypeName(camera) + ")";
        }
        return "";
    }

    public static boolean shouldTakeNewDark(Camera camera) {
        StatusList.ServerState serverState;
        if (camera.useReferencesWhenRecordingWithThisCamera() && camera.hasShutter() && (serverState = TcpManager.getInstance().getStatus().getState()).equals((Object)StatusList.ServerState.Idle)) {
            SpectralReference.DarkReference darkReference = ReferenceHelper.getDarkReference(camera);
            if (darkReference != null) {
                Time.MilliSeconds milliSeconds = new Time.MilliSeconds(Math.max(0L, System.currentTimeMillis() - darkReference.getDate().getTime()));
                return milliSeconds.toHours() > 1.0f;
            }
            return true;
        }
        return false;
    }

    public static String getReferenceTitle(Camera camera) {
        return "References for " + Camera.getCameraTypeName(camera) + ", integration time " + String.valueOf(camera.getIntegrationTime());
    }

    public static String getReferenceTitle(Measurement measurement) {
        IntegrationTime integrationTime = measurement.getIntegrationTime();
        return "References for " + measurement.getName() + ", integration time " + String.valueOf(integrationTime != null ? integrationTime : "unknown");
    }

    public static void viewReferences(final BreezeMainPanel breezeMainPanel, final Camera camera) {
        BreezeProgressDialog.startProgress(breezeMainPanel.getFrame(), new ProgressAction(){

            @Override
            public void runAction() {
                SpectralReferences spectralReferences = new SpectralReferences(camera);
                BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, ReferenceHelper.getReferenceTitle(camera), "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(new ReferenceCachePanel.CachedSpectralPanel(breezeMainPanel, spectralReferences), spectralReferences, 0.8), null, null);
            }
        }, "Loading references");
    }

    public static void clearCurrentDarkReference(Camera camera) {
        TcpManager.getInstance().takeDarkReference(BreezeProgressImpl.createEmpty(), TcpManager.ReferenceAction.Clear, camera.getId());
    }

    public static void clearAllDarkReferences(Camera camera) {
        TcpManager.getInstance().takeDarkReference(BreezeProgressImpl.createEmpty(), TcpManager.ReferenceAction.ClearAll, camera.getId());
    }

    public static void clearCurrentWhiteReference(Camera camera) {
        TcpManager.getInstance().takeWhiteReference(BreezeProgressImpl.createEmpty(), TcpManager.ReferenceAction.Clear, camera.getId());
    }

    public static void clearAllWhiteReferences(Camera camera) {
        TcpManager.getInstance().takeWhiteReference(BreezeProgressImpl.createEmpty(), TcpManager.ReferenceAction.ClearAll, camera.getId());
    }

    public static ReferenceStatus qualityCheckDarkReference(BreezeProgress breezeProgress, File file, IntegrationTime integrationTime, MaxSignal maxSignal) {
        return TcpManager.getInstance().takeDarkReference(breezeProgress, false, TcpManager.ReferenceAction.QualityCheck, file.getAbsolutePath(), 0, integrationTime, maxSignal);
    }

    public static ReferenceStatus qualityCheckWhiteReference(BreezeProgress breezeProgress, File file, IntegrationTime integrationTime, MaxSignal maxSignal) {
        return TcpManager.getInstance().takeWhiteReference(breezeProgress, TcpManager.ReferenceAction.QualityCheck, file.getAbsolutePath(), 0, integrationTime, maxSignal);
    }

    public static interface TakeReferenceAction {
        public ReferenceStatus take();

        default public void clear() {
        }

        default public void complete() {
        }
    }
}

