/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.measurement;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.w3c.dom.Node;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.measure.settings.ReferenceSettings;
import se.prediktera.breeze.common.entry.EntryWithSave;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.measure.ReferenceFile;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.frontend.common.BreezeTextComponentAncestor;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeExternalLinkPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinner;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinnerInputPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlPropertyViewPanel;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.frontend.main.settings.focus.HardwareSidePanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceCachePanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.camera.HySpexCamera;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.util.FileFromAbsolutePath;
import se.prediktera.map.common.update.UpdateHelper;

public class ReferencesSettingsPanel
extends AbstractViewPanel
implements BreezeTextComponentAncestor {
    private final BreezeSpinnerInputPanel numberOfWhiteReferenceFramesInputField;
    private final BreezeSpinnerInputPanel numberOfDarkReferenceFramesInputField;
    private final BreezeSpinnerInputPanel runtimeRecordMaxFramesInputField;
    private final ReferenceCachePanel referenceCachePanel;
    private final HardwareSidePanel hardwareSidePanel;
    private final HySpexCamera.CalibratedReflectanceTargetInputField calibratedReflectanceTargetInputField;
    private final BreezeInfoPanel darkReferenceDisabledWarning;
    private final ReferenceCachePanel.ReferenceDelayInputField.Dark darkRefDelayInputField;
    private final ReferenceCachePanel.ReferenceDelayInputField.White whiteRefDelayInputField;

    public ReferencesSettingsPanel(MaintenancePanel maintenancePanel) {
        super(maintenancePanel);
        this.setLayout(new BorderLayout());
        this.hardwareSidePanel = maintenancePanel.getHardwareSidePanel();
        this.hardwareSidePanel.setType(HardwareSidePanel.HardwareType.Measurement);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(BreezeTheme.getInstance().getPanelBackground());
        this.add(new BreezeScrollPane(jPanel), "Center");
        this.numberOfWhiteReferenceFramesInputField = this.getReferenceFramesInputField(maintenancePanel, ReferenceFile.RuntimeReference.White);
        this.numberOfWhiteReferenceFramesInputField.setName("referenceframes");
        this.numberOfDarkReferenceFramesInputField = this.getReferenceFramesInputField(maintenancePanel, ReferenceFile.RuntimeReference.Dark);
        this.numberOfDarkReferenceFramesInputField.setName("referencedarkframes");
        ReferenceSettings.ReferenceAction referenceAction = BreezeProperties.getInstance().getDarkReferenceCaptureMode();
        this.darkReferenceDisabledWarning = new BreezeInfoPanel(BreezeInfoPanel.InfoType.Warning, "Using cached dark reference when a camera has an automatic shutter is not recommended");
        this.darkReferenceDisabledWarning.setVisible(referenceAction == ReferenceSettings.ReferenceAction.UseStored && this.hasCamerasUsingShutterReferences());
        if (this.getFrame().getProduct().equals((Object)UpdateHelper.Product.BreezeRuntimeClient)) {
            this.runtimeRecordMaxFramesInputField = new BreezeSpinnerInputPanel("Breeze Runtime Client - Record max length", "", 1.0f, 9999999.0f, 1.0f, BreezeProperties.getInstance().getMaxFrameCount().value, "frames", d -> {
                BreezeProperties.getInstance().setMaxFrameCount(new FrameCount(d.intValue()));
                maintenancePanel.repaintEntryList();
            });
            ReferencesSettingsPanel.addPanel(jPanel, this.runtimeRecordMaxFramesInputField, false);
            this.runtimeRecordMaxFramesInputField.setUnitLabelWidth(100);
            this.runtimeRecordMaxFramesInputField.setName("maxframecount");
        } else {
            this.runtimeRecordMaxFramesInputField = null;
        }
        CollapsePanel.NoExpandCollapsePanel noExpandCollapsePanel = new CollapsePanel.NoExpandCollapsePanel("Dark reference");
        noExpandCollapsePanel.setUnitWidth(60);
        noExpandCollapsePanel.setFont(new Font("Tahoma", 1, 14));
        noExpandCollapsePanel.addPanel(this.numberOfDarkReferenceFramesInputField);
        noExpandCollapsePanel.addPanel(this.getReferenceCaptureComboBox(true));
        noExpandCollapsePanel.addPanel(this.darkReferenceDisabledWarning);
        this.darkRefDelayInputField = new ReferenceCachePanel.ReferenceDelayInputField.Dark(maintenancePanel);
        this.darkRefDelayInputField.setName("darkRefDelayInputField");
        this.darkRefDelayInputField.setEnabled(referenceAction == ReferenceSettings.ReferenceAction.UseStored);
        noExpandCollapsePanel.addPanel(this.darkRefDelayInputField);
        ReferencesSettingsPanel.addPanel(jPanel, noExpandCollapsePanel, false);
        CollapsePanel.NoExpandCollapsePanel noExpandCollapsePanel2 = new CollapsePanel.NoExpandCollapsePanel("White reference");
        noExpandCollapsePanel2.setUnitWidth(60);
        noExpandCollapsePanel2.setFont(new Font("Tahoma", 1, 14));
        noExpandCollapsePanel2.addPanel(this.numberOfWhiteReferenceFramesInputField);
        this.calibratedReflectanceTargetInputField = new HySpexCamera.CalibratedReflectanceTargetInputField((Component)maintenancePanel, "Calibrated white reflectance target", BreezeInputFieldHelper.Format.OneRow);
        this.calibratedReflectanceTargetInputField.setVisible(false);
        noExpandCollapsePanel2.addPanel(this.calibratedReflectanceTargetInputField);
        noExpandCollapsePanel2.addPanel(this.getReferenceCaptureComboBox(false));
        this.whiteRefDelayInputField = new ReferenceCachePanel.ReferenceDelayInputField.White(maintenancePanel);
        this.whiteRefDelayInputField.setName("whiteRefDelayInputField");
        this.whiteRefDelayInputField.setEnabled(BreezeProperties.getInstance().getWhiteReferenceCaptureMode() == ReferenceSettings.ReferenceAction.UseStored);
        noExpandCollapsePanel2.addPanel(this.whiteRefDelayInputField);
        ReferencesSettingsPanel.addPanel(jPanel, new JPanel(), false);
        ReferencesSettingsPanel.addPanel(jPanel, noExpandCollapsePanel2, false);
        ReferencesSettingsPanel.addPanel(jPanel, new JPanel(), false);
        CollapsePanel.NoExpandCollapsePanel noExpandCollapsePanel3 = new CollapsePanel.NoExpandCollapsePanel("Cache management for stored White and Dark references");
        noExpandCollapsePanel3.addPanel(new BreezeLabel("References for different integration times are cached per camera.", false, 14));
        this.referenceCachePanel = new ReferenceCachePanel(maintenancePanel, this.whiteRefDelayInputField, this.darkRefDelayInputField);
        noExpandCollapsePanel3.addPanel(this.referenceCachePanel);
        ReferencesSettingsPanel.addPanel(jPanel, noExpandCollapsePanel3, false);
        CollapsePanel collapsePanel = new CollapsePanel("Advanced");
        collapsePanel.addPanel(new BreezeCheckBox("Require retaking references when integration time has changed", BreezeProperties.getInstance().isReferenceCacheIntegrationTimeCheck(), bl -> {
            BreezeProperties.getInstance().setReferenceCacheIntegrationTimeCheck(bl);
            TcpManager.getInstance().setProperty("UpdateReferenceCache", "");
        }));
        collapsePanel.addPanel(new BreezeCheckBox("Show \"Take Dark Reference\" dialog before recording", BreezeProperties.getInstance().showDarkReferenceWizardStep(), BreezeProperties.getInstance()::setShowDarkReferenceWizardStep));
        BreezeCheckBox.ConfirmBreezeCheckBox confirmBreezeCheckBox = new BreezeCheckBox.ConfirmBreezeCheckBox("Perform Breeze reference quality verification", BreezeProperties.getInstance().verifyReferenceQuality(), this, "Confirm disabling reference quality verification", "Using poor references results in poor measurement quality. Confirm that you want to disable Breeze from verifying the reference quality when it is captured. This can be useful if you have hardware that has bad pixels that are always oversaturated", bl -> BreezeProperties.getInstance().setVerifyReferenceQuality(bl), true);
        collapsePanel.addPanel(new BreezeExternalLinkPanel(confirmBreezeCheckBox, "dark-and-white-references"));
        collapsePanel.addPanel(new BreezeCheckBox("Perform Runtime reference quality verification", BreezeProperties.getInstance().enableRuntimeQualityChecks(), bl -> {
            BreezeProperties.getInstance().setEnableRuntimeQualityChecks(bl);
            BreezeProperties.getInstance().save();
        }));
        BreezeCheckBox.ConfirmBreezeCheckBox confirmBreezeCheckBox2 = new BreezeCheckBox.ConfirmBreezeCheckBox("Store references as average values and images, to optimize disk usage", BreezeProperties.getInstance().useCompressedReferences(), this, "Confirm store references as averages only", "Enabling this option will store future references as an average value, losing individual reference details across the spatial and spectral dimensions. Existing references won't be affected. Press OK to proceed", bl -> BreezeProperties.getInstance().setUseCompressedReferences(bl), false);
        collapsePanel.addPanel(new BreezeExternalLinkPanel(confirmBreezeCheckBox2, "reference-averaging"));
        collapsePanel.addPanel(new BreezeLabel("Reference quality settings:", false, 14));
        EntryWithSave entryWithSave = () -> BreezeProperties.getInstance().save();
        XmlPropertyViewPanel xmlPropertyViewPanel = new XmlPropertyViewPanel(maintenancePanel, entryWithSave);
        collapsePanel.addPanel((JComponent)((Object)xmlPropertyViewPanel));
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(BreezeProperties.getInstance().getPropertyNode("measurement/referenceQuality/edgePercent"));
        arrayList.add(BreezeProperties.getInstance().getPropertyNode("measurement/referenceQuality/darkMaxSignal"));
        arrayList.add(BreezeProperties.getInstance().getPropertyNode("measurement/referenceQuality/whiteMinSignal"));
        arrayList.add(BreezeProperties.getInstance().getPropertyNode("measurement/referenceQuality/whiteMaxSignal"));
        arrayList.add(BreezeProperties.getInstance().getPropertyNode("measurement/referenceQuality/whitePixelVariation"));
        arrayList.add(BreezeProperties.getInstance().getPropertyNode("measurement/referenceQuality/maxLineVariation"));
        xmlPropertyViewPanel.updatePanel(null, arrayList);
        ReferencesSettingsPanel.addPanel(jPanel, collapsePanel, false);
        ReferencesSettingsPanel.addPanel(jPanel, new JPanel(), true);
    }

    private BreezeComboBoxInputField<ReferenceSettings.ReferenceAction> getReferenceCaptureComboBox(boolean bl) {
        BreezeComboBoxInputField<ReferenceSettings.ReferenceAction> breezeComboBoxInputField = new BreezeComboBoxInputField<ReferenceSettings.ReferenceAction>("Select the reference capture mode", " ", BreezeInputFieldHelper.Format.OneRow);
        breezeComboBoxInputField.addItem(ReferenceSettings.ReferenceAction.CaptureNew);
        breezeComboBoxInputField.addItem(ReferenceSettings.ReferenceAction.UseStored);
        if (!bl || WorkspaceManager.GUITEST) {
            breezeComboBoxInputField.addItem(ReferenceSettings.ReferenceAction.Disable);
        }
        breezeComboBoxInputField.setSelectedItem(bl ? BreezeProperties.getInstance().getDarkReferenceCaptureMode() : BreezeProperties.getInstance().getWhiteReferenceCaptureMode());
        breezeComboBoxInputField.setChangedListener(referenceAction -> {
            boolean bl2;
            boolean bl3 = bl2 = referenceAction == ReferenceSettings.ReferenceAction.UseStored;
            if (bl) {
                BreezeProperties.getInstance().setDarkReferenceCaptureMode((ReferenceSettings.ReferenceAction)((Object)referenceAction));
                this.darkReferenceDisabledWarning.setVisible(bl2 && this.hasCamerasUsingShutterReferences());
                this.darkRefDelayInputField.setEnabled(bl2);
            } else {
                BreezeProperties.getInstance().setWhiteReferenceCaptureMode((ReferenceSettings.ReferenceAction)((Object)referenceAction));
                this.whiteRefDelayInputField.setEnabled(bl2);
            }
        });
        return breezeComboBoxInputField;
    }

    private boolean hasCamerasUsingShutterReferences() {
        return HardwareRegistry.getInstance().getCamerasForRecord().stream().anyMatch(camera -> camera.hasShutter() && camera.useReferencesWhenRecordingWithThisCamera());
    }

    private BreezeSpinnerInputPanel getReferenceFramesInputField(MaintenancePanel maintenancePanel, ReferenceFile.RuntimeReference runtimeReference) {
        return new BreezeSpinnerInputPanel("Number of frames", "", 1.0f, 999999.0f, 1.0f, runtimeReference == ReferenceFile.RuntimeReference.Dark ? BreezeProperties.getInstance().getDarkReferenceFrames().value : BreezeProperties.getInstance().getWhiteReferenceFrames().value, BreezeInputFieldHelper.Format.OneRow, BreezeSpinner.NumberInputLocation.LEFT, "frames", d -> {
            if (runtimeReference == ReferenceFile.RuntimeReference.White) {
                BreezeProperties.getInstance().setWhiteReferenceFrames(new FrameCount(d.intValue()));
            } else if (runtimeReference == ReferenceFile.RuntimeReference.Dark) {
                BreezeProperties.getInstance().setDarkReferenceFrames(new FrameCount(d.intValue()));
            }
            TcpManager.getInstance().measurementSettingsChanged();
            maintenancePanel.repaintEntryList();
        });
    }

    @Override
    public boolean showRightSettingsPanel() {
        return BreezeProperties.getInstance().isShowHardwareSettings();
    }

    @Override
    public String getType() {
        return "Measurement";
    }

    @Override
    public void setBgColor(Color color) {
        super.setBgColor(color);
    }

    private Camera getSelectedCamera() {
        return ((MaintenancePanel)this.mainpanel).getSelectedCamera();
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.numberOfWhiteReferenceFramesInputField.setValue(BreezeProperties.getInstance().getWhiteReferenceFrames().value);
        this.numberOfDarkReferenceFramesInputField.setValue(BreezeProperties.getInstance().getDarkReferenceFrames().value);
        if (this.runtimeRecordMaxFramesInputField != null) {
            this.runtimeRecordMaxFramesInputField.setValue(BreezeProperties.getInstance().getMaxFrameCount().value);
        }
        this.referenceCachePanel.showEntry();
        Camera camera = this.getSelectedCamera();
        this.hardwareSidePanel.setCameras();
        this.hardwareSidePanel.setSampleMover(HardwareRegistry.getInstance().getSampleMover());
        if (camera instanceof Camera.WhiteReferenceIntensity) {
            Camera.WhiteReferenceIntensity whiteReferenceIntensity = (Camera.WhiteReferenceIntensity)camera;
            this.calibratedReflectanceTargetInputField.getTextField().clearChangeListeners();
            this.calibratedReflectanceTargetInputField.setFile(whiteReferenceIntensity.getWhiteReferenceTargetFile());
            this.calibratedReflectanceTargetInputField.getTextField().addChangeListener(textActionEvent -> {
                for (Camera camera : HardwareRegistry.getInstance().getCameras()) {
                    if (!(camera instanceof Camera.WhiteReferenceIntensity)) continue;
                    Camera.WhiteReferenceIntensity whiteReferenceIntensity = (Camera.WhiteReferenceIntensity)camera;
                    whiteReferenceIntensity.setWhiteReferenceTargetFile(new FileFromAbsolutePath(textActionEvent.getText()).fileOrNull());
                }
            });
            this.calibratedReflectanceTargetInputField.setVisible(true);
        } else {
            this.calibratedReflectanceTargetInputField.setVisible(false);
        }
    }

    @Override
    public WizardStep.LeaveResult leaveEntry(WizardStep.LeaveControlCallback leaveControlCallback) {
        this.referenceCachePanel.leaveEntry();
        return WizardStep.LeaveResult.Ok;
    }

    public String toString() {
        File file = this.calibratedReflectanceTargetInputField.getFile();
        Object object = "";
        if (file != null) {
            object = " (" + FileHelper.getFileName(file) + ")";
        }
        return String.format("Dark %s, White %s%s", BreezeProperties.getInstance().getDarkReferenceDelay().toCompactNiceString(), BreezeProperties.getInstance().getWhiteReferenceDelay().toCompactNiceString(), object);
    }

    public static void addPanel(JPanel jPanel, JComponent jComponent, boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        if (bl) {
            gridBagConstraints.weighty = 1.0;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = jPanel.getComponentCount();
        gridBagConstraints.insets = new Insets(jPanel.getComponentCount() > 0 ? 10 : 0, 0, 0, 0);
        jComponent.setOpaque(false);
        jPanel.add((Component)jComponent, gridBagConstraints);
    }
}

