/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.measurement;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.CachedRawFile;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.evince.data.SpectralMatrixCache;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Project_GUI;

public class SpectralReferences {
    public final SpectralReference.DarkReference darkReference;
    public final SpectralReference.WhiteReference whiteReference;
    private Measurement measurement;
    private MaxSignal maxSignal;
    private final SpectralMatrixCache cache = new SpectralMatrixCache();

    public SpectralReferences(Camera camera) {
        List<RawFrame> list;
        this.darkReference = camera.getDarkReference();
        this.whiteReference = camera.getWhiteReference();
        boolean bl = Camera.isXray(camera);
        if (camera.isConnected()) {
            this.maxSignal = camera.getMaxsignal();
        } else if (this.whiteReference != null) {
            if (bl) {
                this.maxSignal = new MaxSignal(65535.0f);
            } else {
                list = this.whiteReference.readFrames();
                if (list.size() > 0) {
                    RgbBands rgbBands = new RgbBands(List.of(Integer.valueOf(list.get((int)0).rows.value / 2)));
                    this.maxSignal = new MaxSignal(this.whiteReference.readFrames(), rgbBands, true);
                }
            }
        }
        list = new CachedRawFile(new ArrayList<RawFrame>(), new RawHeader(camera), null);
        this.measurement = new MeasurementWithoutIO(this, (CachedRawFile)((Object)list), bl){
            final /* synthetic */ CachedRawFile val$rawFile;
            final /* synthetic */ boolean val$xray;
            final /* synthetic */ SpectralReferences this$0;
            {
                this.val$rawFile = cachedRawFile;
                this.val$xray = bl;
                this.this$0 = spectralReferences;
            }

            @Override
            public RawFile rawFile() {
                return this.val$rawFile;
            }

            @Override
            public SpectralReference.WhiteReference whiteReference() {
                return this.this$0.whiteReference;
            }

            @Override
            public SpectralReference.DarkReference darkReference() {
                return this.this$0.darkReference;
            }

            @Override
            public MaxSignal getMaxSignal() {
                return this.this$0.maxSignal;
            }

            @Override
            public boolean isXrayData() {
                return this.val$xray;
            }
        };
    }

    public SpectralReferences(Measurement measurement) {
        this.measurement = measurement;
        this.darkReference = measurement.darkReference();
        this.whiteReference = measurement.whiteReference();
        this.maxSignal = measurement.getMaxSignal();
    }

    public AbstractDataMatrix getInmatrix(Project_GUI project_GUI, BreezeProgressManager breezeProgressManager, String string) {
        return this.cache.getMatrix(this.measurement, string);
    }

    public MaxSignal getMaxSignal() {
        if (this.maxSignal != null) {
            return this.maxSignal;
        }
        return new MaxSignal(65000.0f);
    }
}

