/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.sensor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.util.raw.GenericGridTiler;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandRectangle;

public abstract class InsetsPanel
extends JPanel {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    private InsetsChanged insetsChanged;
    private boolean enabled = true;
    private final int[] insetsArray = new int[4];
    private final double[][] tpos = new double[8][2];
    private int tadjusting = -1;
    private int handleSize = 10;
    private int imageWidth;
    private int imageHeight;
    private final BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 10.0f);
    private GeneralPath triangle;
    private final RubberbandRectangle rubberBand;
    private InsetsType typeForThisPanel = InsetsType.Segmentation;
    private boolean gridEnabled = false;
    private int gridRows = 1;
    private int gridColumns = 1;
    private boolean aspectRatio = true;
    private double baseZoomX = 1.0;
    private double baseZoomY = 1.0;
    public double zoomMul = 1.0;
    private double viewX = 0.0;
    private double viewY = 0.0;
    private double minZoomMul = 1.0;
    private final double maxZoomMul = 8.0;
    private Point panAnchor = null;
    public boolean rubberbandZoomEnabled = false;

    public void setInsetsChanged(InsetsChanged insetsChanged) {
        this.insetsChanged = insetsChanged;
    }

    public void setInsetsEnabled(boolean bl) {
        this.enabled = bl;
        this.repaint();
    }

    public int[] getInsetsArray() {
        return this.insetsArray;
    }

    public void setGrid(boolean bl) {
        this.gridEnabled = bl;
        this.repaint();
    }

    public void setGrid(int n, int n2) {
        this.gridRows = n;
        this.gridColumns = n2;
        this.repaint();
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public int getGridRows() {
        return this.gridRows;
    }

    public int getGridColumns() {
        return this.gridColumns;
    }

    public boolean hasGrid() {
        return this.gridEnabled && (this.gridRows > 1 || this.gridColumns > 1);
    }

    public void copyInsets(InsetsPanel insetsPanel) {
        System.arraycopy(this.insetsArray, 0, insetsPanel.insetsArray, 0, this.insetsArray.length);
        insetsPanel.gridEnabled = this.gridEnabled;
        insetsPanel.gridColumns = this.gridColumns;
        insetsPanel.gridRows = this.gridRows;
    }

    public void setRubberbandZoomEnabled(boolean bl) {
        this.rubberbandZoomEnabled = bl;
    }

    public Point getViewOrigin() {
        return new Point(this.ox(), this.oy());
    }

    public double getZoomFactor() {
        return this.zoomMul;
    }

    public void setImageSize(int n, int n2) {
        this.imageWidth = Math.max(1, n);
        this.imageHeight = Math.max(1, n2);
        this.recomputeBaseZooms();
        this.ensureMinZoom();
        this.clampView();
        this.repaint();
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.insetsArray[0] = n;
        this.insetsArray[2] = n2;
        this.insetsArray[1] = n3;
        this.insetsArray[3] = n4;
        this.insetsChanged(this.imageWidth, this.imageHeight, this.typeForThisPanel);
    }

    public void setInsets(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.insetsArray[i] = nArray[i];
        }
        this.insetsChanged(this.imageWidth, this.imageHeight, this.typeForThisPanel);
    }

    public void setType(InsetsType insetsType) {
        this.typeForThisPanel = insetsType;
    }

    public void setAspectRatio(boolean bl) {
        this.aspectRatio = bl;
        this.recomputeBaseZooms();
        this.ensureMinZoom();
        this.clampView();
        this.repaint();
    }

    public boolean shouldCrop() {
        if (this.hasGrid()) {
            return true;
        }
        for (int n : this.insetsArray) {
            if (n <= 0) continue;
            return true;
        }
        return false;
    }

    public double getPercentCropped() {
        int n = this.imageWidth * this.imageHeight;
        int n2 = (this.imageWidth - this.insetsArray[2] - this.insetsArray[3]) * (this.imageHeight - this.insetsArray[0] - this.insetsArray[1]);
        return n == 0 ? 1.0 : (double)n2 / (double)n;
    }

    public InsetsPanel() {
        this(1600, 1000, InsetsType.Segmentation);
    }

    public InsetsPanel(final int n, final int n2, InsetsType insetsType) {
        this.imageWidth = Math.max(1, n);
        this.imageHeight = Math.max(1, n2);
        this.typeForThisPanel = insetsType;
        this.setOpaque(false);
        this.setFocusable(true);
        this.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ InsetsPanel this$0;
            {
                this.this$0 = insetsPanel;
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (!this.this$0.enabled || this.this$0.rubberBand.isActive() || mouseEvent.isShiftDown()) {
                    return;
                }
                this.this$0.updateHandleHover(mouseEvent.getPoint());
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (this.this$0.panAnchor != null) {
                    this.this$0.viewX += (double)(mouseEvent.getX() - this.this$0.panAnchor.x);
                    this.this$0.viewY += (double)(mouseEvent.getY() - this.this$0.panAnchor.y);
                    this.this$0.panAnchor = mouseEvent.getPoint();
                    this.this$0.clampView();
                    this.this$0.repaint();
                    return;
                }
                if (this.this$0.rubberBand.isActive()) {
                    return;
                }
                if (this.this$0.tadjusting >= 0) {
                    Point point = mouseEvent.getPoint();
                    double d = this.this$0.screenToWorldX(point.x);
                    double d2 = this.this$0.screenToWorldY(point.y);
                    switch (this.this$0.tadjusting) {
                        case 0: {
                            this.this$0.insetsArray[0] = (int)Math.round(d2);
                            break;
                        }
                        case 1: {
                            this.this$0.insetsArray[1] = (int)Math.round((double)n2 - d2);
                            break;
                        }
                        case 2: {
                            this.this$0.insetsArray[2] = (int)Math.round(d);
                            break;
                        }
                        case 3: {
                            this.this$0.insetsArray[3] = (int)Math.round((double)n - d);
                        }
                    }
                    this.this$0.insetsChanged(n, n2, this.this$0.typeForThisPanel);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ InsetsPanel this$0;
            {
                this.this$0 = insetsPanel;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                    this.this$0.panAnchor = mouseEvent.getPoint();
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isShiftDown()) {
                    this.this$0.rubberBand.setActive(true);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                    this.this$0.panAnchor = null;
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.this$0.rubberBand.isActive()) {
                    this.this$0.rubberBand.setActive(false);
                    Rectangle rectangle = this.this$0.rubberBand.getBoundingBox();
                    if (rectangle.width <= 2 || rectangle.height <= 2) {
                        return;
                    }
                    if (this.this$0.rubberbandZoomEnabled) {
                        double d;
                        double d2 = this.this$0.zoomMul;
                        double d3 = (double)this.this$0.contentWidth() / (double)rectangle.width;
                        double d4 = (double)this.this$0.contentHeight() / (double)rectangle.height;
                        double d5 = InsetsPanel.clamp(d2 * Math.min(d3, d4), this.this$0.minZoomMul, 8.0);
                        double d6 = rectangle.getCenterX();
                        double d7 = rectangle.getCenterY();
                        double d8 = d = d5 / d2;
                        double d9 = this.this$0.ox();
                        double d10 = this.this$0.oy();
                        double d11 = d6 - (d6 - d9) * d;
                        double d12 = d7 - (d7 - d10) * d8;
                        this.this$0.zoomMul = d5;
                        this.this$0.viewX = d11 - (double)this.this$0.handleSize;
                        this.this$0.viewY = d12 - (double)this.this$0.handleSize;
                        this.this$0.clampView();
                        this.this$0.repaint();
                    } else {
                        double d = this.this$0.screenToWorldX(rectangle.x);
                        double d13 = this.this$0.screenToWorldY(rectangle.y);
                        double d14 = this.this$0.screenToWorldX(rectangle.x + rectangle.width);
                        double d15 = this.this$0.screenToWorldY(rectangle.y + rectangle.height);
                        d = InsetsPanel.clamp(d, 0.0, n);
                        d14 = InsetsPanel.clamp(d14, 0.0, n);
                        d13 = InsetsPanel.clamp(d13, 0.0, n2);
                        d15 = InsetsPanel.clamp(d15, 0.0, n2);
                        double d16 = Math.min(d, d14);
                        double d17 = Math.max(d, d14);
                        double d18 = Math.min(d13, d15);
                        double d19 = Math.max(d13, d15);
                        this.this$0.insetsArray[2] = (int)Math.round(d16);
                        this.this$0.insetsArray[3] = (int)Math.round((double)n - d17);
                        this.this$0.insetsArray[0] = (int)Math.round(d18);
                        this.this$0.insetsArray[1] = (int)Math.round((double)n2 - d19);
                        this.this$0.insetsChanged(n, n2, this.this$0.typeForThisPanel);
                    }
                }
            }
        });
        this.addMouseWheelListener(mouseWheelEvent -> {
            double d;
            if (!this.enabled) {
                return;
            }
            double d2 = this.zoomMul;
            double d3 = Math.pow(1.1, -mouseWheelEvent.getPreciseWheelRotation());
            double d4 = InsetsPanel.clamp(d2 * d3, this.minZoomMul, 8.0);
            if (d4 == d2) {
                return;
            }
            Point point = mouseWheelEvent.getPoint();
            double d5 = d = d4 / d2;
            double d6 = this.ox();
            double d7 = this.oy();
            double d8 = (double)point.x - ((double)point.x - d6) * d;
            double d9 = (double)point.y - ((double)point.y - d7) * d5;
            this.zoomMul = d4;
            this.viewX = d8 - (double)this.handleSize;
            this.viewY = d9 - (double)this.handleSize;
            this.clampView();
            this.repaint();
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                InsetsPanel.this.recomputeBaseZooms();
                InsetsPanel.this.ensureMinZoom();
                InsetsPanel.this.clampView();
                InsetsPanel.this.repaint();
            }
        });
        this.setHandleSize(10);
        this.rubberBand = new RubberbandRectangle((Component)this);
        this.recomputeBaseZooms();
        this.ensureMinZoom();
    }

    public int getHandleSize() {
        return this.handleSize;
    }

    public void setHandleSize(int n) {
        this.handleSize = n;
        this.triangle = new GeneralPath();
        this.triangle.moveTo(0.0f, 0.0f);
        this.triangle.lineTo(n, n);
        this.triangle.lineTo(n, -n);
        this.triangle.closePath();
    }

    private double zoomX() {
        return this.baseZoomX * this.zoomMul;
    }

    private double zoomY() {
        return this.baseZoomY * this.zoomMul;
    }

    private int ox() {
        return this.handleSize + (int)Math.round(this.viewX);
    }

    private int oy() {
        return this.handleSize + (int)Math.round(this.viewY);
    }

    private double screenToWorldX(double d) {
        return (d - (double)this.ox()) / this.zoomX();
    }

    private double screenToWorldY(double d) {
        return (d - (double)this.oy()) / this.zoomY();
    }

    private int worldToScreenX(double d) {
        return (int)Math.round((double)this.ox() + d * this.zoomX());
    }

    private int worldToScreenY(double d) {
        return (int)Math.round((double)this.oy() + d * this.zoomY());
    }

    private int contentLeft() {
        return this.handleSize;
    }

    private int contentTop() {
        return this.handleSize;
    }

    private int contentWidth() {
        return this.getWidth() - 2 * this.handleSize;
    }

    private int contentHeight() {
        return this.getHeight() - 2 * this.handleSize;
    }

    public void recomputeBaseZooms() {
        double d = (double)this.contentWidth() / (double)Math.max(1, this.imageWidth);
        double d2 = (double)this.contentHeight() / (double)Math.max(1, this.imageHeight);
        if (this.aspectRatio) {
            double d3;
            this.baseZoomX = d3 = Math.min(d, d2);
            this.baseZoomY = d3;
        } else {
            this.baseZoomX = d;
            this.baseZoomY = d2;
        }
        this.minZoomMul = 1.0;
    }

    private void ensureMinZoom() {
        if (this.zoomMul < this.minZoomMul) {
            this.zoomMul = this.minZoomMul;
        }
    }

    public void clampView() {
        double d;
        int n = this.contentWidth();
        int n2 = this.contentHeight();
        int n3 = (int)Math.round((double)this.imageWidth * this.zoomX());
        int n4 = (int)Math.round((double)this.imageHeight * this.zoomY());
        if (n3 <= n) {
            this.viewX = (double)(n - n3) / 2.0;
        } else {
            d = n - n3;
            this.viewX = Math.max(d, Math.min(0.0, this.viewX));
        }
        if (n4 <= n2) {
            this.viewY = (double)(n2 - n4) / 2.0;
        } else {
            d = n2 - n4;
            this.viewY = Math.max(d, Math.min(0.0, this.viewY));
        }
    }

    private static double clamp(double d, double d2, double d3) {
        return Math.max(d2, Math.min(d3, d));
    }

    private static int clampInt(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n3, n));
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawContent(graphics2D);
    }

    public void drawContent(Graphics2D graphics2D) {
        if (!this.enabled) {
            return;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setColor(BreezeTheme.getInstance().getPanelBackground());
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n = (int)Math.round((double)this.imageWidth * this.zoomX());
        int n2 = (int)Math.round((double)this.imageHeight * this.zoomY());
        int n3 = this.ox();
        int n4 = this.oy();
        this.drawContent(graphics2D, n3, n4, n, n2);
        this.drawLines(graphics2D, n3, n4, n, n2, this.zoomX(), this.zoomY());
        for (int i = 0; i < 8; ++i) {
            this.drawTriangle(graphics2D, i);
        }
    }

    public abstract void drawContent(Graphics2D var1, int var2, int var3, int var4, int var5);

    public void drawLines(Graphics2D graphics2D, int n7, int n8, int n9, int n10, double d, double d2) {
        int n11 = this.worldToScreenX(this.insetsArray[2]);
        int n12 = this.worldToScreenX(this.imageWidth - this.insetsArray[3]);
        int n13 = this.worldToScreenY(this.insetsArray[0]);
        int n14 = this.worldToScreenY(this.imageHeight - this.insetsArray[1]);
        int n15 = this.contentLeft();
        int n16 = this.contentTop();
        int n17 = n15 + this.contentWidth() - 1;
        int n18 = n16 + this.contentHeight() - 1;
        int n19 = n7;
        int n20 = n8;
        int n21 = n7 + n9 - 1;
        int n22 = n8 + n10 - 1;
        int n23 = InsetsPanel.clampInt(n11, n19, n21);
        int n24 = InsetsPanel.clampInt(n12, n19, n21);
        int n25 = InsetsPanel.clampInt(n13, n20, n22);
        int n26 = InsetsPanel.clampInt(n14, n20, n22);
        graphics2D.setStroke(this.stroke);
        graphics2D.setColor(new Color(100, 100, 100, 150));
        if (this.insetsArray[0] > 0) {
            graphics2D.fillRect(n23, n20, Math.max(0, n24 - n23), Math.max(0, n25 - n20));
        }
        if (this.insetsArray[2] > 0) {
            graphics2D.fillRect(n19, n20, Math.max(0, n23 - n19), Math.max(0, n22 - n20));
        }
        if (this.insetsArray[1] > 0) {
            graphics2D.fillRect(n23, n26 + 1, Math.max(0, n24 - n23), Math.max(0, n22 - n26));
        }
        if (this.insetsArray[3] > 0) {
            graphics2D.fillRect(n24 + 1, n20, Math.max(0, n21 - n24), Math.max(0, n22 - n20));
        }
        if (this.hasGrid()) {
            graphics2D.setColor(Color.YELLOW);
            try {
                GenericGridTiler.split(n23, n25, n24, n26, this.gridColumns, this.gridRows, (n, n2, n3, n4, n5, n6) -> {
                    graphics2D.drawLine(n, n2, n, n4);
                    graphics2D.drawLine(n, n4, n3, n4);
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        graphics2D.setColor(Color.RED);
        graphics2D.drawLine(n15, n13, n17, n13);
        graphics2D.drawLine(n15, n14, n17, n14);
        graphics2D.drawLine(n11, n16, n11, n18);
        graphics2D.drawLine(n12, n16, n12, n18);
    }

    private void drawTriangle(Graphics2D graphics2D, int n) {
        AffineTransform affineTransform = graphics2D.getTransform();
        int n2 = this.worldToScreenX(this.insetsArray[2]);
        int n3 = this.worldToScreenX(this.imageWidth - this.insetsArray[3]);
        int n4 = this.worldToScreenY(this.insetsArray[0]);
        int n5 = this.worldToScreenY(this.imageHeight - this.insetsArray[1]);
        int n6 = this.ox();
        int n7 = this.oy();
        int n8 = (int)Math.round((double)this.imageWidth * this.zoomX());
        int n9 = (int)Math.round((double)this.imageHeight * this.zoomY());
        int n10 = n6;
        int n11 = n7;
        int n12 = n6 + n8 - 1;
        int n13 = n7 + n9 - 1;
        n2 = InsetsPanel.clampInt(n2, n10, n12);
        n3 = InsetsPanel.clampInt(n3, n10, n12);
        n4 = InsetsPanel.clampInt(n4, n11, n13);
        n5 = InsetsPanel.clampInt(n5, n11, n13);
        int n14 = this.getWidth() - 1;
        int n15 = this.getHeight() - 1;
        this.tpos[0][0] = this.handleSize;
        this.tpos[0][1] = n4;
        this.tpos[1][0] = n14 - this.handleSize;
        this.tpos[1][1] = n4;
        this.tpos[2][0] = this.handleSize;
        this.tpos[2][1] = n5;
        this.tpos[3][0] = n14 - this.handleSize;
        this.tpos[3][1] = n5;
        this.tpos[4][0] = n2;
        this.tpos[4][1] = this.handleSize;
        this.tpos[5][0] = n2;
        this.tpos[5][1] = n15 - this.handleSize;
        this.tpos[6][0] = n3;
        this.tpos[6][1] = this.handleSize;
        this.tpos[7][0] = n3;
        this.tpos[7][1] = n15 - this.handleSize;
        graphics2D.setColor(Color.RED);
        graphics2D.translate(this.tpos[n][0], this.tpos[n][1]);
        switch (n) {
            case 0: 
            case 2: {
                graphics2D.rotate(Math.PI);
                break;
            }
            case 4: 
            case 6: {
                graphics2D.rotate(4.71238898038469);
                break;
            }
            case 5: 
            case 7: {
                graphics2D.rotate(1.5707963267948966);
            }
        }
        graphics2D.fill(this.triangle);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.triangle);
        graphics2D.setTransform(affineTransform);
    }

    private void updateHandleHover(Point point) {
        this.tadjusting = -1;
        for (int i = 0; i < this.insetsArray.length; ++i) {
            double d;
            int n = i * 2;
            double d2 = d = i < 2 ? Math.abs((double)point.y - this.tpos[n][1]) : Math.abs((double)point.x - this.tpos[n][0]);
            if (!(d < (double)(this.handleSize * 2))) continue;
            this.tadjusting = i;
            break;
        }
        if (this.tadjusting == -1) {
            this.setCursor(Cursor.getDefaultCursor());
        } else if (this.tadjusting == 0 || this.tadjusting == 1) {
            this.setCursor(Cursor.getPredefinedCursor(8));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(10));
        }
    }

    private void insetsChanged(int n, int n2, InsetsType insetsType) {
        if (!insetsType.equals((Object)InsetsType.HeightOnly)) {
            this.insetsArray[2] = (int)InsetsPanel.clamp(this.insetsArray[2], 0.0, n);
            this.insetsArray[3] = (int)InsetsPanel.clamp(this.insetsArray[3], 0.0, n);
        }
        if (!insetsType.equals((Object)InsetsType.WidthOnly)) {
            this.insetsArray[0] = (int)InsetsPanel.clamp(this.insetsArray[0], 0.0, n2);
            this.insetsArray[1] = (int)InsetsPanel.clamp(this.insetsArray[1], 0.0, n2);
        }
        if (this.insetsChanged != null) {
            this.insetsChanged.changed(Arrays.copyOf(this.insetsArray, 4));
        }
        this.repaint();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(() -> {
            JFrame jFrame = new JFrame("InsetsPanel demo");
            jFrame.setDefaultCloseOperation(3);
            InsetsPanel insetsPanel = new InsetsPanel(1600, 1000, InsetsType.Segmentation){

                @Override
                public void drawContent(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
                    BufferedImage bufferedImage = new BufferedImage(Math.max(1, n3), Math.max(1, n4), 1);
                    for (int i = 0; i < n4; ++i) {
                        int n5 = (int)(255.0 * (double)i / (double)Math.max(1, n4 - 1));
                        for (int j = 0; j < n3; ++j) {
                            int n6 = (int)(255.0 * (double)j / (double)Math.max(1, n3 - 1));
                            int n7 = n6 << 16 | n5 << 8 | 0x40;
                            bufferedImage.setRGB(j, i, n7);
                        }
                    }
                    graphics2D.drawImage((Image)bufferedImage, n, n2, null);
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.drawRect(n, n2, Math.max(0, n3 - 1), Math.max(0, n4 - 1));
                }
            };
            insetsPanel.setPreferredSize(new Dimension(1100, 700));
            insetsPanel.setAspectRatio(false);
            insetsPanel.setGrid(true);
            insetsPanel.setGrid(3, 4);
            insetsPanel.setInsetsChanged(nArray -> System.out.println("Insets: " + Arrays.toString(nArray)));
            insetsPanel.addKeyListener(new KeyAdapter(insetsPanel, jFrame){
                final /* synthetic */ 4 val$panel;
                final /* synthetic */ JFrame val$f;
                {
                    this.val$panel = var1_1;
                    this.val$f = jFrame;
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    switch (keyEvent.getKeyCode()) {
                        case 90: {
                            this.val$panel.setRubberbandZoomEnabled(!this.val$panel.rubberbandZoomEnabled);
                            this.val$f.setTitle("InsetsPanel demo - rubberbandZoom=" + this.val$panel.rubberbandZoomEnabled);
                            break;
                        }
                        case 82: {
                            this.val$panel.zoomMul = 1.0;
                            this.val$panel.clampView();
                            this.val$panel.repaint();
                            break;
                        }
                        case 67: {
                            this.val$panel.setInsets(0, 0, 0, 0);
                        }
                    }
                }
            });
            jFrame.setContentPane(insetsPanel);
            jFrame.pack();
            jFrame.setLocationRelativeTo(null);
            jFrame.setVisible(true);
            insetsPanel.requestFocusInWindow();
        });
    }

    public static interface InsetsChanged {
        public void changed(int[] var1);
    }

    public static enum InsetsType {
        WidthOnly,
        HeightOnly,
        Segmentation,
        Import,
        WhiteReference;

    }
}

