/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.sensor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import javax.swing.JPanel;
import se.prediktera.breeze.backend.grabber.CameraStreamAddOn;
import se.prediktera.breeze.backend.grabber.CameraStreamGrabber;
import se.prediktera.breeze.common.frame.DrReMatrix;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.frontend.common.swing.BreezeDescriptionButton;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.CameraPanelInfoText;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.frontend.main.settings.focus.HardwareSidePanel;
import se.prediktera.breeze.frontend.main.settings.integration.IntegrationPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.StateCamera;

public class SensorPanel
extends AbstractViewPanel
implements MaintenancePanel.ConnectCallback {
    private final CameraStreamGrabber grabber = new CameraStreamGrabber();
    private final SensorRealTimePanel sensorRealTimePanel = new SensorRealTimePanel();
    private final BreezeDescriptionButton captureButton = new BreezeDescriptionButton();
    private final BreezeDescriptionButton shutterButton = new BreezeDescriptionButton();
    private final IntegrationPanel.PreProcessingComboBoxInputField preProcessingComboBoxInputField = new IntegrationPanel.PreProcessingComboBoxInputField();
    private final HardwareSidePanel hardwareSidePanel;
    private float[][] darkMatrix;
    private float[][] reMatrixInversed;

    public SensorPanel(MaintenancePanel maintenancePanel) {
        super(maintenancePanel);
        this.hardwareSidePanel = maintenancePanel.getHardwareSidePanel();
        this.hardwareSidePanel.setType(HardwareSidePanel.HardwareType.Focus);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        this.captureButton.setDescription("Camera");
        this.captureButton.setName("sensorCamera");
        this.captureButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ((MaintenancePanel)SensorPanel.this.mainpanel).toggleCamera(SensorPanel.this.captureButton, SensorPanel.this.grabber, SensorPanel.this);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.captureButton, gridBagConstraints);
        this.shutterButton.setDescription("Shutter");
        this.shutterButton.setName("sensorShutter");
        this.shutterButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Camera camera = ((MaintenancePanel)SensorPanel.this.mainpanel).getSelectedCamera();
                if (camera != null && camera.hasShutter()) {
                    if (SensorPanel.this.shutterButton.isToggled()) {
                        camera.openShutter();
                    } else {
                        camera.closeShutter();
                    }
                }
                SensorPanel.this.updateShutterButton(camera);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.shutterButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        jPanel.add((Component)this.preProcessingComboBoxInputField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(20, 20, 0, 0);
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add(this.sensorRealTimePanel, gridBagConstraints);
        this.grabber.addOn(this.sensorRealTimePanel);
        this.captureButton.setToggled(false);
        this.captureButton.setBackground(this.mainpanel.getPageColor());
    }

    @Override
    public boolean showRightSettingsPanel() {
        return BreezeProperties.getInstance().isShowHardwareSettings();
    }

    @Override
    public String getType() {
        return "Sensor";
    }

    @Override
    public void setBgColor(Color color) {
        super.setBgColor(color);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        ((MaintenancePanel)this.mainpanel).enterPanel(this.captureButton, this.grabber, this);
    }

    @Override
    public void updateFromCamera(Camera camera, boolean bl) {
        this.hardwareSidePanel.setCameras();
        this.hardwareSidePanel.setSampleMover(null);
        this.updateShutterButton(camera);
        this.preProcessingComboBoxInputField.init(camera);
    }

    @Override
    public void afterConnection(Camera camera) {
        if (camera instanceof StateCamera && camera.useReferencesWhenRecordingWithThisCamera() && ((StateCamera)camera).autoChangeState() && camera instanceof RemoteCamera) {
            ((RemoteCamera)camera).getRemoteSettings().clear();
        }
        this.updateShutterButton(camera);
        DrReMatrix drReMatrix = camera.getDrReMatrix();
        this.darkMatrix = drReMatrix.getDarkMatrix();
        this.reMatrixInversed = drReMatrix.getReMatrixInversed();
    }

    private void updateShutterButton(Camera camera) {
        if (camera != null && camera.isConnected() && camera.hasShutter()) {
            this.shutterButton.setToggled(!camera.isShutterOpened());
            this.shutterButton.setEnabled(true);
        } else {
            this.shutterButton.setToggled(false);
            this.shutterButton.setEnabled(false);
        }
    }

    public String toString() {
        return "";
    }

    @Override
    public WizardStep.LeaveResult leaveEntry(WizardStep.LeaveControlCallback leaveControlCallback) {
        MaintenancePanel maintenancePanel = (MaintenancePanel)this.mainpanel;
        maintenancePanel.leavePanel(this.grabber);
        this.sensorRealTimePanel.reset();
        Camera camera = maintenancePanel.getSelectedCamera();
        if (camera != null && camera.isConnected() && !camera.isShutterOpened()) {
            camera.openShutter();
        }
        return WizardStep.LeaveResult.Ok;
    }

    private class SensorRealTimePanel
    extends JPanel
    implements CameraStreamAddOn {
        private final CameraPanelInfoText infoText = CameraPanelInfoText.PressCameraStart;
        private BufferedImage image;
        private byte[] data;
        private Camera camera;
        private long lastupdate = 0L;

        private SensorRealTimePanel() {
        }

        @Override
        public void init(Camera camera, FrameCount frameCount) {
            this.image = new BufferedImage(camera.getWidth().value, camera.getBandCount().value, 10);
            this.camera = camera;
            this.data = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
        }

        @Override
        public void apply(FrameStack frameStack) {
            long l = System.currentTimeMillis();
            if (l - this.lastupdate < 100L) {
                return;
            }
            this.lastupdate = l;
            float f = this.camera.getMaxsignal().inverted() * 255.0f;
            int n = SensorPanel.this.preProcessingComboBoxInputField.getSelectedIndex();
            RawFrame rawFrame = frameStack.getFrame();
            int n2 = 0;
            int n3 = this.camera.getWidth().value;
            int n4 = this.camera.getBandCount().value;
            if (n >= 1) {
                if (n == 2) {
                    for (int i = 0; i < n4; ++i) {
                        float[] fArray = SensorPanel.this.darkMatrix[i];
                        float[] fArray2 = SensorPanel.this.reMatrixInversed[i];
                        for (int j = 0; j < n3; ++j) {
                            this.data[n2++] = (byte)(Math.max(0.0f, rawFrame.getFrameValue(i, j) - fArray[j]) * fArray2[j] * f);
                        }
                    }
                } else {
                    for (int i = 0; i < n4; ++i) {
                        float[] fArray = SensorPanel.this.darkMatrix[i];
                        for (int j = 0; j < n3; ++j) {
                            this.data[n2++] = (byte)(Math.max(0.0f, rawFrame.getFrameValue(i, j) - fArray[j]) * f);
                        }
                    }
                }
            } else {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        this.data[n2++] = (byte)(rawFrame.getFrameValue(i, j) * f);
                    }
                }
            }
            this.repaint();
        }

        @Override
        public void stop() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.image != null) {
                graphics.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
            } else {
                this.infoText.draw(graphics, this.getWidth(), this.getHeight());
            }
        }

        public void reset() {
            this.image = null;
            this.repaint();
        }
    }
}

