/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.testscan;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.Resolution;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.CameraStreamPanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;

public class RulePanel
extends JPanel {
    private Orientation orientation;
    private static final int PANEL_SIZE = 50;
    private final String unit;
    private final BasicStroke normalStroke = new BasicStroke(1.0f, 2, 0, 10.0f);
    private final BasicStroke doubleStroke = new BasicStroke(2.0f, 2, 0, 10.0f);
    private CameraStreamPanel streamPanel;

    public RulePanel(CameraStreamPanel cameraStreamPanel) {
        this.streamPanel = cameraStreamPanel;
        this.unit = HardwareRegistry.getInstance().getSampleMoverUnit();
        this.setPreferredSize(new Dimension(50, 50));
        this.setMinimumSize(new Dimension(50, 50));
    }

    public void setStreamPanel(CameraStreamPanel cameraStreamPanel) {
        this.streamPanel = cameraStreamPanel;
        this.repaint();
    }

    public boolean setDefaultOrientation() {
        boolean bl = BreezeProperties.getInstance().getVisualisationDirection().equalsIgnoreCase("vertical");
        this.setOrientation(bl ? Orientation.Vertical : Orientation.Horizontal);
        return bl;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.streamPanel == null) {
            super.paint(graphics);
            return;
        }
        int n = this.streamPanel.getWidth();
        int n2 = this.streamPanel.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        graphics2D.setColor(breezeTheme.getPanelBackground());
        graphics2D.fillRect(0, 0, this.getWidth(), n2);
        Camera camera = this.streamPanel.camera();
        if (camera == null || !camera.isConnected()) {
            return;
        }
        try {
            int n3;
            int n4;
            graphics2D.setFont(new Font("SansSerif", 0, 10));
            graphics2D.setColor(breezeTheme.getLabelForeground());
            Object object = null;
            long l = this.streamPanel.getCapturedFramesCount();
            Resolution resolution = camera.getResolution();
            long l2 = Math.max(l, 1L);
            double d = resolution.value * (float)l2;
            double d2 = (double)(this.orientation == Orientation.Horizontal ? n2 : n) / (double)camera.getWidth().value * (double)l2;
            double d3 = Math.max(1.0, d2 / d);
            int n5 = 0;
            int n6 = n4 = this.orientation == Orientation.Horizontal ? n : n2;
            if (n5 == 0) {
                object = "0" + this.unit;
                n3 = 10;
                this.drawTickAndLabel(graphics2D, 0, n3, (String)object);
                n5 = 25;
            }
            int n7 = 100;
            for (int i = n5; i <= n4; i += 25) {
                if (i >= n7) {
                    graphics2D.setStroke(this.doubleStroke);
                    n3 = 10;
                    object = RtDataFormat.toString((double)i / d3, 3, false);
                    if (this.orientation == Orientation.Horizontal) {
                        object = (String)object + this.unit;
                    }
                    n7 += 100;
                } else {
                    graphics2D.setStroke(this.normalStroke);
                    n3 = 7;
                    object = "";
                }
                this.drawTickAndLabel(graphics2D, i, n3, (String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawTickAndLabel(Graphics2D graphics2D, int n, int n2, String string) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = fontMetrics.getHeight();
        if (this.orientation == Orientation.Horizontal) {
            graphics2D.drawLine(n, 49, n, 50 - n2 - 1);
            if (string != null) {
                graphics2D.drawString(string, n == 0 ? n : n - n3 / 2, 21);
            }
        } else {
            graphics2D.drawLine(49, n, 50 - n2 - 1, n);
            if (string != null) {
                graphics2D.drawString(string, 50 - n2 - n3 - 5, n == 0 ? n4 : n + n4 / 3);
            }
        }
    }

    public static enum Orientation {
        Horizontal,
        Vertical;

    }
}

