/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.testscan;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.realtime.variable.RtRenderModeVariable;
import se.prediktera.breeze.frontend.common.swing.BreezeSlider;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeToggleButton;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.recorder.RenderMode;

public class TestScanButtons
extends JPanel {
    private final TestScanCallback callback;
    private PositionPanel positionPanel;
    private final ButtonGroup buttonGroup;

    public TestScanButtons(TestScanCallback testScanCallback, boolean bl) {
        super(new GridBagLayout());
        this.callback = testScanCallback;
        this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        this.buttonGroup = new ButtonGroup();
        this.addButton(this.buttonGroup, RenderMode.Rgb).setSelected(!bl);
        this.addButton(this.buttonGroup, RenderMode.RgbSquareRoot);
        BreezeToggleButtonRenderMode breezeToggleButtonRenderMode = this.addButton(this.buttonGroup, RenderMode.Gray);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.getComponentCount();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.positionPanel = new PositionPanel(breezeToggleButtonRenderMode, testScanCallback, bl);
        this.add((Component)this.positionPanel, gridBagConstraints);
        this.addButton(this.buttonGroup, RenderMode.Intensity);
        this.addButton(this.buttonGroup, RenderMode.Saturation);
    }

    private BreezeToggleButtonRenderMode addButton(ButtonGroup buttonGroup, RenderMode renderMode) {
        BreezeToggleButtonRenderMode breezeToggleButtonRenderMode = new BreezeToggleButtonRenderMode(renderMode);
        breezeToggleButtonRenderMode.setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForegroundMoreDifuse()));
        buttonGroup.add(breezeToggleButtonRenderMode);
        breezeToggleButtonRenderMode.setPreferredSize(new Dimension(0, 25));
        breezeToggleButtonRenderMode.addActionListener(actionEvent -> {
            if (breezeToggleButtonRenderMode.isSelected()) {
                RenderMode renderMode = breezeToggleButtonRenderMode.getMode();
                this.positionPanel.setRenderMode(renderMode);
                this.callback.onClick(breezeToggleButtonRenderMode.getVariable());
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.getComponentCount();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)breezeToggleButtonRenderMode, gridBagConstraints);
        return breezeToggleButtonRenderMode;
    }

    public void setRenderMode(RenderMode renderMode) {
        this.positionPanel.setRenderMode(renderMode);
    }

    public void updateFromCamera(Camera camera) {
        this.positionPanel.updateFromCamera(camera);
    }

    public void clearSelection() {
        this.buttonGroup.clearSelection();
    }

    public void select(List<BreezeToggleButtonRenderMode> list, RtBasicVariable rtBasicVariable) {
        for (BreezeToggleButtonRenderMode breezeToggleButtonRenderMode : list) {
            if (!breezeToggleButtonRenderMode.getVariable().equals(rtBasicVariable)) continue;
            breezeToggleButtonRenderMode.setSelected(true);
            break;
        }
    }

    public static interface TestScanCallback {
        public void onClick(RtRenderModeVariable var1);
    }

    public static class BreezeToggleButtonRenderMode
    extends BreezeToggleButton {
        private final RtRenderModeVariable variable;

        public BreezeToggleButtonRenderMode(RenderMode renderMode) {
            super(renderMode.getText());
            this.variable = new RtRenderModeVariable(renderMode);
            this.setToolTipText(renderMode.getDescription());
        }

        public RtRenderModeVariable getVariable() {
            return this.variable;
        }

        public RenderMode getMode() {
            return this.variable.getMode();
        }
    }

    private static class PositionPanel
    extends JPanel {
        private final JLabel positionValueLabel = new JLabel();
        private final BreezeSlider positionSlider;
        private final TestScanCallback callback;
        private final BreezeToggleButtonRenderMode grayButton;
        private boolean updating = false;

        public PositionPanel(BreezeToggleButtonRenderMode breezeToggleButtonRenderMode, TestScanCallback testScanCallback, boolean bl) {
            super(new GridBagLayout());
            this.grayButton = breezeToggleButtonRenderMode;
            this.callback = testScanCallback;
            this.setOpaque(false);
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            int n = bl ? 10 : 12;
            JLabel jLabel = new JLabel("Spectral band index:");
            jLabel.setForeground(breezeTheme.getLabelForeground());
            jLabel.setFont(new Font("Tahoma", 0, n));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            this.add((Component)jLabel, gridBagConstraints);
            this.positionValueLabel.setForeground(breezeTheme.getLabelForeground());
            this.positionValueLabel.setFont(new Font("Tahoma", 0, n));
            this.positionValueLabel.setText("128 (256)");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.positionValueLabel, gridBagConstraints);
            this.positionSlider = new BreezeSlider(0, 100, bl ? 8 : 25);
            this.positionSlider.setPreferredSize(new Dimension(100, 25));
            this.positionSlider.setName("focusSlider");
            this.positionSlider.addChangeListener(this::positionSliderStateChanged);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.getComponentCount();
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(2, 0, 0, 0);
            this.add((Component)this.positionSlider, gridBagConstraints);
            this.setVisible(breezeToggleButtonRenderMode.isSelected());
        }

        public void setRenderMode(RenderMode renderMode) {
            this.positionSlider.setEnabled(renderMode.equals((Object)RenderMode.Gray));
            this.setVisible(renderMode.equals((Object)RenderMode.Gray));
        }

        private void positionSliderStateChanged(ChangeEvent changeEvent) {
            int n = this.positionSlider.getValue();
            if (this.positionSlider.getMaximum() == 0) {
                this.positionValueLabel.setText("N/A");
            } else {
                this.positionValueLabel.setText(n + 1 + " (" + (this.positionSlider.getMaximum() + 1) + ")");
            }
            if (this.positionSlider.isEnabled()) {
                this.grayButton.getVariable().setBand(n);
            }
            if (!this.updating) {
                this.callback.onClick(this.grayButton.getVariable());
            }
        }

        public void updateFromCamera(Camera camera) {
            this.updating = true;
            boolean bl = Camera.connected(camera);
            this.positionSlider.setMaximum(bl ? camera.getBandCount().value - 1 : 0);
            this.positionSlider.setValue(bl ? (int)Math.ceil((double)camera.getBandCount().value / 2.0) - 1 : 0);
            this.positionSliderStateChanged(null);
            this.updating = false;
        }
    }
}

