/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.testscan;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import se.prediktera.breeze.backend.grabber.CameraStreamGrabber;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.BoolHolder;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.FrameReader;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeDescriptionButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewPanelCustomPanel;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.frontend.main.play.realtime.LegendPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExploreInterface;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExplorePanel;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.frontend.main.settings.SettingsPanel;
import se.prediktera.breeze.frontend.main.settings.focus.HardwareSidePanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.frontend.main.settings.testscan.TestScanButtons;
import se.prediktera.breeze.frontend.main.settings.testscan.TestScanRealTimePanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.recorder.RenderMode;
import se.prediktera.breeze.test.stubs.GroupWithoutIO;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;

public class TestScanPanel
extends AbstractViewPanel {
    private final CameraStreamGrabber grabber = new CameraStreamGrabber();
    private final TestScanRealTimePanel testScanRealTimePanel;
    private final LegendPanel legendPanel = new LegendPanel();
    private final IntTimeTargetField maxValueInputField = new IntTimeTargetField();
    private final BreezeDescriptionButton scanButton = new BreezeDescriptionButton();
    private final BreezeComboBoxInputField<TestScanMode> modeComboBox = new BreezeComboBoxInputField("Mode");
    private ViewPanelCustomPanel explorePanel;
    private SampleMover connectedMover;
    private BreezeButton exploreButton;
    private final HardwareSidePanel hardwareSidePanel;
    private TestScanButtons testScanButtons;

    public TestScanPanel(MaintenancePanel maintenancePanel) {
        super(maintenancePanel);
        this.hardwareSidePanel = maintenancePanel.getHardwareSidePanel();
        this.hardwareSidePanel.setType(HardwareSidePanel.HardwareType.TestScan);
        this.testScanRealTimePanel = new TestScanRealTimePanel(new TestScanRealTimePanel.TestScanRenderCallback(){

            @Override
            public void onRendered(List<RawFrame> list, Camera camera) {
                TestScanPanel.this.maxValueInputField.setEnabled(true);
                TestScanPanel.this.modeComboBox.setEnabled(true);
            }

            @Override
            public void clear() {
                TestScanPanel.this.maxValueInputField.setEnabled(false);
                TestScanPanel.this.maxValueInputField.setText("");
                TestScanPanel.this.modeComboBox.setEnabled(false);
            }
        }, this.grabber);
        this.grabber.addOn(this.testScanRealTimePanel.getRawFrames());
        this.grabber.addOn(this.testScanRealTimePanel.getCameraStream());
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBackground(breezeTheme.getPanelBackground());
        jPanel.setBorder(BorderFactory.createLineBorder(new Color(51, 51, 51), 2));
        jPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add(jPanel, gridBagConstraints);
        this.scanButton.setDescription("Scan");
        this.scanButton.setName("focusScan");
        this.scanButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TestScanPanel.this.scanButtonMouseClicked(mouseEvent);
            }
        });
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBackground(breezeTheme.getPanelBackground());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = jPanel2.getComponentCount();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.scanButton, gridBagConstraints);
        this.modeComboBox.setFormat(BreezeInputFieldHelper.Format.TwoRows);
        this.modeComboBox.setRenderer(new BreezeComboBox.FormatStringCellRenderer());
        this.modeComboBox.addItem(TestScanMode.Normal);
        this.modeComboBox.addItem(TestScanMode.WhiteReference);
        this.modeComboBox.setChangedListener(testScanMode -> this.testScanRealTimePanel.setScanMode((TestScanMode)((Object)testScanMode)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = jPanel2.getComponentCount();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel2.add(this.modeComboBox, gridBagConstraints);
        CollapsePanel collapsePanel = new CollapsePanel("Advanced");
        collapsePanel.addPanel(this.maxValueInputField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = jPanel2.getComponentCount();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel2.add((Component)collapsePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = jPanel2.getComponentCount();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.testScanButtons = new TestScanButtons(rtRenderModeVariable -> this.setMode(rtRenderModeVariable.getMode(), rtRenderModeVariable.getBand()), false);
        jPanel2.add((Component)this.testScanButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.testScanButtons.getComponentCount();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(20, 10, 0, 0);
        this.exploreButton = EntryMainHelper.createTextButton("Explore", () -> {
            final Camera camera = this.getSelectedCamera();
            final BoolHolder boolHolder = new BoolHolder(false);
            WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO(this){

                @Override
                public boolean isXrayData() {
                    return Camera.isXray(camera);
                }

                @Override
                public void setModellingExplorePixel(boolean bl) {
                    boolHolder.set(bl);
                }

                @Override
                public boolean getModellingExplorePixel() {
                    return boolHolder.getValue();
                }
            };
            TestScanRealTimePanel.FramesRawFile framesRawFile = new TestScanRealTimePanel.FramesRawFile(this.testScanRealTimePanel.getRawFrames().getFrames(), camera.getRgbBands());
            MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO(this, "Test scan", new GroupWithoutIO(), workflowWithoutIO, framesRawFile){
                final /* synthetic */ 3 val$workflow;
                final /* synthetic */ TestScanRealTimePanel.FramesRawFile val$rawFile;
                {
                    this.val$workflow = var4_4;
                    this.val$rawFile = framesRawFile;
                    super(string, group);
                }

                @Override
                public Workflow getWorkflow() {
                    return this.val$workflow;
                }

                @Override
                public RawFile rawFile() {
                    return this.val$rawFile;
                }

                @Override
                public RawFile cachedRawFile(FrameListFromRaw.Reduce reduce) {
                    return this.val$rawFile;
                }
            };
            measurementWithoutIO.getMetaProperties().addProperty("MaxSignal", RtDataFormat.toString(camera.getMaxsignal().value));
            this.explorePanel = new ViewPanelCustomPanel(new PixelExploreInterface.PixelExploreDialogPanel(this.getMainPanel(), workflowWithoutIO, measurementWithoutIO, PixelExplorePanel.PixelExploreType.TestScan), measurementWithoutIO, 0.9);
            BreezeOptionDialog.showDialog(this.getFrame(), this.getMainPanel().getPageColor(), AbstractBreezeDialog.MessageType.NO_BUTTON_OPTION, "Explore Test Scan", "", (AbstractBreezeCustomPanel)this.explorePanel, null, arg_0 -> this.lambda$new$3(measurementWithoutIO, arg_0));
        });
        this.testScanButtons.add((Component)this.exploreButton, gridBagConstraints);
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane(jPanel2);
        breezeScrollPane.setHorizontalScrollBarPolicy(31);
        breezeScrollPane.setMinimumSize(new Dimension(150, 5));
        breezeScrollPane.setPreferredSize(new Dimension(150, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.add(breezeScrollPane, gridBagConstraints);
        jPanel.add((Component)this.testScanRealTimePanel, "Center");
        jPanel.add((Component)this.legendPanel, "East");
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        this.legendPanel.setPreferredSize(new Dimension(80, 0));
        this.legendPanel.setBorder(new LineBorder(Color.BLACK, 1, true));
        this.legendPanel.setTitle("%");
        this.legendPanel.setContinuesType(new VisualisationNode.ColorScale("jet"), null, null, null, new MinMax(0.0f, 100.0f), null, null);
        this.legendPanel.setVisible(false);
        this.scanButton.setBackground(this.mainpanel.getPageColor());
        this.setBackground(breezeTheme.getPanelBackground());
    }

    @Override
    public boolean showRightSettingsPanel() {
        return BreezeProperties.getInstance().isShowHardwareSettings();
    }

    @Override
    public String getType() {
        return "TestScan";
    }

    @Override
    public WizardStep.LeaveResult leaveEntry(WizardStep.LeaveControlCallback leaveControlCallback) {
        JPanel jPanel = this.hardwareSidePanel.getAdditionSettingsPanel();
        jPanel.removeAll();
        ((MaintenancePanel)this.mainpanel).leavePanel(this.grabber);
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.testScanButtons.setRenderMode(this.testScanRealTimePanel.getMode());
        this.testScanRealTimePanel.changeDirection();
        Camera camera = this.getSelectedCamera();
        this.updateFromCamera(camera);
        this.maxValueInputField.setEnabled(Camera.connected(camera) && this.testScanRealTimePanel.getRawFrames().getFrames().size() > 0);
        this.modeComboBox.setEnabled(true);
        JPanel jPanel = this.hardwareSidePanel.getAdditionSettingsPanel();
        jPanel.removeAll();
        DefaultSettingsPanel.SectionPanel sectionPanel = new DefaultSettingsPanel.SectionPanel("Settings", this.hardwareSidePanel.getSettingsWidth());
        jPanel.add((Component)sectionPanel, GridBagHelper.createWithWeigthX1(jPanel.getComponentCount(), new Insets(2, 5, 0, 5)));
        sectionPanel.addComponentHorizontal(new SettingsPanel.MeasurementLengthPanel(this.mainpanel));
        if (this.explorePanel != null) {
            this.explorePanel.onShow();
        }
    }

    public void updateFromCamera(Camera camera) {
        this.testScanButtons.updateFromCamera(camera);
        this.hardwareSidePanel.setCameras();
        this.hardwareSidePanel.setSampleMover(HardwareRegistry.getInstance().getSampleMover());
    }

    public String toString() {
        Camera camera = this.getSelectedCamera();
        if (Camera.connected(camera)) {
            return "";
        }
        return "Camera not connected";
    }

    private int getCameraId() {
        return ((MaintenancePanel)this.mainpanel).getCameraId();
    }

    private Camera getSelectedCamera() {
        return ((MaintenancePanel)this.mainpanel).getSelectedCamera();
    }

    private void scanButtonMouseClicked(MouseEvent mouseEvent) {
        this.scanButton.setEnabled(false);
        this.scanButton.requestFocus();
        this.exploreButton.setEnabled(false);
        if (!this.scanButton.isToggled()) {
            new ConnectProgressAction.ConnectAll(this.getFrame(), this.getCameraId(), "Scan"){

                @Override
                public void afterConnection(BreezeProgress breezeProgress, Camera camera, SampleMover sampleMover) {
                    if (ReferenceHelper.shouldTakeNewDark(camera)) {
                        ReferenceHelper.takeDarkReference(breezeProgress, camera);
                    }
                    TestScanPanel.this.connectedMover = sampleMover;
                    TestScanMode testScanMode = TestScanPanel.this.modeComboBox.getSelectedItem();
                    if (camera instanceof StateCamera) {
                        if (testScanMode.equals((Object)TestScanMode.Normal)) {
                            ((StateCamera)camera).changeStateToNormal();
                        } else {
                            ((StateCamera)camera).changeStateToWhiteReference();
                        }
                    }
                    TestScanPanel.this.updateFromCamera(camera);
                    TestScanPanel.this.mainpanel.repaintEntryList();
                    MeasurementLength measurementLength = camera.getMeasurementLength();
                    FrameCount frameCount = testScanMode.equals((Object)TestScanMode.Normal) ? measurementLength.getFrameCount(camera) : BreezeProperties.getInstance().getWhiteReferenceFrames();
                    TestScanPanel.this.scanButton.setToggled(true);
                    TestScanPanel.this.scanButton.setEnabled(true);
                    TestScanPanel.this.testScanRealTimePanel.getCameraStream().setDarkReference(camera);
                    if (sampleMover instanceof RemoteSampleMover) {
                        RemoteSampleMover remoteSampleMover = (RemoteSampleMover)sampleMover;
                        if (!remoteSampleMover.checkWithinLimits(TestScanPanel.this.getFrame(), TestScanPanel.this.getMainPanel().getPageColor(), measurementLength, camera)) {
                            TestScanPanel.this.scanButton.setToggled(false);
                            return;
                        }
                        TestScanPanel.this.grabber.startGrab(camera, frameCount, null, true);
                        new Thread(() -> {
                            TcpManager.getInstance().setListener(runtimeEvent -> {
                                if (runtimeEvent.getMessage().equals("OnScanStarted")) {
                                    TestScanPanel.this.grabber.setToggle(true);
                                }
                            });
                            if (testScanMode.equals((Object)TestScanMode.Normal)) {
                                remoteSampleMover.remoteScan(measurementLength.getLength(camera), SampleMover.ScanMode.Event, camera, Arrays.asList(frameCount), false, false);
                            } else {
                                remoteSampleMover.scanWhiteReference(null, camera, SampleMover.ScanMode.Event);
                            }
                            TcpManager.getInstance().setListener(null);
                            TestScanPanel.this.stopAndMoveToSamplePosition(sampleMover);
                            if (camera instanceof StateCamera) {
                                ((StateCamera)camera).changeStateToNormal();
                            }
                        }).start();
                    } else {
                        TestScanPanel.this.grabber.startGrab(camera, frameCount, () -> {
                            TestScanPanel.this.stopAndMoveToSamplePosition(null);
                            if (camera instanceof StateCamera) {
                                ((StateCamera)camera).changeStateToNormal();
                            }
                        }, false);
                    }
                }

                @Override
                public void connectionFailed(Exception exception) {
                    TestScanPanel.this.scanButton.setEnabled(true);
                }
            };
        } else {
            SwingUtilities.invokeLater(() -> {
                this.grabber.stop();
                if (this.connectedMover != null) {
                    this.connectedMover.stop();
                    this.connectedMover = null;
                }
            });
        }
    }

    private void stopAndMoveToSamplePosition(SampleMover sampleMover) {
        this.scanButton.setEnabled(false);
        this.exploreButton.setEnabled(true);
        SwingUtilities.invokeLater(() -> {
            this.grabber.stop();
            if (sampleMover != null) {
                new Thread(() -> {
                    sampleMover.moveToReturnPosition(this.getSelectedCamera());
                    this.scanButton.setToggled(false, true);
                }).start();
            } else {
                this.scanButton.setToggled(false, true);
            }
        });
    }

    public void setMode(RenderMode renderMode, final int n) {
        this.legendPanel.setVisible(renderMode.hasLegend());
        this.testScanRealTimePanel.setMode(renderMode);
        BreezeProgressDialog.startProgress(this.getFrame(), new ProgressAction(this){
            final /* synthetic */ TestScanPanel this$0;
            {
                this.this$0 = testScanPanel;
            }

            @Override
            public void runAction() throws Exception {
                this.setInfoText("Rendering: " + String.valueOf((Object)this.this$0.testScanRealTimePanel.getMode()));
                this.this$0.testScanRealTimePanel.reRender(this.getProgressManager(), n);
            }
        }, "Render");
    }

    private /* synthetic */ void lambda$new$3(4 var1_1, BreezeActionListener.BreezeActionEvent breezeActionEvent) {
        DataSetCache.clear(var1_1);
        this.explorePanel = null;
    }

    public class IntTimeTargetField
    extends JPanel {
        private final BreezeInputField inputField;
        private final BreezeButton calculateButton;

        public IntTimeTargetField() {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.inputField = new BreezeInputField("Int. time target", "", "");
            this.inputField.setEnabled(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 0, 0, 0);
            this.add((Component)this.inputField, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = new Insets(2, 0, 0, 0);
            this.calculateButton = EntryMainHelper.createSmallTextButton("Calculate", () -> BreezeProgressDialog.startProgress(TestScanPanel.this.getFrame(), new ProgressAction(){

                @Override
                public void runAction() throws Exception {
                    Camera camera = TestScanPanel.this.getSelectedCamera();
                    IntegrationTime integrationTime = IntegrationTime.getRecommendedValue(this.getProgressManager(), new FrameReader.FrameListIterator(TestScanPanel.this.testScanRealTimePanel.getRawFrames().getFrames()), camera.getIntegrationTime(), camera.getMaxsignal(), 0.8f);
                    IntTimeTargetField.this.inputField.setValue(integrationTime.value);
                }
            }, "Int. time target"));
            this.add((Component)this.calculateButton, gridBagConstraints2);
        }

        public void setText(String string) {
            this.inputField.setText(string);
        }

        @Override
        public void setEnabled(boolean bl) {
            this.calculateButton.setEnabled(bl);
        }
    }

    public static enum TestScanMode {
        Normal,
        WhiteReference;

    }
}

