/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.testscan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import lombok.Generated;
import se.prediktera.breeze.backend.grabber.CameraStreamAddOn;
import se.prediktera.breeze.backend.grabber.CameraStreamGrabber;
import se.prediktera.breeze.common.frame.DrReMatrix;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.realtime.frame.RtFrameStack;
import se.prediktera.breeze.common.util.BreezeColor;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.LongHolder;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.common.util.type.RtThreader;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.CameraPanelInfoText;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.CameraStreamPanel;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.PushbroomStreamImage;
import se.prediktera.breeze.frontend.main.settings.testscan.RulePanel;
import se.prediktera.breeze.frontend.main.settings.testscan.TestScanPanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.recorder.RenderMode;
import se.prediktera.map.common.error.ErrorHandler;

public class TestScanRealTimePanel
extends BreezeScrollPane {
    private int[] grayArray;
    private int band;
    private float maxSignal;
    private float maxSignal99;
    private RenderMode mode = RenderMode.Rgb;
    private final TestScanCameraStream cameraStream = new TestScanCameraStream();
    private final RawFrameListAddOn rawFrames = new RawFrameListAddOn();
    private int cameraWidth;
    private final RulePanel rulePanel = new RulePanel(this.cameraStream);
    private int[] rgbArray;
    private float[][] darkMatrix;
    private float[][] reMatrixInversed;
    private final int[][] jetColorScale;
    private final JPanel contentPane = new JPanel(new BorderLayout());
    private final TestScanRenderCallback callback;
    private boolean vertical;
    private final CameraStreamGrabber grabber;
    private boolean shouldRenderSaturatedPixelsAsRed;

    public TestScanRealTimePanel(TestScanRenderCallback testScanRenderCallback, CameraStreamGrabber cameraStreamGrabber) {
        this.callback = testScanRenderCallback;
        this.grabber = cameraStreamGrabber;
        this.changeDirection();
        this.setViewportView(this.contentPane);
        this.jetColorScale = BreezeProperties.getInstance().getColorScale().create().createColorIndex(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                TestScanRealTimePanel.this.updatePreferredSize();
            }
        });
    }

    public void changeDirection() {
        this.vertical = BreezeProperties.getInstance().getVisualisationDirection().equalsIgnoreCase("vertical");
        this.rulePanel.setOrientation(this.vertical ? RulePanel.Orientation.Vertical : RulePanel.Orientation.Horizontal);
        this.contentPane.removeAll();
        this.contentPane.add((Component)this.rulePanel, this.vertical ? "West" : "South");
        this.contentPane.add((Component)((Object)this.cameraStream), "Center");
        if (this.vertical) {
            this.setHorizontalScrollBarPolicy(31);
            this.setVerticalScrollBarPolicy(22);
        } else {
            this.setHorizontalScrollBarPolicy(32);
            this.setVerticalScrollBarPolicy(21);
        }
    }

    private int getFramesLength() {
        if (this.vertical) {
            return (int)((double)this.cameraStream.getWidth() / (double)this.cameraWidth * (double)this.rawFrames.frames.size()) - this.getHeight();
        }
        return (int)((double)this.cameraStream.getHeight() / (double)this.cameraWidth * (double)this.rawFrames.frames.size()) - this.getWidth();
    }

    private void updatePreferredSize() {
        if (this.cameraWidth > 0) {
            if (this.vertical) {
                int n = (int)((double)this.cameraStream.getWidth() / (double)this.cameraWidth * (double)this.cameraStream.getFrameCount().value);
                this.contentPane.setPreferredSize(new Dimension(100, n));
            } else {
                int n = (int)((double)this.cameraStream.getHeight() / (double)this.cameraWidth * (double)this.cameraStream.getFrameCount().value);
                this.contentPane.setPreferredSize(new Dimension(n, 100));
            }
            this.contentPane.revalidate();
        }
    }

    public void setScanMode(TestScanPanel.TestScanMode testScanMode) {
        this.rulePanel.setVisible(testScanMode.equals((Object)TestScanPanel.TestScanMode.Normal));
        this.rawFrames.frames.clear();
        this.cameraStream.reset();
        this.updatePreferredSize();
    }

    public void reRender(BreezeProgress breezeProgress, int n) {
        this.band = n;
        Camera camera = this.cameraStream.camera();
        if (camera != null && camera.isConnected() && !this.rawFrames.frames.isEmpty() && !this.grabber.isRunning()) {
            this.rgbArray = camera.getRgbBands().getArray(3);
            this.cameraStream.reRender(breezeProgress, this.rawFrames.frames);
        }
    }

    @Generated
    public RenderMode getMode() {
        return this.mode;
    }

    @Generated
    public void setMode(RenderMode renderMode) {
        this.mode = renderMode;
    }

    @Generated
    public TestScanCameraStream getCameraStream() {
        return this.cameraStream;
    }

    @Generated
    public RawFrameListAddOn getRawFrames() {
        return this.rawFrames;
    }

    public class TestScanCameraStream
    extends CameraStreamPanel {
        private FrameCount frameCount;

        public TestScanCameraStream() {
            super(new CameraPanelInfoText("Turn on the Scan switch to capture image data"));
            this.frameCount = new FrameCount(100);
            this.showFps = false;
        }

        @Override
        protected CameraStreamPanel.RgbFrameRasterer createFrameRasterer() {
            return new Renderer();
        }

        public JScrollBar getScrollBar() {
            if (TestScanRealTimePanel.this.vertical) {
                return TestScanRealTimePanel.this.getVerticalScrollBar();
            }
            return TestScanRealTimePanel.this.getHorizontalScrollBar();
        }

        @Override
        protected CameraStreamPanel.ImagePostProcessor createPostProcessor() {
            LongHolder longHolder = new LongHolder(0L);
            return (streamImage, l) -> {
                if (longHolder.getValue() != l) {
                    longHolder.setValue(l);
                    JScrollBar jScrollBar = this.getScrollBar();
                    jScrollBar.setValue(TestScanRealTimePanel.this.getFramesLength());
                    TestScanRealTimePanel.this.rulePanel.repaint();
                }
            };
        }

        @Override
        public void init(Camera camera, FrameCount frameCount) {
            super.init(camera, frameCount);
            this.frameCount = frameCount;
            TestScanRealTimePanel.this.cameraWidth = camera.getWidth().value;
            TestScanRealTimePanel.this.grayArray = new int[TestScanRealTimePanel.this.cameraWidth];
            TestScanRealTimePanel.this.maxSignal = camera.getMaxsignal().value;
            TestScanRealTimePanel.this.shouldRenderSaturatedPixelsAsRed = !camera.isRgb();
            TestScanRealTimePanel.this.maxSignal99 = TestScanRealTimePanel.this.maxSignal * 0.99f;
            TestScanRealTimePanel.this.rgbArray = camera.getRgbBands().getArray(3);
            TestScanRealTimePanel.this.cameraStream.setImageDirection(TestScanRealTimePanel.this.vertical ? PushbroomStreamImage.ImageDirection.DownScan : PushbroomStreamImage.ImageDirection.RightScan);
            TestScanRealTimePanel.this.updatePreferredSize();
            TestScanRealTimePanel.this.rulePanel.repaint();
            TestScanRealTimePanel.this.callback.clear();
            this.getScrollBar().setValue(0);
        }

        public void setDarkReference(Camera camera) {
            DrReMatrix drReMatrix = camera.getDrReMatrix();
            TestScanRealTimePanel.this.darkMatrix = drReMatrix.getDarkMatrix();
            TestScanRealTimePanel.this.reMatrixInversed = drReMatrix.getReMatrixInversed();
        }

        @Override
        public void reset() {
            super.reset();
            this.frameCount = new FrameCount(100);
        }

        @Override
        public void stop() {
            super.stop();
            TestScanRealTimePanel.this.callback.onRendered(TestScanRealTimePanel.this.getRawFrames().getFrames(), this.camera());
        }

        public void reRender(BreezeProgress breezeProgress, List<RawFrame> list) {
            this.clear();
            RtFrameStack rtFrameStack = new RtFrameStack();
            breezeProgress.setMaximumAndReset(list.size());
            for (int i = 0; i < list.size(); ++i) {
                rtFrameStack.setFrame(list.get(i));
                rtFrameStack.setFrameNumber(i);
                this.apply(rtFrameStack);
                breezeProgress.incStep();
            }
        }

        @Generated
        public FrameCount getFrameCount() {
            return this.frameCount;
        }
    }

    public static class RawFrameListAddOn
    implements CameraStreamAddOn {
        private final List<RawFrame> frames = new ArrayList<RawFrame>();

        @Override
        public void apply(FrameStack frameStack) {
            this.frames.add(frameStack.getFrame().copy());
        }

        @Override
        public void init(Camera camera, FrameCount frameCount) {
            this.frames.clear();
        }

        @Override
        public void stop() {
        }

        @Generated
        public List<RawFrame> getFrames() {
            return this.frames;
        }
    }

    public static interface TestScanRenderCallback {
        public void onRendered(List<RawFrame> var1, Camera var2);

        public void clear();
    }

    private class Renderer
    implements CameraStreamPanel.RgbFrameRasterer {
        private Renderer() {
        }

        @Override
        public void rasterIntoRgbFrame(final PushbroomStreamImage.RgbFrame rgbFrame, FrameStack frameStack) {
            Camera camera = TestScanRealTimePanel.this.cameraStream.camera();
            int n = camera.getWidth().value;
            final RawFrame rawFrame = frameStack.getFrame();
            final int n2 = rawFrame.rows.value;
            if (TestScanRealTimePanel.this.mode.equals((Object)RenderMode.Gray)) {
                int n3;
                int n4 = Math.max(0, TestScanRealTimePanel.this.band);
                float[] fArray = TestScanRealTimePanel.this.darkMatrix[n4];
                float[] fArray2 = TestScanRealTimePanel.this.reMatrixInversed[n4];
                for (n3 = 0; n3 < n; ++n3) {
                    float f = fArray[n3];
                    float f2 = (rawFrame.getFrameValue(n4, n3) - f) * fArray2[n3];
                    float f3 = TestScanRealTimePanel.this.maxSignal - f;
                    TestScanRealTimePanel.this.grayArray[n3] = BreezeColor.toRGB(f2 / f3);
                }
                for (n3 = 0; n3 < n; ++n3) {
                    int n5 = TestScanRealTimePanel.this.grayArray[n3];
                    int n6 = n3 * 3;
                    if (n5 == 255) {
                        rgbFrame.origframe[n6] = -1;
                        rgbFrame.origframe[n6 + 1] = 0;
                        rgbFrame.origframe[n6 + 2] = 0;
                        continue;
                    }
                    rgbFrame.origframe[n6] = (byte)n5;
                    rgbFrame.origframe[n6 + 1] = (byte)n5;
                    rgbFrame.origframe[n6 + 2] = (byte)n5;
                }
            } else if (TestScanRealTimePanel.this.mode.equals((Object)RenderMode.Rgb)) {
                block2: for (int i = 0; i < n; ++i) {
                    int n7 = i * 3;
                    for (int j = 0; j < 3; ++j) {
                        int n8 = TestScanRealTimePanel.this.rgbArray[j];
                        float f = TestScanRealTimePanel.this.darkMatrix[n8][i];
                        float f4 = (rawFrame.getFrameValue(n8, i) - f) * TestScanRealTimePanel.this.reMatrixInversed[n8][i];
                        float f5 = TestScanRealTimePanel.this.maxSignal - f;
                        int n9 = BreezeColor.toRGB(f4 / f5);
                        if (TestScanRealTimePanel.this.shouldRenderSaturatedPixelsAsRed && n9 == 255) {
                            rgbFrame.origframe[n7] = -1;
                            rgbFrame.origframe[n7 + 1] = 0;
                            rgbFrame.origframe[n7 + 2] = 0;
                            continue block2;
                        }
                        rgbFrame.origframe[n7 + j] = (byte)n9;
                    }
                }
            } else if (TestScanRealTimePanel.this.mode.equals((Object)RenderMode.RgbSquareRoot)) {
                block4: for (int i = 0; i < n; ++i) {
                    int n10 = i * 3;
                    for (int j = 0; j < 3; ++j) {
                        double d;
                        int n11 = TestScanRealTimePanel.this.rgbArray[j];
                        float f = TestScanRealTimePanel.this.darkMatrix[n11][i];
                        double d2 = Math.sqrt((rawFrame.getFrameValue(n11, i) - f) * TestScanRealTimePanel.this.reMatrixInversed[n11][i]);
                        int n12 = BreezeColor.toRGB(d2 / (d = Math.sqrt(TestScanRealTimePanel.this.maxSignal - f)));
                        if (n12 >= 254) {
                            rgbFrame.origframe[n10] = -1;
                            rgbFrame.origframe[n10 + 1] = 0;
                            rgbFrame.origframe[n10 + 2] = 0;
                            continue block4;
                        }
                        rgbFrame.origframe[n10 + j] = (byte)n12;
                    }
                }
            } else if (TestScanRealTimePanel.this.mode.equals((Object)RenderMode.Intensity)) {
                new RtThreader(this){
                    final /* synthetic */ Renderer this$1;
                    {
                        this.this$1 = renderer;
                    }

                    @Override
                    protected void doOp(boolean bl, int n, int n22) {
                        for (int i = n; i < n22; ++i) {
                            int n3;
                            int n4 = i * 3;
                            float f = 0.0f;
                            for (n3 = 0; n3 < n2; ++n3) {
                                float f2;
                                float f3 = rawFrame.getFrameValue(n3, i);
                                float f4 = this.this$1.TestScanRealTimePanel.this.darkMatrix[n3][i];
                                float f5 = this.this$1.TestScanRealTimePanel.this.maxSignal99 - f4;
                                if (f5 <= 0.0f) continue;
                                float f6 = (f3 - f4) * this.this$1.TestScanRealTimePanel.this.reMatrixInversed[n3][i];
                                float f7 = f2 = f6 >= f5 ? 1.0f : f6 / f5;
                                if (f2 > f) {
                                    f = f2;
                                }
                                if (f2 == 1.0f) break;
                            }
                            if ((n3 = BreezeColor.toRGB(f)) == 255) {
                                rgbFrame.origframe[n4] = -1;
                                rgbFrame.origframe[n4 + 1] = -1;
                                rgbFrame.origframe[n4 + 2] = -1;
                                continue;
                            }
                            int[] nArray = this.this$1.TestScanRealTimePanel.this.jetColorScale[n3];
                            rgbFrame.origframe[n4] = (byte)nArray[0];
                            rgbFrame.origframe[n4 + 1] = (byte)nArray[1];
                            rgbFrame.origframe[n4 + 2] = (byte)nArray[2];
                        }
                    }
                }.execute(n);
            } else if (TestScanRealTimePanel.this.mode.equals((Object)RenderMode.Saturation)) {
                new RtThreader(this){
                    final /* synthetic */ Renderer this$1;
                    {
                        this.this$1 = renderer;
                    }

                    @Override
                    protected void doOp(boolean bl, int n, int n22) {
                        for (int i = n; i < n22; ++i) {
                            float f;
                            float f2;
                            float f3;
                            int n3;
                            int n4 = i * 3;
                            int n5 = 0;
                            for (n3 = 0; n3 < n2; ++n3) {
                                float f4 = rawFrame.getFrameValue(n3, i);
                                f3 = this.this$1.TestScanRealTimePanel.this.darkMatrix[n3][i];
                                f2 = this.this$1.TestScanRealTimePanel.this.maxSignal99 - f3;
                                if (f2 <= 0.0f || !((f = f4 - f3) >= f2)) continue;
                                ++n5;
                            }
                            n3 = BreezeColor.toRGB((float)n5 / (float)n2);
                            if (n5 == 0) {
                                int n6 = Math.max(0, this.this$1.TestScanRealTimePanel.this.band);
                                f3 = rawFrame.getFrameValue(n6, i);
                                f2 = this.this$1.TestScanRealTimePanel.this.darkMatrix[n6][i];
                                f = this.this$1.TestScanRealTimePanel.this.maxSignal99 - f2;
                                if (f <= 0.0f) {
                                    rgbFrame.origframe[n4] = 0;
                                    rgbFrame.origframe[n4 + 1] = 0;
                                    rgbFrame.origframe[n4 + 2] = 0;
                                    continue;
                                }
                                float f5 = (f3 - f2) * this.this$1.TestScanRealTimePanel.this.reMatrixInversed[n6][i];
                                float f6 = f5 >= f ? 1.0f : f5 / f;
                                this.this$1.TestScanRealTimePanel.this.grayArray[i] = BreezeColor.toRGB(f6);
                                rgbFrame.origframe[n4] = (byte)this.this$1.TestScanRealTimePanel.this.grayArray[i];
                                rgbFrame.origframe[n4 + 1] = (byte)this.this$1.TestScanRealTimePanel.this.grayArray[i];
                                rgbFrame.origframe[n4 + 2] = (byte)this.this$1.TestScanRealTimePanel.this.grayArray[i];
                                continue;
                            }
                            if (n3 == 255) {
                                rgbFrame.origframe[n4] = -1;
                                rgbFrame.origframe[n4 + 1] = -1;
                                rgbFrame.origframe[n4 + 2] = -1;
                                continue;
                            }
                            int[] nArray = this.this$1.TestScanRealTimePanel.this.jetColorScale[n3];
                            rgbFrame.origframe[n4] = (byte)nArray[0];
                            rgbFrame.origframe[n4 + 1] = (byte)nArray[1];
                            rgbFrame.origframe[n4 + 2] = (byte)nArray[2];
                        }
                    }
                }.execute(n);
            }
        }
    }

    public static class FramesRawFile
    implements RawFile {
        private final List<RawFrame> frames;
        private final RawHeader header;

        public FramesRawFile(List<RawFrame> list, RgbBands rgbBands) {
            this.frames = list;
            if (list.isEmpty()) {
                throw new ErrorHandler.InformationMessageException("No data has been recorded");
            }
            RawFrame rawFrame = list.getFirst();
            this.header = new RawHeader(new FrameCount(list.size()), rawFrame.rows, rawFrame.columns, rawFrame.getType());
            this.header.setBandNames(rawFrame.bandNames);
            this.header.setRgbBands(rgbBands);
        }

        @Override
        public RawHeader header() {
            return this.header;
        }

        @Override
        public ByteBuffer readRawHeader() {
            return null;
        }

        @Override
        public List<RawFrame> readFrames() {
            return this.frames;
        }

        @Override
        public File file() {
            return null;
        }
    }
}

