/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.testscan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;
import org.apache.commons.lang3.ObjectUtils;
import se.prediktera.breeze.AbstractRuntimeApplication;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.backend.measure.MeasurementTaker;
import se.prediktera.breeze.backend.measure.settings.MeasureSettings;
import se.prediktera.breeze.backend.measure.settings.MoverMeasureSettings;
import se.prediktera.breeze.backend.measure.settings.ReferenceSettings;
import se.prediktera.breeze.common.hardware.settings.ByLengthMeasureLengthSettings;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.realtime.variable.RtRenderModeVariable;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.raw.FrameReader;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.client.select.active.ActiveRealtimePanel;
import se.prediktera.breeze.frontend.client.select.active.RuntimeWorkflowRealtimePanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCenterPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeDescriptionButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeMessagePanel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.CameraPanelInfoText;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.CameraStreamPanel;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.frontend.main.settings.SettingsPanel;
import se.prediktera.breeze.frontend.main.settings.focus.HardwareSidePanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.frontend.wizard.measure.step.PlaceSampleStep;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.runtime.DefaultBreezeRuntime;
import se.prediktera.breeze.hardware.samplemover.tray.SimulatorSampleMoverTray;
import se.prediktera.breeze.recorder.BreezeRecorder;
import se.prediktera.breeze.recorder.GroupRecordMmtCreateAndSaveSettings;
import se.prediktera.breeze.recorder.RenderMode;
import se.prediktera.breeze.test.stubs.GroupWithoutIO;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;

public class TestScanWithRuntimePanel
extends AbstractViewPanel
implements PlaceSampleStep.MeasurementInfoInterface {
    private MeasurementTaker measurementTaker;
    private final List<Measurement> measurements = new ArrayList<Measurement>();
    private final GroupWithoutIO group;
    private MeasureSettings measureSettings;
    private DefaultSettingsPanel settingsPanel;
    private BreezeDescriptionButton scanButton;
    private final BreezeComboBoxInputField<SampleMover.ScanMode> modeComboBox = new BreezeComboBoxInputField("Acquisition mode");
    private final IntTimeTargetField maxValueInputField = new IntTimeTargetField();
    private final BreezeCenterPanel centerPanel = new BreezeCenterPanel();
    private HardwareSidePanel hardwareSidePanel;
    private BreezeCenterPanel referencesPanel;
    private final ActiveRealtimePanel.ActiveTablePanel activeTablePanel;
    private RtBasicVariable currentVariable = new RtRenderModeVariable(RenderMode.Rgb);
    public static boolean showAdvancedSettings;

    public TestScanWithRuntimePanel(final MaintenancePanel maintenancePanel) {
        super(maintenancePanel);
        this.setLayout(new BorderLayout());
        this.hardwareSidePanel = maintenancePanel.getHardwareSidePanel();
        this.hardwareSidePanel.setType(HardwareSidePanel.HardwareType.TestScan);
        this.activeTablePanel = new ActiveRealtimePanel.ActiveTablePanel(maintenancePanel);
        final File file = FileHelper.createTempFolderInWorkspace();
        Workflow workflow = new Workflow(this, "Test Scan", FileHelper.newNonExistingFile()){

            @Override
            public void save() {
            }

            @Override
            public boolean noIO() {
                return true;
            }
        };
        this.group = new GroupWithoutIO(this, workflow){

            @Override
            public File getFolder() {
                return file;
            }
        };
        this.add(this.centerPanel, "Center");
        this.centerPanel.setCenter(BreezeMessagePanel.dark("Turn on the Scan switch to capture image data"));
        this.settingsPanel = new DefaultSettingsPanel(300, false){

            @Override
            public String getDescription() {
                return "Advanced";
            }

            @Override
            public void toggled(boolean bl) {
                showAdvancedSettings = bl;
                super.toggled(showAdvancedSettings);
            }
        };
        DefaultSettingsPanel.SectionPanel sectionPanel = this.settingsPanel.addSection("Settings");
        this.scanButton = new BreezeDescriptionButton();
        this.scanButton.setDescription("Scan");
        this.scanButton.setName("focusScan");
        this.scanButton.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ TestScanWithRuntimePanel this$0;
            {
                this.this$0 = testScanWithRuntimePanel;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.this$0.scanButton.setEnabled(false);
                this.this$0.scanButton.requestFocus();
                if (!this.this$0.scanButton.isToggled()) {
                    new ConnectProgressAction.ConnectAll(this, this.this$0.getFrame(), this.this$0.getCameraId(), "Scan"){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                            super(breezeFrame, n, string);
                        }

                        @Override
                        public void afterConnection(BreezeProgress breezeProgress, Camera camera, SampleMover sampleMover) {
                            this.this$1.this$0.updateSettings(true);
                            this.this$1.this$0.updateFromCamera();
                            this.this$1.this$0.hardwareSidePanel.setEnabled(false);
                            if (ReferenceHelper.shouldTakeNewDark(camera)) {
                                ReferenceHelper.takeDarkReference(breezeProgress, camera);
                            }
                            AtomicInteger atomicInteger = new AtomicInteger(1);
                            this.this$1.this$0.measurementTaker.startMeasurementTaking(maintenancePanel.getFrame(), () -> this.this$1.this$0.scanButton.setToggled(true, true), () -> {
                                if (atomicInteger.decrementAndGet() == 0) {
                                    this.this$1.this$0.stopRecord(null);
                                }
                            }, () -> this.this$1.this$0.addOrDelete(true), n -> {});
                        }

                        @Override
                        public void connectionFailed(Exception exception) {
                            this.this$1.this$0.scanButton.setEnabled(true);
                        }
                    };
                } else {
                    this.this$0.stopRecord(null);
                }
            }
        });
        this.modeComboBox.setFormat(BreezeInputFieldHelper.Format.TwoRows);
        this.modeComboBox.setRenderer(new BreezeComboBox.FormatStringCellRenderer());
        this.modeComboBox.addItem(SampleMover.ScanMode.Measurement);
        this.modeComboBox.addItem(SampleMover.ScanMode.WhiteReferenceOnly);
        sectionPanel.addComponentHorizontal(this.modeComboBox);
        sectionPanel.addComponentHorizontal(this.maxValueInputField);
        DefaultSettingsPanel.SectionPanel sectionPanel2 = this.settingsPanel.addSection("");
        this.referencesPanel = new BreezeCenterPanel();
        sectionPanel2.addComponentHorizontal(this.referencesPanel);
    }

    private void updateSettings(boolean bl) {
        Object object;
        Object object2;
        boolean bl2;
        BreezeMainPanel breezeMainPanel = this.getMainPanel();
        Camera camera = this.getSelectedCamera();
        SampleMover sampleMover = HardwareRegistry.getInstance().getSampleMover();
        boolean bl3 = this.measureSettings != null && this.measureSettings.referenceSettings().getCameras().getFirst() != camera;
        boolean bl4 = bl2 = !bl3 && this.measurements.size() > 0;
        if (bl || this.measureSettings == null || bl3) {
            if (this.measurementTaker != null) {
                this.currentVariable = this.measurementTaker.getCurrentVariable();
                this.addOrDelete(true);
            }
            object2 = MoverMeasureSettings.sampleMoverSettingsByType(sampleMover);
            object2.setMode(this.modeComboBox.getSelectedItem());
            object = List.of(camera);
            this.measureSettings = new MeasureSettings((MoverMeasureSettings)object2, new ByLengthMeasureLengthSettings(camera, false), new GroupRecordMmtCreateAndSaveSettings(this, measurement -> DataSetCache.clear(this.group)), new ReferenceSettings((List<Camera>)object, sampleMover, ReferenceSettings.ReferenceAction.UseStoredTestScan, ReferenceSettings.ReferenceAction.Disable));
            this.measurementTaker = new MeasurementTaker(breezeMainPanel, this.activeTablePanel, this.group, this.measureSettings, runtimeException -> {
                Logg.error((String)"Error while recording", (Throwable)runtimeException);
                BreezeOptionDialog.showErrorDialog(breezeMainPanel.getFrame(), "Error while recording", runtimeException);
                return false;
            }, (List<Camera>)object, BreezeRecorder.RecordMode.TestScan, this.currentVariable, Camera.MultiCameraMode.Single);
        }
        if ((object2 = (ActiveRealtimePanel)this.measurementTaker.getRuntimePanel().getViewPanelAt(0)) != null) {
            object = ((RuntimeWorkflowRealtimePanel)object2).getRealtimePanelAddOn();
            ((CameraStreamPanel)object).setInfoText(new CameraPanelInfoText(bl2 ? "" : "Turn on the Scan switch to capture image data"));
            this.centerPanel.setCenter((Component)object2);
        }
    }

    @Override
    public EntrySettingsPanel.SettingsComponent getLeftSettingsPanel() {
        return this.settingsPanel;
    }

    @Override
    public boolean showLeftSettingsPanel() {
        return showAdvancedSettings;
    }

    private void stopRecord(BreezeProgressManager breezeProgressManager) {
        this.scanButton.setEnabled(false);
        this.measurementTaker.stopMeasurementTaking(breezeProgressManager, true, list -> {
            this.measurements.clear();
            if (list != null) {
                for (Measurement measurement : list) {
                    this.measurements.add(measurement);
                }
            }
            ToastHandler.getInstance().showToast("Test scan completed", Toast.IconType.Success, new Time.Seconds(15.0));
            this.updateFromCamera();
            SampleMover sampleMover = HardwareRegistry.getInstance().getSampleMover();
            if (sampleMover != null) {
                new Thread(() -> {
                    sampleMover.moveToReturnPosition(this.getSelectedCamera());
                    this.scanButton.setToggled(false, true);
                }).start();
            } else {
                this.scanButton.setToggled(false, true);
            }
            this.hardwareSidePanel.setEnabled(true);
        });
    }

    private void addOrDelete(boolean bl) {
        if (bl && ObjectUtils.isNotEmpty(this.measurements)) {
            for (Measurement measurement : this.measurements) {
                if (measurement == null) continue;
                measurement.delete(false);
                this.group.removeChild(measurement);
            }
        }
        this.measurements.clear();
        this.measureSettings.referenceSettings().updateReferenceInfo();
        this.measurementTaker.reset();
    }

    @Override
    public String getMeasurementName() {
        return "Test";
    }

    @Override
    public String getType() {
        return "Test Scan";
    }

    private int getCameraId() {
        return ((MaintenancePanel)this.mainpanel).getCameraId();
    }

    private Camera getSelectedCamera() {
        return ((MaintenancePanel)this.mainpanel).getSelectedCamera();
    }

    @Override
    public WizardStep.LeaveResult leaveEntry(final WizardStep.LeaveControlCallback leaveControlCallback) {
        this.hardwareSidePanel.getTopSettingsPanel().removeAll();
        if (this.scanButton.isToggled()) {
            BreezeProgressDialog.startProgress(this.getFrame(), new ProgressAction(this){
                final /* synthetic */ TestScanWithRuntimePanel this$0;
                {
                    this.this$0 = testScanWithRuntimePanel;
                }

                @Override
                public void runAction() throws Exception {
                    this.this$0.stopRecord(this.getProgressManager());
                    leaveControlCallback.leaveWithControl();
                }
            }, "Done capture measurement(s)");
            return WizardStep.LeaveResult.Control;
        }
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.updateSettings(false);
        this.updateFromCamera();
        JPanel jPanel = this.hardwareSidePanel.getTopSettingsPanel();
        jPanel.removeAll();
        DefaultSettingsPanel.SectionPanel sectionPanel = new DefaultSettingsPanel.SectionPanel("Test Scan", this.hardwareSidePanel.getSettingsWidth());
        sectionPanel.addComponentHorizontal(this.scanButton);
        jPanel.add((Component)sectionPanel, GridBagHelper.createWithWeigthX1(jPanel.getComponentCount(), new Insets(2, 5, 0, 5)));
        sectionPanel.addComponentHorizontal(new SettingsPanel.MeasurementLengthPanel(this.mainpanel));
    }

    private void updateFromCamera() {
        Camera camera = this.getSelectedCamera();
        this.maxValueInputField.setEnabled(Camera.connected(camera) && !this.measurements.isEmpty());
        this.hardwareSidePanel.setCameras();
        this.hardwareSidePanel.setSampleMover(HardwareRegistry.getInstance().getSampleMover());
    }

    public String toString() {
        Camera camera = this.getSelectedCamera();
        if (Camera.connected(camera)) {
            return "";
        }
        return "Camera not connected";
    }

    public static void main(String[] stringArray) {
        showAdvancedSettings = true;
        new TestRuntimeApplication(maintenancePanel -> {
            TestScanWithRuntimePanel testScanWithRuntimePanel = new TestScanWithRuntimePanel(maintenancePanel);
            testScanWithRuntimePanel.add(testScanWithRuntimePanel.hardwareSidePanel, "East");
            testScanWithRuntimePanel.showEntry(null, null);
            return testScanWithRuntimePanel;
        });
    }

    public class IntTimeTargetField
    extends JPanel {
        private final BreezeInputField inputField;
        private final BreezeButton calculateButton;

        public IntTimeTargetField() {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.inputField = new BreezeInputField("Int. time target", "", "");
            this.inputField.setEnabled(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 0, 0, 0);
            this.add((Component)this.inputField, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = new Insets(2, 0, 0, 0);
            this.calculateButton = EntryMainHelper.createSmallTextButton("Calculate", () -> BreezeProgressDialog.startProgress(TestScanWithRuntimePanel.this.getFrame(), new ProgressAction(){

                @Override
                public void runAction() throws Exception {
                    Camera camera = TestScanWithRuntimePanel.this.getSelectedCamera();
                    if (TestScanWithRuntimePanel.this.measurements.isEmpty()) {
                        throw new ErrorHandler.InformationMessageException("No Test Scan available");
                    }
                    Measurement measurement = TestScanWithRuntimePanel.this.measurements.getFirst();
                    try (FrameReader.FrameIterator frameIterator = new FrameReader(measurement.rawFile()).iterator();){
                        IntegrationTime integrationTime = IntegrationTime.getRecommendedValue(this.getProgressManager(), frameIterator, camera.getIntegrationTime(), camera.getMaxsignal(), 0.8f);
                        IntTimeTargetField.this.inputField.setValue(integrationTime.value);
                    }
                }
            }, "Int. time target"));
            this.add((Component)this.calculateButton, gridBagConstraints2);
        }

        public void setText(String string) {
            this.inputField.setText(string);
        }

        @Override
        public void setEnabled(boolean bl) {
            this.calculateButton.setEnabled(bl);
        }
    }

    public static class TestRuntimeApplication
    extends AbstractRuntimeApplication {
        public TestRuntimeApplication(TestApplicationCallback testApplicationCallback) {
            super(new BreezeFrame(UpdateHelper.Product.Breeze), new Breeze.BreezeErrorHandlingSetup(), new DefaultBreezeRuntime());
            Breeze.initForTest();
            Breeze.setFrameIcons(this.breezeFrame);
            ArrayList<ViewClass> arrayList = new ArrayList<ViewClass>();
            var var3_3 = new MaintenancePanel(this.breezeFrame){

                @Override
                public BreezeFrame getFrame() {
                    return breezeFrame;
                }

                @Override
                public void setDirty(boolean bl) {
                }
            };
            HardwareRegistry.getInstance().switchToSampleMover(new SimulatorSampleMoverTray());
            this.breezeFrame.setTitle("Test Runtime Application");
            this.breezeFrame.setDefaultCloseOperation(3);
            this.breezeFrame.setMainPanel(var3_3);
            this.breezeFrame.addMainPage();
            arrayList.add(new ViewClass("Overview", testApplicationCallback.createPanel(var3_3)));
            var3_3.middlePanel.setVisible(false);
            var3_3.topRightPanel.setVisible(false);
            var3_3.bottomRightPanel.setVisible(false);
            var3_3.setLists(arrayList, new ArrayList(), "Study_big");
            this.breezeFrame.showFullScreen(false);
            this.waitUntilDoneAndClose();
        }

        @Override
        protected UpdateHelper.Product getProduct() {
            return UpdateHelper.Product.Breeze;
        }

        public static interface TestApplicationCallback {
            public AbstractViewPanel createPanel(MaintenancePanel var1);
        }
    }
}

