/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings.user;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezePasswordField;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;
import se.prediktera.breeze.frontend.common.util.BreezeUser;
import se.prediktera.breeze.frontend.common.util.BreezeUserManager;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;

public class UserPanel
extends AbstractViewPanel {
    private BreezeButton addButton;
    private JLabel descriptionLabel;
    private BreezeButton editButton;
    private BreezeCheckBox enableUserCheckBox;
    private JLabel firstNameLabel;
    private BreezeTextField firstNameTextField;
    private JPanel inputPanel;
    private JPanel jPanel1;
    private BreezeScrollPane jScrollPane1;
    private JLabel lastNameLabel;
    private BreezeTextField lastNameTextField;
    private BreezePasswordField passwordField;
    private JLabel passwordLabel;
    private BreezeButton removeButton;
    private JLabel roleLabel;
    private BreezeComboBox roleTextField;
    private BreezeTablePanel userTable;
    private JLabel usernameLabel;
    private BreezeTextField usernameTextField;
    private final TableHelper tableHelper;
    private boolean isediting;

    public UserPanel(MaintenancePanel maintenancePanel) {
        super(maintenancePanel);
        this.initComponents();
        for (BreezeUser.Role role : BreezeUser.Role.values()) {
            this.roleTextField.addItem((Object)role);
        }
        this.tableHelper = new TableHelper();
        this.userTable.initTable(this.tableHelper, null, false);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.enableUserCheckBox.setForeground(breezeTheme.getLabelForeground());
        this.jScrollPane1.setBackground(breezeTheme.getPanelBackground());
    }

    @Override
    public String getType() {
        return "s";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.tableHelper.clearFields();
        BreezeUserManager breezeUserManager = BreezeUserManager.getInstance();
        this.userTable.setTableList(breezeUserManager.getUserList(), null);
        this.enableUserCheckBox.setSelected(breezeUserManager.isEnabled());
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.addButton = new BreezeButton();
        this.jPanel1 = new JPanel();
        this.removeButton = new BreezeButton();
        this.editButton = new BreezeButton();
        this.inputPanel = new JPanel();
        this.firstNameLabel = new JLabel();
        this.firstNameTextField = new BreezeTextField();
        this.lastNameLabel = new JLabel();
        this.lastNameTextField = new BreezeTextField();
        this.usernameLabel = new JLabel();
        this.usernameTextField = new BreezeTextField();
        this.roleLabel = new JLabel();
        this.roleTextField = new BreezeComboBox();
        this.passwordLabel = new JLabel();
        this.passwordField = new BreezePasswordField();
        this.jScrollPane1 = new BreezeScrollPane();
        this.userTable = new BreezeTablePanel();
        this.enableUserCheckBox = new BreezeCheckBox();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        this.descriptionLabel.setFont(new Font("Tahoma", 0, 18));
        this.descriptionLabel.setForeground(new Color(150, 150, 150));
        this.descriptionLabel.setText("User table");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add(this.descriptionLabel, gridBagConstraints);
        this.addButton.setBackground(new Color(240, 240, 240));
        this.addButton.setDesc("Add");
        this.addButton.setDescForeground(new Color(30, 30, 30));
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/images/material/person_add.png")));
        this.addButton.setPreferredSize(new Dimension(40, 53));
        this.addButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                UserPanel.this.addButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add(this.addButton, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.removeButton.setBackground(new Color(240, 240, 240));
        this.removeButton.setDesc("Delete");
        this.removeButton.setDescForeground(new Color(30, 30, 30));
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/images/material/person_remove.png")));
        this.removeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                UserPanel.this.removeButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.removeButton, gridBagConstraints);
        this.editButton.setBackground(new Color(240, 240, 240));
        this.editButton.setDesc("Edit");
        this.editButton.setDescForeground(new Color(30, 30, 30));
        this.editButton.setIcon(new ImageIcon(this.getClass().getResource("/images/material/person_edit.png")));
        this.editButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                UserPanel.this.editButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 14, 0, 0);
        this.jPanel1.add((Component)this.editButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add(this.jPanel1, gridBagConstraints);
        this.inputPanel.setOpaque(false);
        this.inputPanel.setLayout(new GridBagLayout());
        this.firstNameLabel.setFont(new Font("Tahoma", 0, 18));
        this.firstNameLabel.setForeground(new Color(150, 150, 150));
        this.firstNameLabel.setText("First name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.inputPanel.add((Component)this.firstNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.inputPanel.add((Component)this.firstNameTextField, gridBagConstraints);
        this.lastNameLabel.setFont(new Font("Tahoma", 0, 18));
        this.lastNameLabel.setForeground(new Color(150, 150, 150));
        this.lastNameLabel.setText("Last name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.inputPanel.add((Component)this.lastNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.inputPanel.add((Component)this.lastNameTextField, gridBagConstraints);
        this.usernameLabel.setFont(new Font("Tahoma", 0, 18));
        this.usernameLabel.setForeground(new Color(150, 150, 150));
        this.usernameLabel.setText("Username");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.inputPanel.add((Component)this.usernameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.inputPanel.add((Component)this.usernameTextField, gridBagConstraints);
        this.roleLabel.setFont(new Font("Tahoma", 0, 18));
        this.roleLabel.setForeground(new Color(150, 150, 150));
        this.roleLabel.setText("Role");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.inputPanel.add((Component)this.roleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.inputPanel.add((Component)this.roleTextField, gridBagConstraints);
        this.passwordLabel.setFont(new Font("Tahoma", 0, 18));
        this.passwordLabel.setForeground(new Color(150, 150, 150));
        this.passwordLabel.setText("Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.inputPanel.add((Component)this.passwordLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.inputPanel.add((Component)this.passwordField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add(this.inputPanel, gridBagConstraints);
        this.jScrollPane1.setViewportView((Component)((Object)this.userTable));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add(this.jScrollPane1, gridBagConstraints);
        this.enableUserCheckBox.setText("Enable user login");
        this.enableUserCheckBox.addItemListener(itemEvent -> this.enableUserCheckBoxItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add(this.enableUserCheckBox, gridBagConstraints);
    }

    private void enableUserCheckBoxItemStateChanged(ItemEvent itemEvent) {
        BreezeUserManager breezeUserManager = BreezeUserManager.getInstance();
        breezeUserManager.setEnabled(this.enableUserCheckBox.isSelected());
        breezeUserManager.saveChanges();
    }

    private void addButtonMouseClicked(MouseEvent mouseEvent) {
        if (this.isediting) {
            this.tableHelper.updateUser();
            this.isediting = false;
            this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/images/material/person_add.png")));
            this.addButton.setDesc("Add");
            this.userTable.updateTable(this.tableHelper.breezeUser, false);
        } else {
            this.userTable.add(false);
        }
        this.tableHelper.clearFields();
        BreezeUserManager.getInstance().saveChanges();
    }

    private void removeButtonMouseClicked(MouseEvent mouseEvent) {
        BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Confirm delete", "Are you sure you want to selected user?", breezeActionEvent -> {
            this.userTable.delete();
            BreezeUserManager.getInstance().saveChanges();
        });
    }

    private void editButtonMouseClicked(MouseEvent mouseEvent) {
        if (this.tableHelper.editSelectedUser()) {
            this.isediting = true;
            this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/images/material/done.png")));
            this.addButton.setDesc("Update");
        }
    }

    public String toString() {
        return "";
    }

    private class TableHelper
    extends DefaultBreezeTableImpl {
        private BreezeUser breezeUser;

        private TableHelper() {
        }

        @Override
        public Object createVOFromFields(Object object, boolean bl) {
            return new BreezeUser(UserPanel.this.usernameTextField.getText(), UserPanel.this.passwordField.getValue(), UserPanel.this.firstNameTextField.getText(), UserPanel.this.lastNameTextField.getText(), (BreezeUser.Role)((Object)UserPanel.this.roleTextField.getSelectedItem()));
        }

        public boolean editSelectedUser() {
            if (this.breezeUser != null) {
                UserPanel.this.firstNameTextField.setText(this.breezeUser.getFirstName());
                UserPanel.this.lastNameTextField.setText(this.breezeUser.getLastName());
                UserPanel.this.usernameTextField.setText(this.breezeUser.getUsername());
                UserPanel.this.passwordField.setText(this.breezeUser.getPassword());
                UserPanel.this.roleTextField.setSelectedItem((Object)this.breezeUser.getRole());
                return true;
            }
            return false;
        }

        public void updateUser() {
            this.breezeUser.setUsername(UserPanel.this.usernameTextField.getText());
            this.breezeUser.setPassword(UserPanel.this.passwordField.getValue());
            this.breezeUser.setFirstName(UserPanel.this.firstNameTextField.getText());
            this.breezeUser.setLastName(UserPanel.this.lastNameTextField.getText());
            this.breezeUser.setRole((BreezeUser.Role)((Object)UserPanel.this.roleTextField.getSelectedItem()));
        }

        @Override
        public Vector createVOVector(Object object) {
            BreezeUser breezeUser = (BreezeUser)object;
            Vector<Object> vector = new Vector<Object>();
            vector.add(breezeUser.getFirstName());
            vector.add(breezeUser.getLastName());
            vector.add(breezeUser.getUsername());
            vector.add((Object)breezeUser.getRole());
            return vector;
        }

        @Override
        public List<Object> getTableHeader(List list) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("Firstname");
            arrayList.add("Lastname");
            arrayList.add("Username");
            arrayList.add("Role");
            return arrayList;
        }

        public void clearFields() {
            UserPanel.this.firstNameTextField.setText("");
            UserPanel.this.lastNameTextField.setText("");
            UserPanel.this.usernameTextField.setText("");
            UserPanel.this.passwordField.setText("");
            UserPanel.this.roleTextField.setSelectedIndex(0);
        }

        @Override
        public void putVOIntoFields(Object object) {
            this.breezeUser = (BreezeUser)object;
        }
    }
}

