/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.WizardPanel;

public abstract class AbstractWizardPanel
extends WizardPanel
implements PPEntryMainInterface {
    protected List<ViewClass> viewClassList = new ArrayList<ViewClass>();
    protected Object entryData;
    protected final BreezeMainPanel mainPanel;
    private final BreezeType pageType;

    public AbstractWizardPanel(BreezeMainPanel breezeMainPanel, BreezeType breezeType, String string, Object object, boolean bl) {
        super(breezeMainPanel.getFrame(), string, bl);
        this.mainPanel = breezeMainPanel;
        this.entryData = object;
        this.pageType = breezeType;
    }

    @Override
    public BreezeType getPageType() {
        return this.pageType;
    }

    @Override
    protected String getEntryName(Object object) {
        if (this.entryData != null) {
            return super.getEntryName(object) + " - " + AbstractWizardPanel.getEntryDataName(this.entryData);
        }
        return super.getEntryName(object);
    }

    public static String getEntryDataName(Object object) {
        if (object instanceof Group) {
            Group group = (Group)object;
            return String.valueOf(group.getParent()) + " / " + String.valueOf(group);
        }
        return object.toString();
    }

    protected String toasterMessageWhenFinished() {
        return "Done";
    }

    protected boolean shouldShowToasterWhenFinished() {
        return true;
    }

    protected void backButtonClicked() {
    }

    public static abstract class AbstractExportWizard
    extends AbstractWizardPanel {
        public AbstractExportWizard(EntryMainPanel entryMainPanel, BreezeType breezeType, String string, Object object) {
            super(entryMainPanel, breezeType, string, object, true);
        }

        @Override
        protected String toasterMessageWhenFinished() {
            return "Export done";
        }
    }

    public static abstract class AbstractImportWizard
    extends AbstractWizardPanel {
        public AbstractImportWizard(EntryMainPanel entryMainPanel, BreezeType breezeType, String string, Object object) {
            super(entryMainPanel, breezeType, string, object, true);
        }

        @Override
        protected String toasterMessageWhenFinished() {
            return "Import done";
        }
    }

    public static abstract class WizardProgressAction
    extends ProgressAction {
        private final AbstractWizardPanel wizard;

        public WizardProgressAction(AbstractWizardPanel abstractWizardPanel) {
            this.wizard = abstractWizardPanel;
        }

        @Override
        public final void actionComplete() {
            this.onFinish();
            this.wizard.closeWizard();
            if (this.wizard.shouldShowToasterWhenFinished()) {
                ToastHandler.getInstance().showToast(this.wizard.getFrame(), this.wizard.toasterMessageWhenFinished(), Toast.IconType.Success, Toast.DURATION);
            }
        }

        public void onFinish() {
        }

        @Override
        public final void actionAborted() {
            this.wizard.cancelWizard();
        }

        @Override
        public final boolean actionFailed(Exception exception) {
            this.wizard.cancelWizard();
            return super.actionFailed(exception);
        }
    }
}

