/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryTabPanel;
import se.prediktera.breeze.frontend.common.entry.MainCardPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.TextIcon;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeProgressBar;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.Project_GUI;

public abstract class WizardPanel
extends BreezeMainPanel {
    private final BreezeProgressBar progressBar = new BreezeProgressBar();
    private final List<WizardStep> allWizardSteps = new ArrayList<WizardStep>();
    private final List<WizardStep> wizardSteps = new ArrayList<WizardStep>();
    private final JPanel buttonsPanel = new JPanel(new GridBagLayout());
    private WizardStep currentStep;
    private final JPanel stepLabelsPanel;
    private final BreezeButton previousButton;
    private final BreezeButton nextButton;
    private final MainCardPanel centerPanel;
    private Project_GUI evinceProject;
    private final WizardStep.WizardControlCallback control = this.createWizardControl();

    public WizardPanel(BreezeFrame breezeFrame, String string, boolean bl) {
        super(breezeFrame);
        Color color = BreezeTheme.getInstance().getPanelBackground();
        this.progressBar.setStringPainted(false);
        this.progressBar.setPreferredSize(new Dimension(this.progressBar.getPreferredSize().width, 5));
        this.progressBar.setMinimumSize(new Dimension(this.progressBar.getPreferredSize().width, 5));
        this.progressBar.setForeground(BreezeTheme.getInstance().getProgressBarColor());
        this.progressBar.setBackground(color);
        this.stepLabelsPanel = new JPanel();
        this.stepLabelsPanel.setLayout(new BoxLayout(this.stepLabelsPanel, 0));
        this.stepLabelsPanel.setAlignmentX(0.0f);
        this.stepLabelsPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.stepLabelsPanel.setBackground(color);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.getComponentCount();
        gridBagConstraints.fill = 1;
        this.add((Component)new BreezeOptionDialog.TopPanel(string, () -> this.exitWizard(false)), gridBagConstraints);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.progressBar, "North");
        jPanel.add((Component)this.stepLabelsPanel, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = this.getComponentCount();
        this.add((Component)jPanel, gridBagConstraints);
        this.centerPanel = new MainCardPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.getComponentCount();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.centerPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setPreferredSize(new Dimension(0, 55));
        jPanel2.setMinimumSize(new Dimension(0, 55));
        jPanel2.setOpaque(false);
        this.buttonsPanel.setOpaque(false);
        jPanel2.add((Component)this.buttonsPanel, "Center");
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = jPanel3.getComponentCount();
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel3.add((Component)EntryMainHelper.createTextButton("Cancel", "cancel", this::cancelWizard), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = jPanel3.getComponentCount();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.previousButton = EntryMainHelper.createTextButton("Previous", "previous", this::previousStep);
        jPanel3.add((Component)this.previousButton, gridBagConstraints);
        this.previousButton.setVisible(bl);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = jPanel3.getComponentCount();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.nextButton = EntryMainHelper.createTextButton("Next", "next", () -> this.moveToNextStep(true));
        this.nextButton.setEnabled(false);
        jPanel3.add((Component)this.nextButton, gridBagConstraints);
        jPanel2.add((Component)jPanel3, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.getComponentCount();
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.add((Component)jPanel2, gridBagConstraints);
        this.setBackground(color);
    }

    @Override
    public void addRightButton(JComponent jComponent) {
        EntryMainHelper.addComponent(this.buttonsPanel, jComponent);
    }

    protected void cancelWizard() {
        this.closeWizard();
    }

    @Override
    public void cleanUp() {
        this.cleanUpSteps();
        super.cleanUp();
    }

    private void cleanUpSteps() {
        for (WizardStep wizardStep : this.wizardSteps) {
            wizardStep.cleanUp();
        }
    }

    protected void finishWizard() {
        this.closeWizard();
    }

    protected void closeWizard() {
        this.closeEvinceProject();
        this.cleanUpSteps();
        this.frame.removePage(this);
    }

    public void exitWizard(boolean bl) {
        if (bl) {
            this.finishWizard();
        } else {
            this.cancelWizard();
        }
    }

    protected String getEntryName(Object object) {
        return "N/A";
    }

    protected void setLists(List<ViewClass> list) {
        this.allWizardSteps.clear();
        for (final ViewClass viewClass : list) {
            this.addWizardStep(new WizardStep(){
                final /* synthetic */ WizardPanel this$0;
                {
                    this.this$0 = wizardPanel;
                }

                @Override
                public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
                    if (bl) {
                        if (viewClass.checkValidContent(wizardControlCallback).ok()) {
                            return WizardStep.LeaveResult.Ok;
                        }
                        this.this$0.enabledNextButton(true);
                        return WizardStep.LeaveResult.Failed;
                    }
                    return WizardStep.LeaveResult.Ok;
                }

                public boolean cleanUp() {
                    return true;
                }

                public boolean isCleaned() {
                    return true;
                }

                @Override
                public ViewClass getViewClass() {
                    return viewClass;
                }

                @Override
                public void enterStep() {
                    viewClass.getPanel().showEntry(null, null);
                }
            });
        }
    }

    protected void addWizardStep(WizardStep wizardStep) {
        this.allWizardSteps.add(wizardStep);
    }

    protected WizardStep.WizardControlCallback createWizardControl() {
        return new WizardStep.WizardControlCallback(){

            @Override
            public void leaveWithControl() {
                WizardPanel.this.moveToNextStep(false);
            }

            @Override
            public void resetText() {
                WizardPanel.this.setNextText("Next");
                WizardPanel.this.nextButton.setBackground(BreezeTheme.getInstance().getPanelBackground());
                WizardPanel.this.nextButton.setForeground(BreezeTheme.getInstance().getLabelForeground());
            }

            @Override
            public void restart() {
                WizardPanel.this.enterFirstStep();
            }

            @Override
            public void setEnabled(boolean bl) {
                WizardPanel.this.enabledNextButton(bl);
            }

            @Override
            public void setNextText(String string) {
                WizardPanel.this.setNextText(string);
            }
        };
    }

    protected void enabledNextButton(boolean bl) {
        this.nextButton.setEnabled(bl);
    }

    @Override
    public void showSelectedEntry(boolean bl) {
        this.enterFirstStep();
    }

    public void enterFirstStep() {
        this.enabledNextButton(false);
        this.setupEntryList();
        this.progressBar.setMaximum(this.wizardSteps.size() * 2);
        this.progressBar.setValue(1);
        this.updateStepLabels(0);
        this.enterStep(0);
    }

    public int getProgressValue() {
        return this.progressBar.getValue();
    }

    @Override
    public void setDirty(boolean bl) {
        if (bl) {
            AbstractViewPanel abstractViewPanel = this.wizardSteps.get(this.wizardSteps.indexOf(this.currentStep)).getViewClass().getPanel();
            abstractViewPanel.showEntry(null, null);
        }
    }

    public void enterStep(int n) {
        if (n >= this.wizardSteps.size()) {
            return;
        }
        WizardStep wizardStep = this.wizardSteps.get(n);
        if (wizardStep instanceof AbstractViewPanel) {
            AbstractViewPanel abstractViewPanel = (AbstractViewPanel)((Object)wizardStep);
            abstractViewPanel.showEntry(null, null);
        }
        wizardStep.enterStep();
        int n2 = this.wizardSteps.indexOf(wizardStep);
        this.previousButton.setEnabled(n2 > 0);
        AbstractViewPanel abstractViewPanel = wizardStep.getViewClass().getPanel();
        this.centerPanel.showPanel(abstractViewPanel);
        this.buttonsPanel.removeAll();
        abstractViewPanel.addComponent(this);
        this.buttonsPanel.add((Component)new JLabel(""), new GridBagConstraints(100, 0, 0, 0, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonsPanel.repaint();
        this.currentStep = wizardStep;
        new Thread(() -> {
            ThreadUtil.awaitOrThrow(abstractViewPanel::contentReady);
            this.updateNexText(n);
            this.enabledNextButton(true);
        }).start();
    }

    private JLabel getStepLabel(int n, int n2, int n3) {
        JLabel jLabel = new JLabel(this.wizardSteps.get(n2).getViewClass().getTitle(), 0);
        jLabel.setFont(new Font("Tahoma", 0, 12));
        jLabel.setMinimumSize(new Dimension(n3, jLabel.getPreferredSize().height));
        jLabel.setPreferredSize(new Dimension(n3, jLabel.getPreferredSize().height));
        if (n2 < n) {
            jLabel.setForeground(BreezeTheme.getInstance().getLabelForegroundLittleMoreDifuse());
        } else if (n2 == n) {
            jLabel.setForeground(BreezeTheme.getInstance().getLabelForeground());
            jLabel.setFont(jLabel.getFont().deriveFont(1));
        } else {
            jLabel.setForeground(BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
        }
        return jLabel;
    }

    private WizardStep.LeaveResult leaveCurrentAndEnterNewStep(int n, boolean bl) {
        WizardStep.LeaveResult leaveResult;
        if (this.currentStep != null && !(leaveResult = this.currentStep.leaveStep(this.control, bl)).ok()) {
            return leaveResult;
        }
        this.enterStep(n);
        return WizardStep.LeaveResult.Ok;
    }

    public void moveToNextStep(boolean bl) {
        int n = this.wizardSteps.indexOf(this.currentStep) + 1;
        this.enabledNextButton(false);
        if (n >= this.wizardSteps.size()) {
            if (bl) {
                WizardStep.LeaveResult leaveResult = this.currentStep.leaveStep(this.control, true);
                if (leaveResult.ok()) {
                    this.exitWizard(true);
                } else if (leaveResult.failed()) {
                    this.enabledNextButton(true);
                } else if (leaveResult.retry()) {
                    this.currentStep.enterStep();
                    this.enabledNextButton(true);
                    return;
                }
            } else {
                this.exitWizard(true);
            }
        } else if (bl) {
            if (this.leaveCurrentAndEnterNewStep(n, true).failed()) {
                this.enabledNextButton(true);
            }
        } else {
            this.enterStep(n);
        }
        this.updateProgress(n);
    }

    private void updateProgress(int n) {
        if (n < this.progressBar.getMaximum() - 1) {
            this.progressBar.setValue(n * 2 + 1);
            this.updateStepLabels(n);
        }
    }

    private void updateNexText(int n) {
        if (n < this.wizardSteps.size() - 1) {
            this.setNextText("Next");
            this.nextButton.setBackground(BreezeTheme.getInstance().getPanelBackground());
            this.nextButton.setDescForegroundReal(BreezeTheme.getInstance().getLabelForeground());
        } else {
            this.setNextText(this.getFinishText());
            this.nextButton.setBackground(BreezeTheme.getInstance().getWizardFinishButtonBackground());
            this.nextButton.setDescForegroundReal(BreezeTheme.getInstance().getWizardFinishButtonForeground());
        }
    }

    protected String getFinishText() {
        return "Finish";
    }

    private void previousStep() {
        int n = this.wizardSteps.indexOf(this.currentStep) - 1;
        this.updateNexText(n);
        if (n < 0) {
            Logg.warn((String)"Trying to step to previous from first wizard page", (Object[])new Object[0]);
        } else if (this.leaveCurrentAndEnterNewStep(n, false).ok()) {
            this.enabledNextButton(true);
            this.progressBar.setValue(n * 2 + 1);
            this.updateStepLabels(n);
        }
    }

    protected void setNextText(String string) {
        this.nextButton.setText(string);
    }

    private void setupEntryList() {
        this.wizardSteps.clear();
        ArrayList<ViewClass> arrayList = new ArrayList<ViewClass>();
        for (WizardStep wizardStep : this.allWizardSteps) {
            Object object;
            if (wizardStep instanceof WizardStep.WizardStepConditional && !(object = (WizardStep.WizardStepConditional)wizardStep).isCondition()) continue;
            object = wizardStep.getViewClass();
            this.wizardSteps.add(wizardStep);
            arrayList.add((ViewClass)object);
            ((ViewClass)object).setIcon(new TextIcon(this.wizardSteps.size(), this.getPageColor()));
        }
        this.centerPanel.addPanelsFromViewList(arrayList);
        this.updateNexText(0);
    }

    private void updateStepLabels(int n) {
        int n2 = this.wizardSteps.size();
        this.stepLabelsPanel.removeAll();
        this.stepLabelsPanel.setLayout(new GridLayout(1, n2));
        int n3 = this.progressBar.getWidth();
        if (n2 > 0) {
            int n4 = n3 / n2;
            for (int i = 0; i < n2; ++i) {
                this.stepLabelsPanel.add(this.getStepLabel(n, i, n4));
            }
        }
        this.stepLabelsPanel.revalidate();
        this.stepLabelsPanel.repaint();
    }

    @Override
    public Project_GUI getOrCreateEvinceProject() {
        if (this.evinceProject == null) {
            this.evinceProject = EntryTabPanel.createEvinceProject("Wizard", this.getColorScale());
            return this.evinceProject;
        }
        return this.evinceProject;
    }

    public void closeEvinceProject() {
        if (this.evinceProject != null) {
            try {
                this.evinceProject.closeProjectNow();
            }
            catch (Exception exception) {
                Logg.error((String)"Error closing Evince project", (Throwable)exception);
            }
            this.evinceProject = null;
        }
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> {
            BreezeFrame breezeFrame = new BreezeFrame(UpdateHelper.Product.Breeze);
            WizardPanel wizardPanel = new WizardPanel(breezeFrame, "Wizard", true){

                @Override
                protected void cancelWizard() {
                    System.exit(0);
                }

                @Override
                protected void finishWizard() {
                    System.exit(0);
                }

                @Override
                public BreezeType getPageType() {
                    return BreezeType.Project;
                }
            };
            for (int i = 1; i <= 5; ++i) {
                String string = "Step " + i;
                final ViewClass viewClass = new ViewClass(string, "Description " + string, new PPDescriptionPanel("Panel " + string));
                wizardPanel.addWizardStep(new WizardStep(){

                    public boolean cleanUp() {
                        return true;
                    }

                    public boolean isCleaned() {
                        return true;
                    }

                    @Override
                    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
                        return WizardStep.LeaveResult.Ok;
                    }

                    @Override
                    public ViewClass getViewClass() {
                        return viewClass;
                    }

                    @Override
                    public void enterStep() {
                    }
                });
            }
            wizardPanel.enterFirstStep();
            breezeFrame.setDefaultCloseOperation(3);
            Breeze.setFrameIcons(breezeFrame);
            breezeFrame.getContentPane().add((Component)wizardPanel, "Center");
            breezeFrame.setSize(800, 600);
            breezeFrame.setLocationRelativeTo(null);
            breezeFrame.setVisible(true);
        });
    }

    public static abstract class LeaveProgressAction
    extends ProgressAction {
        private final WizardStep.WizardControlCallback wizardControl;

        private LeaveProgressAction(WizardStep.WizardControlCallback wizardControlCallback) {
            this.wizardControl = wizardControlCallback;
        }

        public abstract void leaveAction();

        @Override
        public void runAction() throws Exception {
            this.leaveAction();
            this.wizardControl.leaveWithControl();
        }

        @Override
        public boolean actionFailed(Exception exception) {
            this.wizardControl.setEnabled(true);
            return false;
        }

        @Override
        public void actionAborted() {
            this.wizardControl.setEnabled(true);
        }

        public static WizardStep.LeaveResult create(BreezeFrame breezeFrame, WizardStep.WizardControlCallback wizardControlCallback, final BreezeProgressDialog.RunAction runAction, String string) {
            BreezeProgressDialog.startProgress(breezeFrame, new LeaveProgressAction(wizardControlCallback){

                @Override
                public void leaveAction() {
                    runAction.runAction(this.getProgressManager());
                }
            }, string, 0);
            return WizardStep.LeaveResult.Control;
        }

        public static WizardStep.LeaveResult createWithCancel(BreezeFrame breezeFrame, WizardStep.WizardControlCallback wizardControlCallback, final BreezeProgressDialog.RunAction runAction, String string) {
            BreezeProgressDialog.startProgressWithCancel(breezeFrame, new LeaveProgressAction(wizardControlCallback){

                @Override
                public void leaveAction() {
                    runAction.runAction(this.getProgressManager());
                }
            }, string);
            return WizardStep.LeaveResult.Control;
        }
    }
}

