/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.measure.step;

import javax.swing.SwingUtilities;
import se.prediktera.breeze.backend.measure.MeasurementTaker;
import se.prediktera.breeze.backend.measure.settings.MeasureSettings;
import se.prediktera.breeze.common.util.measure.ReferenceStatus;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.record.measurement.panel.DescriptionPanel;
import se.prediktera.breeze.frontend.wizard.WizardPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;

public class ManualDarkReferenceStep
implements WizardStep.WizardStepConditional {
    private final MeasurementTaker measurementTaker;
    private final BreezeFrame mainFrame;
    private final ViewClass viewClass;
    private final Camera camera;
    private final MeasureSettings measureSettings;
    private final SkipReferenceCheckBox skipCheckBox;
    private ReferenceStatus referenceStatus;

    public ManualDarkReferenceStep(WizardStep.WizardControlCallback wizardControlCallback, MeasurementTaker measurementTaker, BreezeFrame breezeFrame, Camera camera, MeasureSettings measureSettings) {
        DescriptionPanel descriptionPanel;
        this.measurementTaker = measurementTaker;
        this.mainFrame = breezeFrame;
        this.camera = camera;
        this.measureSettings = measureSettings;
        if (Camera.isXray(camera)) {
            descriptionPanel = new DescriptionPanel("Turn off the source and press next", "PlaceShutter2");
            this.viewClass = new CameraViewClass(camera, "Turn off source", "Turn off the source", descriptionPanel);
        } else {
            descriptionPanel = new DescriptionPanel("Place the shutter on the lens", "PlaceShutter2");
            this.viewClass = new CameraViewClass(camera, "Place Shutter", "Place shutter on lens", descriptionPanel);
        }
        this.skipCheckBox = new SkipReferenceCheckBox("dark", wizardControlCallback);
        if (measureSettings.referenceSettings().hasDarkReference(camera)) {
            descriptionPanel.addOption(this.skipCheckBox);
        }
        this.viewClass.setSubtitle2(camera.formatType());
    }

    public boolean cleanUp() {
        return true;
    }

    public boolean isCleaned() {
        return true;
    }

    @Override
    public void enterStep() {
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        if (bl && this.isCondition()) {
            return WizardPanel.LeaveProgressAction.createWithCancel(this.mainFrame, wizardControlCallback, breezeProgressManager -> {
                this.referenceStatus = this.measurementTaker.grabManualDarkReference(breezeProgressManager, this.camera);
            }, "Taking Dark Reference");
        }
        this.measurementTaker.addTookDarkReference(this.camera);
        this.skipCheckBox.skipNext();
        return WizardStep.LeaveResult.Ok;
    }

    public ReferenceStatus getReferenceStatus() {
        return this.referenceStatus;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    @Override
    public boolean isCondition() {
        if (this.skipCheckBox.isSelected()) {
            return false;
        }
        return this.measureSettings.referenceSettings().shouldTakeDarkReferenceManually(this.camera);
    }

    public static class CameraViewClass
    extends ViewClass {
        public CameraViewClass(Camera camera, String string, String string2, DescriptionPanel descriptionPanel) {
            super(string + CameraViewClass.getCameraDisplayIndex(camera), string2, descriptionPanel);
            BreezeLabel breezeLabel = new BreezeLabel(" " + Camera.getCameraTypeName(camera), true, 16);
            breezeLabel.setResourceIcon("material/videocam");
            descriptionPanel.addBottomOption(breezeLabel);
        }

        public static String getCameraDisplayIndex(Camera camera) {
            if (HardwareRegistry.hasSecondCamera()) {
                return " (" + (camera.getId() + 1) + ")";
            }
            return "";
        }
    }

    public static class SkipReferenceCheckBox
    extends BreezeCheckBox {
        private final WizardStep.WizardControlCallback nextButtonCallback;

        public SkipReferenceCheckBox(String string, WizardStep.WizardControlCallback wizardControlCallback) {
            super("Skip take " + string + " reference and use stored instead", false);
            this.nextButtonCallback = wizardControlCallback;
            this.setName("skip" + string);
            this.addCallback(bl -> wizardControlCallback.setNextText(bl ? "Skip" : "Next"));
        }

        public void skipNext() {
            SwingUtilities.invokeLater(() -> {
                this.nextButtonCallback.leaveWithControl();
                this.nextButtonCallback.setNextText("Next");
            });
        }
    }
}

