/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.measure.step;

import se.prediktera.breeze.backend.measure.MeasurementTaker;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.record.measurement.panel.DescriptionPanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.frontend.wizard.measure.step.ManualDarkReferenceStep;
import se.prediktera.breeze.frontend.wizard.measure.step.ReferenceInfoPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.Camera;

public class ManualRemoveDarkReferenceStep
implements WizardStep.WizardStepConditional {
    private final ViewClass viewClass;
    private final Camera camera;
    private final ManualDarkReferenceStep manualDarkReferenceStep;
    private final ReferenceInfoPanel infoPanel = new ReferenceInfoPanel();

    public ManualRemoveDarkReferenceStep(Camera camera, MeasurementTaker measurementTaker, ManualDarkReferenceStep manualDarkReferenceStep) {
        DescriptionPanel descriptionPanel;
        this.camera = camera;
        this.manualDarkReferenceStep = manualDarkReferenceStep;
        if (Camera.isXray(camera)) {
            descriptionPanel = new DescriptionPanel("Turn on the source and press next", "RemoveShutter2");
            this.viewClass = new ManualDarkReferenceStep.CameraViewClass(camera, "Turn on source", "Turn on the source", descriptionPanel);
        } else {
            descriptionPanel = new DescriptionPanel("Remove the shutter from the lens", "RemoveShutter2");
            this.viewClass = new ManualDarkReferenceStep.CameraViewClass(camera, "Remove Shutter", "Remove shutter on lens", descriptionPanel);
        }
        this.viewClass.setSubtitle2(camera.formatType());
        descriptionPanel.addOption(this.infoPanel);
        descriptionPanel.addOptionNoFill(EntryMainHelper.createSmallTextButton("View", () -> ReferenceHelper.viewReferences(measurementTaker.getMainPanel(), camera)));
    }

    public boolean cleanUp() {
        return true;
    }

    public boolean isCleaned() {
        return true;
    }

    @Override
    public void enterStep() {
        this.infoPanel.update(this.manualDarkReferenceStep.getReferenceStatus(), this.camera);
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    @Override
    public boolean isCondition() {
        return this.manualDarkReferenceStep.isCondition();
    }
}

