/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.measure.step;

import se.prediktera.breeze.backend.measure.MeasurementTaker;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.record.measurement.panel.DescriptionPanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.frontend.wizard.measure.step.ManualDarkReferenceStep;
import se.prediktera.breeze.frontend.wizard.measure.step.ManualWhiteReferenceStep;
import se.prediktera.breeze.frontend.wizard.measure.step.ReferenceInfoPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.SampleMover;

public class ManualRemoveWhiteReferenceStep
implements WizardStep.WizardStepConditional {
    private final ViewClass viewClass;
    private final Camera camera;
    private final ManualWhiteReferenceStep manualWhiteReferenceStep;
    private final ReferenceInfoPanel infoPanel = new ReferenceInfoPanel();

    public ManualRemoveWhiteReferenceStep(Camera camera, MeasurementTaker measurementTaker, ManualWhiteReferenceStep manualWhiteReferenceStep, SampleMover sampleMover) {
        this.camera = camera;
        this.manualWhiteReferenceStep = manualWhiteReferenceStep;
        boolean bl = sampleMover != null && sampleMover.hasWhiteRefState();
        DescriptionPanel descriptionPanel = new DescriptionPanel(bl ? "White reference has been taken" : "White reference has been taken. Remove the white reference from the camera", "RemoveWhiteReference2");
        this.viewClass = new ManualDarkReferenceStep.CameraViewClass(camera, "Remove White Reference", "Remove white reference", descriptionPanel);
        this.viewClass.setSubtitle2(camera.formatType());
        descriptionPanel.addOption(this.infoPanel);
        descriptionPanel.addOptionNoFill(EntryMainHelper.createSmallTextButton("View", () -> ReferenceHelper.viewReferences(measurementTaker.getMainPanel(), camera)));
    }

    public boolean cleanUp() {
        return true;
    }

    public boolean isCleaned() {
        return true;
    }

    @Override
    public void enterStep() {
        this.infoPanel.update(this.manualWhiteReferenceStep.getReferenceStatus(), this.camera);
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    @Override
    public boolean isCondition() {
        return this.manualWhiteReferenceStep.isCondition();
    }
}

