/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.measure.step;

import lombok.Generated;
import se.prediktera.breeze.backend.measure.MeasurementTaker;
import se.prediktera.breeze.backend.measure.settings.MeasureSettings;
import se.prediktera.breeze.common.util.measure.ReferenceStatus;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.record.measurement.panel.DescriptionPanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.frontend.wizard.WizardPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.ManualDarkReferenceStep;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.SampleMover;

public class ManualWhiteReferenceStep
implements WizardStep.WizardStepConditional {
    private final MeasurementTaker measurementTaker;
    private final ViewClass viewClass;
    private final BreezeFrame mainFrame;
    private final Camera camera;
    private final MeasureSettings measureSettings;
    private final ManualDarkReferenceStep.SkipReferenceCheckBox skipCheckBox;
    private ReferenceStatus referenceStatus;

    public ManualWhiteReferenceStep(WizardStep.WizardControlCallback wizardControlCallback, MeasurementTaker measurementTaker, BreezeFrame breezeFrame, Camera camera, MeasureSettings measureSettings, SampleMover sampleMover) {
        this.measurementTaker = measurementTaker;
        this.mainFrame = breezeFrame;
        this.camera = camera;
        this.measureSettings = measureSettings;
        boolean bl = sampleMover != null && sampleMover.hasWhiteRefState();
        DescriptionPanel descriptionPanel = new DescriptionPanel(bl ? "Confirm that the white reference is placed at its position on the sample mover" : "Place the white reference in front of the camera", "PlaceWhiteReference2");
        this.viewClass = new ManualDarkReferenceStep.CameraViewClass(camera, "Place White Reference", "Place white reference", descriptionPanel);
        this.viewClass.setSubtitle2(camera.formatType());
        this.skipCheckBox = new ManualDarkReferenceStep.SkipReferenceCheckBox("white", wizardControlCallback);
        if (measureSettings.referenceSettings().hasDarkReference(camera)) {
            descriptionPanel.addOption(this.skipCheckBox);
        }
    }

    public boolean cleanUp() {
        return true;
    }

    public boolean isCleaned() {
        return true;
    }

    @Override
    public void enterStep() {
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        if (bl && this.isCondition()) {
            return WizardPanel.LeaveProgressAction.createWithCancel(this.mainFrame, wizardControlCallback, breezeProgressManager -> {
                if (BreezeProperties.getInstance().useWhiteIntensity() && !ReferenceHelper.HasDarkReference(this.camera)) {
                    this.measurementTaker.grabManualDarkReference(breezeProgressManager, this.camera);
                }
                this.referenceStatus = this.measurementTaker.grabManualWhiteReference(breezeProgressManager, this.camera);
            }, "Taking White Reference");
        }
        this.measurementTaker.addTookWhiteReference(this.camera);
        this.skipCheckBox.skipNext();
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    @Override
    public boolean isCondition() {
        if (this.skipCheckBox.isSelected()) {
            return false;
        }
        return this.measureSettings.referenceSettings().shouldTakeWhiteReferenceManually(this.camera);
    }

    @Generated
    public ReferenceStatus getReferenceStatus() {
        return this.referenceStatus;
    }
}

