/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.measure.step;

import java.util.List;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeTextAreaInputField;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.measure.step.PlaceSampleStep;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.recorder.BreezeRecorder;

public class MeasurementInformationStep
implements WizardStep {
    private final BreezeInputField nameInputField = new BreezeInputField("Measurement name", "", " ", BreezeInputFieldHelper.Format.TwoRows);
    private final BreezeTextAreaInputField commentTextField = new BreezeTextAreaInputField("Comment", "", true);
    private final Group group;
    private final ViewClass viewClass;
    private final BreezeRecorder.BreezeRecorderViewPanel recorder;

    public MeasurementInformationStep(BreezeRecorder.BreezeRecorderViewPanel breezeRecorderViewPanel, Group group) {
        this.recorder = breezeRecorderViewPanel;
        this.group = group;
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("");
        this.nameInputField.setLabelWidth(120);
        this.nameInputField.setUnitLabelWidth(50);
        this.nameInputField.setValue(group.nextMeasurementName());
        pPDescriptionPanel.addOption(this.nameInputField);
        Workflow workflow = group.getParent();
        if (BreezeFrame.isLoggingFeature(workflow)) {
            List<BreezeInputField> list = breezeRecorderViewPanel.getLoggingFields();
            SpatialDescriptor.SiUnit siUnit = workflow.getDefaultUnit();
            for (Workflow.Logging logging : workflow.getLoggins()) {
                BreezeInputField.Number number = new BreezeInputField.Number(logging.formatName(), 0.0, siUnit.getUnit());
                number.setFormat(BreezeInputFieldHelper.Format.OneRow);
                number.setName(logging.name());
                number.setLabelWidth(120);
                number.setUnitLabelWidth(50);
                pPDescriptionPanel.addOption(number);
                list.add(number);
            }
        }
        pPDescriptionPanel.addOption(this.commentTextField);
        this.viewClass = new ViewClass("Measurement information", "", pPDescriptionPanel);
    }

    public boolean cleanUp() {
        return true;
    }

    public boolean isCleaned() {
        return true;
    }

    @Override
    public void enterStep() {
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        String string = this.nameInputField.getValue().trim();
        if (PlaceSampleStep.checkValidName(this.recorder.getFrame(), this.group, this.nameInputField, string)) {
            this.recorder.nameInputField.setText(string);
            this.recorder.commentTextArea.setText(this.commentTextField.getValue());
            return WizardStep.LeaveResult.Ok;
        }
        return WizardStep.LeaveResult.Failed;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }
}

