/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.measure.step;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.main.settings.focus.HardwareSidePanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;

public class PlaceSampleStep {
    public static boolean checkFrameRate = true;

    public static boolean checkValid(BreezeFrame breezeFrame, Group group, BreezeInputField breezeInputField, String string, List<Camera> list, SampleMover sampleMover, final HardwareSidePanel hardwareSidePanel, final Runnable runnable) {
        Object object;
        if (group != null && !PlaceSampleStep.checkValidName(breezeFrame, group, breezeInputField, string)) {
            return false;
        }
        BreezeType breezeType = BreezeType.Recorder;
        Camera camera = list.get(0);
        if (checkFrameRate && sampleMover != null && HardwareRegistry.hasMultiModeCameras()) {
            object = camera.getFrameRate();
            Camera camera2 = list.get(1);
            FrameRate frameRate = camera2.getFrameRate();
            Camera.MultiCameraMode multiCameraMode = BreezeProperties.getInstance().getMultiCameraSetting().mode();
            BreezeActionListener breezeActionListener = new BreezeActionListener(){

                @Override
                public void actionPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                    runnable.run();
                }

                @Override
                public void cancelPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                    hardwareSidePanel.getFrameRateSecondCamera().requestFocusAndSelectAll();
                }
            };
            if (multiCameraMode.equals((Object)Camera.MultiCameraMode.ScaleDown)) {
                if ((double)(Math.abs(((FrameRate)object).value - frameRate.value) / ((FrameRate)object).value) > 0.05) {
                    BreezeOptionDialog.showDialog(breezeFrame, breezeType.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Invalid frame rate", "When recording with merge, both cameras should have the " + PlaceSampleStep.getTarget(hardwareSidePanel, (FrameRate)object, true) + "\n\nPress Cancel to adjust " + PlaceSampleStep.getTarget(hardwareSidePanel, (FrameRate)object, false) + " or OK to continue", null, breezeActionListener);
                    return false;
                }
            } else if (multiCameraMode.equals((Object)Camera.MultiCameraMode.SeparateFiles) && camera.getType() == Camera.CameraCaptureType.Linescan && camera2.getType() == Camera.CameraCaptureType.Linescan) {
                FrameRate frameRate2 = FrameRate.calculateTargetFrameRate(camera, camera2);
                if ((double)(Math.abs(frameRate2.value - frameRate.value) / frameRate2.value) > 0.05) {
                    BreezeOptionDialog.showDialog(breezeFrame, breezeType.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Invalid frame rate", "When recording with separate files, the second camera (" + Camera.getCameraTypeName(camera2) + ") should have " + PlaceSampleStep.getTarget(hardwareSidePanel, frameRate2, true) + " for square pixels\n\nPress Cancel to adjust " + PlaceSampleStep.getTarget(hardwareSidePanel, frameRate2, false) + " or OK to continue", null, breezeActionListener);
                    return false;
                }
            }
        }
        return !(sampleMover instanceof RemoteSampleMover) || ((RemoteSampleMover)(object = (RemoteSampleMover)sampleMover)).checkWithinLimits(breezeFrame, breezeType.getColor(), camera.getMeasurementLength(), camera);
    }

    public static boolean checkValidName(BreezeFrame breezeFrame, Group group, BreezeInputField breezeInputField, String string) {
        String string2 = PlaceSampleStep.validateName(string, group);
        if (string2 != null) {
            BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Recorder.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Invalid name", string2, null, breezeActionEvent -> {
                if (breezeInputField != null) {
                    breezeInputField.requestFocusAndSelectAll();
                }
            });
            return false;
        }
        return true;
    }

    private static String getTarget(HardwareSidePanel hardwareSidePanel, FrameRate frameRate, boolean bl) {
        if (hardwareSidePanel.getFrameRateSecondCamera() instanceof Camera.FrameRateInputField) {
            if (bl) {
                return "frame rate (" + RtDataFormat.toString(frameRate.value, 4) + ")";
            }
            return "frame rate";
        }
        if (bl) {
            return "frame period (" + RtDataFormat.toString(frameRate.framePeriodFloat(), 4) + ")";
        }
        return "frame period";
    }

    private static String validateName(String string, Group group) {
        if (string.contains("<BARCODE>")) {
            string = string.replace("<BARCODE>", "BARCODE");
        }
        if (!FileHelper.isValidName(string)) {
            return "The measurement name is not valid\n\nAvoid special characters like \\ / : * ? \" < > | ;";
        }
        if (group.getMeasurement(string) != null) {
            return "The measurement name already exists";
        }
        List<Camera> list = HardwareRegistry.getInstance().getCamerasForRecord();
        if (list.size() > 1 && BreezeProperties.getInstance().getMultiCameraSetting().mode() == Camera.MultiCameraMode.SeparateFiles) {
            ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
            boolean bl = list.stream().map(Camera::getFormattedCameraType).distinct().count() == 1L;
            for (Camera camera : list) {
                String string2 = string + "_" + String.valueOf(bl ? Integer.valueOf(camera.getId() + 1) : camera.getFormattedCameraType());
                if (group.getMeasurement(string2) == null) continue;
                arrayList.add((CallSite)((Object)string2));
            }
            if (!arrayList.isEmpty()) {
                return "The measurement name already exists: " + String.join((CharSequence)", ", arrayList);
            }
        }
        return null;
    }

    public static interface MeasurementInfoInterface {
        public String getMeasurementName();

        default public List<BreezeInputField> getLoggingFields() {
            return new ArrayList<BreezeInputField>();
        }
    }
}

