/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.measure.step;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import se.prediktera.breeze.common.util.measure.ReferenceStatus;
import se.prediktera.breeze.common.util.measure.SpectralReferenceQuality;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.BreezePanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;

public class ReferenceInfoPanel
extends BreezePanel {
    private final BreezeInfoPanel referenceStatePanel;
    private final BreezeInfoPanel referenceTotalNumberOfSaturatedPanel;
    private final BreezeInfoPanel referenceMaxWhitePanel;
    private final BreezeInfoPanel referenceMinWhitePanel;
    private final BreezeInfoPanel referencePixelVariationPanel;

    public ReferenceInfoPanel() {
        this.setLayout(new GridBagLayout());
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.referenceStatePanel = new BreezeInfoPanel(false);
        this.add((Component)this.referenceStatePanel, gridBagConstraints);
        this.referenceStatePanel.setVisible(false);
        ++gridBagConstraints.gridy;
        this.referenceTotalNumberOfSaturatedPanel = new BreezeInfoPanel(false);
        this.add((Component)this.referenceTotalNumberOfSaturatedPanel, gridBagConstraints);
        this.referenceTotalNumberOfSaturatedPanel.setVisible(false);
        ++gridBagConstraints.gridy;
        this.referenceMaxWhitePanel = new BreezeInfoPanel(false);
        this.add((Component)this.referenceMaxWhitePanel, gridBagConstraints);
        this.referenceMaxWhitePanel.setVisible(false);
        ++gridBagConstraints.gridy;
        this.referenceMinWhitePanel = new BreezeInfoPanel(false);
        this.add((Component)this.referenceMinWhitePanel, gridBagConstraints);
        this.referenceMinWhitePanel.setVisible(false);
        ++gridBagConstraints.gridy;
        this.referencePixelVariationPanel = new BreezeInfoPanel(false);
        this.add((Component)this.referencePixelVariationPanel, gridBagConstraints);
        this.referencePixelVariationPanel.setVisible(false);
    }

    public void update(ReferenceStatus referenceStatus, Camera camera) {
        if (referenceStatus != null) {
            BreezeProperties breezeProperties = BreezeProperties.getInstance();
            this.referenceStatePanel.updatePanel(this.getInfoType(referenceStatus), this.getMessage(referenceStatus));
            if (referenceStatus.getSaturatedPixels() > 0) {
                this.referenceTotalNumberOfSaturatedPanel.setVisible(true);
                this.referenceTotalNumberOfSaturatedPanel.updatePanel(BreezeInfoPanel.InfoType.Error, "Reference has " + referenceStatus.getSaturatedPixels() + " saturated pixels");
            } else {
                this.referenceTotalNumberOfSaturatedPanel.setVisible(false);
            }
            if (referenceStatus.isWhiteReference()) {
                double d;
                float f = camera.getMaxsignal().value;
                double d2 = referenceStatus.getMean();
                if (d2 < (double)f * (d = breezeProperties.getReferenceQualityWhiteMinSignal())) {
                    this.referenceMinWhitePanel.updatePanel(BreezeInfoPanel.InfoType.Warning, "White reference less than " + Math.round(d * 100.0) + "% of max signal");
                    this.referenceMinWhitePanel.setVisible(true);
                } else {
                    this.referenceMinWhitePanel.setVisible(false);
                }
                double d3 = breezeProperties.getReferenceQualityWhiteMaxSignal();
                if (d2 > (double)f * d3) {
                    this.referenceMaxWhitePanel.updatePanel(BreezeInfoPanel.InfoType.Warning, "White reference over " + Math.round(d3 * 100.0) + "% of max signal, possible saturation");
                    this.referenceMaxWhitePanel.setVisible(true);
                } else {
                    this.referenceMaxWhitePanel.setVisible(false);
                }
            }
            double d = breezeProperties.getReferenceQualityWhitePixelVariation();
            if (referenceStatus.getStderrPixels() > d) {
                this.referencePixelVariationPanel.updatePanel(BreezeInfoPanel.InfoType.Warning, "Variation over pixels is higher than " + Math.round(d * 100.0) + "%");
                this.referencePixelVariationPanel.setVisible(true);
            } else {
                this.referencePixelVariationPanel.setVisible(false);
            }
            this.referenceStatePanel.setVisible(!this.referenceMaxWhitePanel.isVisible() && !this.referencePixelVariationPanel.isVisible() && !this.referenceMinWhitePanel.isVisible() && !this.referenceTotalNumberOfSaturatedPanel.isVisible());
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }

    private String getMessage(ReferenceStatus referenceStatus) {
        if (referenceStatus.getState().equals((Object)SpectralReferenceQuality.ReferenceState.Good)) {
            return "Reference state is Good";
        }
        return referenceStatus.getMessage();
    }

    private BreezeInfoPanel.InfoType getInfoType(ReferenceStatus referenceStatus) {
        return switch (referenceStatus.getState()) {
            default -> throw new MatchException(null, null);
            case SpectralReferenceQuality.ReferenceState.Good -> BreezeInfoPanel.InfoType.Note;
            case SpectralReferenceQuality.ReferenceState.Warning -> BreezeInfoPanel.InfoType.Warning;
            case SpectralReferenceQuality.ReferenceState.Error -> BreezeInfoPanel.InfoType.Error;
        };
    }
}

