/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.measure.step;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.Semaphore;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.measure.ReferenceStatus;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.main.record.measurement.panel.DescriptionPanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.frontend.wizard.measure.step.ReferenceInfoPanel;
import se.prediktera.breeze.hardware.Camera;

public class ReferenceStatusCustomPanel
extends AbstractBreezeCustomPanel {
    private final BreezeMainPanel mainPanel;
    private final Semaphore gate;
    private final SelectedAction[] returnValue;

    public ReferenceStatusCustomPanel(BreezeMainPanel breezeMainPanel, Camera camera, String string, ReferenceStatus referenceStatus, Semaphore semaphore, SelectedAction[] selectedActionArray) {
        this.mainPanel = breezeMainPanel;
        this.gate = semaphore;
        this.returnValue = selectedActionArray;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        DescriptionPanel descriptionPanel = new DescriptionPanel(string, null);
        descriptionPanel.setOpaque(false);
        ReferenceInfoPanel referenceInfoPanel = new ReferenceInfoPanel();
        referenceInfoPanel.update(referenceStatus, camera);
        descriptionPanel.addOption(referenceInfoPanel);
        descriptionPanel.addOptionNoFill(EntryMainHelper.createSmallTextButton("View", () -> ReferenceHelper.viewReferences(breezeMainPanel, camera)));
        BreezeLabel breezeLabel = new BreezeLabel(" " + Camera.getCameraTypeName(camera), true, 16);
        breezeLabel.setResourceIcon("material/videocam");
        descriptionPanel.addBottomOption(breezeLabel);
        this.add((Component)((Object)descriptionPanel), "Center");
        BreezeFrame.setRelativeSize(this, 0.5, 0.7);
    }

    @Override
    public void customButton(BreezeButton breezeButton, BreezeButton breezeButton2, BreezeButton breezeButton3) {
        breezeButton.setName("retake");
        breezeButton.setText("Retake");
        breezeButton.addClickCallBack(() -> this.setReturnValueAndClose(SelectedAction.RETAKE));
        breezeButton2.setName("cancel");
        breezeButton2.setText("Cancel");
        breezeButton2.clearMouseListeners();
        breezeButton2.addHoverEffects();
        breezeButton2.addClickCallBack(() -> this.setReturnValueAndClose(SelectedAction.CANCEL));
        breezeButton3.setName("continue");
        breezeButton3.setText("Continue");
        breezeButton3.clearMouseListeners();
        breezeButton3.addHoverEffects();
        breezeButton3.addClickCallBack(this::showConfirmDialogForContinue);
    }

    private void showConfirmDialogForContinue() {
        BreezeOptionDialog.showDialog(this.mainPanel.getFrame(), this.mainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Reference quality not met", "The reference did not pass quality validation.\n\nDo you want to continue and use it anyway?", null, breezeActionEvent -> this.setReturnValueAndClose(SelectedAction.CONTINUE));
    }

    private void setReturnValueAndClose(SelectedAction selectedAction) {
        this.returnValue[0] = selectedAction;
        this.okPressed(true);
    }

    public static SelectedAction showDialog(BreezeMainPanel breezeMainPanel, Camera camera, ReferenceStatus referenceStatus, ReferenceStatusDialogType referenceStatusDialogType) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must not block EDT");
        }
        final Semaphore semaphore = new Semaphore(0);
        final SelectedAction[] selectedActionArray = new SelectedAction[1];
        BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), referenceStatusDialogType.getDialogType(), StringHelper.formatLabel(referenceStatus.getType()) + " information", "", (AbstractBreezeCustomPanel)new ReferenceStatusCustomPanel(breezeMainPanel, camera, referenceStatusDialogType.getDescription(), referenceStatus, semaphore, selectedActionArray), null, new BreezeActionListener(){

            @Override
            public void actionPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                semaphore.release();
            }

            @Override
            public void cancelPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                selectedActionArray[0] = SelectedAction.CANCEL;
                semaphore.release();
            }
        });
        semaphore.acquire();
        return selectedActionArray[0];
    }

    @Override
    public boolean usePreferredSize() {
        return true;
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public void cancelPressed() {
        this.setReturnValueAndClose(SelectedAction.CANCEL);
        this.gate.release();
    }

    public static enum SelectedAction {
        CANCEL,
        RETAKE,
        CONTINUE;

    }

    public static enum ReferenceStatusDialogType {
        Record,
        Import,
        Quality;


        public String getDescription() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "Warnings and errors from reference capture";
                case 1 -> "Warnings and errors from reference import";
                case 2 -> "Warnings and errors from reference import";
            };
        }

        public AbstractBreezeDialog.MessageType getDialogType() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> AbstractBreezeDialog.MessageType.WIZARD_OPTION;
                case 1 -> AbstractBreezeDialog.MessageType.CONFIRM_OPTION;
                case 2 -> AbstractBreezeDialog.MessageType.CLOSE_OPTION;
            };
        }
    }
}

