/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.measure.step;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import se.prediktera.breeze.common.util.image.RtPixelFloat;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class SegmentationOptionPanel
extends JPanel {
    private SegmentationOption option;
    private final SegmentationObjectPanel objectPanel = new SegmentationObjectPanel();

    public SegmentationOptionPanel() {
        super(new BorderLayout());
        this.setOpaque(false);
        this.add((Component)this.objectPanel, "Center");
        this.objectPanel.setPreferredSize(new Dimension(100, 120));
        this.objectPanel.setMinimumSize(new Dimension(100, 120));
        this.objectPanel.setOpaque(false);
    }

    public void setOption(SegmentationOption segmentationOption) {
        this.option = segmentationOption;
        this.objectPanel.setToolTipText(this.getDescription(segmentationOption));
        this.repaint();
    }

    private String getDescription(SegmentationOption segmentationOption) {
        return switch (segmentationOption.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "Generates image measurement after an empty horizontal line is seen across the image view or if max line setting is reached";
            case 1 -> "Generates image measurement after each object";
            case 2 -> "Crop object (image a rectangular shape around the object";
        };
    }

    private class SegmentationObjectPanel
    extends JPanel {
        final float[] dash1 = new float[]{5.0f};
        final BasicStroke dashed = new BasicStroke(2.0f, 0, 0, 10.0f, this.dash1, 0.0f);
        private final List<RtPixelFloat> objects = new ArrayList<RtPixelFloat>();
        private final int size = 25;

        public SegmentationObjectPanel() {
            this.objects.add(new RtPixelFloat(1.0f, 1.0f));
            this.objects.add(new RtPixelFloat(3.0f, 1.5f));
            this.objects.add(new RtPixelFloat(1.5f, 2.2f));
            this.objects.add(new RtPixelFloat(2.7f, 3.0f));
            this.objects.add(new RtPixelFloat(1.0f, 4.4f));
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (RtPixelFloat object2 : this.objects) {
                this.drawObject(graphics2D, object2.x, object2.y);
            }
            graphics2D.setStroke(this.dashed);
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            graphics2D.setColor(breezeTheme.getLabelForegroundMoreDifuse());
            Color color = breezeTheme.getSelectionBackground();
            switch (SegmentationOptionPanel.this.option.ordinal()) {
                case 0: {
                    this.drawRect(graphics2D, 1.0, 4.0, 3.0, 1.5);
                    graphics2D.setColor(color);
                    this.drawRect(graphics2D, 1.0, 1.0, 3.0, 3.0);
                    break;
                }
                case 1: {
                    for (int i = 1; i < this.objects.size(); ++i) {
                        this.drawRect(graphics2D, 1.0, this.objects.get((int)i).y, 3.0, 1.0);
                    }
                    graphics2D.setColor(color);
                    this.drawRect(graphics2D, 1.0, 1.0, 3.0, 1.0);
                    break;
                }
                case 2: {
                    for (int i = 1; i < this.objects.size(); ++i) {
                        this.drawRect(graphics2D, this.objects.get((int)i).x, this.objects.get((int)i).y, 1.0, 1.0);
                    }
                    graphics2D.setColor(color);
                    this.drawRect(graphics2D, 1.0, 1.0, 1.0, 1.0);
                }
            }
        }

        private void drawObject(Graphics2D graphics2D, double d, double d2) {
            int n = (int)((d - 1.0) * 25.0 + 2.5) + 1;
            int n2 = (int)((d2 - 1.0) * 25.0 + 2.5) + 1;
            graphics2D.setColor(Color.lightGray);
            graphics2D.fillOval(n, n2, 20, 20);
            graphics2D.setColor(Color.black);
            graphics2D.drawOval(n, n2, 20, 20);
        }

        private void drawRect(Graphics2D graphics2D, double d, double d2, double d3, double d4) {
            int n = (int)((d - 1.0) * 25.0) + 1;
            int n2 = (int)((d2 - 1.0) * 25.0) + 1;
            int n3 = (int)(d3 * 25.0);
            int n4 = (int)(d4 * 25.0);
            graphics2D.drawRect(n, n2, n3, n4);
        }
    }

    public static enum SegmentationOption {
        Sequential,
        Parallel,
        Crop;

    }
}

