/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.measure.step;

import se.prediktera.breeze.backend.measure.MeasurementTaker;
import se.prediktera.breeze.backend.measure.settings.MeasureSettings;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.record.measurement.panel.DescriptionPanel;
import se.prediktera.breeze.frontend.wizard.WizardPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.ManualDarkReferenceStep;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.map.common.error.Logg;

public class TakeDarkReferenceStep
implements WizardStep.WizardStepConditional {
    private final MeasurementTaker measurementTaker;
    private final BreezeFrame mainFrame;
    private final ViewClass viewClass;
    private final BreezeCheckBox showWizardStepCheckBox;
    private final Camera camera;
    private final MeasureSettings measureSettings;

    public TakeDarkReferenceStep(MeasurementTaker measurementTaker, BreezeFrame breezeFrame, Camera camera, MeasureSettings measureSettings) {
        this.measurementTaker = measurementTaker;
        this.mainFrame = breezeFrame;
        this.camera = camera;
        this.measureSettings = measureSettings;
        DescriptionPanel descriptionPanel = new DescriptionPanel("The dark reference will be taken", null);
        this.showWizardStepCheckBox = new BreezeCheckBox("Always show this step", BreezeProperties.getInstance().showDarkReferenceWizardStep());
        descriptionPanel.addOption(this.showWizardStepCheckBox);
        this.showWizardStepCheckBox.addActionListener(actionEvent -> BreezeProperties.getInstance().setShowDarkReferenceWizardStep(this.showWizardStepCheckBox.isSelected()));
        this.viewClass = new ManualDarkReferenceStep.CameraViewClass(camera, "Take Dark Reference", camera.formatType(), descriptionPanel);
    }

    public boolean cleanUp() {
        return true;
    }

    public boolean isCleaned() {
        return true;
    }

    @Override
    public void enterStep() {
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        if (bl) {
            Logg.debug((String)"Taking dark reference wizard step", (Object[])new Object[0]);
            return WizardPanel.LeaveProgressAction.createWithCancel(this.mainFrame, wizardControlCallback, breezeProgressManager -> this.measurementTaker.grabManualDarkReference(breezeProgressManager, this.camera), "Taking Dark Reference");
        }
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    @Override
    public boolean isCondition() {
        return BreezeProperties.getInstance().showDarkReferenceWizardStep() && this.measureSettings.referenceSettings().shouldTakeDarkReferenceAutomatically(this.camera);
    }
}

