/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model;

import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.RuntimeClassificationModel;
import se.prediktera.breeze.entry.util.PPModelInfo;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.pp.PPViewClass;
import se.prediktera.breeze.frontend.wizard.model.AbstractModelWizard;
import se.prediktera.breeze.frontend.wizard.model.RuntimeModelWizard;
import se.prediktera.breeze.frontend.wizard.model.panel.ml.ANNModelPanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectSamplePanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectVariablePanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectWavelengthPanelStep;

public class ANNModelWizard
extends RuntimeModelWizard {
    public ANNModelWizard(BreezeProgress breezeProgress, BreezeMainPanel breezeMainPanel, BreezeType breezeType, PPViewClass pPViewClass, Analyse analyse, AbstractModelWizard.OnFinishWizardCallback onFinishWizardCallback) {
        super(breezeProgress, breezeMainPanel, breezeType, pPViewClass, analyse, onFinishWizardCallback);
        this.modelFilePath = this.getCurrentAnalyse().getModelDataFile().toPath();
        this.addWizardStep(new SelectVariablePanelStep(this, analyse, (Model.ModelWithSample)this.model, "Categories"));
        this.addWizardStep(new SelectSamplePanelStep(this, analyse, (Model.ModelWithSample)this.model));
        this.addWizardStep(new SelectWavelengthPanelStep(this, analyse, this.model));
        this.addWizardStep(new ANNModelPanelStep(this, analyse, this.ppclass, (RuntimeClassificationModel)this.model, this.createWizardControl(), this.callBack));
    }

    public static class Info
    extends PPModelInfo {
        @Override
        public String getDescription() {
            return "Create classification model (Artificial Neural Network)";
        }

        @Override
        public String getName() {
            return "ANNClassification";
        }

        @Override
        public String getImageIcon() {
            return "onnx";
        }

        @Override
        public String getShortDescription() {
            return this.getShortName();
        }

        @Override
        public String getHelp() {
            return "";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Classification;
        }

        @Override
        public String getShortName() {
            return "Artificial Neural Network";
        }

        @Override
        public BasicAnalyse.ModelMethod getModelMethod() {
            return BasicAnalyse.ModelMethod.ClassificationANN;
        }

        @Override
        public AbstractModelWizard createWizard(BreezeProgress breezeProgress, BreezeMainPanel breezeMainPanel, PPViewClass pPViewClass, Analyse analyse, AbstractModelWizard.OnFinishWizardCallback onFinishWizardCallback) {
            return new ANNModelWizard(breezeProgress, breezeMainPanel, BreezeType.Analyse, pPViewClass, analyse, onFinishWizardCallback);
        }
    }
}

