/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.AnalyseSpectralGroup;
import se.prediktera.breeze.entry.analyse.RecordGroupHolder;
import se.prediktera.breeze.entry.analyse.model.ClassificationModel;
import se.prediktera.breeze.entry.analyse.model.CurveSeparationModel;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.QuantificationModel;
import se.prediktera.breeze.entry.analyse.model.RuntimeClassificationModel;
import se.prediktera.breeze.entry.analyse.model.RuntimeQuantificationModel;
import se.prediktera.breeze.entry.analyse.model.RuntimeSampleModel;
import se.prediktera.breeze.entry.analyse.model.SampleModel;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.pp.PPClass;
import se.prediktera.breeze.frontend.common.pp.PPViewClass;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.util.ModelVersionHelper;
import se.prediktera.map.main.script.EvinceScriptCommands;

public abstract class AbstractModelWizard
extends AbstractWizardPanel {
    protected Analyse currentAnalyse;
    protected final PPClass ppclass;
    protected final Model model;
    private final OnFinishWizardCallback onFinishCallback;

    public AbstractModelWizard(BreezeProgress breezeProgress, BreezeMainPanel breezeMainPanel, BreezeType breezeType, PPViewClass pPViewClass, Analyse analyse, OnFinishWizardCallback onFinishWizardCallback) {
        super(breezeMainPanel, breezeType, pPViewClass.getPpInfo().getDescription() + " - [" + analyse.getName() + "]", analyse, true);
        this.currentAnalyse = analyse;
        this.onFinishCallback = onFinishWizardCallback;
        this.ppclass = new PPClass(this, EvinceScriptCommands.removeSpace((String)pPViewClass.getName().toLowerCase()), pPViewClass);
        analyse.checkFullyParsed();
        this.model = AbstractModelWizard.createModel(breezeProgress, analyse, null);
        RecordGroupHolder recordGroupHolder = analyse.getRecordGroupHolder();
        AnalyseSpectralGroup.AnalyseSpectralGroups analyseSpectralGroups = recordGroupHolder.getGroups();
        for (AnalyseSpectralGroup analyseSpectralGroup : new ArrayList<AnalyseSpectralGroup>(analyseSpectralGroups)) {
            if (analyseSpectralGroup.hasGroup()) continue;
            ToastHandler.getInstance().showToast(breezeMainPanel.getFrame(), "Group (" + analyseSpectralGroup.getGroupName() + ") removed");
            analyseSpectralGroups.remove(analyseSpectralGroup);
        }
    }

    public static Model createModel(BreezeProgress breezeProgress, Analyse analyse, List<FactorOrDescriptor> list) {
        BasicAnalyse.ModelMethod modelMethod = analyse.getModelMethod();
        switch (modelMethod) {
            case SamplePca: {
                return new SampleModel(analyse);
            }
            case SampleRuntime: {
                return new RuntimeSampleModel(analyse);
            }
            case QuantificationPls: {
                return new QuantificationModel(breezeProgress, analyse, list);
            }
            case ClassificationPlsDa: 
            case SimcaClassification: {
                return new ClassificationModel(breezeProgress, analyse, list);
            }
            case ClassificationCurveSeparation: {
                return new CurveSeparationModel(breezeProgress, analyse, list);
            }
            case ClassificationRuntime: 
            case ClassificationANN: {
                return new RuntimeClassificationModel(breezeProgress, analyse, list);
            }
            case QuantificationRuntime: {
                return new RuntimeQuantificationModel(breezeProgress, analyse, list);
            }
        }
        throw new RuntimeException("Unsupported model type: " + String.valueOf((Object)modelMethod));
    }

    @Override
    public VisualisationNode.ColorScale getColorScale() {
        Workflow workflow = this.currentAnalyse.getWorkflow();
        if (workflow != null) {
            return workflow.getColorScale();
        }
        return null;
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return this.model.getEvinceMatrix(breezeProgressManager, string);
    }

    @Override
    protected void cancelWizard() {
        this.model.close();
        super.cancelWizard();
    }

    @Override
    public void finishWizard() {
        BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this){

            @Override
            public void runAction() {
                this.setInfoText("Saving model");
                ModelVersionHelper.archiveModelFiles(AbstractModelWizard.this.getCurrentAnalyse(), this.getProgressManager());
                AbstractModelWizard.this.model.finishAndSave(this.getProgressManager());
                AbstractModelWizard.this.finishLocal(this.getProgressManager());
                AbstractModelWizard.this.currentAnalyse.calculateAndSaveCorrectlyClassified(this.getProgressManager());
                DataSetCache.clear(AbstractModelWizard.this.currentAnalyse);
                AbstractModelWizard.this.currentAnalyse.reload();
                if (AbstractModelWizard.this.onFinishCallback != null) {
                    AbstractModelWizard.this.onFinishCallback.onFinish();
                }
            }
        }, "Finish");
    }

    protected void finishLocal(BreezeProgress breezeProgress) {
    }

    @Override
    protected String getEntryName(Object object) {
        if (this.currentAnalyse != null) {
            return super.getEntryName(object) + " - " + this.currentAnalyse.toString();
        }
        return super.getEntryName(object);
    }

    @Generated
    public Analyse getCurrentAnalyse() {
        return this.currentAnalyse;
    }

    public static interface OnFinishWizardCallback {
        public void onFinish();
    }
}

