/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.ClassificationModel;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.util.PPModelInfo;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.pp.PPViewClass;
import se.prediktera.breeze.frontend.wizard.model.AbstractModelWizard;
import se.prediktera.breeze.frontend.wizard.model.panel.EvaluatePanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.ExcludeOutlierPanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectSamplePanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectVariablePanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectWavelengthPanelStep;

public class ClassificationModelWizard
extends AbstractModelWizard {
    public ClassificationModelWizard(BreezeProgress breezeProgress, BreezeMainPanel breezeMainPanel, PPViewClass pPViewClass, Analyse analyse, AbstractModelWizard.OnFinishWizardCallback onFinishWizardCallback) {
        super(breezeProgress, breezeMainPanel, BreezeType.Analyse, pPViewClass, analyse, onFinishWizardCallback);
        this.addWizardStep(new SelectVariablePanelStep(this, analyse, (ClassificationModel)this.model, "Categories"));
        this.addWizardStep(new SelectSamplePanelStep(this, analyse, (Model.ModelWithSample)this.model));
        this.addWizardStep(new SelectWavelengthPanelStep(this, analyse, this.model));
        this.addWizardStep(new ExcludeOutlierPanelStep(this, analyse, true, this.ppclass, (ClassificationModel)this.model));
        this.addWizardStep(new EvaluatePanelStep(this, analyse, this.ppclass, (ClassificationModel)this.model));
    }

    public static class Info
    extends PPModelInfo {
        @Override
        public String getImageIcon() {
            return "classification.png";
        }

        @Override
        public String getHelp() {
            return "";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Classification;
        }

        @Override
        public String getShortDescription() {
            return "PLS-DA Classification";
        }

        @Override
        public String getDescription() {
            return "Create classification model (PLS-DA)";
        }

        @Override
        public String getName() {
            return "Classification";
        }

        @Override
        public BasicAnalyse.ModelMethod getModelMethod() {
            return BasicAnalyse.ModelMethod.ClassificationPlsDa;
        }

        @Override
        public List<BasicAnalyse.ModelMethod> getTypes(Workflow workflow) {
            BandCount bandCount;
            Measurement measurement;
            ArrayList<BasicAnalyse.ModelMethod> arrayList = new ArrayList<BasicAnalyse.ModelMethod>();
            if (workflow != null && (measurement = workflow.getFirstMeasurementWithData()) != null && (bandCount = measurement.getBandCount()) != null && bandCount.value == 2) {
                arrayList.add(BasicAnalyse.ModelMethod.ClassificationCurveSeparation);
            }
            arrayList.add(BasicAnalyse.ModelMethod.ClassificationPlsDa);
            arrayList.add(BasicAnalyse.ModelMethod.SimcaClassification);
            arrayList.add(BasicAnalyse.ModelMethod.ClassificationRuntime);
            if (BreezeFrame.isCustomNeuralNetworkFeature()) {
                arrayList.add(BasicAnalyse.ModelMethod.ClassificationANN);
            }
            return arrayList;
        }

        @Override
        public AbstractModelWizard createWizard(BreezeProgress breezeProgress, BreezeMainPanel breezeMainPanel, PPViewClass pPViewClass, Analyse analyse, AbstractModelWizard.OnFinishWizardCallback onFinishWizardCallback) {
            return new ClassificationModelWizard(breezeProgress, breezeMainPanel, pPViewClass, analyse, onFinishWizardCallback);
        }
    }
}

