/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.pp.PPViewClass;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.frontend.wizard.model.AbstractModelWizard;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectSamplePanelStep;

public class RuntimeModelWizard
extends AbstractModelWizard {
    private File newlyCreatedModelFile = null;
    protected CallBack callBack = file -> {
        this.newlyCreatedModelFile = file;
    };
    protected Path modelFilePath = this.getCurrentAnalyse().getOnnxFile().toPath();

    public RuntimeModelWizard(BreezeProgress breezeProgress, BreezeMainPanel breezeMainPanel, BreezeType breezeType, PPViewClass pPViewClass, Analyse analyse, AbstractModelWizard.OnFinishWizardCallback onFinishWizardCallback) {
        super(breezeProgress, breezeMainPanel, breezeType, pPViewClass, analyse, onFinishWizardCallback);
    }

    protected SelectSamplePanelStep GetSelectSamplePanelStepWithTestSetValidation() {
        return new SelectSamplePanelStep(this, this.currentAnalyse, (Model.ModelWithSample)this.model){

            @Override
            public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
                if (bl && !this.anyTestObjects()) {
                    BreezeOptionDialog.showDialog(this.mainpanel.getFrame(), BreezeType.Analyse.getColor(), AbstractBreezeDialog.MessageType.WARNING_OPTION, "Add Test Set Required", "You have not selected any test set for training the ML model. Please ensure you select a test set to proceed with training.\nA test set is crucial for evaluating the model's performance and generalization.", null, breezeActionEvent -> RuntimeModelWizard.this.enabledNextButton(true));
                    return WizardStep.LeaveResult.Failed;
                }
                return super.leaveStep(wizardControlCallback, bl);
            }
        };
    }

    @Override
    protected void finishLocal(BreezeProgress breezeProgress) {
        super.finishLocal(breezeProgress);
        if (this.newlyCreatedModelFile != null && this.newlyCreatedModelFile.exists()) {
            Files.copy(this.newlyCreatedModelFile.toPath(), this.modelFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static interface CallBack {
        public void OnDone(File var1);
    }
}

