/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model;

import java.awt.Dimension;
import java.util.Arrays;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.SegmentationParameter;
import se.prediktera.breeze.common.realtime.segmentation.model.AbstractModelSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.model.ModelSegmentation;
import se.prediktera.breeze.common.util.image.RtObjectIdentificationHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.SampleModel;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.pp.PPClass;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.wizard.model.SampleModelWizard;
import se.prediktera.breeze.frontend.wizard.model.panel.ModelFinishStep;

class SampleModelFinishStep
extends ModelFinishStep {
    private final BreezeInputField minAreaField;
    public final BreezeCheckBox applyCheckBox;
    private final BreezeInputField.Number shrinkInputField;
    private final BreezeComboBoxInputField separateComboBox;
    private final BreezeCheckBox inverseCheckBox = new BreezeCheckBox("Inverse", false);
    protected final Analyse analyse;
    private final SampleModel model;

    public SampleModelFinishStep(Analyse analyse, PPClass pPClass, SampleModel sampleModel) {
        super("A Sample model has been created.\n\nPress Finish to save the sample model and apply it on all measurements in the group.", pPClass);
        this.analyse = analyse;
        this.model = sampleModel;
        this.applyCheckBox = new BreezeCheckBox();
        this.applyCheckBox.setText("Apply changes when finished");
        this.applyCheckBox.setSelected(true);
        this.addOption(this.applyCheckBox);
        CollapsePanel.NoExpandCollapsePanel noExpandCollapsePanel = new CollapsePanel.NoExpandCollapsePanel("Segmentation options");
        this.minAreaField = new BreezeInputField("Minimum area size", "50", "pixels", BreezeInputFieldHelper.Format.OneRow);
        this.minAreaField.setLabelWidth(200);
        this.minAreaField.getTextField().setPreferredSize(new Dimension(200, 30));
        this.minAreaField.setNumberField(true, 0.0, 2.147483647E9);
        noExpandCollapsePanel.addPanelNoFillHorizontal(this.minAreaField);
        this.shrinkInputField = new BreezeInputField.Number("Shrink", 0.0, "pixels");
        this.shrinkInputField.setUsage("Remove number of pixels from border");
        CollapsePanel collapsePanel = new CollapsePanel("Advanced");
        collapsePanel.addPanel(this.shrinkInputField, null, 150);
        this.separateComboBox = new BreezeComboBoxInputField<SegmentationParameter.SeparateOption>("Separate", Arrays.asList(SegmentationParameter.SeparateOption.values()), SegmentationParameter.SeparateOption.NORMAL, BreezeInputFieldHelper.Format.OneRow);
        this.separateComboBox.reformat();
        collapsePanel.addPanel(this.separateComboBox, 150);
        collapsePanel.addPanel(this.inverseCheckBox);
        noExpandCollapsePanel.addPanel(collapsePanel);
        this.addOption(noExpandCollapsePanel);
        this.minAreaField.setName("minArea");
    }

    public double getMinArea() {
        return this.minAreaField.getNumber();
    }

    public int getShrink() {
        return this.shrinkInputField.getNumberInt();
    }

    public SegmentationParameter.SeparateOption getSeparate() {
        return (SegmentationParameter.SeparateOption)((Object)this.separateComboBox.getSelectedItem());
    }

    public boolean isInverse() {
        return this.inverseCheckBox.isSelected();
    }

    private AbstractModelSegmentation getModelSegmentation(Analyse analyse) {
        Workflow workflow;
        FunctionTreeNode functionTreeNode;
        Group group = analyse.getFirstGroup();
        if (group != null && (functionTreeNode = (workflow = group.getParent()).getRoot()) != null) {
            return SampleModelWizard.getSegmentation(functionTreeNode, analyse);
        }
        return null;
    }

    @Override
    public void enterStep() {
        super.enterStep();
        AbstractModelSegmentation abstractModelSegmentation = this.getModelSegmentation(this.analyse);
        if (abstractModelSegmentation != null) {
            this.minAreaField.setValue(abstractModelSegmentation.getMinArea());
            this.shrinkInputField.setValue(abstractModelSegmentation.getShrink());
            this.separateComboBox.setSelectedItem(abstractModelSegmentation.getSeparateOption());
            if (abstractModelSegmentation instanceof ModelSegmentation) {
                ModelSegmentation modelSegmentation = (ModelSegmentation)abstractModelSegmentation;
                this.inverseCheckBox.setSelected(modelSegmentation.isInverse());
            }
        } else {
            this.minAreaField.setValue(this.calculateMinArea());
            this.shrinkInputField.setValue(0.0);
            this.separateComboBox.setSelectedItem(SegmentationParameter.SeparateOption.NORMAL);
            this.inverseCheckBox.setSelected(false);
        }
    }

    private int calculateMinArea() {
        RtObjectIdentificationHelper.RtIdentifiedObjectList rtIdentifiedObjectList = this.model.getObjects();
        if (rtIdentifiedObjectList.isEmpty()) {
            return 0;
        }
        int n = this.model.getReduce();
        int n2 = this.model.getPixelCount();
        int n3 = n2 / rtIdentifiedObjectList.size();
        return this.round((int)((double)((float)n3 * 0.2f) * Math.pow(n, 2.0)));
    }

    private int round(int n) {
        if (n >= 1000000) {
            return (int)((double)n / 1000000.0) * 1000000;
        }
        if (n >= 100000) {
            return (int)((double)n / 100000.0) * 100000;
        }
        if (n >= 10000) {
            return (int)((double)n / 10000.0) * 10000;
        }
        if (n >= 1000) {
            return (int)((double)n / 1000.0) * 1000;
        }
        if (n >= 100) {
            return (int)((double)n / 100.0) * 100;
        }
        if (n >= 10) {
            return (int)((double)n / 10.0) * 10;
        }
        if (n >= 5) {
            return 5;
        }
        return 0;
    }
}

