/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.segmentation.model.AbstractModelSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.model.ModelSegmentation;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.SampleModel;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.util.PPModelInfo;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.pp.PPViewClass;
import se.prediktera.breeze.frontend.wizard.model.AbstractModelWizard;
import se.prediktera.breeze.frontend.wizard.model.SampleModelFinishStep;
import se.prediktera.breeze.frontend.wizard.model.panel.SampleModelPanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.SampleOutlierPanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectMeasurementPanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectWavelengthPanelStep;

public class SampleModelWizard
extends AbstractModelWizard {
    private final SampleModelFinishStep finishStep;

    public SampleModelWizard(BreezeProgress breezeProgress, BreezeMainPanel breezeMainPanel, PPViewClass pPViewClass, Analyse analyse, AbstractModelWizard.OnFinishWizardCallback onFinishWizardCallback) {
        super(breezeProgress, breezeMainPanel, BreezeType.Analyse, pPViewClass, analyse, onFinishWizardCallback);
        this.addWizardStep(new SelectMeasurementPanelStep(this, analyse, (SampleModel)this.model));
        this.addWizardStep(new SelectWavelengthPanelStep(this, analyse, this.model));
        this.addWizardStep(new SampleModelPanelStep(this, analyse, this.ppclass));
        this.addWizardStep(new SampleOutlierPanelStep(this, this.ppclass, (SampleModel)this.model));
        this.finishStep = new SampleModelFinishStep(analyse, this.ppclass, (SampleModel)this.model);
        this.addWizardStep(this.finishStep);
    }

    @Override
    protected void finishLocal(BreezeProgress breezeProgress) {
        breezeProgress.setInfoText("Applying model on record files");
        Group group = this.currentAnalyse.getFirstGroup();
        Workflow workflow = group.getParent();
        FunctionTreeNode functionTreeNode = workflow.getRoot();
        AbstractModelSegmentation abstractModelSegmentation = SampleModelWizard.getSegmentation(functionTreeNode, this.currentAnalyse);
        if (abstractModelSegmentation == null) {
            SegmentationNode segmentationNode = (SegmentationNode)FunctionHelper.createNew(new ModelSegmentation.Info());
            abstractModelSegmentation = (ModelSegmentation)segmentationNode.getFunction();
            segmentationNode.recreateSegmentationPorts(workflow);
            SegmentationNode segmentationNode2 = SegmentationNode.getLastSegmentationNode(functionTreeNode);
            if (segmentationNode2 != null && segmentationNode2.getDefaultPort() != null && segmentationNode2.getFunction() instanceof AbstractModelSegmentation) {
                segmentationNode2.getDefaultPort().addChild(segmentationNode);
            } else {
                functionTreeNode.addChild(segmentationNode);
            }
        }
        abstractModelSegmentation.setAnalyse(this.currentAnalyse);
        abstractModelSegmentation.getParameterByName("minarea").setValue(this.finishStep.getMinArea());
        abstractModelSegmentation.getParameterByName("shrink").setValue(this.finishStep.getShrink());
        abstractModelSegmentation.getParameterByName("object").setValueStr(this.finishStep.getSeparate().xmlName());
        abstractModelSegmentation.getParameterByName("inverse").setValueStr(Boolean.toString(this.finishStep.isInverse()));
        workflow.save();
        workflow.getVisualisationNode().setDefaultLevel(false);
        DataSetCache.clearRecursive(group);
        if (this.finishStep.applyCheckBox.isSelected()) {
            ApplyChanges.applyChanges(breezeProgress, workflow.getAllMeasurements());
        } else {
            workflow.setApplyChangesNeededOnAllMeasurements();
        }
        group.performGroupDescriptors();
        DataSetCache.clearRecursive(group);
        group.save();
    }

    public static AbstractModelSegmentation getSegmentation(FunctionTreeNode functionTreeNode, Analyse analyse) {
        AbstractBreezeFunction abstractBreezeFunction = functionTreeNode.getFunction();
        if (abstractBreezeFunction instanceof AbstractModelSegmentation) {
            AbstractModelSegmentation abstractModelSegmentation = (AbstractModelSegmentation)abstractBreezeFunction;
            if (analyse.getUid().equals(abstractModelSegmentation.getAnalyseUid())) {
                return abstractModelSegmentation;
            }
        }
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            AbstractModelSegmentation abstractModelSegmentation = SampleModelWizard.getSegmentation(functionTreeNode2, analyse);
            if (abstractModelSegmentation == null) continue;
            return abstractModelSegmentation;
        }
        return null;
    }

    public static class Info
    extends PPModelInfo {
        @Override
        public String getImageIcon() {
            return "segmentanything";
        }

        @Override
        public String getHelp() {
            return "";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Sample;
        }

        @Override
        public String getShortDescription() {
            return "Sample Model";
        }

        @Override
        public String getDescription() {
            return "Segmentation to remove background and define samples (PCA)";
        }

        @Override
        public String getName() {
            return "Sample";
        }

        @Override
        public BasicAnalyse.ModelMethod getModelMethod() {
            return BasicAnalyse.ModelMethod.SamplePca;
        }

        @Override
        public List<BasicAnalyse.ModelMethod> getTypes(Workflow workflow) {
            ArrayList<BasicAnalyse.ModelMethod> arrayList = new ArrayList<BasicAnalyse.ModelMethod>();
            arrayList.add(BasicAnalyse.ModelMethod.SamplePca);
            if (BreezeFrame.isRuntimeSampleFeature()) {
                arrayList.add(BasicAnalyse.ModelMethod.SampleRuntime);
            }
            return arrayList;
        }

        @Override
        public AbstractModelWizard createWizard(BreezeProgress breezeProgress, BreezeMainPanel breezeMainPanel, PPViewClass pPViewClass, Analyse analyse, AbstractModelWizard.OnFinishWizardCallback onFinishWizardCallback) {
            return new SampleModelWizard(breezeProgress, breezeMainPanel, pPViewClass, analyse, onFinishWizardCallback);
        }
    }
}

