/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.CurveSeparationModel;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.pp.PPClass;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeList;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.TabViewContainer;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.preview.InteractionPreviewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.frontend.wizard.model.panel.ModelButtonHelper;
import se.prediktera.breeze.util.curveseparation.CurveSeparationStatisticsInfo;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class CurveSeparationPanelStep
extends ViewContainer
implements WizardStep {
    private final CurveSeparationScatterPlot scatterPanel;
    private final CurveSeparationSettingsPanel settingsPanel;
    private final ViewClass viewClass;
    private final InteractionPreviewPanel previewPanel;
    private boolean shouldLeaveWithoutAssigned = false;

    public CurveSeparationPanelStep(BreezeMainPanel breezeMainPanel, Analyse analyse, PPClass pPClass, CurveSeparationModel curveSeparationModel) {
        super(breezeMainPanel, false);
        this.viewClass = new ViewClass("Curves", "Separation curves", this, pPClass);
        this.scatterPanel = new CurveSeparationScatterPlot(breezeMainPanel, true, curveSeparationModel, true);
        this.addViewPanel((Component)((Object)this.scatterPanel), 0, 0, 1, 1, null, 2.0, 1.0);
        this.settingsPanel = new CurveSeparationSettingsPanel(breezeMainPanel, curveSeparationModel, this.scatterPanel);
        this.previewPanel = new InteractionPreviewPanel(analyse.getWorkflow(), curveSeparationModel);
        this.setLeftSettingsPanel(this.previewPanel);
    }

    @Override
    public EntrySettingsPanel.SettingsComponent getRightSettingsPanel(EntrySettingsPanel entrySettingsPanel) {
        return this.settingsPanel;
    }

    @Override
    public boolean showRightSettingsPanel() {
        return true;
    }

    @Override
    public boolean showLeftSettingsPanel() {
        return false;
    }

    @Override
    public void enterStep() {
        this.previewPanel.enableInteraction(this.mainpanel);
        this.settingsPanel.enterStep();
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        if (bl) {
            if (this.shouldLeaveWithoutAssigned) {
                return WizardStep.LeaveResult.Ok;
            }
            CatClass catClass = this.settingsPanel.checkClassAssignment();
            if (catClass != null) {
                BreezeOptionDialog.showDialog(this.mainpanel.getFrame(), BreezeType.Analyse.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Area assignment", "No area assignment for class " + catClass.getName() + "\n\nDo you still want to continue?", null, breezeActionEvent -> {
                    this.shouldLeaveWithoutAssigned = true;
                    wizardControlCallback.leaveWithControl();
                });
                return WizardStep.LeaveResult.Failed;
            }
        } else {
            wizardControlCallback.resetText();
        }
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    public static class CurveSeparationScatterPlot
    extends PlotViewPanel {
        private final boolean editable;
        private final CurveSeparationModel model;
        private final boolean showLegend;

        public CurveSeparationScatterPlot(EntryMainPanelInterface entryMainPanelInterface, boolean bl, CurveSeparationModel curveSeparationModel, boolean bl2) {
            super((PPEntryMainInterface)entryMainPanelInterface, "Curve separation", "Scatter2d", new String[]{"model_xres"});
            this.editable = bl;
            this.model = curveSeparationModel;
            this.showLegend = bl2;
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            super.plotSetup(abstractPlotLayout);
            if (this.model != null) {
                this.setStatistics(abstractPlotLayout, this.model.getCurves(), null);
            }
            abstractPlotLayout.setSize(new Object[]{"fixed", 3.0});
            if (this.showLegend) {
                abstractPlotLayout.addLegend(new Object[]{"color"});
            }
            abstractPlotLayout.getLayer(Double.valueOf(1.0)).setLayerName("Samples");
        }

        private void setStatistics(AbstractPlotLayout abstractPlotLayout, CurveSeparationStatisticsInfo.CurveAreas curveAreas, CurveSeparationStatisticsInfo.CurveClass curveClass) {
            AbstractPlotLayout abstractPlotLayout2;
            ScriptHelper.ScriptProperties scriptProperties = new ScriptHelper.ScriptProperties();
            scriptProperties.put((Object)"curveAreas", (Object)curveAreas);
            if (curveClass != null) {
                scriptProperties.put((Object)"selectedCurve", (Object)curveClass);
            }
            scriptProperties.put((Object)"editable", (Object)this.editable);
            AbstractPlotLayout abstractPlotLayout3 = abstractPlotLayout2 = abstractPlotLayout != null ? abstractPlotLayout : this.getVisualization();
            if (abstractPlotLayout2 != null) {
                abstractPlotLayout2.setStatistics(new Object[]{"curveseparation", scriptProperties});
            }
        }

        @Override
        public void setAnalyse(Analyse analyse) {
            if (analyse != null) {
                this.setStatistics(this.getVisualization(), new CurveSeparationStatisticsInfo.CurveAreas(analyse.getSetupXmlNode()), null);
            }
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            super.postSetup(breezeProgressManager, abstractPlotLayout);
            abstractPlotLayout.setColor(new Object[]{"category", 1.0});
        }

        @Override
        protected boolean supportChange() {
            return false;
        }
    }

    public static class CurveSeparationSettingsPanel
    extends DefaultSettingsPanel {
        private final BreezeList list;
        private final DefaultSettingsPanel.SectionPanel classesSection;
        private final CurveSeparationModel model;
        private final CurvePointsPanel pointsPanel;
        private final CurveSeparationScatterPlot plot;
        private final CurveSeparationStatisticsInfo.CurveAreas curves;

        public CurveSeparationSettingsPanel(BreezeMainPanel breezeMainPanel, CurveSeparationModel curveSeparationModel, CurveSeparationScatterPlot curveSeparationScatterPlot) {
            this.model = curveSeparationModel;
            this.plot = curveSeparationScatterPlot;
            DefaultSettingsPanel.SectionPanel sectionPanel = this.addSection("Curves");
            this.list = new BreezeList();
            this.list.setBorder(BorderFactory.createEtchedBorder());
            this.curves = curveSeparationModel.getCurves();
            this.pointsPanel = new CurvePointsPanel(() -> curveSeparationScatterPlot.setStatistics(curveSeparationScatterPlot.getVisualization(), this.curves, null));
            this.updateListModel(this.curves, null);
            sectionPanel.addComponentVertical((JComponent)((Object)this.list));
            this.list.addListSelectionListener(listSelectionEvent -> {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    CurveSeparationStatisticsInfo.CurveClass curveClass = (CurveSeparationStatisticsInfo.CurveClass)this.list.getSelectedValue();
                    this.pointsPanel.set(curveClass);
                    curveSeparationScatterPlot.setStatistics(curveSeparationScatterPlot.getVisualization(), this.curves, curveClass);
                }
            });
            sectionPanel.addComponentVertical(this.pointsPanel);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            jPanel.add((Component)EntryMainHelper.createButton("Add", "material/add", () -> {
                CurveSeparationStatisticsInfo.CurveClass curveClass = curveSeparationModel.createDefaultCurve(this.curves.size());
                this.curves.add(curveClass);
                this.updateListModel(this.curves, curveClass);
            }), GridBagHelper.create(0, new Insets(0, 0, 0, 0), false));
            jPanel.add((Component)EntryMainHelper.createButton("Remove", "material/delete", () -> {
                for (Object e : this.list.getSelectedValuesList()) {
                    this.curves.remove(e);
                }
                this.updateListModel(this.curves, null);
            }), GridBagHelper.create(1, new Insets(0, 12, 0, 0), false));
            jPanel.add((Component)EntryMainHelper.createButton("Import", "material/csv", () -> {
                jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Select file", (Component)this);
                jopensaveDialog2.addExtension("csv", "Curves");
                jopensaveDialog2.setFileName("curves.csv");
                if (jopensaveDialog2.openshow()) {
                    this.curves.clear();
                    this.curves.load(jopensaveDialog2.getSelectedFile());
                    this.updateListModel(this.curves, !this.curves.isEmpty() ? (CurveSeparationStatisticsInfo.CurveClass)this.curves.getFirst() : null);
                }
            }), GridBagHelper.create(2, new Insets(0, 24, 0, 0), false));
            jPanel.add((Component)EntryMainHelper.createButton("Export", "file_save", () -> {
                jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Save to file", (Component)this);
                jopensaveDialog2.setFileName("curves.csv");
                if (jopensaveDialog2.saveshow()) {
                    this.curves.save(jopensaveDialog2.getSelectedFile());
                }
            }), GridBagHelper.create(3, new Insets(0, 12, 0, 0), true));
            sectionPanel.addComponentVertical(jPanel);
            this.classesSection = this.addSection("Area assignment");
            DefaultSettingsPanel.SectionPanel sectionPanel2 = this.addSection("Include / Exclude");
            sectionPanel2.addComponent(ModelButtonHelper.createIncludeButtonScatter(breezeMainPanel, curveSeparationScatterPlot));
            sectionPanel2.addComponent(ModelButtonHelper.createIncludeOnlyButtonScatter(breezeMainPanel, curveSeparationScatterPlot));
            sectionPanel2.addComponentLast(ModelButtonHelper.createExcludeButtonScatter(breezeMainPanel, curveSeparationScatterPlot));
        }

        public CatClass checkClassAssignment() {
            JPanel jPanel = this.classesSection.getPanel();
            for (int i = 0; i < jPanel.getComponentCount(); ++i) {
                if (!(jPanel.getComponent(i) instanceof BreezeInputField)) continue;
                ((BreezeInputField)jPanel.getComponent(i)).getTextField().triggerChange(true);
            }
            for (CatClass catClass : this.model.getFactor().getClasses()) {
                String string;
                if (catClass.isNoClass() || !catClass.isIncluded() || (string = catClass.getExtraInfo()) != null && !string.isEmpty()) continue;
                return catClass;
            }
            return null;
        }

        public void enterStep() {
            this.updateListModel(this.curves, null);
            this.classesSection.clear();
            for (CatClass catClass : this.model.getFactor().getClasses()) {
                if (catClass.isNoClass() || !catClass.isIncluded()) {
                    catClass.setExtraInfo("");
                    continue;
                }
                String string = catClass.getExtraInfo();
                BreezeInputField breezeInputField = new BreezeInputField(catClass.getName(), string != null ? string : "", "");
                breezeInputField.setName("area" + catClass.getName().toLowerCase());
                breezeInputField.addChangeListener(textActionEvent -> catClass.setExtraInfo(textActionEvent.getText()));
                this.classesSection.addComponentVertical(breezeInputField);
            }
            this.classesSection.addComponentVertical(new BreezeLabel("Example 1: A1"));
            this.classesSection.addComponentVertical(new BreezeLabel("Example 2: A2+A3+A4"));
        }

        private void updateListModel(CurveSeparationStatisticsInfo.CurveAreas curveAreas, CurveSeparationStatisticsInfo.CurveClass curveClass2) {
            this.list.setModel(curveAreas);
            if (!curveAreas.isEmpty()) {
                int n = curveAreas.size() - 1;
                if (curveClass2 != null) {
                    n = curveAreas.indexOf(curveClass2);
                }
                this.list.setSelectedIndex(n);
                CurveSeparationStatisticsInfo.CurveClass curveClass3 = (CurveSeparationStatisticsInfo.CurveClass)this.list.getSelectedValue();
                this.pointsPanel.set(curveClass3);
                AbstractPlotLayout abstractPlotLayout = this.plot.getVisualization();
                if (abstractPlotLayout != null) {
                    AbstractAxisPlot abstractAxisPlot = (AbstractAxisPlot)abstractPlotLayout.getMainWindow();
                    abstractAxisPlot.zoomAll();
                }
                this.plot.setStatistics(abstractPlotLayout, curveAreas, curveClass3);
            }
            for (CurveSeparationStatisticsInfo.CurveClass curveClass3 : curveAreas) {
                curveClass3.setCallback((curveClass, curvePoint) -> {
                    this.list.setSelectedValue(curveClass, true);
                    this.list.repaint();
                    this.pointsPanel.set(curveClass);
                });
            }
        }
    }

    public static class CurveSeparationScatterPlots
    extends TabViewContainer {
        private final CurveSeparationScatterPlot plot;

        public CurveSeparationScatterPlots(BreezeMainPanel breezeMainPanel, boolean bl) {
            super(breezeMainPanel);
            this.plot = new CurveSeparationScatterPlot(breezeMainPanel, false, null, bl);
        }

        public CurveSeparationScatterPlot getPlot() {
            return this.plot;
        }

        public void updateTabs(Workflow workflow) {
            this.clearTabs();
            for (Analyse analyse : CurveSeparationScatterPlots.getCurveSeparationAnalyses(workflow)) {
                this.addTab("Group", analyse.getName(), analyse, this.plot);
            }
            if (this.getGroups() > 0) {
                this.setSelectedTab(0, 0);
            }
        }

        @Override
        public void updateSelected(ViewClass viewClass) {
            if (viewClass != null) {
                this.plot.setAnalyse((Analyse)viewClass.getValue());
            }
            super.updateSelected(viewClass);
        }

        public static List<Analyse> getCurveSeparationAnalyses(Workflow workflow) {
            ArrayList<Analyse> arrayList = new ArrayList<Analyse>();
            for (DescriptorTreeNode descriptorTreeNode : workflow.getAllDescriptorNodes()) {
                BasicAnalyse basicAnalyse = descriptorTreeNode.getAnalyse();
                if (basicAnalyse == null || !basicAnalyse.getModelMethod().equals((Object)BasicAnalyse.ModelMethod.ClassificationCurveSeparation)) continue;
                arrayList.add((Analyse)basicAnalyse);
            }
            return arrayList;
        }
    }

    private static class CurvePointsPanel
    extends JPanel {
        private final CurvePointPanel p1;
        private final CurvePointPanel p2;
        private final CurvePointPanel p3;

        public CurvePointsPanel(OnTextChangedCallback onTextChangedCallback) {
            super(new GridBagLayout());
            this.addPanel(this.createHeaderPanel());
            this.p1 = new CurvePointPanel(1, onTextChangedCallback);
            this.addPanel(this.p1);
            this.p2 = new CurvePointPanel(2, onTextChangedCallback);
            this.addPanel(this.p2);
            this.p3 = new CurvePointPanel(3, onTextChangedCallback);
            this.addPanel(this.p3);
            this.setOpaque(false);
        }

        private JPanel createHeaderPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints = GridBagHelper.create(0, new Insets(0, 0, 0, 0));
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)new BreezeLabel("X"), gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = GridBagHelper.create(0, new Insets(0, 10, 0, 0));
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.weightx = 1.0;
            jPanel.add((Component)new BreezeLabel("Y"), gridBagConstraints2);
            return jPanel;
        }

        private void addPanel(Component component) {
            GridBagConstraints gridBagConstraints = GridBagHelper.create(this.getComponentCount(), new Insets(0, 0, 0, 0));
            gridBagConstraints.weightx = 1.0;
            this.add(component, gridBagConstraints);
        }

        public void set(CurveSeparationStatisticsInfo.CurveClass curveClass) {
            if (curveClass != null) {
                this.p1.set(curveClass.p1);
                this.p2.set(curveClass.p2);
                this.p3.set(curveClass.p3);
            } else {
                this.p1.set(null);
                this.p2.set(null);
                this.p3.set(null);
            }
        }

        private static class CurvePointPanel
        extends JPanel {
            private final BreezeTextField x = new BreezeTextField();
            private final BreezeTextField y = new BreezeTextField();
            private CurveSeparationStatisticsInfo.CurvePoint p;

            public CurvePointPanel(int n, OnTextChangedCallback onTextChangedCallback) {
                super(new GridBagLayout());
                this.setOpaque(false);
                Font font = new Font("Tahoma", 0, 12);
                this.add(this.x, font, textActionEvent -> {
                    this.p.x = textActionEvent.getValue();
                    onTextChangedCallback.onChange();
                });
                this.add(this.y, font, textActionEvent -> {
                    this.p.y = textActionEvent.getValue();
                    onTextChangedCallback.onChange();
                });
            }

            private void add(BreezeTextField breezeTextField, Font font, TextActionEvent.TextActionListener textActionListener) {
                breezeTextField.addChangeListener(textActionListener);
                breezeTextField.getTextField().setFont(font);
                breezeTextField.setCrossPanelVisible(false);
                int n = this.getComponentCount();
                GridBagConstraints gridBagConstraints = GridBagHelper.create(n, new Insets(0, n > 0 ? 10 : 0, 0, 0), false);
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                this.add((Component)breezeTextField, gridBagConstraints);
            }

            public void set(CurveSeparationStatisticsInfo.CurvePoint curvePoint) {
                this.p = curvePoint;
                if (curvePoint != null) {
                    this.x.setFormatedNumber(curvePoint.x);
                    this.y.setFormatedNumber(curvePoint.y);
                } else {
                    this.x.setText("");
                    this.y.setText("");
                }
                this.x.getTextField().setEnabled(curvePoint != null);
                this.y.getTextField().setEnabled(curvePoint != null);
            }
        }

        public static interface OnTextChangedCallback {
            public void onChange();
        }
    }
}

