/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel;

import java.awt.Color;
import java.awt.Component;
import java.util.Properties;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.ClassificationModel;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.pp.PPClass;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.TabViewContainer;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.preview.InteractionPreviewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExploreInterface;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.frontend.wizard.model.panel.ModelButtonHelper;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;
import se.prediktera.map.plot.axisplot.windows.LegendWindow;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class EvaluatePanelStep
extends ViewContainer
implements WizardStep {
    private final ModelYcalcPlot modelYcalcPlot;
    private final PlotViewPanel overviewPanel;
    private TabViewContainer tabViewContainer = null;
    private final DefaultSettingsPanel settingsPanel = new DefaultSettingsPanel();
    private final Model.ModelWithSample model;
    private final ViewClass viewClass;
    private final InteractionPreviewPanel previewPanel;
    private final PixelExploreInterface.ComponentSectionPanel componentSectionPanel;
    private final ModelCutOff modelCutOff = new ModelCutOff();

    public EvaluatePanelStep(BreezeMainPanel breezeMainPanel, Analyse analyse, PPClass pPClass, Model.ModelWithSample modelWithSample) {
        super(breezeMainPanel, false);
        this.model = modelWithSample;
        this.viewClass = new ViewClass("Evaluate", "Evaluate model statistics", this, pPClass);
        this.modelYcalcPlot = new ModelYcalcPlot((PPEntryMainInterface)breezeMainPanel, analyse, modelWithSample);
        this.tabViewContainer = new TabViewContainer(breezeMainPanel){

            @Override
            public void updateSelected(ViewClass viewClass) {
                EvaluatePanelStep.this.modelYcalcPlot.setVariable(this.getSelectedTabIndex() + 1);
                super.updateSelected(viewClass);
            }
        };
        this.addViewPanel((Component)((Object)this.tabViewContainer), 0, 0, 1, 2);
        this.tabViewContainer.addTab(this.modelYcalcPlot);
        ModelButtonHelper.addTools(this, this.settingsPanel);
        DefaultSettingsPanel.SectionPanel sectionPanel = this.settingsPanel.addSection("Include / Exclude");
        sectionPanel.addComponent(ModelButtonHelper.createIncludeButtonScatter(breezeMainPanel, this.modelYcalcPlot));
        sectionPanel.addComponent(ModelButtonHelper.createIncludeOnlyButtonScatter(breezeMainPanel, this.modelYcalcPlot));
        sectionPanel.addComponentLast(ModelButtonHelper.createExcludeButtonScatter(breezeMainPanel, this.modelYcalcPlot));
        this.componentSectionPanel = new PixelExploreInterface.ComponentSectionPanel(this.settingsPanel);
        this.overviewPanel = new PlotViewPanel(breezeMainPanel, "Overview (Total for all Y)", "Column", new String[]{"model_q2y_cum", "model_r2y_cum"}){

            @Override
            public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
                super.plotSetup(abstractPlotLayout);
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
                abstractAxisLayer.setColor(new Object[]{"fixed", RtPerfectSpread.generateColor(0)});
                AbstractAxisLayer abstractAxisLayer2 = abstractPlotLayout.getLayer(Double.valueOf(2.0));
                abstractAxisLayer2.setColor(new Object[]{"fixed", RtPerfectSpread.generateColor(2)});
                abstractPlotLayout.addLegend(new Object[]{"color", "right"});
            }

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                super.postSetup(breezeProgressManager, abstractPlotLayout);
                EvaluatePanelStep.this.componentSectionPanel.updateComponents();
            }

            @Override
            public boolean hasInteraction(boolean bl) {
                return false;
            }
        };
        this.addViewPanel((Component)((Object)this.overviewPanel), 1, 0, 1, 1);
        this.componentSectionPanel.initiate(breezeMainPanel, this.overviewPanel);
        this.addViewPanel((Component)((Object)new VariableOverviewPanel(breezeMainPanel)), 1, 1, 1, 1);
        this.previewPanel = new InteractionPreviewPanel(analyse.getWorkflow(), modelWithSample);
        this.setLeftSettingsPanel(this.previewPanel);
        this.previewPanel.enableInteraction(breezeMainPanel);
        if (analyse.getModelMethod().isClassification()) {
            this.modelCutOff.addModelSettings(this.settingsPanel, criticalValues -> {}, true, true, "Confidence Level");
        }
    }

    @Override
    public void showEntry(Object object, Object object2) {
        super.showEntry(object, object2);
        this.modelCutOff.update(this.model.getCriticalValues());
    }

    @Override
    public EntrySettingsPanel.SettingsComponent getRightSettingsPanel(EntrySettingsPanel entrySettingsPanel) {
        return this.settingsPanel;
    }

    @Override
    public boolean showRightSettingsPanel() {
        return true;
    }

    @Override
    public boolean showLeftSettingsPanel() {
        return false;
    }

    @Override
    public void enterStep() {
        this.previewPanel.setSegmentationLevel(this.model.getSegmentationLevel(), this.model.getSegmentationHashId());
        this.previewPanel.enableInteraction(this.mainpanel);
        this.tabViewContainer.clearTabs();
        for (String string : this.model.getModelVariables()) {
            this.tabViewContainer.addTab(string, this.modelYcalcPlot);
        }
        SwingUtilities.invokeLater(() -> this.tabViewContainer.setSelectedTab(0, 0));
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        if (!bl) {
            wizardControlCallback.resetText();
        }
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    public static class ModelCutOff {
        private final BreezeInputField.Number lowCutOffInputField = new BreezeInputField.Number("Low", 0.5, "");
        private final BreezeInputField.Number highCutOffInputField = new BreezeInputField.Number("High", 1.5, "");
        private ModelProperties.CriticalValues criticalValues;

        public void addModelSettings(DefaultSettingsPanel defaultSettingsPanel, ModelCutOffCallback modelCutOffCallback, boolean bl, boolean bl2, String string) {
            DefaultSettingsPanel.SectionPanel sectionPanel = defaultSettingsPanel.addSection(string);
            this.addModelSettings(sectionPanel, modelCutOffCallback, bl);
        }

        public void addModelSettings(DefaultSettingsPanel.SectionPanel sectionPanel, ModelCutOffCallback modelCutOffCallback, boolean bl) {
            sectionPanel.addComponentVertical(this.lowCutOffInputField);
            sectionPanel.addComponentVertical(this.highCutOffInputField);
            TextActionEvent.TextActionListener textActionListener = textActionEvent -> {
                this.criticalValues.setCutOffLow(this.lowCutOffInputField.getNumber());
                this.criticalValues.setCutOffHigh(this.highCutOffInputField.getNumber());
                modelCutOffCallback.onChange(this.criticalValues);
            };
            this.lowCutOffInputField.addChangeListener(textActionListener);
            this.highCutOffInputField.addChangeListener(textActionListener);
        }

        public void update(ModelProperties.CriticalValues criticalValues) {
            this.criticalValues = criticalValues;
            this.lowCutOffInputField.setValue(criticalValues.getCutOffLow());
            this.highCutOffInputField.setValue(criticalValues.getCutOffHigh());
            this.highCutOffInputField.setVisible(criticalValues.supportHighCutOff());
        }

        public ModelProperties.CriticalValues getCriticalValues() {
            return this.criticalValues;
        }

        public static interface ModelCutOffCallback {
            public void onChange(ModelProperties.CriticalValues var1);
        }
    }

    public static class ModelYcalcPlot
    extends ModelPlot {
        private int variable = 1;

        public ModelYcalcPlot(PPEntryMainInterface pPEntryMainInterface, Analyse analyse, Model model) {
            super(pPEntryMainInterface, "Observed vs Calculated", "Scatter2D", new String[]{"model_ypred", "model_ycalc"}, analyse, model);
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            super.plotSetup(abstractPlotLayout);
            ((FloatWindowScatter)abstractPlotLayout.getMainWindow()).setPaintReverse(false);
            Analyse analyse = this.getAnalyse();
            this.setAnalyse(analyse);
            abstractPlotLayout.getLayer(Double.valueOf(1.0)).setShowLayerDescription(false);
            abstractPlotLayout.getLayer(Double.valueOf(1.0)).setLayerName("Train");
            abstractPlotLayout.getLayer(Double.valueOf(2.0)).setLayerName("Test");
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            DataSet dataSet;
            super.postSetup(breezeProgressManager, abstractPlotLayout);
            AbstractModel abstractModel = this.getModel();
            if (abstractModel != null && (dataSet = abstractModel.getDataSet()) != null) {
                Object object;
                AbstractDataMatrix abstractDataMatrix = dataSet.getMatrix(2);
                AbstractDataMatrix abstractDataMatrix2 = dataSet.getMatrix(3);
                double d = abstractModel.getComponentsInt();
                int n = abstractDataMatrix.getK();
                abstractPlotLayout.setDataRange(new Object[]{"x", "value", (double)n * (d - 1.0) + (double)this.variable});
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
                if (abstractAxisLayer != null) {
                    abstractAxisLayer.setDataRange(new Object[]{"y", "value", abstractDataMatrix, (double)this.variable});
                    this.setColor(abstractAxisLayer, RtPerfectSpread.generateColor(0));
                    object = new Properties();
                    ((Properties)object).put("showstatistics", "true");
                    abstractAxisLayer.setStatistics(new Object[]{"linearregression", object});
                }
                if ((object = abstractPlotLayout.getLayer(Double.valueOf(2.0))) != null) {
                    object.setDataRange(new Object[]{"y", "value", abstractDataMatrix2, (double)this.variable});
                    this.setColor((AbstractAxisLayer)object, RtPerfectSpread.generateColor(1));
                    object.setShape(new Object[]{"fixed", "hollowcircle"});
                }
            }
        }

        public void setVariable(int n) {
            this.variable = n;
        }

        @Override
        protected boolean supportChange() {
            return false;
        }
    }

    public static class VariableOverviewPanel
    extends PlotViewPanel {
        public VariableOverviewPanel(BreezeMainPanel breezeMainPanel) {
            super((PPEntryMainInterface)breezeMainPanel, "Variable overview", "Column", new String[]{"model_q2y_var_cum", "model_r2y_var_cum"});
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            super.plotSetup(abstractPlotLayout);
            AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
            abstractAxisLayer.setColor(new Object[]{"fixed", RtPerfectSpread.generateColor(0)});
            AbstractAxisLayer abstractAxisLayer2 = abstractPlotLayout.getLayer(Double.valueOf(2.0));
            abstractAxisLayer2.setColor(new Object[]{"fixed", RtPerfectSpread.generateColor(2)});
            abstractPlotLayout.addLegend(new Object[]{"color", "right"});
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            AbstractModel abstractModel;
            DataSet dataSet;
            AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)abstractPlotLayout.getPlotInit().getDataTreeInterface();
            DataTreeInterface dataTreeInterface = abstractDataMatrix.getTreeParent().getTreeParent();
            if (dataTreeInterface instanceof AbstractModel && (dataSet = (abstractModel = (AbstractModel)dataTreeInterface).getDataSet()) != null) {
                double d = abstractModel.getComponentsInt();
                abstractPlotLayout.setDataRange(new Object[]{"Y", "value", d});
            }
        }

        @Override
        public boolean hasInteraction(boolean bl) {
            return false;
        }
    }

    public static abstract class ModelPlot
    extends PlotViewPanel {
        protected final Model model;
        private LegendWindow legend;

        public ModelPlot(PPEntryMainInterface pPEntryMainInterface, String string, String string2, String[] stringArray, Analyse analyse, Model model) {
            super(pPEntryMainInterface, string, string2, stringArray, analyse);
            this.model = model;
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            abstractPlotLayout.setSize(new Object[]{"fixed", 5});
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            super.postSetup(breezeProgressManager, abstractPlotLayout);
            if (abstractPlotLayout != null) {
                if (this.legend != null) {
                    abstractPlotLayout.removeArea((FloatWindow)this.legend);
                    this.legend = null;
                }
                if (this.isClassification()) {
                    AbstractAxisLayer abstractAxisLayer = this.getTrainLayer(abstractPlotLayout);
                    this.legend = abstractPlotLayout.addLegend(new Object[]{abstractAxisLayer, "color", "right"});
                } else {
                    AbstractAxisLayer abstractAxisLayer = this.getTestLayer(abstractPlotLayout);
                    if (abstractAxisLayer != null && abstractAxisLayer.getNrVisibleObjects() > 0) {
                        this.legend = abstractPlotLayout.addLegend(new Object[]{abstractAxisLayer, "layer", "right"});
                    }
                }
            }
        }

        private AbstractAxisLayer getTrainLayer(AbstractPlotLayout abstractPlotLayout) {
            AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
            if (abstractAxisLayer != null && abstractAxisLayer.toString().contains("pred")) {
                return abstractPlotLayout.getLayer(Double.valueOf(2.0));
            }
            return abstractAxisLayer;
        }

        private AbstractAxisLayer getTestLayer(AbstractPlotLayout abstractPlotLayout) {
            AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
            if (abstractAxisLayer != null && abstractAxisLayer.toString().contains("pred")) {
                return abstractAxisLayer;
            }
            return abstractPlotLayout.getLayer(Double.valueOf(2.0));
        }

        public boolean isClassification() {
            return this.getAnalyse() != null && this.getAnalyse().getModelMethod().isClassification();
        }

        public CategoryFactor getCategoryFactor() {
            if (this.model instanceof ClassificationModel) {
                return ((ClassificationModel)this.model).getFactor();
            }
            return this.getAnalyse().getCategoryFactor();
        }

        protected void setColor(AbstractAxisLayer abstractAxisLayer, Color color) {
            if (this.isClassification()) {
                CategoryFactor categoryFactor = this.getCategoryFactor();
                if (categoryFactor != null) {
                    abstractAxisLayer.setColor(new Object[]{"category", categoryFactor.getName()});
                } else {
                    abstractAxisLayer.setColor(new Object[]{"fixed", color});
                }
            } else {
                abstractAxisLayer.setColor(new Object[]{"fixed", color});
            }
        }
    }
}

