/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel;

import java.awt.Component;
import java.awt.Insets;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.ClassificationModel;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.pp.PPClass;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.preview.InteractionPreviewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.PlotSettingsPanel;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExploreInterface;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.frontend.wizard.model.panel.EvaluatePanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.ModelButtonHelper;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.plot2D.scatter.FloatWindowScatter;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class ExcludeOutlierPanelStep
extends ViewContainer
implements WizardStep {
    private final ScoreVariancePlot scatterPanel;
    private final DefaultSettingsPanel settingsPanel = new DefaultSettingsPanel();
    private final ViewClass viewClass;
    private final Model.ModelWithSample model;
    private final InteractionPreviewPanel previewPanel;
    private final BreezeCheckBox enableDcritButton = new BreezeCheckBox("X Model Distance(Dcrit)", false);
    private final BreezeCheckBox enableHotellingT2Button = new BreezeCheckBox("Hotelling T2", false);
    private final PixelExploreInterface.ComponentSectionPanel componentSectionPanel;
    private final PlotSettingsPanel.EditPlotSections editPlotSections;

    public ExcludeOutlierPanelStep(final BreezeMainPanel breezeMainPanel, Analyse analyse, final boolean bl, PPClass pPClass, final Model.ModelWithSample modelWithSample) {
        super(breezeMainPanel, false);
        this.model = modelWithSample;
        this.viewClass = new ViewClass("Model", "Exclude outliers", this, pPClass);
        ModelButtonHelper.addTools(this, this.settingsPanel);
        DefaultSettingsPanel.SectionPanel sectionPanel = this.settingsPanel.addSection("Include / Exclude");
        this.componentSectionPanel = new PixelExploreInterface.ComponentSectionPanel(this.settingsPanel);
        this.scatterPanel = new ScoreVariancePlot((PPEntryMainInterface)breezeMainPanel, analyse, modelWithSample);
        this.addViewPanel((Component)((Object)this.scatterPanel), 0, 0, 1, 1);
        this.componentSectionPanel.initiate(this.mainpanel, this.scatterPanel);
        this.addViewPanel((Component)((Object)new PlotViewPanel(this.mainpanel, "Overview (Total for all Y)", "Column", new String[]{"model_q2y_cum", "model_r2y_cum"}){

            @Override
            public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
                super.plotSetup(abstractPlotLayout);
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
                abstractAxisLayer.setColor(new Object[]{"fixed", RtPerfectSpread.generateColor(0)});
                AbstractAxisLayer abstractAxisLayer2 = abstractPlotLayout.getLayer(Double.valueOf(2.0));
                abstractAxisLayer2.setColor(new Object[]{"fixed", RtPerfectSpread.generateColor(2)});
                abstractPlotLayout.addLegend(new Object[]{"color", "right"});
            }

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                ExcludeOutlierPanelStep.this.componentSectionPanel.updateComponents();
            }
        }), 0, 1, 1, 1, new Insets(0, 20, 0, 0));
        this.addViewPanel((Component)((Object)new PlotViewPanel(this, breezeMainPanel, "Distance to model in X", "Column", new String[]{"model_obsdmx", "model_obsdmxpred"}){
            final /* synthetic */ ExcludeOutlierPanelStep this$0;
            {
                this.this$0 = excludeOutlierPanelStep;
                super(pPEntryMainInterface, string, string2, stringArray);
            }

            @Override
            public void preSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                super.preSetup(breezeProgressManager, abstractPlotLayout);
                abstractPlotLayout.show("autorescale", Double.valueOf(0.0));
            }

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                super.postSetup(breezeProgressManager, abstractPlotLayout);
                ExcludeOutlierPanelStep.setClassesColor(bl, abstractPlotLayout, breezeMainPanel, modelWithSample);
                abstractPlotLayout.setStatistics(new Object[]{"dcrit"});
                AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)abstractPlotLayout.getPlotInit().getDataTreeInterface();
                AbstractModel abstractModel = (AbstractModel)abstractDataMatrix.getTreeParent();
                abstractPlotLayout.setDataRange(new Object[]{"y", "value", (double)abstractModel.getComponentsInt()});
                double[] dArray = ((AbstractAxisPlot)abstractPlotLayout.getMainWindow()).getMinmax(0, 0);
                double d = (dArray[1] - dArray[0]) * 0.1;
                abstractPlotLayout.show("xmin", Double.valueOf(dArray[0] - d));
                abstractPlotLayout.show("xmax", Double.valueOf(dArray[1] + d));
                double[] dArray2 = ((AbstractAxisPlot)abstractPlotLayout.getMainWindow()).getMinmax(1, 0);
                double d2 = (dArray2[1] - dArray2[0]) * 0.1;
                double d3 = dArray2[1] + d2;
                if (abstractModel.isUseDcrit()) {
                    d3 = Math.max(d3, abstractModel.getDcritX()) * 2.0;
                }
                abstractPlotLayout.show("ymin", Double.valueOf(dArray2[0] - d2));
                abstractPlotLayout.show("ymax", Double.valueOf(d3));
            }
        }), 1, 0, 1, 1, new Insets(0, 20, 0, 0));
        this.addViewPanel((Component)((Object)new PlotViewPanel(this, breezeMainPanel, "Distance to model in Y", "Column", new String[]{"model_obsdmy", "model_obsdmypred"}){
            final /* synthetic */ ExcludeOutlierPanelStep this$0;
            {
                this.this$0 = excludeOutlierPanelStep;
                super(pPEntryMainInterface, string, string2, stringArray);
            }

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                super.postSetup(breezeProgressManager, abstractPlotLayout);
                ExcludeOutlierPanelStep.setClassesColor(bl, abstractPlotLayout, breezeMainPanel, modelWithSample);
                AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)abstractPlotLayout.getPlotInit().getDataTreeInterface();
                AbstractModel abstractModel = (AbstractModel)abstractDataMatrix.getTreeParent();
                abstractPlotLayout.setDataRange(new Object[]{"y", "value", (double)abstractModel.getComponentsInt()});
            }
        }), 1, 1, 1, 1, new Insets(0, 20, 0, 0));
        if (BreezeFrame.isExcludeOutlierWithHotellingT2InClassificationFeature()) {
            this.addViewPanel((Component)((Object)new PlotViewPanel(this, breezeMainPanel, "Hotelling T2", "Column", new String[]{"model_hotellingt2", "model_hotellingt2pred"}){
                final /* synthetic */ ExcludeOutlierPanelStep this$0;
                {
                    this.this$0 = excludeOutlierPanelStep;
                    super(pPEntryMainInterface, string, string2, stringArray);
                }

                @Override
                public void preSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                    super.preSetup(breezeProgressManager, abstractPlotLayout);
                    abstractPlotLayout.show("autorescale", Double.valueOf(0.0));
                }

                @Override
                public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                    super.postSetup(breezeProgressManager, abstractPlotLayout);
                    ExcludeOutlierPanelStep.setClassesColor(bl, abstractPlotLayout, breezeMainPanel, modelWithSample);
                    abstractPlotLayout.setStatistics(new Object[]{"hotellingt2"});
                    AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)abstractPlotLayout.getPlotInit().getDataTreeInterface();
                    AbstractModel abstractModel = (AbstractModel)abstractDataMatrix.getTreeParent();
                    abstractPlotLayout.setDataRange(new Object[]{"y", "value", (double)abstractModel.getComponentsInt()});
                    double[] dArray = ((AbstractAxisPlot)abstractPlotLayout.getMainWindow()).getMinmax(1, 0);
                    double d = dArray[1] * 1.05;
                    if (abstractModel.isUseHotelling()) {
                        d = Math.max(d, abstractModel.getHotellingt2()) * 2.0;
                    }
                    abstractPlotLayout.show("ymax", Double.valueOf(d));
                }
            }), 1, 2, 1, 1, new Insets(0, 20, 0, 0));
        }
        sectionPanel.addComponent(ModelButtonHelper.createIncludeButtonScatter(this.mainpanel, this.scatterPanel));
        sectionPanel.addComponent(ModelButtonHelper.createIncludeOnlyButtonScatter(this.mainpanel, this.scatterPanel));
        sectionPanel.addComponentLast(ModelButtonHelper.createExcludeButtonScatter(this.mainpanel, this.scatterPanel));
        DefaultSettingsPanel.SectionPanel sectionPanel2 = this.settingsPanel.addSection("Train / Test");
        sectionPanel2.addComponent(ModelButtonHelper.createTrainButton(this.mainpanel, this.scatterPanel));
        sectionPanel2.addComponentLast(ModelButtonHelper.createTestButton(this.mainpanel, this.scatterPanel));
        if (this.supportCriticalValues(analyse)) {
            DefaultSettingsPanel.SectionPanel sectionPanel3 = this.settingsPanel.addSection("Critical distance");
            this.enableDcritButton.addItemListener(itemEvent -> {
                this.getModel().setUseDcrit(this.enableDcritButton.isSelected());
                breezeMainPanel.setDirty(true);
            });
            sectionPanel3.addComponentVertical(this.enableDcritButton);
            if (BreezeFrame.isExcludeOutlierWithHotellingT2InClassificationFeature()) {
                this.enableHotellingT2Button.addItemListener(itemEvent -> {
                    this.getModel().setUseHotelling(this.enableHotellingT2Button.isSelected());
                    breezeMainPanel.setDirty(true);
                });
                sectionPanel3.addComponentVertical(this.enableHotellingT2Button);
            }
        }
        this.previewPanel = new InteractionPreviewPanel(analyse.getWorkflow(), modelWithSample);
        this.setLeftSettingsPanel(this.previewPanel);
        this.previewPanel.enableInteraction(breezeMainPanel);
        this.editPlotSections = new PlotSettingsPanel.EditPlotSections(breezeMainPanel.getFrame(), this.previewPanel, this.settingsPanel);
        this.editPlotSections.setData(this.scatterPanel, analyse);
    }

    private AbstractModel getModel() {
        return ((ModelMatrix)this.scatterPanel.getVisualization().getPlotInit().getDataTreeInterface()).getModel();
    }

    private boolean supportCriticalValues(Analyse analyse) {
        return analyse.getModelMethod().equals((Object)BasicAnalyse.ModelMethod.ClassificationPlsDa);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        super.showEntry(object, object2);
        ModelProperties.CriticalValues criticalValues = this.model.getCriticalValues();
        this.enableDcritButton.setSelected(criticalValues.isDcrit());
        this.enableHotellingT2Button.setSelected(criticalValues.isHotellingT2());
        this.editPlotSections.updateListsWhenReady(this, this.scatterPanel.isClassification() ? this.scatterPanel.getCategoryFactor() : null);
    }

    @Override
    public EntrySettingsPanel.SettingsComponent getRightSettingsPanel(EntrySettingsPanel entrySettingsPanel) {
        return this.settingsPanel;
    }

    @Override
    public boolean showRightSettingsPanel() {
        return true;
    }

    public static void setClassesColor(boolean bl, AbstractPlotLayout abstractPlotLayout, BreezeMainPanel breezeMainPanel, Model model) {
        if (bl) {
            if (model instanceof ClassificationModel) {
                abstractPlotLayout.setColor(new Object[]{"category", ((ClassificationModel)model).getFactor().getName()});
            } else {
                abstractPlotLayout.setColor(new Object[]{"category", 1.0});
            }
        }
    }

    @Override
    public boolean showLeftSettingsPanel() {
        return false;
    }

    @Override
    public void enterStep() {
        this.previewPanel.setSegmentationLevel(this.model.getSegmentationLevel(), this.model.getSegmentationHashId());
        this.previewPanel.enableInteraction(this.mainpanel);
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    public static class ScoreVariancePlot
    extends EvaluatePanelStep.ModelPlot {
        public ScoreVariancePlot(PPEntryMainInterface pPEntryMainInterface, Analyse analyse, Model model) {
            super(pPEntryMainInterface, "Score variance", "Score2D", new String[]{"model_tpred", "model"}, analyse, model);
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            super.plotSetup(abstractPlotLayout);
            ((FloatWindowScatter)abstractPlotLayout.getMainWindow()).setPaintReverse(false);
            abstractPlotLayout.getLayer(Double.valueOf(1.0)).setLayerName("Train");
            AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(2.0));
            abstractAxisLayer.setShape(new Object[]{"fixed", "hollowcircle"});
            abstractAxisLayer.setShowLayerDescription(false);
            abstractAxisLayer.setLayerName("Test");
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            super.postSetup(breezeProgressManager, abstractPlotLayout);
            abstractPlotLayout.setDataRange(new Object[]{"x", "value", 1.0});
            abstractPlotLayout.setDataRange(new Object[]{"y", "value", 2.0});
            this.setColor(abstractPlotLayout.getLayer(Double.valueOf(1.0)), RtPerfectSpread.generateColor(0));
            this.setColor(abstractPlotLayout.getLayer(Double.valueOf(2.0)), RtPerfectSpread.generateColor(1));
        }
    }
}

