/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.wizard.model.panel;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.RtThreader;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeToggleButton;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class ModelButtonHelper {
    public static BreezeButton createIncludeButton(BreezeMainPanel breezeMainPanel, PlotViewPanel plotViewPanel) {
        return EntryMainHelper.createButton("Include", "explore/library_add", () -> ModelButtonHelper.setTrainTest(breezeMainPanel, plotViewPanel, true, false, true));
    }

    public static BreezeButton createIncludeOnlyButton(BreezeMainPanel breezeMainPanel, PlotViewPanel plotViewPanel) {
        return EntryMainHelper.createButton("includeonly", "Include Only", "explore/add_box", () -> ModelButtonHelper.setTrainTest(breezeMainPanel, plotViewPanel, true, true, true));
    }

    public static BreezeButton createExcludeButton(BreezeMainPanel breezeMainPanel, PlotViewPanel plotViewPanel) {
        return EntryMainHelper.createButton("Exclude", "explore/remove_selection", () -> ModelButtonHelper.setTrainTest(breezeMainPanel, plotViewPanel, false, false, true));
    }

    public static BreezeButton createTrainButton(BreezeMainPanel breezeMainPanel, PlotViewPanel plotViewPanel) {
        return EntryMainHelper.createButton("Train", "explore/add_box", () -> ModelButtonHelper.setTrainTest(breezeMainPanel, plotViewPanel, true, false, false));
    }

    public static BreezeButton createTestButton(BreezeMainPanel breezeMainPanel, PlotViewPanel plotViewPanel) {
        return EntryMainHelper.createButton("Test", "explore/remove_selection", () -> ModelButtonHelper.setTrainTest(breezeMainPanel, plotViewPanel, false, false, false));
    }

    private static void setTrainTest(final BreezeMainPanel breezeMainPanel, final PlotViewPanel plotViewPanel, final boolean bl, final boolean bl2, final boolean bl3) {
        BreezeProgressDialog.startProgress(breezeMainPanel.getFrame(), new ProgressAction(){

            @Override
            public void runAction() {
                AbstractAxisPlot abstractAxisPlot = (AbstractAxisPlot)plotViewPanel.getVisualization().getMainWindow();
                ModelButtonHelper.assertSelectionMade(abstractAxisPlot.getInteractionArray(1));
                abstractAxisPlot.setTrainTest((ProgressManager)this.getProgressManager(), bl, bl2, bl3);
                abstractAxisPlot.clearSelection();
                breezeMainPanel.setDirty(true);
            }
        }, "Updating", -1);
    }

    public static BreezeButton createIncludeButtonScatter(BreezeMainPanel breezeMainPanel, VisualizationInterface visualizationInterface) {
        return EntryMainHelper.createButton("Include", "explore/library_add", () -> ModelButtonHelper.setTrainTestScatter(breezeMainPanel, visualizationInterface, true, false));
    }

    public static BreezeButton createIncludeOnlyButtonScatter(BreezeMainPanel breezeMainPanel, VisualizationInterface visualizationInterface) {
        return EntryMainHelper.createButton("includeonly", "Include Only", "explore/add_box", () -> ModelButtonHelper.setTrainTestScatter(breezeMainPanel, visualizationInterface, true, true));
    }

    public static BreezeButton createExcludeButtonScatter(BreezeMainPanel breezeMainPanel, VisualizationInterface visualizationInterface) {
        return EntryMainHelper.createButton("Exclude", "explore/remove_selection", () -> ModelButtonHelper.setTrainTestScatter(breezeMainPanel, visualizationInterface, false, false));
    }

    public static void setTrainTestScatter(final BreezeMainPanel breezeMainPanel, final VisualizationInterface visualizationInterface, final boolean bl, final boolean bl2) {
        BreezeProgressDialog.startProgress(breezeMainPanel.getFrame(), new ProgressAction(){

            @Override
            public void runAction() {
                AbstractAxisPlot abstractAxisPlot = (AbstractAxisPlot)visualizationInterface.getVisualization().getMainWindow();
                DataSet dataSet = abstractAxisPlot.getDataSet();
                BreezeProgressManager breezeProgressManager = this.getProgressManager();
                InteractionArray interactionArray = abstractAxisPlot.getInteractionArray(1);
                ModelButtonHelper.assertSelectionMade(interactionArray);
                if (bl) {
                    if (bl2) {
                        dataSet.exclude((ProgressManager)breezeProgressManager, "obs");
                    }
                    dataSet.include(interactionArray);
                } else {
                    dataSet.exclude(interactionArray);
                }
                dataSet.applyChanges((ProgressManager)breezeProgressManager);
                abstractAxisPlot.clearSelection();
                breezeMainPanel.setDirty(true);
            }
        }, "Updating", -1);
    }

    private static void assertSelectionMade(InteractionArray interactionArray) {
        if (interactionArray == null || !interactionArray.hasSelection()) {
            throw new ErrorHandler.InformationMessageException("No selection has been made");
        }
    }

    public static BreezeButton createAddComponentButton(EntryMainPanelInterface entryMainPanelInterface, Object object) {
        return EntryMainHelper.createButton("Add", "explore/exposure_plus_1", () -> ModelButtonHelper.changeComponents(entryMainPanelInterface, object, 1));
    }

    public static BreezeButton createSetComponentButton(EntryMainPanelInterface entryMainPanelInterface, Object object) {
        return EntryMainHelper.createButton("Set", "explore/edit", () -> {
            int n = ModelButtonHelper.getModel(object).getComponentsInt();
            BreezeActionListener breezeActionListener = breezeActionEvent -> {
                int n2 = RtDataFormat.toNumberInt(breezeActionEvent.result().toString());
                ModelButtonHelper.changeComponents(entryMainPanelInterface, object, n2 - n);
            };
            BreezeOptionDialog.showDialog(entryMainPanelInterface.getFrame(), entryMainPanelInterface.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Set components", "Set number of components", String.valueOf(n), breezeActionListener);
        });
    }

    public static BreezeButton createRemoveComponentButton(EntryMainPanelInterface entryMainPanelInterface, Object object) {
        return EntryMainHelper.createButton("Remove", "explore/exposure_neg_1", () -> ModelButtonHelper.changeComponents(entryMainPanelInterface, object, -1));
    }

    private static void changeComponents(final EntryMainPanelInterface entryMainPanelInterface, final Object object, final int n) {
        BreezeProgressDialog.startProgressWithCancel(entryMainPanelInterface.getFrame(), new ProgressAction(){

            @Override
            public void runAction() {
                AbstractModel abstractModel = ModelButtonHelper.getModel(object);
                if (abstractModel != null) {
                    abstractModel.changeComponent((ProgressManager)this.getProgressManager(), n);
                    abstractModel.recalculateCriticalValues();
                    entryMainPanelInterface.setDirty(true);
                }
            }
        }, "Updating Components");
    }

    public static DataSet getDataSet(Object object) {
        if (object instanceof PlotViewPanel) {
            PlotViewPanel plotViewPanel = (PlotViewPanel)object;
            return plotViewPanel.getDataSet();
        }
        if (object instanceof Model) {
            Model model = (Model)object;
            return Model.getEvinceModel(model).getDataSet();
        }
        return null;
    }

    public static AbstractModel getModel(Object object) {
        if (object instanceof PlotViewPanel) {
            PlotViewPanel plotViewPanel = (PlotViewPanel)object;
            return plotViewPanel.getModel();
        }
        if (object instanceof Model) {
            Model model = (Model)object;
            return Model.getEvinceModel(model);
        }
        return null;
    }

    public static BreezeButton createSelectByDensityButton(EntryMainPanelInterface entryMainPanelInterface, PlotViewPanel plotViewPanel) {
        return EntryMainHelper.createButton("By Density", "explore/blur_on", () -> BreezeOptionDialog.showDialog(entryMainPanelInterface.getFrame(), entryMainPanelInterface.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Select by density", "Enter number of percentage to select", "5", breezeActionEvent -> {
            int n = RtDataFormat.toNumberInt(breezeActionEvent.result().toString());
            ModelButtonHelper.selectByDensity(entryMainPanelInterface, plotViewPanel, n);
        }));
    }

    private static void selectByDensity(EntryMainPanelInterface entryMainPanelInterface, final PlotViewPanel plotViewPanel, final double d) {
        BreezeProgressDialog.startProgress(entryMainPanelInterface.getFrame(), new ProgressAction(){

            @Override
            public void runAction() {
                Double[] doubleArray = (Double[])EvinceScriptCommands.apply((ProgressManager)this.getProgressManager(), (Object[])new Object[]{"density", plotViewPanel.getVisualization(), 1.0, d});
                plotViewPanel.getVisualization().select(new Object[]{"select", doubleArray});
            }
        }, "Selecting", -1);
    }

    public static BreezeButton createSelectBorderButton(EntryMainPanelInterface entryMainPanelInterface, PlotViewPanel plotViewPanel, boolean bl) {
        return EntryMainHelper.createButton("Border pixels", "explore/rounded_corner", () -> BreezeOptionDialog.showDialog(entryMainPanelInterface.getFrame(), entryMainPanelInterface.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Select border pixels", "Enter number of border pixels", "1", breezeActionEvent -> ModelButtonHelper.selectBorder(entryMainPanelInterface, plotViewPanel, RtDataFormat.toNumberInt(breezeActionEvent.result().toString()), bl)));
    }

    private static void selectBorder(EntryMainPanelInterface entryMainPanelInterface, final PlotViewPanel plotViewPanel, final int n, final boolean bl) {
        BreezeProgressDialog.startProgress(entryMainPanelInterface.getFrame(), new ProgressAction(){

            @Override
            public void runAction() {
                Properties properties = new Properties();
                properties.put("distance", String.valueOf(n + 1));
                properties.put("train", String.valueOf(bl));
                properties.put("index", "true");
                properties.put("outeredge", "true");
                Double[] doubleArray = (Double[])EvinceScriptCommands.apply((ProgressManager)this.getProgressManager(), (Object[])new Object[]{"shrink", ModelButtonHelper.getDataSet(plotViewPanel), properties});
                plotViewPanel.getVisualization().select(new Object[]{"select", doubleArray});
            }
        }, "Selecting", -1);
    }

    public static BreezeButton createSelectSimilarButton(EntryMainPanelInterface entryMainPanelInterface, PlotViewPanel plotViewPanel) {
        return EntryMainHelper.createButton("Similar", "explore/compress", () -> BreezeOptionDialog.showDialog(entryMainPanelInterface.getFrame(), entryMainPanelInterface.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Select percent similar", "Enter number of percent similar pixels", "80", breezeActionEvent -> ModelButtonHelper.selectSimilar(entryMainPanelInterface, plotViewPanel, RtDataFormat.toNumber(breezeActionEvent.result().toString()))));
    }

    private static void selectSimilar(EntryMainPanelInterface entryMainPanelInterface, final PlotViewPanel plotViewPanel, final double d) {
        BreezeProgressDialog.startProgress(entryMainPanelInterface.getFrame(), new ProgressAction(){

            @Override
            public void runAction() {
                DataSet dataSet = ModelButtonHelper.getDataSet(plotViewPanel);
                final AbstractDataMatrix abstractDataMatrix = dataSet.getMatrix(0);
                final InteractionArray interactionArray = (InteractionArray)plotViewPanel.getVisualization().get("selection");
                if (interactionArray != null) {
                    final double d2 = d / 100.0;
                    final ArrayList arrayList = new ArrayList();
                    new RtThreader(this){

                        @Override
                        protected void doOp(boolean bl, int n, int n2) {
                            block0: for (int i = n; i < n2; ++i) {
                                for (int j = interactionArray.getFirstSet(); j < interactionArray.getLastSet(); ++j) {
                                    double d;
                                    if (!interactionArray.get(j) || !((d = ModelButtonHelper.getSam(abstractDataMatrix, j, i)) <= d2)) continue;
                                    arrayList.add((double)i + 1.0);
                                    continue block0;
                                }
                            }
                        }
                    }.execute(abstractDataMatrix.getN());
                    plotViewPanel.getVisualization().select(new Object[]{"select", arrayList.toArray(new Double[0])});
                }
            }
        }, "Selecting", -1);
    }

    public static double getSam(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < abstractDataMatrix.getK(); ++i) {
            double d4 = abstractDataMatrix.getValue(n, i);
            double d5 = abstractDataMatrix.getValue(n2, i);
            d += d4 * d5;
            d2 += d4 * d4;
            d3 += d5 * d5;
        }
        return Math.acos(d / Math.sqrt(d2 * d3));
    }

    public static BreezeButton createResetButton(EntryMainPanelInterface entryMainPanelInterface, VisualizationInterface visualizationInterface, Runnable runnable) {
        return EntryMainHelper.createButton("Reset", "explore/restart", () -> {
            runnable.run();
            ModelButtonHelper.resetDataSet(entryMainPanelInterface, visualizationInterface);
        });
    }

    public static void resetDataSet(final EntryMainPanelInterface entryMainPanelInterface, final VisualizationInterface visualizationInterface) {
        BreezeProgressDialog.startProgress(entryMainPanelInterface.getFrame(), new ProgressAction(){

            @Override
            public void runAction() {
                AbstractAxisPlot abstractAxisPlot = (AbstractAxisPlot)visualizationInterface.getVisualization().getMainWindow();
                DataSet dataSet = abstractAxisPlot.getDataSet();
                if (dataSet == null) {
                    throw new ErrorHandler.InformationMessageException("Cannot reset");
                }
                if (dataSet.originalObs != null) {
                    ((InnerColumnBoolean)dataSet.getObsDataInfo().getPrimaryColumnByType(1)).setValues(dataSet.originalObs);
                    dataSet.updateReferences();
                } else {
                    dataSet.setTest(Double.valueOf(1.0), null);
                    dataSet.setTrain(Double.valueOf(1.0), null);
                    dataSet.excludeZeroObservationVariances();
                }
                abstractAxisPlot.clearSelection();
                dataSet.doUpdate((ProgressManager)this.getProgressManager());
                entryMainPanelInterface.setDirty(true);
            }
        }, "Updating", -1);
    }

    public static void addTools(AbstractViewPanel abstractViewPanel, DefaultSettingsPanel defaultSettingsPanel) {
        ButtonGroup buttonGroup = new ButtonGroup();
        DefaultSettingsPanel.SectionPanel sectionPanel = defaultSettingsPanel.addSection("Selection");
        sectionPanel.addComponent(new BreezeToggleButton("Free", "selectionFreehand", buttonGroup, true, () -> ModelButtonHelper.setSelectionTool((JComponent)((Object)abstractViewPanel), "freehand")));
        sectionPanel.addComponent(new BreezeToggleButton("Ellipse", "selectionEllipse", buttonGroup, false, () -> ModelButtonHelper.setSelectionTool((JComponent)((Object)abstractViewPanel), "ellipse")));
        sectionPanel.addComponent(new BreezeToggleButton("Rect", "selectionRectangle", buttonGroup, false, () -> ModelButtonHelper.setSelectionTool((JComponent)((Object)abstractViewPanel), "rectangle")));
        sectionPanel.addComponentLast(new BreezeToggleButton("Pixel", "selectionNormal", buttonGroup, false, () -> ModelButtonHelper.setSelectionTool((JComponent)((Object)abstractViewPanel), "normal")));
        DefaultSettingsPanel.SectionPanel sectionPanel2 = defaultSettingsPanel.addSection("Zoom");
        sectionPanel2.addComponent(EntryMainHelper.createButton("Reset", "explore/zoom_all", () -> ModelButtonHelper.setZoomTool((JComponent)((Object)abstractViewPanel), (byte)-1)));
        sectionPanel2.addComponent(new BreezeToggleButton("In", "explore/zoom_in", buttonGroup, false, () -> ModelButtonHelper.setZoomTool((JComponent)((Object)abstractViewPanel), (byte)1)));
        sectionPanel2.addComponent(new BreezeToggleButton("Out", "explore/zoom_out", buttonGroup, false, () -> ModelButtonHelper.setZoomTool((JComponent)((Object)abstractViewPanel), (byte)2)));
        sectionPanel2.addComponent(new BreezeToggleButton("Area", "explore/zoom_area", buttonGroup, false, () -> ModelButtonHelper.setZoomTool((JComponent)((Object)abstractViewPanel), (byte)0)));
        sectionPanel2.addComponentLast(new BreezeToggleButton("Pan", "explore/pan", buttonGroup, false, () -> ModelButtonHelper.setZoomTool((JComponent)((Object)abstractViewPanel), (byte)5)));
    }

    private static void setZoomTool(JComponent jComponent, byte by) {
        if (jComponent instanceof PlotViewPanel) {
            PlotViewPanel plotViewPanel = (PlotViewPanel)((Object)jComponent);
            plotViewPanel.getVisualization().setZoomTool(by);
        }
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent2 = (JComponent)component;
            ModelButtonHelper.setZoomTool(jComponent2, by);
        }
    }

    private static void setSelectionTool(JComponent jComponent, String string) {
        if (jComponent instanceof PlotViewPanel) {
            PlotViewPanel plotViewPanel = (PlotViewPanel)((Object)jComponent);
            plotViewPanel.getVisualization().setSelectionTool(string);
        }
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent2 = (JComponent)component;
            ModelButtonHelper.setSelectionTool(jComponent2, string);
        }
    }

    public static interface VisualizationInterface {
        public AbstractPlotLayout getVisualization();
    }
}

